;Wolfware Assembler
;Copyright (c) 1985-1991 Eric Tauck. All rights reserved.

;===============================================;
;                   Pass_Zero                   ;
; Pass zero assembly. Construct symbol,         ;
; operation, and macro tables.                  ;
;===============================================;

Pass_Zero Proc Near

;----- initialize for pass

 Call Read              ;read first buffer full

;----- loop for each source line

Pnextline
 Call Read_Line         ;read line from buffer
 Jc Ppassdone           ;jump if so
 Test Mac_Stat,Mac_Def  ;check if macro definition
 Jnz Macppstar          ;jump if so
 Cmp Line_Size,0        ;check if line read is zero len
 Je Pnextline           ;jump if so

;----- processes a line for the symbol

 Call Line_Asm0         ;process line
 Jmps Pnextline         ;next line if not end of file

;----- finished

Ppassdone
 Test Mac_Stat,Mac_Def  ;check if still defining
 Jnz Premerr            ;jump if so
 Ret

;----- macro definition

Macppstar
 Call Mac_Asm0          ;process macro definition
 Jnc Pnextline          ;next line if not end of file

;----- unexpected end of macro definition

Premerr
 Call Pendm             ;finish macro
 Ret
 Endp                   ;Pass_Zero

;===============================================;
;                    Line_Asm0                  ;
; Pass zero line assembly. Put symbol and       ;
; operation into their respective tables. Set   ;
; any special symbol types.                     ;
;===============================================;

Line_Asm0 Proc Near
 Mov Line_Stat,Reset_Line ;reset line flags

;----- check if label

 Mov Si,Line            ;beginning of line
 Cmp Byte [Si],' '      ;space
 Jbe Ppasmchk           ;jump if space or control

;----- not delimiter, there must be a label

 Or Line_Stat,Label_Flag ;set flag
 Call Get_Field         ;get label
 Mov Si,Tempbuff        ;source
 Call Add_Sym           ;put into symbol table pass one

 Call Mne_Put           ;get and look up mnemonic
 Jnc Nosplabel          ;finish if not found

 Mov Bx,Optype1         ;pre-instruction flags
 And Bx,Reset           ;mask bits
 Jz Nospspch            ;jump if so

 Dec Bx                 ;scale 0 to BX-1
 Shl Bx                 ;table offset
 Add Bx,Offset Symres_Tab ;absolute offset
 Call Word [Bx]         ;reseting routine

;----- test for special assembly on line with label

Nospspch Test Optype1,Spec_Assm ;test for assembly
 Jnz Ppassm             ;jump if so
Nosplabel Ret

;----- check for pre-process assembly, no label

Ppasmchk Call Mne_Put   ;get and look up mnemonic
 Jnc Nosplabel          ;finish if not found

 Test Optype1,Spec_Assm ;test for assembly
 Jnz Ppassm             ;jump if so
 Ret

;----- special pre-process assembly

Ppassm Call Operands    ;set operands
 Call Code_Look         ;look up op code
 Jnc Nosplabel          ;skip process if error
 Call Code_Asm          ;process instruction
 Ret

;----- type setting routine table

Symres_Tab Label Word
 Dw Offset Put_Proc
 Dw Offset Put_Db
 Dw Offset Put_Dw
 Dw Offset Put_Ds
 Dw Offset Put_Equ
 Dw Offset Put_Label
 Dw Offset Put_Macro
 Dw Offset Put_Macroc
 Endp                   ;Line_Asm0

;===============================================;
;                    Mac_Asm0                   ;
; Pass zero macro assembly. Save a macro        ;
; definition into the macro table.              ;
;===============================================;

Mac_Asm0 Proc Near
 Cmp Line_Size,0        ;check if nul line
 Je Mpcomline           ;jump if so

;----- loop for each macro line

Macpploop
 Mov Line_Stat,Reset_Line ;reset line flags
 Mov Si,Line            ;beginning of line

;----- skip label if any

 Cmp Byte [Si],' '      ;space
 Jbe Nmplab             ;jump if space or control

;----- not delimiter, there must be a label

 Or Line_Stat,Label_Flag ;set flag
 Call Get_Field         ;get label
 Mov Si,Tempbuff        ;source
 Call Mac_Dlabel        ;make macro label
 Call Add_Sym           ;put into symbol table pass one

 Call Mne_Put           ;get and look up mnemonic
 Jnc Mpcomline          ;finish if not found

 Mov Bx,Optype1         ;pre-instruction flags
 And Bx,Reset           ;mask bits
 Jz Mpcompe             ;jump if so

 Dec Bx                 ;scale 0 to BX-1
 Shl Bx                 ;table offset
 Add Bx,Offset Symres_Tab ;absolute offset
 Call Word [Bx]         ;reseting routine
 Jmps Mpcompe

;----- get instruction on line without any label

Nmplab Call Mne_Put     ;get and look up mnemonic
 Jnc Mpcomline          ;finish line if not found

;----- check for end of macro

Mpcompe Cmp Op_Number,Endm ;check if end of definition
 Je Macpdone            ;jump if so, finished
 Cmp Op_Number,Macro    ;check if start of new def
 Je Mpmacst             ;jump if so

;----- compress and store line

Mpcomline Call Compress ;compress present line

;----- read next line

Macpplo2
 Call Read_Line         ;read next line from buffer
 Jc Macppdone           ;jump if so
 Cmp Line_Size,0        ;check if line read is zero len
 Je Mpcomline           ;jump if so, compress
 Jmps Macpploop         ;loop back to start

;----- end of file before the definition was finished

Macppdone Stc
 Ret

;----- finished defining macro

Macpdone Call Pendm     ;finish macro
 Clc
 Ret

;----- start of new macro definition (missing ENDM), arrgh!

Mpmacst Call Pendm      ;finish present macro

;----- must remove last four identifing bytes from last symbol

 Test Line_Stat,Label_Flag ;make sure there is label
 Jz Mpmacstnl           ;jump if not

 Mov Si,Last_Sym        ;start of last symbol in table
 Mov Sym_Point,Si       ;reset pointer

;----- extract symbol from table

 Mov Di,Tempbuff        ;storage
 Push Ds
 Mov Ds,Sym_Seg         ;symbol table segment
 Copy_Str               ;move full string to storage
 Pop Ds

;----- put symbol back into table

 Mov Si,Tempbuff        ;storage
 Call Mac_Unlabel       ;strip identifier
 Call Add_Sym           ;back into symbol table
 Call Put_Macro         ;reset symbol data

Mpmacstnl Call Pmacro   ;start new macro

 Test Mac_Stat,Mac_Def  ;check if still defining
 Jnz Macpplo2           ;jump if so, continue
 Clc
 Ret
 Endp                   ;Mac_Asm0

;===============================================;
;                   Pass_Main                   ;
; Pass one and two assembly (main assembly).    ;
; Skip macro definitions, assemble each line    ;
; in file, and output assembly listing.         ;
;===============================================;

Pass_Main Proc Near
 Mov Ax, Loctr          ;get the last location from the last pass
 Mov Endloc, Ax         ;save it

;----- initialize for each pass

 Or Input_Stat,Src_First ;first read
 Mov Line_Num,0         ;zero lines read
 Mov Line_Tot,0         ;zero lines processed
 Mov Loctr,Def_Offset   ;beginning offset
 Mov Counter_Num,0      ;zero bytes counted
 Mov Counter_Chk,0      ;initialize checksum
 Mov Obj_Count,0        ;zero bytes of object code
 Mov Program_Chk,0      ;initialize program checksum
 Mov Stack_Top,0        ;clear PROC stack
 Mov Cod_Point,0        ;code table pointer
 Mov Mac_Number1,0      ;no macros defined
 Mov Mac_Number2,0      ;no macros expanded
 Mov Mac_Number3,0      ;ditto
 Mov If_Stat,If_None    ;reset IF status
 Mov Ifnum,0            ;clear IF stack
 Mov Prt_Flag,Clear     ;reset print flag, just in case set

 Call Begin_File        ;beginning of source file
 Call Read              ;read first buffer full

;----- loop for each source line

Nextline
 Mov Obj_Length,0       ;no object code
 Mov Line_Stat,Reset_Line ;reset line flags
 Mov Ax,Loctr
 Mov Lostor,Ax          ;save location counter for list

Nextline2
 Call Read_Line         ;read line from buffer
 Jc Passdone            ;done with pass
 Cmp Line_Size,0        ;check if line read is zero length
 Je Noline              ;no line if zero

;----- processes a line

 Test Mac_Stat,Mac_def  ;check if macro definition
 Jnz Procdemacs         ;jump if so

 Call Line_Asm          ;process line

Procpcon Cmp Pass,1     ;which pass
 Je Nextline            ;next line if pass one

 Call Obj_Send          ;store object code

 Call Line_List         ;check if line should be listed
 Jnc Nextline           ;next line if not
 Call Line_Out          ;output line
 Jmps Nextline          ;next line

;----- finished

Passdone Test Mac_Stat,Mac_Def ;check if macro definition (first line)
 Jnz Procbade           ;jump if so
 Ret

;----- no line procedure, zero length line

Noline Cmp Pass,1       ;which pass
 Je Nextline2           ;next line if pass one
 Call Line_List         ;check if line should be listed
 Jnc Nextline2          ;next line if no list
 Call Line_Out          ;output line
 Jmps Nextline2         ;next line

;----- start macro definition, loop until end of definition found

Procdemacs Call Mac_Asm ;process definition (i.e. skip it)
 Jnc Procpcon           ;loop back for print if not end of file

;----- unexpected end of macro

Procbade Call Pendm     ;finish macro
 Mov Ax,008ah           ;error 138
 Call Error             ;error routine
 Ret
 Endp                   ;Pass_Main

;===============================================;
;                    Line_Asm                   ;
; Pass one and two line assembly. Update symbol ;
; location, look up operands and assemble code. ;    
;===============================================;

Line_Asm Proc Near

;----- check if label

 Mov Si,Line            ;beginning of line
 Cmp Byte [Si],' '      ;space
 Jbe Proccon            ;jump if space or control

;----- found label, check which pass

 Or Line_Stat,Label_Flag Or Loc_Flag ;set label and location flags
 Cmp Pass,2             ;which pass
 Je Chkph               ;check phase on pass two

;----- pass one label, set label location

 Call Update_Sym        ;enter symbol location
 Jmps Proccon

;----- pass two label, check phase

Chkph Call Check_Phas   ;check phase
 Jmps Proccon           ;continue with op code

;----- get type of operation

Proccon Call Mne_Get    ;get instruction type
 Jnc Syne               ;finish if not found

;----- check for conditional assembly

 Or Line_Stat,Loc_Flag  ;print location if instruction
 Cmp If_Stat,If_None    ;check if not in conditional code
 Je Lacont              ;jump if so
 Cmp If_Stat,If_True    ;check if in true conditional code
 Je Lacont              ;jump if so
 Test Optype1,Cond_Inst+Spec_Assm ;special or conditional code
 Jz Syne                ;jump if not

;----- assemble line

Lacont Call Operands    ;set operands
 Call Code_Look         ;look up op code
 Jnc Syne               ;skip process if error
 Call Code_Asm          ;process instruction
Syne Ret
 Endp                   ;Line_Asm

;===============================================;
;                    Mac_Asm                    ;
; Pass one and two macro assembly. Update       ;
; symbol locations (probably unecessary). Skip  ;
; all lines of the macro definition. Carry is   ;
; set if end of file.                           ;
;===============================================;

Mac_Asm Proc Near

;----- loop for each definition line, check for label first

Macdploop
 Mov Si,Line            ;beginning of line
 Cmp Byte [Si],' '      ;space
 Jbe Nopmdeflab         ;jump if space or control

;----- found label, check which pass

 Or Line_Stat,Label_flag ;label flag true
 Cmp Pass,2             ;which pass
 Je Chkmacp             ;check phase on pass two

;----- pass one label, set label location

 Call Update_Sym        ;enter symbol location
 Jmps Nopmdeflab

;----- pass two label, check phase

Chkmacp Call Check_Phas ;check phase

;----- get instruction

Nopmdeflab Call Mne_Get ;get and look up mnemonic
 Jnc Macplin            ;next line if not found

;----- check for end of macro

 Cmp Op_Number,Endm     ;check if end of definition
 Je Macdend             ;jump if so, finished
 Cmp Op_Number,Macro    ;check if start of new def
 Je Macdst              ;jump if so

;----- check if print line

Macplin Cmp Pass,1      ;which pass
 Je Macdlin             ;next line if pass one
 Call Line_List         ;check if line should be listed
 Jnc Macdlin            ;next line if no list
 Call Line_Out          ;output line

;----- get next line

Macdlin
 Mov Line_Stat,Reset_Line ;reset line flags
 Call Read_Line         ;read line from buffer
 Jc Macderr             ;jump if so
 Cmp Line_Size,0        ;check if line read is zero len
 Je Macplin             ;jump if so, print only
 Jmps Macdploop         ;process line

;----- ENDM found, finished (but do processing to flag any errors)

Macdend Call Pendm      ;finish macro
 Clc
 Ret

;----- MACRO found (missing ENDM), finished but start new macro

Macdst Mov Ax,008ah     ;error 138
 Call Error             ;error routine

 Call Pendm             ;finish macro
 Call Pmacro            ;start new macro

 Test Mac_Stat,Mac_Def  ;check if still defining
 Jnz Macplin            ;jump if so, continue
 Clc
 Ret

;----- end of file but missing ENDM

Macderr Stc
 Ret
 Endp                   ;Mac_Asm

;===============================================;
;                  Update_Sym                   ;
; Update symbol location. Advances the line     ;
; pointer past the symbol and updates next      ;
; symbol in symbol table to location counter.   ;
; Executed on pass one.                         ;
;===============================================;

Update_Sym Proc Near
 Test Mac_Stat,Mac_Flag ;check if in macro expansion
 Jnz Oldemac            ;jump if so

 Push Ds
 Mov Dx,Loctr           ;present location
 Mov Di,Osym_Point      ;symbol pointer
 Mov Ds,Sym_Seg         ;symbol table segment

;----- pointer past symbol

 Mov Al,[Di]            ;length
 Sub Ah,Ah
 Add Di,Ax              ;pointer past symbol
 Inc Di                 ;include length byte
 Seg Cs
 Mov Last_Dat,Di        ;save last data loc for EQU check

;----- check for conditional code, not in macro expansion

 Seg Cs
 Cmp If_Stat,If_None    ;check if not in conditional code
 Je Upsnlocup           ;jump if so
 Seg Cs
 Cmp If_Stat,If_True    ;check if in true conditional code
 Je Upsnlocup           ;jump if so

 Or Word [Di+4],Cfalse_Sym ;set false code bit

;----- set location

Upsnlocup Test Word [Di+4],Spec_Sym ;test if special symbol, no change
 Jnz Nooup              ;jump if not
 Mov [Di],Dx            ;set to present location

;----- save table pointer

Nooup Pop Ds
 Add Di,6               ;skip label data
 Mov Osym_Point,Di      ;save pointer

 Sub Line_Rem,Ax        ;reduce bytes in line
 Add Line_Point,Ax      ;skip over label
 Ret

;----- label within macro expansion, must define

Oldemac Call Get_Field  ;get label
 Mov Si,Tempbuff        ;location
 Push Si
 Call Mac_Label         ;make the label unique
 Call Add_Sym           ;into symbol table
 Pop Si

;----- get original definition

 Call Mac_Unlabel       ;make normal
 Call Mac_Dlabel        ;make into definition label
 Call Get_Sym           ;get table location and data

;----- check for conditional code in macro expansion

 Cmp If_Stat,If_None    ;check if not in conditional code
 Je Upsmlocup           ;jump if so
 Cmp If_Stat,If_True    ;check if in true conditional code
 Je Upsmlocup           ;jump if so

 Or Ax,Cfalse_Sym       ;set bits

;----- set new label type

Upsmlocup Or Ax,Mlabel  ;set macro label bit
 Test Ax,Spec_Sym       ;test if special symbol
 Jnz Oldmss             ;jump if so
 Mov Bx,Loctr           ;location counter
Oldmss Call Put_Sym2    ;reset table data
 Ret
 Endp                   ;Update_Sym

;===============================================;
;                   Check_Phas                  ;
; Check phase. Gets the symbol and its previous ;
; offset, then compares it to the present value ;
; of the location counter. Also flags several   ;
; symbol errors. Executed on pass two.          ;
;===============================================;

Check_Phas Proc Near
 Test Mac_Stat,Mac_Flag ;check if in macro expansion
 Jnz Getpmac            ;jump if so

 Push Ds
 Mov Di,Osym_Point      ;symbol pointer
 Mov Ds,Sym_Seg         ;symbol table segment

;----- get symbol value, type, and length

 Mov Al,[Di]            ;length
 Sub Ah,Ah
 Add Di,Ax              ;pointer past symbol
 Inc Di                 ;include length byte

 Mov Bx,[Di]            ;value
 Or Word [Di+4],Defined_Sym ;symbol has been defined
 Mov Dx,[Di+4]          ;type

;----- save table pointer

 Pop Ds
 Mov Last_Dat,Di        ;save last data loc for EQU check
 Add Di,6               ;skip label data
 Mov Osym_Point,Di      ;save pointer

;----- test label

 Test Dx,Macrot Or Cfalse_Sym Or Mlabel ;special bits
 Jnz Cpnotunus          ;jump if any set, symbol never used
 Test Dx,Used_Sym       ;test if used bit set
 Jz Gpchkerrs           ;jump for error display if not
Cpnotunus Test Dx,Badsym Or Dupdef ;test if any error bits set
 Jnz Gpchkerrs          ;jump if so

;----- symbol contains no errors, skip in line (do not bother extracting)

 Test Mac_Stat,Mac_Def ;check if in macro definition
 Jz Gpnomacds           ;jump if not
 Sub Ax,4               ;fix label size

Gpnomacds Sub Line_Rem,Ax ;reduce bytes in line
 Add Line_Point,Ax      ;skip over label

;----- check phase

Gpchktyp Test Dx,Spec_Sym ;test if special symbol, no phase check
 Jnz Notlab             ;jump if so
 Test Dx,Cfalse_Sym     ;test if in false conditional code
 Jnz Notlab             ;jump if so

 Sub Bx,Phase_Off       ;include phase offset
 Cmp Bx,Loctr           ;comp old to new
 Jne Phserror           ;error if not equal
Notlab Ret

;----- phase error

Phserror Push Bx
 Sub Bx,Loctr           ;difference in numbers
 Add Phase_Off,Bx       ;put into phase offset
 Pop Bx

 Mov Ax,0821h           ;error 33
 Call Error             ;error routine
 Ret

;----- label within macro expansion

Getpmac Call Get_Field  ;get field
 Mov Si,Tempbuff        ;location of label
 Call Mac_Label         ;make it a macro label

 Call Get_Sym           ;get table location
 Mov Last_Dat,Di        ;save last data loc for EQU check
 Mov Dx,Ax

 Push Ds
 Mov Ds,Sym_Seg         ;symbol table segment
 Or Word [Di+4],Defined_Sym ;symbol has been defined
 Pop Ds

 Test Ax,Used_Sym       ;see if accessed
 Jz Unusedsm            ;jump if not
Unumacsc Test Ax,Dupdef ;test if duplicate definition
 Jz Gpchktyp            ;jump if not
 Ret

;----- test for individual symbol errors (not within a macro)

Gpchkerrs Push Bx
 Push Dx
 Call Get_Field         ;get label field, if needed for display
 Pop Dx
 Pop Bx
 Mov Si,Tempbuff        ;location of label

 Test Dx,Used_Sym ;test if symbol used
 Jz Unuseds
Gpechkb Test Dx,Badsym  ;test if invalid symbol
 Jnz Inverror
Gpechkc Test Dx,Dupdef  ;test if duplicate definition
 Jnz Duperror
 Jmps Gpchktyp

;----- symbol never accessed, not in macro expansion

Unuseds Test Dx,Macrot+Cfalse_Sym+Mlabel ;special bits
 Jnz Gpechkb            ;jump if any set, got here by other error
 Test Opt_Stat,Used_flag ;test if flag symbol
 Jz Gpechkb             ;jump if not
 Test Mac_Stat,Mac_def  ;see if in macro definition
 Jnz Gpechkb            ;jump if so, never access symbol

 Push Ax
 Mov Ax,440ch           ;error 12
 Call Error             ;error routine
 Pop Ax
 Jmps Gpechkb

;----- invalid character in symbol error

Inverror Push Ax
 Mov Ax,0488h           ;error 136
 Call Error             ;error routine
 Pop Ax
 Jmps Gpechkc

;----- duplicate definition error

Duperror Mov Ax,043ch   ;error 60
 Call Error             ;error routine
 Clc                    ;clear carry, no phase check
 Ret

;----- symbol never accessed, inside of macro expansion

Unusedsm Test Opt_Stat,Used_flag ;test if flag symbol
 Jz Unumacsc            ;jump if not

 Push Ax
 Push Bx
 Call Mac_Unlabel       ;fix label
 Mov Ax,440ch           ;error 12
 Call Error             ;error routine
 Pop Bx
 Pop Ax
 Jmps Unumacsc
 Endp                   ;Check_Phas

;===============================================;
;                   Line_List                   ;
; Sets carry if line should be output based on  ;
; the list and conditional flags.               ;
;===============================================;

Line_List Proc Near

;----- check general list flags

 Test Line_Stat,Err_flag ;check if error
 Jnz Liliprt
 Cmp Prt_Flag,Show      ;check if print
 Je Liliprt
 Cmp Prt_Flag,Hide      ;check if suppress
 Je Lilisup
 Test Opt_Stat,List_flag ;list on?
 Jz Nolinelist

;----- check conditional flags

 Cmp If_Stat,If_Skip    ;check if in skipped (false) code
 Je Nolinelist
 Cmp If_Stat,If_False   ;check if in false code
 Je Nolinelist

;----- check macro flags

 Test Mac_Stat,Mac_Flag ;in macro expansion?
 Jz Linelist
 Test Opt_Stat,Exp_Flag ;check expansion
 Jnz Linelist
 Cmp Nmac_Num,1         ;check if nested macros
 Ja Nolinelist
 Test Line_Stat,Mac_Line ;check if macro line
 Jz Nolinelist

;----- line output

Linelist Stc
 Ret

;----- no line output

Nolinelist Clc
 Ret

;----- explicitly print line

Liliprt Mov Prt_Flag,Clear ;reset print flag
 Stc
 Ret

;----- explicitly suppress line

Lilisup Mov Prt_Flag,Clear ;reset print flag
 Clc
 Ret
 Endp                   ;Line_List

