;Wolfware Assembler
;Copyright (c) 1985-1991 Eric Tauck. All rights reserved.

;===============================================;
;                   Initialize                  ;
; Initilize program data.                       ;
;===============================================;

Initialize Proc Near
 Cld                    ;make sure direction is normal

;----- check DOS version

 Dos_Function 30h       ;get DOS version number
 Cmp Al, 2              ;check if version two
 Jae Steinit            ;jump if OK
 Jmp Baddos             ;bad version number

;----- check program checksum

Steinit
 Mov Di, Offset Checksum        ;offset of checksum

 Test Opt_Stat2, Check_Flag ;check if checksum
 Jz Steinit2            ;jump if not

 Mov Si, 100h           ;start of program
 Sub Ah, Ah

;----- loop for each byte in the program

Initchkl
 Cmp Si, Di             ;check if end of program
 Je Initchkd            ;jump if so

 Lodsb                  ;load next byte
 Add Ah, Al             ;add into sum
 Jmps Initchkl          ;loop back

Initchkd
 Cmp Ah, Checksum       ;check checksum
 Je Steinit2            ;jump if ok
 Jmp Badchks            ;checksum error

;----- data locations

Steinit2
 Mov Ax, Di             ;end of program
 Inc Ax                 ;skip checksum (doesn't really matter)

 Mov Lst_Buffer,Ax      ;list buffer
 Add Ax,String_Siz
 Mov Obj_Buffer,Ax      ;obj storage buffer
 Add Ax,String_Siz
 Mov Title_Buff,Ax      ;title storage
 Add Ax,String_Siz
 Mov Subt_Buff,Ax       ;subtitle storage
 Add Ax,String_Siz
 Mov Head_Buff,Ax       ;head line storage
 Add Ax,String_Siz
 Mov Line,Ax            ;line buffer
 Add Ax,String_Siz
 Mov Tempbuff,Ax        ;general storage
 Add Ax,String_Siz
 Mov Mac_Buff,Ax        ;macro parameter storage
 Add Ax,String_Siz
 Mov Iftab,Ax           ;IF stack
 Add Ax,Ifmax
 Mov Num_Buff,Ax        ;number string storage
 Add Ax,17              ;could be 16 digits (binary?) plus len byte
 Mov Str_Buff,Ax        ;string operand storage
 Add Ax,String_Siz
 Mov Def_Pth,Ax         ;path storage
 Add Ax,Pth_Size+1      ;size plus length
 Mov Def_Nam,Ax         ;name storage
 Add Ax,Nam_Size+1
 Mov Def_Ext,Ax         ;extension storage
 Add Ax,Ext_Size+1
 Mov Name_Buff,Ax       ;name string storage
 Add Ax,Name_Size+1
 Mov Date_Buff,Ax       ;date/time string storage
 Add Ax,29
 Mov Src_Name,Ax        ;source name
 Add Ax,Name_Size+1
 Mov Obj_Name,Ax        ;object name
 Add Ax,Name_Size+1
 Mov Lst_Name,Ax        ;list name
 Add Ax,Name_Size+1
 Mov Inc_Name,Ax        ;include name
 Add Ax,Name_Size+1

 Mov Oprnd_Tab,Ax       ;operand table
 Mov Dx,Oprnd_Max       ;max nest level
 Shl Dx
 Shl Dx                 ;times 4
 Add Dx,Oprnd_Max
 Add Dx,Oprnd_Max       ;times 2 more, 6 bytes per entry
 Add Ax,Dx

 Mov Nmac_Loc,Ax        ;macro stack
 Mov Dx,Nmac_Max        ;max on stack
 Dec Dx                 ;top macro is never on stack
 Add Ax,Dx              ;DX times 1 plus ...
 Shl Dx
 Add Ax,Dx              ;... DX times 2 plus ...
 Shl Dx
 Add Ax,Dx              ;... DX times 4 plus ...
 Shl Dx
 Add Ax,Dx              ;... DX times 8 = 15 per stack entry

 Mov Omac_Loc,Ax        ;parameter area
 Mov Dx,Omac_Max        ;max table entries
 Inc Dx                 ;plus pointer to next table
 Shl Dx                 ;two bytes per entry
 Add Dx,String_Siz*2    ;max parameter data length, two lines worth
 Push Ax
 Mov Ax,Nmac_Max        ;parameter area for each nest level
 Mov Bx,Dx
 Sub Dx,Dx
 Mul Ax,Bx              ;multiply entry size times each nest level
 Mov Dx,Ax
 Pop Ax
 Add Ax,Dx

 Mov Inctor,Ax          ;include storage
 Add Ax,12

 Mov Stack_Base,Ax      ;PROC stack base
 Mov Dx,Max_Proc
 Shl Dx
 Add Ax,Dx              ;needs two for each nesting

 Mov Error_Tabl,Ax      ;error translation table base
 Add Ax,512             ;two for each (256) possible errors

 Mov Op_Table2,Ax       ;mnemonic search table
 Mov Dx,Op_Num
 Shl Dx                 ;two for each entry
 Add Ax,Dx

 Add Ax,Stack_Size      ;stack size, and AX get top of new stack

;----- check if enough memory available 

 Mov Cl, 4
 Mov Dx, Ax
 Shr Dx, Cl             ;make segment form
 Inc Dx                 ;adjust for remainder
 Mov Bx, Cs             ;present segment
 Add Dx, Bx             ;DX points to next possible segment
 Cmp Dx, [Size_Loc]     ;make sure there is available memory
 Jb Redpseg             ;jump if so

Intmerr Jmp Memerri     ;insufficient memory error

;----- enough memory for data and stack in code segment

;----- transfer to new stack

Redpseg Pop Dx          ;pop return address on initial stack
 Mov Sp,Ax              ;new stack pointer
 Push Dx                ;save return address

;----- reduce main data/code/stack segment to minimum, AX has bytes used

 Mov Cl,4               ;bits to shift to make paragraph
 Shr Ax,Cl              ;segment form (number of 16 byte paragraphs)
 Inc Ax                 ;allow for any remainder
 Mov Bx,Ax
 Dos_Function 4ah       ;change segment size

;----- calculate various data segments

 Mov Bx,Read_Size/16+1  ;paragraphs for source read
 Dos_Function 48h       ;allocate memory
 Jc Intmerr             ;jump if not enough memory
 Mov Src_Seg,Ax         ;save segment

 Mov Bx,Read_Size/16+1  ;paragraphs for source (include) read
 Dos_Function 48h       ;allocate memory
 Jc Intmerr             ;jump if not enough memory
 Mov Inc_Seg,Ax         ;save segment

 Mov Bx,Write_Size/16+1 ;paragraphs for object write
 Dos_Function 48h       ;allocate memory
 Jc Intmerr             ;jump if not enough memory
 Mov Obj_Seg,Ax         ;save segment

 Mov Bx,Write_Size/16+1 ;paragraphs for list write
 Dos_Function 48h       ;allocate memory
 Jc Intmerr             ;jump if not enough memory
 Mov Lst_Seg,Ax         ;save segment

 Mov Bx,Max_Instr*2/16+1 ;paragraphs for preprocessing code
 Dos_Function 48h       ;allocate memory
 Jc Intmerr             ;jump if not enough memory
 Mov Cod_Seg,Ax         ;save segment

 Mov Bx,Asym_Len+7*Max_Sym ;bytes for symtab
 Push Bx
 Shr Bx,Cl              ;paragraph form
 Inc Bx
 Dos_Function 48h       ;allocate memory
 Jc Intmerr             ;jump if not enough memory
 Mov Sym_Seg,Ax         ;save segment
 Pop Ax

 Sub Ax,Sym_Entry       ;allow for single entry
 Mov Sym_Size,Ax        ;save max size

 Mov Bx,Macro_Size/16+1 ;bytes for macros
 Dos_Function 48h       ;allocate memory
 Jnc Imacok             ;jump if ok
 Or Bx, Bx              ;check if any available
 Jz Intmerr             ;jump if not
 Dos_Function 48h       ;allocate memory, try again with new value
 Jc Intmerr             ;jump if error, shouldn't happen on second shot
Imacok
 Mov Mac_Seg,Ax         ;save segment
 Mov Cl, 4
 Shl Bx, Cl             ;bytes available
 Sub Bx,Mac_Entry       ;allow for single entry
 Mov Mac_Size,Bx        ;save max size

;----- initialize error table to undefined error

 Mov Ax,Offset Undefer+1 ;message location
 Mov Cx,256             ;number of locations to initialize
 Mov Di,Error_Tabl      ;table location
 Rep
 Stosw                  ;fill entire table

;----- error message locations

 Mov Bx,Error_Tabl      ;base
 Mov Dx,Def_Error       ;number of errors
 Mov Si,Offset Errtop   ;offset of first error

;----- loop for each error

Errloop Lodsb           ;load error number
 Sub Ah,Ah
 Mov Di,Ax
 Shl Di                 ;offset into error table
 Mov [Bx+Di],Si         ;store offset of error

 Inc Si
 Mov Di,Si

;----- find end of error and save length

Errloop2 Lodsb
 Or Al,Al
 Jne Errloop2

 Push Si
 Sub Si,Di
 Mov Ax,Si
 Dec Ax
 Mov [Di-1],Al
 Pop Si

 Dec Dx                 ;one less error
 Jnz Errloop            ;loop for next error

;----- create operation table two (search table)

 Mov Cx,Op_Num          ;number of instructions
 Mov Si,Op_Table1       ;table of mnemonics
 Inc Si                 ;skip over length
 Mov Di,Op_Table2       ;search table location

;----- loop for each operation

Opinloop Movsw          ;move first two characters
 Add Si,14              ;next mnemonic entry
 Loop Opinloop          ;loop back for each instruction

;----- initialize title and subtitle

 Mov Bx,Title_Buff      ;title
 Mov Byte [Bx],0        ;nul string
 Mov Bx,Subt_Buff       ;subtitle
 Mov Byte [Bx],0        ;nul string

;----- save initial interrupt 0 values

 Push Es
 Dos_Function 35h, 0    ;get interrupt vector 0
 Mov Int0_Off,Bx        ;save offset
 Mov Int0_Seg,Es        ;save segment
 Pop Es

;----- save break state

 Dos_Function 33h, 0    ;get break state
 Mov Break_State,Dl     ;save

;----- set interrupt 23h

 Mov Dx,Offset Break_Routine ;routine location
 Dos_Function 25h, 23h  ;set interrupt vector 23h

;----- set break state

 Test Opt_Stat2,Break_Flag ;see if set on
 Jz Nobrkset

 Mov Dl,1               ;turn on
 Dos_Function 33h, 1    ;set break state

;----- set interrupt 0

Nobrkset
 Mov Dx,Offset Int_Zero ;routine location
 Dos_Function 25h, 0    ;set interrupt vector 0
 Ret

;----- incorrect DOS version

Baddos
 Mov Ah, 9                      ;display function
 Mov Dx,Offset Dosemess         ;message
 Int 21h                        ;execute
 Int 20h                        ;exit

Dosemess Db 'WASM detects incorrect DOS version',13,10,'$'

;----- checksum error, bad program copy

Badchks
 Mov Si,Offset Chkemess         ;message
 Call Print_Str                 ;display it
 Dos_Function 4ch, Chk_Err_Code ;exit with error code

Chkemess Db 31,'WASM detects checksum failure',13,10

;----- insufficient memory to run

Memerri
 Mov Si,Offset Insufmes         ;message
 Call Print_Str                 ;display it
 Dos_Function 4ch, Mem_Err_Code ;exit with error code

Insufmes Db 34,'WASM detects insufficient memory',13,10
 Endp                   ;Initialize

;===============================================;
;                     Start                     ;
; Display opening message.  If no files         ;
; specified in command line, then prompt user   ;
; for file names.                               ;
;===============================================;

Start Proc Near
 Mov Si,Offset Omess    ;opening message
 Call Print_Str         ;display

;----- input names

 Call Reset_Nam         ;reset default names
 Mov Al,[80h]           ;bytes in command line
 Sub Ah,Ah
 Mov Line_Rem,Ax        ;set bytes to scan
 Mov Line_Point,81h     ;start of command line

 Call Get_Ffield        ;get first field
 Jz Usprompt            ;jump if none

;----- command line input, source name

 Mov Si,Offset Defasm   ;default source
 Call Extract_Tot       ;set
 Mov Si,Tempbuff        ;name
 Mov Di,Src_Name        ;save location
 Call Format_Name       ;format and save

;----- object name

 Mov Si,Offset Defcom   ;default object
 Call Extract_Tot       ;set
 Call Get_Ffield        ;get next field
 Mov Si,Tempbuff        ;name
 Mov Di,Obj_Name        ;save location
 Call Format_Name       ;format and save

;----- list name

 Mov Si,Offset Deflst   ;default list
 Call Extract_Tot       ;set
 Call Get_Ffield        ;get next field
 Mov Si,Tempbuff        ;name
 Mov Di,Lst_Name        ;save location
 Call Format_Name       ;format and save
 Jmps Checklst          ;check list file

;----- manual input

;----- source file

Usprompt
 Mov Ah,Bit3+Bit4       ;just extension
 Mov Bx,Offset Defasm +1 ;default name (skip length)
 Mov Di,Src_Name        ;source name
 Mov Si,Offset Smess    ;prompt message
 Call Start_Inp         ;formatted input

;----- check if serial number display

 Mov Si,Tempbuff        ;input location
 Inc Si                 ;skip max input length
 Cmp Word [Si],3d01h    ;compare to length one and character '='
 Jne Usobjcon           ;jump if not, assume normal operation

 Call Ser_Displ         ;serial number display
 Dos_Function 4ch, Sta_Err_Code ;exit with error code

;----- object file

Usobjcon Mov Ah,Bit1+Bit2+Bit3+Bit4 ;the works
 Mov Bx,Offset Defcom +1 ;default name (skip length)
 Mov Di,Obj_Name        ;source name
 Mov Si,Offset Cmess    ;prompt message
 Call Start_Inp         ;formatted input

;----- list file

 Mov Ah,Bit1+Bit2+Bit3+Bit4 ;the works
 Mov Bx,Offset Deflst +1 ;default name (skip length)
 Mov Di,Lst_Name        ;source name
 Mov Si,Offset Lmess    ;prompt message
 Call Start_Inp         ;formatted input

;----- all file names have been taken in, display

Checklst
 Mov Si,Offset Bsmess   ;prompt
 Mov Di,Src_Name        ;name
 Call Prompt_File       ;display

 Mov Si,Offset Bomess   ;prompt
 Mov Di,Obj_Name        ;name
 Call Prompt_File       ;display

 Mov Si,Offset Blmess   ;prompt
 Mov Di,Lst_Name        ;name
 Call Prompt_File       ;display

;--- check the list type

 Call Name_Type         ;get file type of list name
 Cmp Al,Con_File        ;check if con (screen)
 Je Conlist             ;jump if so
 Cmp Al,Prn_File        ;check if prn (printer)
 Je Prnlist             ;jump if so
 Cmp Al,Nul_File        ;check if nul (no list)
 Je Nullist             ;jump if no list

;----- list activated (non-nul)

 Mov List_Type,Al       ;save list type
 Or Opt_Stat,List_Flag  ;list on
 Call Opener            ;open all I/O files
 Ret

;----- list activated, console

Conlist Mov List_Type,Con_File ;list type
 Or Opt_Stat,List_Flag  ;list on
 Jmps Constandrd

;----- list activated, printer

Prnlist Mov List_Type,Prn_File ;list type
 Or Opt_Stat,List_Flag  ;list on
 Mov Lst_Handle,Prn_Device ;printer device
 Call Opener            ;open all I/O files
 Ret

;----- no list, turn list off and send any output to screen

Nullist Mov List_Type,Nul_File ;list type
 Mov Si,Offset Console  ;file
 Mov Di,Lst_Name        ;list name
 Call Format_Name       ;format

;----- send any listing to standard output

Constandrd Mov Lst_Handle,Std_Device ;standard device
 Call Opener            ;open all I/O files
 Ret
 Endp                   ;Start

;===============================================;
;                 Opening Data                  ;
;===============================================;

;--- opening message

 Resetc

Omess Db Byte (Offset Omessx - Offset Omess - 1)
 Db 13,10
 Db 'Wolfware Assembler, Version '
 Db Version_Hi\10+'0', '.', Version_Lo/10+'0', Version_Lo\10+'0', 13,10
 Db 'Copyright (c) 1985-1991 Eric Tauck', 13,10
 Db 'All rights reserved', 13,10
Omessx

 Db $Sum        ;checksum on copyright notice

;--- prompts

Smess Db 15, 13,10,'Source file ['
Cmess Db 13, 'Object file ['
Lmess Db 11, 'List file ['
Xmess Db 3, ']: '

;----- file names

Bsmess Db 11, 13,10,'Source = '
Bomess Db 9, 'Object = '
Blmess Db 7, 'List = '

;----- default file names

Defasm Db 7,'Nul.Asm',0 ;source
Defcom Db 4,'.Com',0    ;object
Deflst Db 7,'Nul.Lst',0 ;list

;----- list file if no list specified

Console Db 3,'Con'      ;console

;===============================================;
;                   Start_Inp                   ;
; File name input. Display the prompt at SI and ;
; the default file name at BX. Then input  a    ;
; file name and format the DI file name         ;
; according to the input name and default. AH   ;
; is passed directly to the routine             ;
; (STORE_NAM) to print the file name and must   ;
; contain the proper bit settings.              ;
;===============================================;

Start_Inp Proc Near
 Push Di

;----- prompt

 Push Ax
 Push Bx
 Call Print_Str         ;first part
 Pop Si
 Pop Ax

 Call Store_Nam         ;print name (and set default values)

 Mov Si,Offset Xmess    ;second part
 Call Print_Str         ;print "]: "

;----- set up input buffer

 Mov Si,Tempbuff        ;use TEMPBUFF for input
 Push Si

 Mov Al,Name_Size+1     ;size of buffer + CR
 Mov [Si],Al            ;set up size
 Mov Dx,Si
 Dos_Function 0ah       ;string input

 Call New_Line          ;next line

 Pop Si
 Inc Si                 ;point to length

;----- format name

 Pop Di
 Call Format_Name       ;format
 Ret
 Endp                   ;Start_Inp

;===============================================;
;                  Prompt_File                  ;
; Display the string at SI, the file name at    ;
; DI, and a new line.                           ;
;===============================================;

Prompt_File Proc Near
 Push Di
 Call Print_Str         ;first part
 Call Reset_Nam         ;reset default names
 Pop Si
 Mov Ah,Bit1+Bit2+Bit3+Bit4 ;the works
 Call Store_Nam         ;print name
 Call New_Line          ;new line
 Ret
 Endp

;===============================================;
;                   Ser_Displ                   ;
; Display block ID data.                        ;
;===============================================;

Ser_Displ Proc Near

;----- creation date

 Mov Si,Offset D4mess   ;message
 Call Print_Str         ;display

 Mov Si, Offset Assemblydate    ;date location
 Mov Ax,[Si+2]                  ;hours and minutes
 Mov Cx,[Si+6]                  ;year
 Mov Dx,[Si+4]                  ;month and day
 Call Store_Date                ;store date

 Mov Si, Date_Buff      ;date buffer
 Call Print_Str         ;display

;----- serial number

 Mov Si,Offset D3mess   ;message
 Call Print_Str         ;display

 Mov Cx,4               ;four bytes
 Mov Si, Offset Serial  ;serial number

Sdloop Lodsb            ;load next double digit
 Push Cx
 Push Ax

 Shr Al
 Shr Al
 Shr Al
 Shr Al                 ;high nibble to low
 Add Al,'0'             ;make ASCII
 Call Print_Char        ;display

 Pop Ax
 And Al,0fh             ;clear upper nibble
 Add Al,'0'             ;make ASCII
 Call Print_Char        ;display
 Pop Cx
 Loop Sdloop            ;loop CX times

 Call New_Line          ;next line
 Ret

;----- data

D3mess Db 16, 13,10,'Serial number '
D4mess Db 10, 13,10, 'Created '
 Endp                   ;Ser_Displ

;===============================================;
;                     Finish                    ;
; The final procedure. Checks procedure stack,  ;
; displays compilation statistics, sends final  ;
; object code to file, closes all files, and    ;
; dumps symbol table.                           ;
;===============================================;

Finish Proc Near
 Or List_Stat,Opt_Line6 ;suppress line if first line of page

;----- check PROC stack

 Cmp Stack_Top,0        ;top should be zero
 Je Oktop               ;jump if ok

;----- missing ENDP error

 Sub Bh,Bh
 Mov Bl,Stack_Top       ;number of ENDP missing
 Mov Ax,021fh           ;error 31
 Call Error             ;error routine

;----- check IF stack

Oktop Cmp Ifnum,0       ;nest number should be zero
 Je Okifn               ;jump if ok

;----- missing ENDIF error

 Mov Bx,Ifnum           ;number of ENDIF missing
 Mov Ax,0209h           ;error 9
 Call Error             ;error routine

;----- send final object code to file

Okifn Call Obj_Send     ;send obj output buffer

;----- blank line

 Or List_Stat,Opt_Line6 ;suppress line if first line of page
 Mov Di,Lst_Buffer      ;zero output
 Call Lst_Send          ;send empty line to list file

;----- output number of errors

 Mov Ax,Error_Num ;number of errors
 Mov Si,Offset Femess   ;error number message
 Call Finish_Dis        ;send errors

;----- output number of lines

 Mov Ax,Line_Tot        ;total lines processed
 Mov Si,Offset Flmess   ;line number message
 Call Finish_Dis        ;send lines

;----- output object size

 Mov Ax,Obj_Count       ;object byte count
 Mov Si,Offset Fomess   ;object message
 Call Finish_Dis        ;send length

;----- output number of symbols

 Mov Ax,Sym_Num         ;total number of symbols
 Mov Si,Offset Fsmess   ;symbol number message
 Call Finish_Dis        ;send symbols

;----- symbol table dump

 Test Opt_Stat,List_Flag ;check if list on
 Jz Ferrdmess            ;jump if not
 Test Opt_Stat,Symtab_Flag ;check if dump is on
 Jz Ferrdmess            ;jump if not

 Call Sym_Dump          ;symbol table dump

;----- see if display errors message to screen

Ferrdmess
 Cmp List_Type, Nul_File ;check if no list (errors to screen)
 Je Nosym               ;jump if so
 Cmp List_Type, Con_File ;check if list to screen
 Je Nosym               ;jump if so

 Mov Si, Offset Fnxmes  ;no errors message
 Test Asm_Stat, Err_Exist ;test for errors
 Jz Fnoerr              ;jump if none
 Mov Si, Offset Fexmes  ;errors message

Fnoerr Call Print_Str   ;display

;----- add end of file mark to list file, if really file

Nosym
 Cmp List_Type, Alt_File ;check if really file
 Jne Noaddef            ;jump if not

 Mov Di,Lst_Buffer      ;buffer
 Mov Al,File_Mark       ;^Z
 Stosb
 And Opt_Stat,Not Page_Flag ;clear paging
 Or List_Stat,Last_Line ;set last line
 Call Lst_Send          ;send it

Noaddef
 Call Restore           ;restore system info and close files
 Ret

;----- final routine data

Femess Db 18,' Error(s) detected'
Flmess Db 18,' Line(s) processed'
Fomess Db 16,' Byte(s) of code'
Fsmess Db 18,' Symbol(s) defined'
Fexmes Db 19, 13,10,'Errors detected',13,10
Fnxmes Db 22, 13,10,'No errors detected',13,10
 Endp                   ;Finish

;===============================================;
;                   Finish_Dis                  ;
; Final assembly display. Sends the string at   ;
; SI and the number in AX to the list file.     ;
; Used to show the compilation statistics.      ;
;===============================================;

Finish_Dis Proc Near
 Mov Di,Lst_Buffer      ;output buffer
 Mov Cx,10              ;base ten
 Mov Dx,0520h           ;length 2, buffer with blank
 Call Store_Fnum        ;formated number output
 Store_Str              ;move string
 Call Lst_Send          ;send output buffer to list file
 Ret
 Endp                   ;Finish_Dis

;===============================================;
;                   Restore                     ;
; Restore original system information and close ;
; files.                                        ;
;===============================================;

Restore Proc Near
 Call Flusher           ;flush all buffers
 Call Closer            ;close all files

;----- restore original interrupt 0

 Push Ds
 Mov Dx,Int0_Off        ;offset
 Mov Ds,Int0_Seg        ;segment
 Dos_Function 25h, 0    ;set interrupt 0
 Pop Ds

;----- restore break state

 Mov Dl,Break_State     ;get original state
 Dos_Function 33h, 1    ;set break state
 Ret
 Endp                   ;Restore

;===============================================;
;                 Break_Routine                 ;
; Handle an initial user break. Flush and close ;
; files, reset system data, and exit. The next  ;
; break, if occuring in exit routines, will     ;
; cause the program to terminate immediately.   ;
;===============================================;

Break_Routine Proc Far
 Push Ax                ;save all registers
 Push Bx
 Push Cx
 Push Dx
 Push Di
 Push Si
 Push Bp
 Push Ds
 Push Es

 Mov Ax,Cs              ;set data segment registers
 Mov Ds,Ax

 Mov Dx,Offset Terminal_Break ;terminate location
 Dos_Function 25h, 23h  ;set interrupt vector 23h

 Call Restore           ;close files and restore system

 Pop Es                 ;restore registers
 Pop Ds
 Pop Bp
 Pop Si
 Pop Di
 Pop Dx
 Pop Cx
 Pop Bx
 Pop Ax

Terminal_Break
 Stc
 Ret
 Endp                   ;Break_Routine

