;Display Regs/memory procedure by D. E. Johnson
;  MICON Systems, Inc.   or  Computer Science Dept.
;  RT. 3, Box 163D           University of Wis.
;  Menomonie, WI 54751       Eau Claire, WI 54701
;This program may be used without obligation,
;  but NO PART OF IT MAY BE SOLD.
;** Useage: Include the following in your code **
;	CALL DRM	;To display regs and/or mem
;	INCLUDE 'DREGMEM.INC' ;Once, at end of program
;May be assembled alone to see where DOS loads .COMs
;System (normal) or local stack used (see next line)
lstk equ 0;40 ;0 for system stack, # for local stack
; (device drivers require local stack of 40)
;All registers are restored before exit
drm	proc	near	;from DOS or included
 if $ > 256
 	expand-	;don't list macro
 else
 	expand+	;do list macro
 endif
 	list-	;don't list macro definition
xpand	macro		;make all symbols local
	cs:
	mov	ssp,sp
	cs:
	push	ssp	;put regs on stack
	push	ss
	pushf		;save regs
	push	bp
	push	ds
	push	si
	push	ax
	push	bx
	push	cx
	push	dx	;fills stack for driver use
 if lstk
	mov	bx,ss	;save old segment
	mov	cx,cs
	mov	ax,offset h ;past new stack
	cli		;no breaks
	mov	ss,cx	;new stack
	xchg	ax,sp
	sti
	push	bx	;old SS
	push	ax	;& SP on stack top
	mov	bx,4	;# words for first display
 endif
	push	di	;push for initial display
	push	es
	mov	ax,offset drm
	push	ax	;address of this procedure
	push	cs
	push	cs
	pop	ds	;to current segment
	mov	dx,offset h
	mov	ah,9
	int	21h	;display header
 ifn lstk
	mov	si,sp	;source address
	mov	bx,15	;# of words to display
 endif
	MOV     cX,3a04h ;colon & # to rotate
 if lstk
	pop	ax	;word from stack
	call	wdis	;display load params
	dec	bx
	jne near $-5	;til all 4 done
	lds	si,h-4	;old stack
	mov	bl,11	;# words left
	lodsw
	call	wdis	;display regs
	dec	bx
;note: displacements used because of WASM bug
;indicating "UNUSED SYMBOLS" if defined first
	jne near $-5	;til done
	push	cs
	pop	ds	;DS = CS
 else
	seg	ss	;data on stack
	lodsw		;Word to display
	call	wdis	;display load params
	dec	bx
	jne near $-6	;til all 15 done
	add	sp,8	;remove some regs
 endif
	mov	dx,offset h2
;print message (WASM bug prevents lebel)
	push	ds	;message print
	push	cs
	pop	ds
	mov	ah,9
	int	21h	;display header
	pop	ds
	xor	bp,bp	;default offset
	jmps	dnxt+4
dnxt	lodsw		;Next memory word
	call	wdis
	xor	si,si	;addr accumulated
	xor	ax,ax
	shl	si,cl	;Accumulate addr
	or	si,ax	;lsw of address
	mov	ah,7
	int	21h	;get char into AL
	call	dchar	;display it
	MOV     AH,0
	cmp	al,'+'	;process input
	je	next
	cmp	al,10
	je	next	;on cr-lf also
	cmp	al,'-'
	je	prev
	cmp	al,':'
	je	sets	;set seg
	cmp	al,'?'	;Help?
	je	hlp
	CMP     AL,'9'
	JLE     EDIG    ;IF VALID DECIMAL
	DEC     AX      ;'A'=64,'a'=96
	OR      AL,20H  ;A-F = 96-101
	ADD     AL,26   ;>F SETS SF
	JS      stop
	SUB     AL,64   ;A-F = 58-63
EDIG	SUB     AL,'0'  ;AX=BINARY VAL
	Jns     dnxt+8   ;MORE DIGITS
	jmps	dnxt	;New input
sets	mov	ds,si	;ds:si = addr of data
	xor	bp,bp	;offset = 0
	jmps	dnxt+4	;initialize offset
prev	sub	bp,4	;display previous word
next	mov	si,bp	;display next word
	mov	ax,si
	mov	ch,'/'	;char following offset
	call	wdis+2	;addr
	jmps	dnxt
hlp	mov	dx,offset help
	jmps	dnxt-12 ;to message display
stop	;restore everything & exit
 if lstk
	pop	ax	;SP to restore
	cli		;restored later
	pop	ss
	xchg	ax,sp	;stack restored
 endif
	pop	dx	;restore regs modified
	pop	cx
	pop	bx
	pop	ax
	pop	si
	pop	ds
	pop	bp
	popf
	pop	ss	;doesn't change
	pop	sp	;restore original SP
	ret
  endp	;drm
wdis	proc	near	;display word & trailer
	mov	bp,si	;save for +/-
	mov	dh,cl	;4
	rol	ax,cl
	push	ax
	and	al,15	;4 bits
	ADD     AL,'0'  ;GENERATE DIGIT
	CMP     AL,'9'
	JLE     NORM    ;0-9
	ADD     AL,7    ;A-F
NORM	CALL	DCHAR	;display digit
	pop	ax
	dec	dh
	jne	wdis+4	;next digit
	mov	al,ch	;terminating char
	mov	ch,' '	;"fall" into display
DCHAR	;proc	near	;display single char in AL
	mov	dl,al
	mov	ah,2	;char display command
	int	21h	;do display at cursor
	cmp	dl,13
	mov	dl,10
	je near $-7
	ret
	endp ;DCHAR & WDIS
help db 13,10,	;This starts the data area
  db 'D. Johnson memory examiner:  "+"/"Ret" = n'
  db 'ext word, "-" = previous word'
  db 13,10,' (e. g. - - from 0 OFFSET in CS when'
  db ' first started)',13,10,'4-digit addresses '
  db 'have leading zeros assumed (trailing ":" se'
  db 'ts new segment)',13,10
  db '   <"0"= end address input (e. g. - "/")  '
  db '    >"F"= exit (e. g. - "q")',13,10,'$'
 if lstk ;stack may expand into help message
	ds	lstk	;room for stack
 endif ;40 bytes prevents garbled '?' message
ssp dw	0 ;entry SP & 1st local stack
h db 13,10,' DRM Addr  ES   DI   DX   CX   BX   '
  db 'AX   SI   DS   BP Flags  SS   SP  RA ?=Help'
  db 13,10,'$'
h2 db 'Init', 13,10,'$'
 endm ;xpand

 if $ = 256
	list+
 endif
 xpand 	;expand macro (symbols local)
