;D. Johnson's example character device driver
;Device "CHARIO" invokes console/screen I/O
;(This isn't a "useful" device, but illustrative.)
;Example invocations: COPY CON CHARIO
; or  COPY CHARIO CON  (don't forget ^Z to end each)
	expand-
	org	0	;start address (not 100h)
da	macro a1,a2,a3,a4,a5,a6,a7,a8 ;define address(es)
	dw	offset a1
  ifn type(a2)=type()
	da	a2,a3,a4,a5,a6,a7,a8 ;recursively
  endif
 endm ;da
;****** Driver header follows ***************
	dw	-1,-1	;next pointer (system modified)
	dw	8000h	;char device only attribute
	da	strat	;strategy entry
	da	intr	;interrupt entry
	db	'CHARIO  ' ;device name (all CAPS)
;******** Data for INTR follows *************
req	dw	0,0	;holds request pointer
ftab	da	init	;func 0 entry address
	da	err,err,err ;func 1-3 illegal
	da	read	;func 4
	da	err,err,err ;func 5-7
	da	write	;func 8
	da	err,err,err,err ;func 9-12
f4m	db	'Input char: $' ;func 4 prompt
f8m	db	'Out = '	;func 8 label
chr	db	0,13,10,'$' ;holds display character 
;******* Code starts here *****************	
strat	proc	far	;save request pointer
	seg	cs	;ds unknown
	mov	req,bx	;pointer offset
	seg	cs
	mov	req+2,es ;pointer segment
	ret
  endp ;strat
;******* INTR processing routine *********
intr	proc	far	;process command
	push	ds	;save regs
	push	es
	push	ax
	push	dx	;save bx & cx if modified
	push	si
	push	di
	seg	cs	;REQ in CS
	lds	si,req	;load DS & SI from REQ	
	mov	al,[si+2] ;command
	cbw
	shl	al	;displacement in table
	xchg	ax,di
;DS:SI points to data header in INTR procedure
	seg	cs	;FTAB in CS
	call near [di+offset ftab] ;do function
	or	[si+3],ax ;set status from ax
	pop	di	;restore regs
	pop	si
	pop	dx
	pop	ax
	pop	es
	pop	ds
	ret
  endp ;intr
;********** function subroutines *********
err	proc	near	;return illegal func
	mov	ax,8103h ;error done - unknown
	ret		;to restore
 endp ;err
read	proc	near	;read & display a char
	mov	dx,offset f4m
	call	disp
	mov	ah,0
	int	16h	;get a char (BIOS call)
	mov word [si+18],1 ;count = 1
	les	di,[si+14] ;es:di = address
	stosb		;store data byte
	seg	cs
	mov	chr,al
	mov	dx,offset chr
	call	disp	;display char & end line
	mov	ax,100h	;done status
	ret
  endp ;read
write	proc	near	;display a char
	les	di,[si+14] ;address of data
	seg	es
	mov	al,[di]	;get byte
	seg	cs
	mov	chr,al	;store it for output
	mov	dx,offset f8m
	call	disp	;display message & char
	mov	ax,100h	;done status
	ret
  endp ;write	
disp	proc	near	;display a string @CS:DX
	push	ds
	push	cs
	pop	ds	;to driver seg
	mov	ah,9
	int	21H	;string output
	pop	ds
	ret
  endp ;disp
;**** start of free area after initializing ***
init	proc near ;called upon loading
	mov	dx,offset f0m
	call	disp	;display message
	mov word [si+14],offset init ;first free
	mov	[si+16],cs ;seg of free
;The following illustrates parameter access
	push	ds
	push	si
	lds	si,[si+18] ;byte following "="
	xor	di,di
	mov	ax,0b000h ;monochrome start
	mov	es,ax
	pushf
	cld
	lodsb		;get parameter char
lp	es:
	mov	[di+8000h],al ;CGA video
	stosb		;to mono video
	inc	di	;skip attribute
	lodsb		;next char
	cmp	al,13	;End of line?
	jne	lp
	popf
	pop	si
	pop	ds
	mov	ax,100h	;done status
	ret
  endp ;init
f0m	db	'Installing CHARIO driver',13,10,'$'
