;***************************************
; This OBJ module defines a routine to
; return the value of a particular bit,
; in other words, a power of 2:
;
;   n = BIT(x)
;
;     where
;
;   n = 2^(x-1)
;
; Defines:
;
;   BIT  return bit value
;
; Assemble as:
;
;   WASM bit bit.obj

        INCLUDE 'object.inc'

        INIT    'BIT.ASM', '_TEXT', 'CODE', ALIGN_BYTE + COMBINE_PUBLIC

        PUBLIC  BIT, 'BIT'

        BEGIN

BIT     PROC    FAR
        push    bp
        mov     bp, sp
        mov     cx, [bp+6]      ;load bit number
        mov     ax, 1           ;bit zero
        sub     dx, dx          ;zero high word
        sub     cx, 1           ;decrement
        jbe     bit2            ;exit if done
bit1    shl     ax              ;shift low word
        rcl     dx              ;shift high word
        loop    bit1            ;loop for count
bit2    pop     bp
        ret     2
        ENDP

        END
