;***************************************;
; WASM Video Module, Write Routines     ;
; By Eric Tauck                         ;
;                                       ;
; Defines:                              ;
;                                       ;
;   WrtChr   write a character          ;
;   WrtChrs  write multiple characters  ;
;   WrtStr   write a string             ;
;   WrtStrc  write a string with length ;
;                                       ;
; Requires:                             ;
;                                       ;
;   VIDEO1.ASM                          ;
;***************************************;

        jmps    _video5_end

;========================================
; Write a character.
;
; In: AL= character.

WrtChr  PROC    NEAR
        mov     _vid_curadv, 1  ;save advance length
        push    di
        push    es
        mov     ah, _vid_attr   ;load attribute
        les     di, _vid_addr   ;load address
        cld
        stosw                   ;store character/attribute
        pop     es
        pop     di
        ret
        ENDP

;========================================
; Write multiple characters.
;
; In: AL= character; CL= count.

WrtChrs PROC    NEAR
        mov     _vid_curadv, cl ;save advance length
        sub     ch, ch
        push    di
        push    es
        mov     ah, _vid_attr   ;load attribute
        sub     ch, ch          ;zero CH
        les     di, _vid_addr   ;load address
        cld
        rep                     ;for count
        stosw                   ;store characters/attributes
        pop     es
        pop     di
        ret
        ENDP

;========================================
; Write an ASCIIZ string.
;
; In: AX= offset.
;
; Out: CL= string length.

WrtStr  PROC    NEAR
        sub     cl, cl          ;zero CL
        push    di
        push    si
        push    es
        les     di, _vid_addr   ;load address
        mov     si, ax          ;put source in SI
        mov     ah, _vid_attr   ;load attribute
        cld
        jmps    _wtstz2         ;enter loop
_wtstz1 stosw                   ;store character/attribute
        inc     cl              ;increment length
_wtstz2 lodsb                   ;load character
        or      al, al          ;check if end of string
        jnz     _wtstz1         ;loop back if not
        pop     es
        pop     si
        pop     di
        mov     _vid_curadv, cl ;save advance length
        ret
        ENDP

;========================================
; Write a string.
;
; In: AX= offset; CL= length.

WrtStrc PROC    NEAR
        mov     _vid_curadv, cl ;save advance length
        sub     ch, ch
        jcxz    _wtstr2         ;exit if zero characters
        push    di
        push    si
        push    es
        sub     ch, ch          ;zero CH
        les     di, _vid_addr   ;load address
        mov     si, ax          ;put source in SI
        mov     ah, _vid_attr   ;load attribute
        cld
_wtstr1 lodsb                   ;load character
        stosw                   ;store character/attribute
        loop    _wtstr1         ;loop for each character
        pop     es
        pop     si
        pop     di
_wtstr2 ret
        ENDP

_video5_end
