;**********************************;
; WASM TSR Support, Resident Query ;
; By Eric Tauck                    ;
;                                  ;
; Defines:                         ;
;                                  ;
;   Trap21  hook interrupt 21      ;
;   Free21  release interrupt 21   ;
;   Okay21  verify interrupt 21    ;
;   Query   query resident TSR     ;
;                                  ;
; Requires:                        ;
;                                  ;
;   INTR.ASM                       ;
;**********************************;

; Note: program must define: TSR_ID1, TSR_ID2, and TsrUsr.
  
        jmps    _tsr2_end

_tsr_int21      LABEL   DWORD
                DS      4

;========================================
; Macro to hook the INT 21H hander.

Trap21  MACRO

;--- save old interrupt

        mov     al, 21H                 ;interrupt number
        call    IntGet                  ;get interrupt
        mov     WORD _tsr_int21, bx     ;save segment
        mov     WORD _tsr_int21+2, dx   ;save offset

;--- hook new interrupt

        mov     al, 21H                 ;interrupt number
        mov     dx, ds                  ;segment
        mov     bx, OFFSET _tsr_dos     ;offset
        call    IntSet                  ;set interrupt
        ENDM

;========================================
; Macro to unhook the INT 21H handler.
;
; In: seg= TSR segment address in a
;          register or variable.

Free21  MACRO   seg
        push    ds
        mov     ds, seg
        mov     bx, WORD _tsr_int21     ;load offset
        mov     dx, WORD _tsr_int21+2   ;load segment
        pop     ds
        mov     al, 21H                 ;interrupt number
        call    IntSet                  ;restore interrupt
        ENDM

;========================================
; Macro to check that INT 21 can be
; unhooked with Free21.
;
; In: seg= TSR segment address in a
;          register or variable.
;
; Out: ZY= set if okay.

Okay21  MACRO   seg
        push    seg
        mov     al, 21H                 ;interrupt number
        call    IntGet                  ;get interrupt address
        pop     ax
        cmp     bx, OFFSET _tsr_dos     ;check offset
        jne     _oky211
        cmp     dx, ax                  ;check segment
_oky211
        ENDM

;========================================
; Macro to query a resident TSR.
;
; In: code= query function code.
;
; Out: CY= set if no response from TSR.

Query   MACRO   code
        IFN     TYPE(code) = TYPE()
        mov     al, code                        ;code
        ENDIF
        mov     ah, 2BH                         ;set date function
        mov     cx, TSR_ID1                     ;id one
        mov     dx, TSR_ID2                     ;id two
        int     21H                             ;execute
        sub     al, 1                           ;carry set if okay
        cmc                                     ;carry set if error
        ENDM

;========================================
; Interrupt 21H handler.

_tsr_dos PROC   FAR
        cmp     ah, 2Bh                 ;check set date function
        jne     _tsrdo4
        cmp     cx, TSR_ID1             ;check if first id matches
        jne     _tsrdo4
        cmp     dx, TSR_ID2             ;check if second id matches
        jne     _tsrdo4

;--- external query

        push    bx
        mov     bx, OFFSET TsrUsr       ;user function table
        jmps    _tsrdo2

_tsrdo1 add     bx, 3                   ;next table entry
_tsrdo2 seg     cs
        cmp     BYTE [bx], 0            ;check if end of table
        je      _tsrdo3                 ;exit if so
        seg     cs
        cmp     [bx], al                ;check if command matches
        jne     _tsrdo1                 ;loop back if not
        seg     cs
        mov     ax, [bx + 1]            ;load routine
        pop     bx

        push    ds
        push    es
        mov     dx, cs
        mov     ds, dx                  ;load data segments
        mov     es, dx                  ;
        call    ax                      ;call routine
        pop     es
        pop     ds

        sub     al, al                  ;clear error
        clc                             ;no carry
        ret     2                       ;exit

;--- invalid resident function

_tsrdo3 pop     bx
        mov     al, 0FFH                ;return error
        stc
        ret     2

;--- branch to old DOS

_tsrdo4 seg     cs
        jmp     _tsr_int21              ;branch to dos handler
        ENDP

_tsr2_end
