#!/bin/sh
#
# Copyright (c) 2018 TK Chia
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
#   * Redistributions of source code must retain the above copyright notice,
#     this list of conditions and the following disclaimer.
#   * Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#   * Neither the name of the developer(s) nor the names of its contributors
#     may be used to endorse or promote products derived from this software
#     without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
# IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
# THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

# Given libi86.a, automatically generate a header file which defines macros
# for routines implemented in the current libi86.

set -e

if [ $# = 0 ]; then
  echo "usage: `basename "$0"` libi86.a" >&2
  exit 1
fi

cat <<FIN
/* Automatically generated by `basename "$0"` on `TZ=UTC0 date +%Y%m%d`. */

#ifndef _LIBI86_LIBI86_CONFIG_H_
#define _LIBI86_LIBI86_CONFIG_H_

#include <libi86/internal/acconfig.h>

FIN

${NM-'ia16-elf-nm'} -P "$@" | \
  ${AWK-'awk'} '!/:$/ && !/^_[_ABCDEFGHIJKLMNOPQRSTUVWXYZ]/ && / [TDBW] / {
		  if ($2 == "T" || $2 == "D" || $2 == "B" || $2 == "W")
		    {
		      print "/* " $1 " is implemented. */"
		      print "#define _LIBI86_HAVE_" toupper($1) " 1"
		      print ""
		    }
		}'

cat <<FIN
#endif
FIN
