Unit Windows;
Interface
USES
  Crt, Graph, Yd;
{
177=  178=  179=  180=  181=  182=  183=  184=  185=  186=  187=

188=  189=  190=  191=  192=  193=  194=  195=  196=  197=  198=

199=  200=  201=  202=  203=  204=  205=  206=  207=  208=  209=

210=  211=  212=  213=  214=  215=  216=  217=  218=  219=  220=

221=  222=  223=  176=
}

CONST
  BoxChar : ARRAY[1..9, 1..6] of Char =
      ((#218, #196, #191, #179, #192, #217),
       (#201, #205, #187, #186, #200, #188),
       (#213, #205, #184, #179, #212, #190),
       (#214, #196, #183, #186, #211, #189),
       (#219, #219, #219, #186, #219, #219),
       (#176, #176, #176, #186, #176, #176),
       (#177, #177, #177, #186, #177, #177),
       (#178, #178, #178, #186, #178, #178),
       (#201, #240, #187, #186, #200, #188));
TYPE
  BStyle = (Single, Double, Hide, Special1,
            Special2, Special3, Special4,
            Special5, Special6, AppleStyle);
  Box    = Object
    x1, y1, x2, y2 : integer;
    Color          : Byte;
    Style          : BStyle;
  Procedure Init(Px1, Py1, Px2, Py2 : integer; PColor : Byte;
               PStyle : BStyle);
  Procedure Draw;
  Procedure Erase;
End;

Type
   Win = Object(Box)
   Fill : Byte;
   Title : String;
   Procedure Init(Px1, Py1, Px2, Py2 : integer; PColor, PFill : Byte;
               PTitle : String; PStyle : BStyle);
   Procedure Draw;
   Procedure Erase;
End;

Implementation
Procedure Box.Init(Px1, Py1, Px2, Py2 : integer; PColor : Byte;
                PStyle : BStyle);
Begin
   x1     := Px1;
   y1     := Py1;
   x2     := Px2;
   y2     := Py2;
   Color  := PColor;
   Style  := PStyle;
End;

Procedure Box.Draw;
VAR
 B, I   : integer;
 BColor : Byte;

Begin
   TextColor(Color);
   IF Style = Single THEN B := 1
   ELSE IF Style = Double THEN B := 2
   ELSE IF Style = Hide THEN
   Begin
      B := 1;
      BColor := GetBkColor;
      TextColor(BColor);
   End
   else if Style = Special1 then B := 3
   else if Style = Special2 then B := 4
   else if Style = Special3 then B := 5
   else if Style = Special4 then B := 6
   else if Style = Special5 then B := 7
   else if Style = Special6 then B := 8
   else if Style = AppleStyle then B := 9;
   GoToXY(x1, y1);
   Write(BoxChar[B, 1]);
   FOR I := 1 TO (x2 -x1) - 1 DO
   Begin
      GoToXY(x1 + I, y1);
      Write(BoxChar[B, 2]);
   End;
   GoToXY(x2, y1);
   Write(BoxChar[B, 3]);
   FOR I := y1 + 1 TO  y2 - 1 DO
   Begin
      GoToXY(x1, I);
      Write(BoxChar[B, 4]);
      GoToXY(x2, I);
      Write(BoxChar[B, 4]);
   End;
   GoToXY(x1, y2);
   Write(BoxChar[B, 5]);
   FOR I := 1 TO (x2 - x1) - 1 DO
   Begin
      GoToXY(x1 + I, y2);
      Write(BoxChar[B, 2]);
   End;
   GoToXY(x2, y2);
   Write(BoxChar[B, 6]);
End;

Procedure Box.Erase;
VAR
  SaveStyle : BStyle;
Begin
   SaveStyle := Style;
   Style := Hide;
   Draw;
   Style := SaveStyle;
End;

Procedure Win.Init(Px1, Py1, Px2, Py2 : integer; PColor, PFill : Byte;
                           PTitle : String; PStyle : BStyle);
Begin
   x1     := Px1;
   y1     := Py1;
   x2     := Px2;
   y2     := Py2;
   Color  := PColor;
   Style  := PStyle;
   Title  := PTitle;
   Fill   := PFill;
End;
Procedure Win.Draw;
Begin
   TextBackground(Fill);
   Box.Draw;
   GoToXY((X2+X1) div 2-Length(Title)+Length(Title) div 2,y1);
   Write(Title);
   Window(X1+1, Y1+1, X2-1, Y2-1);
   ClrScr;
End;
Procedure Win.Erase;
Begin
   TextBackground(0);
   ClrScr;
   Window(1,1,80,25);
   Box.Erase;
End;
End.