////////////////////////////////////////////////////////////////////////////////
//
//  Clipboard - Core File
//
//	(c) Copyright 2003,2004 Point Mad, Lukas Lipka. All rights reserved.
//
////////////////////////////////////////////////////////////////////////////////

#include "kernel.h"
#include "clipboard.h"

l_ulong	AppVersion = ULONG_ID(0, 0, 0, 1);
l_char	AppName[] = "Clipboard";
l_uid	nUID = "clipbrd";

TClipboardItem Clipboard;


void ClipboardPut ( l_ulong Type, void *Data, l_ulong Size, l_bool Duplicate ) {
	if ( Duplicate )
		Clipboard.Data = DataDuplicate(Type,Data,Size);
	else
		Clipboard.Data = Data;
	Clipboard.Type = Type;
	Clipboard.Size = Size;
}

void *ClipboardGet ( l_ulong Type, l_ulong *Size ) {
	if ( Clipboard.Type != Type ) return 0;
	if ( Size ) *Size = Clipboard.Size;
	return Clipboard.Data;
}

void ClipboardFree ( void ) {
	if ( Clipboard.Data ) DataFree(Clipboard.Type,Clipboard.Data);
	Clipboard.Type = 0;
	Clipboard.Size = 0;
}

l_int LibMain(l_text Args)
{
	
	APPEXPORT(ClipboardPut);
	APPEXPORT(ClipboardGet);
	APPEXPORT(ClipboardFree);

	return true;
}

void Close(void)
{
	
	ClipboardFree();
	
}
