////////////////////////////////////////////////////////////////////////////////
//
//  Widgets - Header File
//
//	(c) Copyright 2003,2004 Point Mad, Lukas Lipka. All rights reserved.
//
////////////////////////////////////////////////////////////////////////////////

#include "metrics.h"
#include "dynld.h"

#ifndef _WIDGET_H_INCLUDED_
#define _WIDGET_H_INCLUDED_

typedef struct TWidget *PWidget;
typedef struct TWidget
{
	l_ulong Type;

	TRect Relative;
	TRect Absolute;

	TRect DrawAbsolute;
	//TRect SizeLimits;

	TRect ChildArea;
	TRect ChildDrawAbs;

	PWidget Prev;
	PWidget Next;
	PWidget Last;
	PWidget Parent;

	l_text	Name;
	l_long  BackgroundColor;
	l_ulong Flags;

	PApplication AppOwner;

	l_ulong MessageBuffer;

	l_bool (*EventHandler) ( PWidget o, PEvent Ev );
	l_bool (*AppEvHdl) ( PWidget o, PEvent Ev );

	void (*Refresh)		( PWidget o, PRect w, p_bitmap Out, PPoint delta, l_ulong Flags, PWidget extoa );

	void (*Draw)		  ( PWidget o, p_bitmap buffer, PRect w );
	void (*FreeEx)		( PWidget o );

	void (*Setup)     ( PWidget o );

	void (*Insert)    ( PWidget o, PWidget i );
	void (*Remove)    ( PWidget o, PWidget i );
	void (*SetFirstEx)    ( PWidget o, PWidget i );



	PWidget FocusBack;

	l_uchar Alpha;

	TPoint  	APoint;
	p_bitmap ACache;

} TWidget;

////////////////////////////////////////////////////////////////////////////////

#define WIDGET(o) ((PWidget)(o))

#define MSG_NONE 0x00
#define MSG_MSGCANCEL 0x01


extern p_bitmap wallpaper;

extern PWidget DeskTop;
extern PWidget Desktop;
extern PWidget MasterWidget;
extern PWidget FocusedWidget;

PWidget		IntialiseWidget		( PApplication App, PWidget o, TRect r, l_text Name );


PWidget		NewWidget			( PApplication App, TRect r, l_text Name );
void		WidgetDrawOnRect	( PWidget o, TRect w, PWidget Ignore );
void		WidgetMove			( PWidget o, l_long dX, l_long dY );
void		WidgetResize		( PWidget o, l_long dW, l_long dH );
void		WidgetResizeToSize	( PWidget o, l_long SizeX, l_long SizeY );
void		WidgetMoveToPoint	( PWidget o, l_int x, l_int y );
void		WidgetSetMetrics	( PWidget o, l_int x, l_int y, l_int w, l_int h );
l_bool  WidgetSendEvent			( PWidget o, TEvent Ev );
void WidgetDrawAll ( PWidget o );

void		WidgetInsert		( PWidget o, PWidget i );
void		WidgetRemove		( PWidget o, PWidget i );

#define InsertWidget(o,i) o->Insert(o,i)
#define RemoveWidget(o,i) o->Remove(o,i)

#define WidgetSize(r,x,y,w,h) RectAssign(r,x,y,x+w,y+h)

void WidgetSetOSDRect ( TRect r );
void WidgetUnOSD ( void );

void WidgetDispose ( PWidget o );
l_ulong WidgetExecute ( PWidget o );

void WidgetSetFirst ( PWidget o );

void WidgetSetFocusEx ( PWidget o );
void WidgetSetFocus ( PWidget o );


// Use between insertion in parent and 1st draw
void WidgetPreCenter ( PWidget o );

void WidgetUnMakeSync ( PWidget *o );
void WidgetMakeSync ( PWidget *o );

void WidgetSetChildArea( PWidget o, TRect r );
l_bool WidgetSendPEvent ( PWidget o, PEvent Ev );


void WidgetSetRect ( PWidget o, TRect r );

void WidgetSelect ( PWidget o );
void WidgetUnSelectAllSubs ( PWidget o );
void WidgetSetFirstEx ( PWidget o, PWidget i  );

void WidgetDraw ( PWidget o, PRect w );

void WidgetSendUniversalPEvent ( PEvent Ev );
void WidgetSendUniversalEvent ( TEvent Ev );
void WidgetSetFocusExNoNotify ( PWidget o );

l_bool WidgetSendSEvent ( PWidget o, l_int Type, l_ulong Message, void *Extra );
l_bool WidgetSendEEvent ( PWidget o, l_int Type, l_ulong Message, void *Extra, TKeybState  Keyb, TMouseState Mouse );

////////////////////////////////////////////////////////////////////////////////
// Flags
#define WFVisible					0x00000001
#define WFForceBuffer			0x00000002 // Just if it blink too much...
#define WFForceNonBuffer	0x00000004 // Faster for some uses, BUT you must respect (Rect *w) for drawing to not waste time
#define WFFocused					0x00000008
#define WFFocusable				0x00000010
#define WFOnTop						0x00000020
#define WFSelectable			0x00000040
#define WFSelected				0x00000080

#define WFExecuting				0x80000000


#define WF_AUTORESIZE			0x00100000
#define WF_FIXEDWIDTH			0x00200000
#define WF_FIXEDHEIGHT		0x00400000
#define WF_MAGNETRIGHT		0x00800000
#define WF_MAGNETBOTTOM		0x01000000

////////////////////////////////////////////////////////////////////////////////
// Events

// 0xFFFF1XXX reserved for mouse events

#define WEvMouse		0xFFFF1000
#define WEvKeyboard		0xFFFF2000
#define WEvNotify 		0xFFFF4000

#define WEvMouseOther	0x100
#define WEvMouseUp		0x200
#define WEvMouseDown	0x400
#define WEvMouseDClk	0x800

#define WEvMouseR		0x01
#define WEvMouseM		0x02
#define WEvMouseL		0x04

#define WEvMouseLeft	0xFFFF1101
#define WEvMouseEnter	0xFFFF1102
#define WEvMouseMove	0xFFFF1103
#define WEvMouseEnterDelay	0xFFFF1104

#define WEvMouseRUp		0xFFFF1201
#define WEvMouseMUp		0xFFFF1202
#define WEvMouseLUp		0xFFFF1204

#define WEvMouseRDown	0xFFFF1401
#define WEvMouseMDown	0xFFFF1402
#define WEvMouseLDown	0xFFFF1404

#define WEvMouseRDClk	0xFFFF1801
#define WEvMouseMDClk	0xFFFF1802
#define WEvMouseLDClk	0xFFFF1804

#define WEvMouseRClick	WEvMouseRUp
#define WEvMouseMClick	WEvMouseMUp
#define WEvMouseLClick	WEvMouseLUp

#define WEvNotifyLostFocus 0xFFFF4001
#define WEvNotifyFocused   0xFFFF4002
#define WEvNotifySameFocus 0xFFFF4003 // A focus change was try, but no change (usefull for some widget like menus)

#define WEvNotifySelect 	0xFFFF4004
#define WEvNotifyUnSelect 	0xFFFF4005

#define MSG_NOTIFY_AUTO_RESIZE 	0xFFFF4006
/**
*	Default messages (Reserved 0xFFFF8XXX)
*/
#define MSG_OK		0xFFFF8001
#define MSG_CANCEL	0xFFFF8002
#define MSG_YES		0xFFFF8004
#define MSG_NO		0xFFFF8008
#define MSG_APPLY	0xFFFF8016
#define MSG_YESALL	0xFFFF8017


void SwitchGraphicsMode ( void );
void SwitchTextMode ( void );

#endif /* _WIDGET_H_INCLUDED_ */
