
 id=U2;
 object[id].max_draw_dist=5000;
 object[id].always_draw_dist=50;

 object[id].nvertices = 120;
 object[id].nfacets   =  71; /* Excluding control surface polys */
 object[id].nctrl_srf =  10;

 object[id].ctrl_surface[0].hinge.x      =  -6.86;
 object[id].ctrl_surface[0].hinge.y      =   0;
 object[id].ctrl_surface[0].hinge.z      =   0.57;
 object[id].ctrl_surface[0].rudder_gain  =   0;
 object[id].ctrl_surface[0].aileron_gain =   0;
 object[id].ctrl_surface[0].elevator_gain=   1;
 object[id].ctrl_surface[0].flap_gain    =   0;
 object[id].ctrl_surface[0].brake_gain   =   0;
 object[id].ctrl_surface[0].gear_gain    =   0;
 object[id].ctrl_surface[0].gear_id      =  -1;
 object[id].ctrl_surface[0].nctrlpoly    =   4;
 object[id].ctrl_surface[0].poly_id[0]   =  71;
 object[id].ctrl_surface[0].poly_id[1]   =  72;
 object[id].ctrl_surface[0].poly_id[2]   =  73;
 object[id].ctrl_surface[0].poly_id[3]   =  74;

 object[id].ctrl_surface[1].hinge.x      =  -7.12;
 object[id].ctrl_surface[1].hinge.y      =   0;
 object[id].ctrl_surface[1].hinge.z      =   0.57;
 object[id].ctrl_surface[1].rudder_gain  =   1;
 object[id].ctrl_surface[1].aileron_gain =   0;
 object[id].ctrl_surface[1].elevator_gain=   0;
 object[id].ctrl_surface[1].flap_gain    =   0;
 object[id].ctrl_surface[1].brake_gain   =   0;
 object[id].ctrl_surface[1].gear_gain    =   0;
 object[id].ctrl_surface[1].gear_id      =  -1;
 object[id].ctrl_surface[1].nctrlpoly    =   2;
 object[id].ctrl_surface[1].poly_id[0]   =  75;
 object[id].ctrl_surface[1].poly_id[1]   =  76;

 object[id].ctrl_surface[2].hinge.x      =  -1.564;
 object[id].ctrl_surface[2].hinge.y      =   7.74;
 object[id].ctrl_surface[2].hinge.z      =  -0.134;
 object[id].ctrl_surface[2].rudder_gain  =   0;
 object[id].ctrl_surface[2].aileron_gain =   0;
 object[id].ctrl_surface[2].elevator_gain=   0;
 object[id].ctrl_surface[2].flap_gain    =   1.5;
 object[id].ctrl_surface[2].brake_gain   =   0;
 object[id].ctrl_surface[2].gear_gain    =   0;
 object[id].ctrl_surface[2].gear_id      =  -1;
 object[id].ctrl_surface[2].nctrlpoly    =   2;
 object[id].ctrl_surface[2].poly_id[0]   =  77;
 object[id].ctrl_surface[2].poly_id[1]   =  78;

 object[id].ctrl_surface[3].hinge.x      =  -1.564;
 object[id].ctrl_surface[3].hinge.y      =  -7.74;
 object[id].ctrl_surface[3].hinge.z      =  -0.134;
 object[id].ctrl_surface[3].rudder_gain  =   0;
 object[id].ctrl_surface[3].aileron_gain =   0;
 object[id].ctrl_surface[3].elevator_gain=   0;
 object[id].ctrl_surface[3].flap_gain    =   1.5;
 object[id].ctrl_surface[3].brake_gain   =   0;
 object[id].ctrl_surface[3].gear_gain    =   0;
 object[id].ctrl_surface[3].gear_id      =  -1;
 object[id].ctrl_surface[3].nctrlpoly    =   2;
 object[id].ctrl_surface[3].poly_id[0]   =  79;
 object[id].ctrl_surface[3].poly_id[1]   =  80;

 object[id].ctrl_surface[4].hinge.x      =  -1.564;
 object[id].ctrl_surface[4].hinge.y      =   7.74;
 object[id].ctrl_surface[4].hinge.z      =  -0.134;
 object[id].ctrl_surface[4].rudder_gain  =   0;
 object[id].ctrl_surface[4].aileron_gain =   1;
 object[id].ctrl_surface[4].elevator_gain=   0;
 object[id].ctrl_surface[4].flap_gain    =   0;
 object[id].ctrl_surface[4].brake_gain   =   0;
 object[id].ctrl_surface[4].gear_gain    =   0;
 object[id].ctrl_surface[4].gear_id      =  -1;
 object[id].ctrl_surface[4].nctrlpoly    =   2;
 object[id].ctrl_surface[4].poly_id[0]   =  81;
 object[id].ctrl_surface[4].poly_id[1]   =  82;

 object[id].ctrl_surface[5].hinge.x      =  -1.564;
 object[id].ctrl_surface[5].hinge.y      =  -7.74;
 object[id].ctrl_surface[5].hinge.z      =  -0.134;
 object[id].ctrl_surface[5].rudder_gain  =   0;
 object[id].ctrl_surface[5].aileron_gain =  -1;
 object[id].ctrl_surface[5].elevator_gain=   0;
 object[id].ctrl_surface[5].flap_gain    =   0;
 object[id].ctrl_surface[5].brake_gain   =   0;
 object[id].ctrl_surface[5].gear_gain    =   0;
 object[id].ctrl_surface[5].gear_id      =  -1;
 object[id].ctrl_surface[5].nctrlpoly    =   2;
 object[id].ctrl_surface[5].poly_id[0]   =  83;
 object[id].ctrl_surface[5].poly_id[1]   =  84;

 object[id].ctrl_surface[6].hinge.x      =  -2.92;
 object[id].ctrl_surface[6].hinge.y      =   0.68;
 object[id].ctrl_surface[6].hinge.z      =  -0.28;
 object[id].ctrl_surface[6].rudder_gain  =   0;
 object[id].ctrl_surface[6].aileron_gain =   0;
 object[id].ctrl_surface[6].elevator_gain=   0;
 object[id].ctrl_surface[6].flap_gain    =   0;
 object[id].ctrl_surface[6].brake_gain   =  35;
 object[id].ctrl_surface[6].gear_gain    =   0;
 object[id].ctrl_surface[6].gear_id      =  -1;
 object[id].ctrl_surface[6].nctrlpoly    =   2;
 object[id].ctrl_surface[6].poly_id[0]   =  85;
 object[id].ctrl_surface[6].poly_id[1]   =  86;

 object[id].ctrl_surface[7].hinge.x      =  -2.92;
 object[id].ctrl_surface[7].hinge.y      =  -0.68;
 object[id].ctrl_surface[7].hinge.z      =  -0.28;
 object[id].ctrl_surface[7].rudder_gain  =   0;
 object[id].ctrl_surface[7].aileron_gain =   0;
 object[id].ctrl_surface[7].elevator_gain=   0;
 object[id].ctrl_surface[7].flap_gain    =   0;
 object[id].ctrl_surface[7].brake_gain   =  35;
 object[id].ctrl_surface[7].gear_gain    =   0;
 object[id].ctrl_surface[7].gear_id      =  -1;
 object[id].ctrl_surface[7].nctrlpoly    =   2;
 object[id].ctrl_surface[7].poly_id[0]   =  87;
 object[id].ctrl_surface[7].poly_id[1]   =  88;

 object[id].ctrl_surface[8].hinge.x      =   0.92;
 object[id].ctrl_surface[8].hinge.y      =   0.00;
 object[id].ctrl_surface[8].hinge.z      =  -0.65;
 object[id].ctrl_surface[8].rudder_gain  =   0;
 object[id].ctrl_surface[8].aileron_gain =   0;
 object[id].ctrl_surface[8].elevator_gain=   0;
 object[id].ctrl_surface[8].flap_gain    =   0;
 object[id].ctrl_surface[8].brake_gain   =   0;
 object[id].ctrl_surface[8].gear_gain    =  90;
 object[id].ctrl_surface[8].gear_id      =   1;
 object[id].ctrl_surface[8].nctrlpoly    =   4;
 object[id].ctrl_surface[8].poly_id[0]   =  89;
 object[id].ctrl_surface[8].poly_id[1]   =  90;
 object[id].ctrl_surface[8].poly_id[2]   =  91;
 object[id].ctrl_surface[8].poly_id[3]   =  92;

 object[id].ctrl_surface[9].hinge.x      =  -5.00;
 object[id].ctrl_surface[9].hinge.y      =   0.00;
 object[id].ctrl_surface[9].hinge.z      =  -0.50;
 object[id].ctrl_surface[9].rudder_gain  =   0;
 object[id].ctrl_surface[9].aileron_gain =   0;
 object[id].ctrl_surface[9].elevator_gain=   0;
 object[id].ctrl_surface[9].flap_gain    =   0;
 object[id].ctrl_surface[9].brake_gain   =   0;
 object[id].ctrl_surface[9].gear_gain    =  90;
 object[id].ctrl_surface[9].gear_id      =   0;
 object[id].ctrl_surface[9].nctrlpoly    =   4;
 object[id].ctrl_surface[9].poly_id[0]   =  93;
 object[id].ctrl_surface[9].poly_id[1]   =  94;
 object[id].ctrl_surface[9].poly_id[2]   =  95;
 object[id].ctrl_surface[9].poly_id[3]   =  96;

 nfacets=object[id].nfacets;
 for (j=0; j<object[id].nctrl_srf; j++) nfacets+=object[id].ctrl_surface[j].nctrlpoly;

 if ((object[id].vertex = malloc(object[id].nvertices*sizeof(cartvektor))) == NULL)
 {
   printf("Not enough memory\n");
   exit(1);
 }

 if ((object[id].facet = malloc(nfacets*sizeof(polygon_struct))) == NULL)
 {
   printf("Not enough memory\n");
   exit(1);
 }
 facetid=object[id].facet;

 /* port wing */
 (object[id].vertex+0)->x= 0.89;
 (object[id].vertex+0)->y= 0.94;
 (object[id].vertex+0)->z= 0.00;

 (object[id].vertex+1)->x=-0.88;
 (object[id].vertex+1)->y=12.20;
 (object[id].vertex+1)->z=-0.098;

 (object[id].vertex+2)->x=-1.77;
 (object[id].vertex+2)->y=12.20;
 (object[id].vertex+2)->z=-0.146;

 (object[id].vertex+3)->x=-2.40;
 (object[id].vertex+3)->y= 0.72;
 (object[id].vertex+3)->z=-0.18;

 /* stb. wing */
 (object[id].vertex+4)->x= 0.89;
 (object[id].vertex+4)->y=-0.94;
 (object[id].vertex+4)->z= 0.00;

 (object[id].vertex+5)->x=-0.88;
 (object[id].vertex+5)->y=-12.20;
 (object[id].vertex+5)->z=-0.098;

 (object[id].vertex+6)->x=-1.77;
 (object[id].vertex+6)->y=-12.20;
 (object[id].vertex+6)->z=-0.146;

 (object[id].vertex+7)->x=-2.40;
 (object[id].vertex+7)->y=-0.72;
 (object[id].vertex+7)->z=-0.18;

 /* nose */
 (object[id].vertex+8)->x= 7.11;
 (object[id].vertex+8)->y= 0.00;
 (object[id].vertex+8)->z=-0.15;

 (object[id].vertex+9)->x= 6.75;
 (object[id].vertex+9)->y= 0.093;
 (object[id].vertex+9)->z= 0.226-0.15;

 (object[id].vertex+10)->x= 6.75;
 (object[id].vertex+10)->y= 0.226;
 (object[id].vertex+10)->z= 0.093-0.15;

 (object[id].vertex+11)->x= 6.75;
 (object[id].vertex+11)->y= 0.226;
 (object[id].vertex+11)->z=-0.093-0.15;

 (object[id].vertex+12)->x= 6.75;
 (object[id].vertex+12)->y= 0.093;
 (object[id].vertex+12)->z=-0.226-0.15;

 (object[id].vertex+13)->x= 6.75;
 (object[id].vertex+13)->y=-0.093;
 (object[id].vertex+13)->z=-0.226-0.15;

 (object[id].vertex+14)->x= 6.75;
 (object[id].vertex+14)->y=-0.226;
 (object[id].vertex+14)->z=-0.093-0.15;

 (object[id].vertex+15)->x= 6.75;
 (object[id].vertex+15)->y=-0.226;
 (object[id].vertex+15)->z= 0.093-0.15;

 (object[id].vertex+16)->x= 6.75;
 (object[id].vertex+16)->y=-0.093;
 (object[id].vertex+16)->z= 0.226-0.15;

 /* Canopy */
 (object[id].vertex+17)->x= 5.45;
 (object[id].vertex+17)->y= 0.17;
 (object[id].vertex+17)->z= 0.39;

 (object[id].vertex+18)->x= 5.45;
 (object[id].vertex+18)->y=-0.17;
 (object[id].vertex+18)->z= 0.39;

 (object[id].vertex+19)->x= 4.68;
 (object[id].vertex+19)->y= 0.38;
 (object[id].vertex+19)->z= 0.42;

 (object[id].vertex+20)->x= 4.68;
 (object[id].vertex+20)->y=-0.38;
 (object[id].vertex+20)->z= 0.42;

 (object[id].vertex+21)->x= 4.77;
 (object[id].vertex+21)->y= 0.09;
 (object[id].vertex+21)->z= 0.73;

 (object[id].vertex+22)->x= 4.77;
 (object[id].vertex+22)->y=-0.09;
 (object[id].vertex+22)->z= 0.73;

 (object[id].vertex+23)->x= 3.87;
 (object[id].vertex+23)->y= 0.41;
 (object[id].vertex+23)->z= 0.46;

 (object[id].vertex+24)->x= 3.87;
 (object[id].vertex+24)->y=-0.41;
 (object[id].vertex+24)->z= 0.46;

 (object[id].vertex+25)->x= 3.87;
 (object[id].vertex+25)->y= 0.18;
 (object[id].vertex+25)->z= 0.80;

 (object[id].vertex+26)->x= 3.87;
 (object[id].vertex+26)->y=-0.18;
 (object[id].vertex+26)->z= 0.80;

 (object[id].vertex+27)->x= 3.87;
 (object[id].vertex+27)->y= 0.57;
 (object[id].vertex+27)->z=-0.23;

 (object[id].vertex+28)->x= 3.87;
 (object[id].vertex+28)->y= 0.23;
 (object[id].vertex+28)->z=-0.57;

 (object[id].vertex+29)->x= 3.87;
 (object[id].vertex+29)->y=-0.23;
 (object[id].vertex+29)->z=-0.57;

 (object[id].vertex+30)->x= 3.87;
 (object[id].vertex+30)->y=-0.57;
 (object[id].vertex+30)->z=-0.23;

 (object[id].vertex+31)->x= 3.87;
 (object[id].vertex+31)->y= 0.57;
 (object[id].vertex+31)->z= 0.23;

 (object[id].vertex+32)->x= 3.87;
 (object[id].vertex+32)->y=-0.57;
 (object[id].vertex+32)->z= 0.23;

 (object[id].vertex+33)->x=-2.24;
 (object[id].vertex+33)->y= 0.28;
 (object[id].vertex+33)->z= 0.68;

 (object[id].vertex+34)->x=-2.24;
 (object[id].vertex+34)->y= 0.68;
 (object[id].vertex+34)->z= 0.28;

 (object[id].vertex+35)->x=-2.24;
 (object[id].vertex+35)->y= 0.68;
 (object[id].vertex+35)->z=-0.28;

 (object[id].vertex+36)->x=-2.24;
 (object[id].vertex+36)->y= 0.28;
 (object[id].vertex+36)->z=-0.68;

 (object[id].vertex+37)->x=-2.24;
 (object[id].vertex+37)->y=-0.28;
 (object[id].vertex+37)->z=-0.68;

 (object[id].vertex+38)->x=-2.24;
 (object[id].vertex+38)->y=-0.68;
 (object[id].vertex+38)->z=-0.28;

 (object[id].vertex+39)->x=-2.24;
 (object[id].vertex+39)->y=-0.68;
 (object[id].vertex+39)->z= 0.28;

 (object[id].vertex+40)->x=-2.24;
 (object[id].vertex+40)->y=-0.28;
 (object[id].vertex+40)->z= 0.68;

 /* rear body */
 (object[id].vertex+41)->x=-7.57;
 (object[id].vertex+41)->y= 0.15;
 (object[id].vertex+41)->z= 0.36+0.09;

 (object[id].vertex+42)->x=-7.57;
 (object[id].vertex+42)->y= 0.36;
 (object[id].vertex+42)->z= 0.15+0.09;

 (object[id].vertex+43)->x=-7.57;
 (object[id].vertex+43)->y= 0.36;
 (object[id].vertex+43)->z=-0.15+0.09;

 (object[id].vertex+44)->x=-7.57;
 (object[id].vertex+44)->y= 0.15;
 (object[id].vertex+44)->z=-0.36+0.09;

 (object[id].vertex+45)->x=-7.57;
 (object[id].vertex+45)->y=-0.15;
 (object[id].vertex+45)->z=-0.36+0.09;

 (object[id].vertex+46)->x=-7.57;
 (object[id].vertex+46)->y=-0.36;
 (object[id].vertex+46)->z=-0.15+0.09;

 (object[id].vertex+47)->x=-7.57;
 (object[id].vertex+47)->y=-0.36;
 (object[id].vertex+47)->z= 0.15+0.09;

 (object[id].vertex+48)->x=-7.57;
 (object[id].vertex+48)->y=-0.15;
 (object[id].vertex+48)->z= 0.36+0.09;

 /* tailplane */
 (object[id].vertex+49)->x=-5.46;
 (object[id].vertex+49)->y= 0.00;
 (object[id].vertex+49)->z= 0.57;

 (object[id].vertex+50)->x=-6.26;
 (object[id].vertex+50)->y= 3.06;
 (object[id].vertex+50)->z= 0.57;

 (object[id].vertex+51)->x=-7.10;
 (object[id].vertex+51)->y= 3.06;
 (object[id].vertex+51)->z= 0.57;

 (object[id].vertex+52)->x=-7.41;
 (object[id].vertex+52)->y= 0.00;
 (object[id].vertex+52)->z= 0.57;

 (object[id].vertex+53)->x=-7.10;
 (object[id].vertex+53)->y=-3.06;
 (object[id].vertex+53)->z= 0.57;

 (object[id].vertex+54)->x=-6.26;
 (object[id].vertex+54)->y=-3.06;
 (object[id].vertex+54)->z= 0.57;

 /* tail fin */
 (object[id].vertex+55)->x=-6.91;
 (object[id].vertex+55)->y= 0.00;
 (object[id].vertex+55)->z= 3.62;

 (object[id].vertex+56)->x=-7.75;
 (object[id].vertex+56)->y= 0.00;
 (object[id].vertex+56)->z= 3.62;

 (object[id].vertex+57)->x=-7.75;
 (object[id].vertex+57)->y= 0.00;
 (object[id].vertex+57)->z= 0.57;

 /* air intakes */
 (object[id].vertex+58)->x= 3.51;
 (object[id].vertex+58)->y= 0.69;
 (object[id].vertex+58)->z=-0.30;

 (object[id].vertex+59)->x= 3.51;
 (object[id].vertex+59)->y= 0.59;
 (object[id].vertex+59)->z= 0.42;

 (object[id].vertex+60)->x= 3.51;
 (object[id].vertex+60)->y= 0.96;
 (object[id].vertex+60)->z= 0.17;

 (object[id].vertex+61)->x= 3.51;
 (object[id].vertex+61)->y= 0.96;
 (object[id].vertex+61)->z=-0.09;

 (object[id].vertex+62)->x= 3.51;
 (object[id].vertex+62)->y=-0.69;
 (object[id].vertex+62)->z=-0.30;

 (object[id].vertex+63)->x= 3.51;
 (object[id].vertex+63)->y=-0.59;
 (object[id].vertex+63)->z= 0.42;

 (object[id].vertex+64)->x= 3.51;
 (object[id].vertex+64)->y=-0.96;
 (object[id].vertex+64)->z= 0.17;

 (object[id].vertex+65)->x= 3.51;
 (object[id].vertex+65)->y=-0.96;
 (object[id].vertex+65)->z=-0.09;

 /* air duct */
 (object[id].vertex+66)->x= 1.34;
 (object[id].vertex+66)->y= 0.69;
 (object[id].vertex+66)->z=-0.30;

 (object[id].vertex+67)->x= 1.34;
 (object[id].vertex+67)->y= 0.59;
 (object[id].vertex+67)->z= 0.42;

 (object[id].vertex+68)->x= 1.34;
 (object[id].vertex+68)->y= 0.96;
 (object[id].vertex+68)->z= 0.17;

 (object[id].vertex+69)->x= 1.34;
 (object[id].vertex+69)->y= 0.96;
 (object[id].vertex+69)->z=-0.09;

 (object[id].vertex+70)->x= 1.34;
 (object[id].vertex+70)->y=-0.69;
 (object[id].vertex+70)->z=-0.30;

 (object[id].vertex+71)->x= 1.34;
 (object[id].vertex+71)->y=-0.59;
 (object[id].vertex+71)->z= 0.42;

 (object[id].vertex+72)->x= 1.34;
 (object[id].vertex+72)->y=-0.96;
 (object[id].vertex+72)->z= 0.17;

 (object[id].vertex+73)->x= 1.34;
 (object[id].vertex+73)->y=-0.96;
 (object[id].vertex+73)->z=-0.09;

 /* Elevator */
 (object[id].vertex+74)->x=-6.86;
 (object[id].vertex+74)->y= 3.06;
 (object[id].vertex+74)->z= 0.57;

 (object[id].vertex+75)->x=-6.86;
 (object[id].vertex+75)->y= 0.00;
 (object[id].vertex+75)->z= 0.57;

 (object[id].vertex+76)->x=-6.86;
 (object[id].vertex+76)->y=-3.06;
 (object[id].vertex+76)->z= 0.57;

 /* Rudder */
 (object[id].vertex+77)->x=-7.12;
 (object[id].vertex+77)->y= 0.00;
 (object[id].vertex+77)->z= 0.57;

 (object[id].vertex+78)->x=-7.45;
 (object[id].vertex+78)->y= 0.00;
 (object[id].vertex+78)->z= 2.90;

 (object[id].vertex+79)->x=-7.75;
 (object[id].vertex+79)->y= 0.00;
 (object[id].vertex+79)->z= 2.90;

 /* Ailerons / flaps */
 (object[id].vertex+80)->x= -1.523;
 (object[id].vertex+80)->y= 12.20;
 (object[id].vertex+80)->z= -0.132;

 (object[id].vertex+81)->x=-1.564;
 (object[id].vertex+81)->y= 7.74;
 (object[id].vertex+81)->z=-0.134;

 (object[id].vertex+82)->x=-1.65;
 (object[id].vertex+82)->y= 0.77;
 (object[id].vertex+82)->z=-0.139;

 (object[id].vertex+83)->x=-2.016;
 (object[id].vertex+83)->y= 7.74;
 (object[id].vertex+83)->z=-0.159;

 (object[id].vertex+84)->x=-1.65;
 (object[id].vertex+84)->y=-0.77;
 (object[id].vertex+84)->z=-0.139;

 (object[id].vertex+85)->x=-1.564;
 (object[id].vertex+85)->y=-7.74;
 (object[id].vertex+85)->z=-0.134;

 (object[id].vertex+86)->x= -1.523;
 (object[id].vertex+86)->y=-12.20;
 (object[id].vertex+86)->z= -0.132;

 (object[id].vertex+87)->x=-2.016;
 (object[id].vertex+87)->y=-7.74;
 (object[id].vertex+87)->z=-0.159;

 /* Air brakes */
 (object[id].vertex+88)->x=-2.92;
 (object[id].vertex+88)->y= 0.64;
 (object[id].vertex+88)->z=-0.264+0.011;

 (object[id].vertex+89)->x=-2.92;
 (object[id].vertex+89)->y= 0.264;
 (object[id].vertex+89)->z=-0.64 +0.011;

 (object[id].vertex+90)->x=-3.85;
 (object[id].vertex+90)->y= 0.24;
 (object[id].vertex+90)->z=-0.583+0.027;

 (object[id].vertex+91)->x=-3.85;
 (object[id].vertex+91)->y= 0.583;
 (object[id].vertex+91)->z=-0.24 +0.027;

 (object[id].vertex+92)->x=-2.92;
 (object[id].vertex+92)->y=-0.64;
 (object[id].vertex+92)->z=-0.264+0.011;

 (object[id].vertex+93)->x=-2.92;
 (object[id].vertex+93)->y=-0.264;
 (object[id].vertex+93)->z=-0.64 +0.011;

 (object[id].vertex+94)->x=-3.85;
 (object[id].vertex+94)->y=-0.24;
 (object[id].vertex+94)->z=-0.583+0.027;

 (object[id].vertex+95)->x=-3.85;
 (object[id].vertex+95)->y=-0.583;
 (object[id].vertex+95)->z=-0.24 +0.027;

 /* Main gear */
 for (i=0; i<8; i++){
  float xc= 0.92, yc= 0.00, zc=-1.31, radius=0.25;

  (object[id].vertex+96+i)->x=xc+radius*sin(i*PI/4+PI/8);
  (object[id].vertex+96+i)->y=yc;
  (object[id].vertex+96+i)->z=zc+radius*cos(i*PI/4+PI/8);
 }

 (object[id].vertex+104)->x= 0.97;
 (object[id].vertex+104)->y= 0.00;
 (object[id].vertex+104)->z=-0.65;

 (object[id].vertex+105)->x= 0.87;
 (object[id].vertex+105)->y= 0.00;
 (object[id].vertex+105)->z=-0.65;

 (object[id].vertex+106)->x= 0.87;
 (object[id].vertex+106)->y= 0.00;
 (object[id].vertex+106)->z=-1.06;

 (object[id].vertex+107)->x= 0.97;
 (object[id].vertex+107)->y= 0.00;
 (object[id].vertex+107)->z=-1.06;

 /* Tail wheel */
 for (i=0; i<8; i++){
  float xc= -5.00, yc= 0.00, zc=-0.93, radius=0.10;

  (object[id].vertex+108+i)->x=xc+radius*sin(i*PI/4+PI/8);
  (object[id].vertex+108+i)->y=yc;
  (object[id].vertex+108+i)->z=zc+radius*cos(i*PI/4+PI/8);
 }

 (object[id].vertex+116)->x=-4.97;
 (object[id].vertex+116)->y= 0.00;
 (object[id].vertex+116)->z=-0.50;

 (object[id].vertex+117)->x=-5.03;
 (object[id].vertex+117)->y= 0.00;
 (object[id].vertex+117)->z=-0.50;

 (object[id].vertex+118)->x=-5.03;
 (object[id].vertex+118)->y= 0.00;
 (object[id].vertex+118)->z=-0.96;

 (object[id].vertex+119)->x=-4.97;
 (object[id].vertex+119)->y= 0.00;
 (object[id].vertex+119)->z=-0.96;

 /*
 (object[id].vertex+)->x=;
 (object[id].vertex+)->y=;
 (object[id].vertex+)->z=;
 */

 /**********/
 /* Facets */
 /**********/

 /*0 Wings */
 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]= 0;
 facetid->edge[1]= 1;
 facetid->edge[2]=80;
 facetid->edge[3]=82;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=80;
 facetid->edge[1]= 1;
 facetid->edge[2]= 0;
 facetid->edge[3]=82;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]= 4;
 facetid->edge[1]= 5;
 facetid->edge[2]=86;
 facetid->edge[3]=84;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=86;
 facetid->edge[1]= 5;
 facetid->edge[2]= 4;
 facetid->edge[3]=84;
 facetid++;

 /*4 nose */
 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=11;
 facetid->edge[1]=8;
 facetid->edge[2]=12;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=12;
 facetid->edge[1]=8;
 facetid->edge[2]=13;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=13;
 facetid->edge[1]=8;
 facetid->edge[2]=14;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=14;
 facetid->edge[1]=8;
 facetid->edge[2]=15;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=15;
 facetid->edge[1]=8;
 facetid->edge[2]=16;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=16;
 facetid->edge[1]=8;
 facetid->edge[2]=9;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=9;
 facetid->edge[1]=8;
 facetid->edge[2]=10;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=10;
 facetid->edge[1]=8;
 facetid->edge[2]=11;
 facetid++;

 /*12 canopy */
 facetid->color=CYAN;
 facetid->nedges=3;
 facetid->edge[0]=21;
 facetid->edge[1]=17;
 facetid->edge[2]=19;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=3;
 facetid->edge[0]=20;
 facetid->edge[1]=18;
 facetid->edge[2]=22;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=22;
 facetid->edge[1]=18;
 facetid->edge[2]=17;
 facetid->edge[3]=21;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=23;
 facetid->edge[1]=25;
 facetid->edge[2]=21;
 facetid->edge[3]=19;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=25;
 facetid->edge[1]=26;
 facetid->edge[2]=22;
 facetid->edge[3]=21;
 facetid++;

 facetid->color=CYAN;
 facetid->nedges=4;
 facetid->edge[0]=24;
 facetid->edge[1]=20;
 facetid->edge[2]=22;
 facetid->edge[3]=26;
 facetid++;

 /*18 fore body */
 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=11;
 facetid->edge[1]=12;
 facetid->edge[2]=28;
 facetid->edge[3]=27;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=12;
 facetid->edge[1]=13;
 facetid->edge[2]=29;
 facetid->edge[3]=28;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=13;
 facetid->edge[1]=14;
 facetid->edge[2]=30;
 facetid->edge[3]=29;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=16;
 facetid->edge[1]=9;
 facetid->edge[2]=17;
 facetid->edge[3]=18;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=17;
 facetid->edge[1]=9;
 facetid->edge[2]=19;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=20;
 facetid->edge[1]=16;
 facetid->edge[2]=18;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=10;
 facetid->edge[1]=11;
 facetid->edge[2]=27;
 facetid->edge[3]=31;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=14;
 facetid->edge[1]=15;
 facetid->edge[2]=32;
 facetid->edge[3]=30;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=19;
 facetid->edge[1]=10;
 facetid->edge[2]=23;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=24;
 facetid->edge[1]=15;
 facetid->edge[2]=20;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=23;
 facetid->edge[1]=10;
 facetid->edge[2]=31;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=32;
 facetid->edge[1]=15;
 facetid->edge[2]=24;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=19;
 facetid->edge[1]=9;
 facetid->edge[2]=10;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=20;
 facetid->edge[1]=15;
 facetid->edge[2]=16;
 facetid++;

 /*32 mid body */
 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=35;
 facetid->edge[1]=27;
 facetid->edge[2]=28;
 facetid->edge[3]=36;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=36;
 facetid->edge[1]=28;
 facetid->edge[2]=29;
 facetid->edge[3]=37;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=37;
 facetid->edge[1]=29;
 facetid->edge[2]=30;
 facetid->edge[3]=38;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=34;
 facetid->edge[1]=31;
 facetid->edge[2]=27;
 facetid->edge[3]=35;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=38;
 facetid->edge[1]=30;
 facetid->edge[2]=32;
 facetid->edge[3]=39;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=33;
 facetid->edge[1]=23;
 facetid->edge[2]=31;
 facetid->edge[3]=34;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=39;
 facetid->edge[1]=32;
 facetid->edge[2]=24;
 facetid->edge[3]=40;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=40;
 facetid->edge[1]=26;
 facetid->edge[2]=25;
 facetid->edge[3]=33;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=33;
 facetid->edge[1]=25;
 facetid->edge[2]=23;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=40;
 facetid->edge[1]=24;
 facetid->edge[2]=26;
 facetid++;

 /* 42 rear body */
 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=41;
 facetid->edge[1]=42;
 facetid->edge[2]=43;
 facetid->edge[3]=44;
 facetid->edge[4]=45;
 facetid->edge[5]=46;
 facetid->edge[6]=47;
 facetid->edge[7]=48;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=35;
 facetid->edge[1]=36;
 facetid->edge[2]=44;
 facetid->edge[3]=43;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=36;
 facetid->edge[1]=37;
 facetid->edge[2]=45;
 facetid->edge[3]=44;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=37;
 facetid->edge[1]=38;
 facetid->edge[2]=46;
 facetid->edge[3]=45;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=38;
 facetid->edge[1]=39;
 facetid->edge[2]=47;
 facetid->edge[3]=46;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=39;
 facetid->edge[1]=40;
 facetid->edge[2]=48;
 facetid->edge[3]=47;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=40;
 facetid->edge[1]=33;
 facetid->edge[2]=41;
 facetid->edge[3]=48;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=33;
 facetid->edge[1]=34;
 facetid->edge[2]=42;
 facetid->edge[3]=41;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=34;
 facetid->edge[1]=35;
 facetid->edge[2]=43;
 facetid->edge[3]=42;
 facetid++;

 /*51 tailplane */

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=49;
 facetid->edge[1]=50;
 facetid->edge[2]=74;
 facetid->edge[3]=75;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=49;
 facetid->edge[1]=75;
 facetid->edge[2]=76;
 facetid->edge[3]=54;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=75;
 facetid->edge[1]=51;
 facetid->edge[2]=50;
 facetid->edge[3]=49;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=54;
 facetid->edge[1]=76;
 facetid->edge[2]=75;
 facetid->edge[3]=49;
 facetid++;

 /* 55 tail fin */
 facetid->color=DARKGRAY;
 facetid->nedges=6;
 facetid->edge[0]=55;
 facetid->edge[1]=49;
 facetid->edge[2]=77;
 facetid->edge[3]=78;
 facetid->edge[4]=79;
 facetid->edge[5]=56;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=6;
 facetid->edge[0]=77;
 facetid->edge[1]=49;
 facetid->edge[2]=55;
 facetid->edge[3]=56;
 facetid->edge[4]=79;
 facetid->edge[5]=78;
 facetid++;

 /* 57 air intakes */
 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=69;
 facetid->edge[1]=66;
 facetid->edge[2]=35;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=3;
 facetid->edge[0]=70;
 facetid->edge[1]=73;
 facetid->edge[2]=38;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=61;
 facetid->edge[1]=58;
 facetid->edge[2]=66;
 facetid->edge[3]=69;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=62;
 facetid->edge[1]=65;
 facetid->edge[2]=73;
 facetid->edge[3]=70;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=59;
 facetid->edge[1]=58;
 facetid->edge[2]=61;
 facetid->edge[3]=60;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=63;
 facetid->edge[1]=64;
 facetid->edge[2]=65;
 facetid->edge[3]=62;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=60;
 facetid->edge[1]=61;
 facetid->edge[2]=69;
 facetid->edge[3]=68;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=65;
 facetid->edge[1]=64;
 facetid->edge[2]=72;
 facetid->edge[3]=73;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=59;
 facetid->edge[1]=60;
 facetid->edge[2]=68;
 facetid->edge[3]=67;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=64;
 facetid->edge[1]=63;
 facetid->edge[2]=71;
 facetid->edge[3]=72;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=68;
 facetid->edge[1]=69;
 facetid->edge[2]=35;
 facetid->edge[3]=34;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=73;
 facetid->edge[1]=72;
 facetid->edge[2]=39;
 facetid->edge[3]=38;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=67;
 facetid->edge[1]=68;
 facetid->edge[2]=34;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=3;
 facetid->edge[0]=72;
 facetid->edge[1]=71;
 facetid->edge[2]=39;
 facetid++;

 /* Control surfaces below */

 /* 71 elevator */
 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=75;
 facetid->edge[1]=74;
 facetid->edge[2]=51;
 facetid->edge[3]=52;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=51;
 facetid->edge[1]=74;
 facetid->edge[2]=75;
 facetid->edge[3]=52;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=76;
 facetid->edge[1]=75;
 facetid->edge[2]=52;
 facetid->edge[3]=53;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=52;
 facetid->edge[1]=75;
 facetid->edge[2]=76;
 facetid->edge[3]=53;
 facetid++;

 /* 75 Rudder */
 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=57;
 facetid->edge[1]=79;
 facetid->edge[2]=78;
 facetid->edge[3]=77;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=78;
 facetid->edge[1]=79;
 facetid->edge[2]=57;
 facetid->edge[3]=77;
 facetid++;

 /* 77 flaps */
 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=82;
 facetid->edge[1]=81;
 facetid->edge[2]=83;
 facetid->edge[3]= 3;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=83;
 facetid->edge[1]=81;
 facetid->edge[2]=82;
 facetid->edge[3]= 3;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=85;
 facetid->edge[1]=84;
 facetid->edge[2]= 7;
 facetid->edge[3]=87;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]= 7;
 facetid->edge[1]=84;
 facetid->edge[2]=85;
 facetid->edge[3]=87;
 facetid++;

 /* 81 ailerons */
 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=81;
 facetid->edge[1]=80;
 facetid->edge[2]= 2;
 facetid->edge[3]=83;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]= 2;
 facetid->edge[1]=80;
 facetid->edge[2]=81;
 facetid->edge[3]=83;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=4;
 facetid->edge[0]=86;
 facetid->edge[1]=85;
 facetid->edge[2]=87;
 facetid->edge[3]= 6;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=87;
 facetid->edge[1]=85;
 facetid->edge[2]=86;
 facetid->edge[3]= 6;
 facetid++;

 /* 85 Air brakes */
 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=88;
 facetid->edge[1]=89;
 facetid->edge[2]=90;
 facetid->edge[3]=91;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=90;
 facetid->edge[1]=89;
 facetid->edge[2]=88;
 facetid->edge[3]=91;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=92;
 facetid->edge[1]=93;
 facetid->edge[2]=94;
 facetid->edge[3]=95;
 facetid++;

 facetid->color=LIGHTGRAY;
 facetid->nedges=4;
 facetid->edge[0]=94;
 facetid->edge[1]=93;
 facetid->edge[2]=92;
 facetid->edge[3]=95;
 facetid++;

 /* 89 Main gear */
 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]= 96;
 facetid->edge[1]= 97;
 facetid->edge[2]= 98;
 facetid->edge[3]= 99;
 facetid->edge[4]=100;
 facetid->edge[5]=101;
 facetid->edge[6]=102;
 facetid->edge[7]=103;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]= 98;
 facetid->edge[1]= 97;
 facetid->edge[2]= 96;
 facetid->edge[3]=103;
 facetid->edge[4]=102;
 facetid->edge[5]=101;
 facetid->edge[6]=100;
 facetid->edge[7]= 99;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=104;
 facetid->edge[1]=105;
 facetid->edge[2]=106;
 facetid->edge[3]=107;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=106;
 facetid->edge[1]=105;
 facetid->edge[2]=104;
 facetid->edge[3]=107;
 facetid++;

 /* 93 Tail wheel */
 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=108;
 facetid->edge[1]=109;
 facetid->edge[2]=110;
 facetid->edge[3]=111;
 facetid->edge[4]=112;
 facetid->edge[5]=113;
 facetid->edge[6]=114;
 facetid->edge[7]=115;
 facetid++;

 facetid->color=DARKGRAY;
 facetid->nedges=8;
 facetid->edge[0]=115;
 facetid->edge[1]=114;
 facetid->edge[2]=113;
 facetid->edge[3]=112;
 facetid->edge[4]=111;
 facetid->edge[5]=110;
 facetid->edge[6]=109;
 facetid->edge[7]=108;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=116;
 facetid->edge[1]=117;
 facetid->edge[2]=118;
 facetid->edge[3]=119;
 facetid++;

 facetid->color=WHITE;
 facetid->nedges=4;
 facetid->edge[0]=118;
 facetid->edge[1]=117;
 facetid->edge[2]=116;
 facetid->edge[3]=119;
 facetid++;

 /*
 facetid->color=;
 facetid->nedges=;
 facetid->edge[0]=;
 facetid->edge[1]=;
 facetid->edge[2]=;
 facetid->edge[3]=;
 facetid++;
 */

 if (object[id].facet+nfacets!=facetid)
 {
   printf("U2: Incorrect number of facets\n");
   exit(1);
 }

 /* Define control surface rotation axis */
 object[id].ctrl_surface[0].axis =
   vminus(*(object[id].vertex+74),*(object[id].vertex+76));
 object[id].ctrl_surface[1].axis =
   vminus(*(object[id].vertex+78),*(object[id].vertex+77));
 object[id].ctrl_surface[2].axis =
   vminus(*(object[id].vertex+82),*(object[id].vertex+81));
 object[id].ctrl_surface[3].axis =
   vminus(*(object[id].vertex+85),*(object[id].vertex+84));
 object[id].ctrl_surface[4].axis =
   vminus(*(object[id].vertex+81),*(object[id].vertex+80));
 object[id].ctrl_surface[5].axis =
   vminus(*(object[id].vertex+86),*(object[id].vertex+85));
 object[id].ctrl_surface[6].axis =
   vminus(*(object[id].vertex+89),*(object[id].vertex+88));
 object[id].ctrl_surface[7].axis =
   vminus(*(object[id].vertex+92),*(object[id].vertex+93));
 object[id].ctrl_surface[8].axis =
   vminus(*(object[id].vertex+76),*(object[id].vertex+74));
 object[id].ctrl_surface[9].axis =
   vminus(*(object[id].vertex+76),*(object[id].vertex+74));

 for (j=0; j<object[id].nctrl_srf; j++){
  float norm;
  cartvektor tmp, tmp2;

  /* Generate orthonormal-system */
  norm=sqrt(VPRIK(object[id].ctrl_surface[j].axis,
                  object[id].ctrl_surface[j].axis));
  object[id].ctrl_surface[j].front=
                  svmult(1./norm,object[id].ctrl_surface[j].axis);
  /* Rotate 90 deg about z */
  tmp.x = -object[id].ctrl_surface[j].front.y;
  tmp.y =  object[id].ctrl_surface[j].front.x;
  tmp.z =  object[id].ctrl_surface[j].front.z;

  /* Rotate 90 deg about x - then the vector is not parallel with front vector */
  tmp2.x =  tmp.x;
  tmp2.y = -tmp.z;
  tmp2.z =  tmp.y;

  object[id].ctrl_surface[j].left =
   vkryds(object[id].ctrl_surface[j].front,tmp2);
  norm=sqrt(VPRIK(object[id].ctrl_surface[j].left,
                  object[id].ctrl_surface[j].left));
  object[id].ctrl_surface[j].left=
                  svmult(1./norm,object[id].ctrl_surface[j].left);

  object[id].ctrl_surface[j].top =
   vkryds(object[id].ctrl_surface[j].front,object[id].ctrl_surface[j].left);
 }

  object[id].colarr[WHITE].r = 255;
 object[id].colarr[WHITE].g = 255;
 object[id].colarr[WHITE].b = 255;

 object[id].colarr[LIGHTGRAY].r = 192;
 object[id].colarr[LIGHTGRAY].g = 192;
 object[id].colarr[LIGHTGRAY].b = 192;

 object[id].colarr[DARKGRAY].r =  80;
 object[id].colarr[DARKGRAY].g =  80;
 object[id].colarr[DARKGRAY].b =  80;

 object[id].colarr[RED].r = 255;
 object[id].colarr[RED].g =  32;
 object[id].colarr[RED].b =  32;

 object[id].colarr[GREEN].r =  32;
 object[id].colarr[GREEN].g = 255;
 object[id].colarr[GREEN].b =  32;

 object[id].colarr[BLUE].r =  32;
 object[id].colarr[BLUE].g =  32;
 object[id].colarr[BLUE].b = 255;

 object[id].colarr[LIGHTRED].r = 255;
 object[id].colarr[LIGHTRED].g =  96;
 object[id].colarr[LIGHTRED].b =  96;

 object[id].colarr[LIGHTBLUE].r = 96;
 object[id].colarr[LIGHTBLUE].g = 96;
 object[id].colarr[LIGHTBLUE].b = 255;

 object[id].colarr[CYAN].r =  96;
 object[id].colarr[CYAN].g = 192;
 object[id].colarr[CYAN].b = 192;

 object[id].colarr[LIGHTCYAN].r =  64;
 object[id].colarr[LIGHTCYAN].g = 255;
 object[id].colarr[LIGHTCYAN].b = 255;

 object[id].colarr[DARKGREEN].r =  50;
 object[id].colarr[DARKGREEN].g = 100;
 object[id].colarr[DARKGREEN].b =  40;

 nobjects++;
