# GNUmakefile
.RECIPEPREFIX := _

#=== fix2.sed begins ===
# 1i\
# OFFSET equ\
# Offset equ\
# Ptr equ\
# LEA equ MOV
# /^;/b
# /CODE_SEG/d
# /END /d
# / ENDP/d
# s/40://
# s/\]\[/+/
# s/\[0\]//
# s/\][+]BX/+BX/
# s/ES:\[/[ES:/
# s/[ ][ ]*PROC .*/:/
# s/\[\[/[/
#=== fix2.sed ends ===

#=== fix3.sed begins ===
# /RemoveNewInt9:/,/ RET/s/OldInt9Addr/cs:&/
# /NewInt9Handler:/,/NotIntercept:/s/\[/[cs:/
# /NotIntercept:/,/CLC/s/StoreAX/cs:&/
#=== fix3.sed ends ===

.PHONY: all check clean cleanall

PROG=inv-fasm
GAMEZIP=invadr11.zip
OLDASM=INVADERS.ASM
SED=sed
FASM=fasm
MD5SUM=md5sum
WGET=wget
WGETOPT=-q
UNZIPPER=unzip
UNZIPFLAGS=-qjan

#GAMEURL=ftp.lanet.lv/ftp/mirror/x2ftp/msdos/programming/gamesrc/
GAMEURL=www.ibiblio.org/pub/micro/pc-stuff/freedos/files/games/invaders/

all: $(PROG).com check

$(PROG).com: $(PROG).asm
_@$(FASM) $< $@

fix2.sed fix3.sed: $(lastword $(MAKEFILE_LIST))
_@$(SED) -n -e '/$@ begins ===/,/$@ ends ===/s/^#[ ][ ]*//w $@' $<

asmvars.sed: $(OLDASM)
_@$(SED) -n -e 's|^\([^ ][^ ]*\)[ ][ ]*D[BWD] ..*|s/\\<\1\\>/[\&]/|p' $^ >$@

$(PROG).asm: $(OLDASM) asmvars.sed fix2.sed fix3.sed
_@$(SED) -e '/^;/b' -e '/ D[BWD] /b' -e '/,OFFSET/b' -e '/LEA /b'\
 -f asmvars.sed $< | $(SED) -f fix2.sed -f fix3.sed >$@

$(GAMEZIP):
_@$(WGET) $(WGETOPT) $(GAMEURL)$(GAMEZIP)

$(OLDASM): $(GAMEZIP)
_@$(UNZIPPER) $(UNZIPFLAGS) $< INVADERS/$@ >/dev/null

check: $(PROG).com
_@$(MD5SUM) $<
_@echo 5d6fa26af01606feb90f17e014390139 \ $<

clean:
_@$(RM) $(PROG).asm fix?.sed asmvars.sed

cleanall: clean
_@$(RM) $(PROG).com $(OLDASM)

# EOF
