/*

 Nibbles - Copyright (C) 2000 Andrea Fazzi

 This file is part of Nibbles.

 Nibbles is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Nibbles is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Nibbles; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
//---------------------------------------------------------------------------
#ifndef _BODY_H_
#define _BODY_H_

#include "Sprite.h"
#include "Level.h"

#define DIR_LEFT   -1
#define DIR_RIGHT   1
#define DIR_UP     -2
#define DIR_DOWN    2

#define IS_A_TAIL   1
#define IS_A_HEAD   2
#define IS_A_BODY   3
//---------------------------------------------------------------------------
struct pointXY {

 int x,y;
 char dir;

};
//---------------------------------------------------------------------------
class Body {

   public:

    Body();
    ~Body();

    int x,y,W,H;
    int bodyID,mass;
    char pivotCheck[100];

    int x0,y0;

    char direction,type;

    char *sprFileName;
    DblBuf *GraphBuf;

    Body *NextPart;
    Body *PrevPart;

    Sprite *GraphData;

    bool Exists;

     void Init(LevelHeader *lev,char *sprname,DblBuf *buf);
     void Make(int bodynum,int bodytot);
     void Grow(int bodynum);
     void AddPart(Body *prev);

     void Move(char dir);
     bool Crawl(pointXY *pivots,char num,bool StopFlag,bool pivotTest);
     void Die(int t);
     bool Eat(int t);
     bool ImEatingMySelf(int X,int Y,int w,int h,char dir);

     void Display();

};
//---------------------------------------------------------------------------
#endif


