/*
 * This file is part of the uHex project.
 * Copyright (C) Mateusz Viste 2015
 *
 * Provides a file-handling API with an integrated cache. This avoids to
 * access the disk too frequently on cacheless systems, significantly speeding
 * up the application when running from a diskette (or any other slow medium).
 */

#ifndef FILE_H_SENTINEL
#define FILE_H_SENTINEL

/* opens a file in given mode, returns the file's size on success, and a
 * negative value on error. if error occurs, errvar is filled with errno. */
long file_open(char *fname, char *mode, int *errvar);

/* reads len bytes from file since position offset and writes them to
 * bytebuff. returns the amount of bytes read (can be less than len if EOF
 * reached). */
int file_read(unsigned char *bytebuff, int len, long offset);

/* writes a byte 'b' to file at position offset */
int file_writebyte(long offset, int b);

/* close the file and frees the cache memory */
void file_close(void);

#endif
