/***************************************************
	mined keyboard mapping table
	* generated with mkkbmap
	  from lib/kbmaps/cxterm/4Corner.utf
	* supplemented with punctuation mappings
*/
struct keymap keymap_4Corner [] = {
	{"!", "！"},
	{"#", "〃 々 〆 〇 〜 ￦"},
	{"$", "￥"},
	{"&", "―"},
	{"(", "（"},
	{")", "）"},
	{",", "，"},
	{".", "。"},
	{":", "："},
	{";", "；"},
	{"<", "〈"},
	{"<<", "《"},
	{">", "〉"},
	{">>", "》"},
	{"?", "？"},
	{"@", "・"},
	{"[", "【 〖 〔 「 『"},
	{"\\", "、"},
	{"]", "】 〗 〕 」 』"},
	{"^", "……"},
	{"_", "――"},
	{"«", "《"},
	{"»", "》"},
	{"€", "€ ＄ ￥ ￦ ￡ ￠ ￢ ￣"},

	{"00104", "主 童 壅"},
	{"00106", "亶"},
	{"00107", "衁 亹 斖"},
	{"00108", "立"},
	{"00109", "鏖"},
	{"00111", "症 疵 痙 痱 疕 疘 庛 疪 痄"},
	{"00112", "痝 瘥"},
	{"00113", "瘣"},
	{"00114", "疣 痊 痲 瘧 癱 疰 痤 痽 瘞 瘽 癃 癰"},
	{"00116", "疸"},
	{"00117", "疙 疤 疽 瘋 瘟 疶 癙"},
	{"00118", "痘"},
	{"00120", "痢 痸 瘌"},
	{"00121", "瘉 疔 痾 痹"},
	{"00122", "疹 瘳"},
	{"00123", "癠"},
	{"00127", "病 痛 瘍 瘠 瘸 瘺 癆 癘 癟 痀 疿 痏 痌 痑 痡 痟 痭 瘑 癇 癤 癵"},
	{"00128", "疥"},
	{"00129", "痧"},
	{"00131", "痣"},
	{"00132", "痕 痍 癒 癢 瘃 瘛"},
	{"00133", "疼 瘀 瘱"},
	{"00134", "疾 瘈 瘊 瘯 瘼"},
	{"00136", "癮 痋 瘙 瘜"},
	{"00137", "疺"},
	{"00141", "痔 癖"},
	{"00142", "疧"},
	{"00144", "痿 癭"},
	{"00146", "痺 瘴 癉"},
	{"00147", "疫 疲 痠 瘦 瘢 痚 瘕 癈 癜"},
	{"00148", "瘁 癥 癓"},
	{"00149", "痵"},
	{"00151", "癬 痒 廯"},
	{"00157", "痗"},
	{"00160", "痂 痴 痐 痼"},
	{"00161", "瘩 痦 瘖 癚"},
	{"00162", "瘤 痁 癗"},
	{"00164", "瘏 痻 瘔"},
	{"00166", "癐"},
	{"00167", "瘡"},
	{"00169", "痞"},
	{"00172", "疝 癌"},
	{"00175", "疳"},
	{"00177", "痯"},
	{"00181", "瘓 癡 痶 瘨 瘲"},
	{"00182", "痎"},
	{"00186", "癩 癲 疻 癪"},
	{"00187", "疚 瘚"},
	{"00189", "疢 痰"},
	{"00191", "瘭 瘵"},
	{"00193", "瘰"},
	{"00194", "痳"},
	{"00196", "療"},
	{"00199", "瘝"},
	{"00201", "亭"},
	{"00207", "亨"},
	{"00210", "麤"},
	{"00211", "庇 鹿 麂 龐 靡 庀 巟 麀 廘 廲 爢 麤"},
	{"00212", "庖 庬"},
	{"00213", "充 魔 庣 廅 廆 麍"},
	{"00214", "座 產 塵 麾 庄 庢 塺 廑 廛 麈 廱"},
	{"00216", "兗 庵 竟 競 痷"},
	{"00217", "亢 亮 嬴 廬 羸 贏 庉 麆 蠃 麑 臝 鸁"},
	{"00220", "廁"},
	{"00221", "廝 庍"},
	{"00222", "序 彥 廖"},
	{"00223", "帟 齊 齋 齌 齍 齎 齏 麡"},
	{"00224", "齋"},
	{"00227", "方 市 肓 育 帝 席 旁 高 商 庸 廊 裔 廓 腐 膏 廟 膺 鷹 庈 离 廌 廗"},
	{"00230", "卞"},
	{"00231", "應 廳 廕 廡 麃"},
	{"00232", "康 豪 麼 麎"},
	{"00236", "螷 蠯"},
	{"00237", "庚 庶 庾 廉 庹"},
	{"00240", "府 廚"},
	{"00241", "庭 麝 庌 庤 廦 麛"},
	{"00242", "底"},
	{"00244", "庰 廔 廮"},
	{"00246", "庳"},
	{"00247", "夜 度 廄 廈 廢 慶 庋 庨 庪 庱 廋"},
	{"00248", "廠 廒 黀"},
	{"00251", "庠"},
	{"00252", "摩 廨"},
	{"00253", "麙"},
	{"00256", "庫"},
	{"00259", "犘"},
	{"00260", "廂"},
	{"00261", "店 磨 庮 庴 廧"},
	{"00262", "廇"},
	{"00264", "廜 麔"},
	{"00266", "廥"},
	{"00267", "唐"},
	{"00271", "麠"},
	{"00280", "庂"},
	{"00281", "廙"},
	{"00282", "廞"},
	{"00286", "廣 賡 廎"},
	{"00293", "緳 縻"},
	{"00294", "床 麻 糜 庥 廩 穈"},
	{"00298", "庲"},
	{"00330", "亦"},
	{"00331", "忘 麜"},
	{"00332", "烹"},
	{"00334", "忞"},
	{"00336", "意"},
	{"00337", "悹"},
	{"00400", "文"},
	{"00401", "辛"},
	{"00403", "率"},
	{"00404", "妄 妾"},
	{"00406", "章"},
	{"00407", "享"},
	{"00408", "交 卒"},
	{"00414", "離"},
	{"00430", "奕 麌"},
	{"00441", "辨 辦 瓣 辮 辯"},
	{"00443", "弈"},
	{"00503", "牽"},
	{"00601", "言 盲 音 麋"},
	{"00602", "啻"},
	{"00603", "畜"},
	{"00604", "吝"},
	{"00614", "註 誰"},
	{"00617", "譠"},
	{"00622", "諺"},
	{"00627", "訪 諦 謗 謫 謞 謪 謧"},
	{"00631", "譙"},
	{"00632", "讓 誸 譹"},
	{"00637", "謶 譧"},
	{"00647", "諄 謢"},
	{"00648", "詨 誶"},
	{"00661", "諳 讟"},
	{"00682", "該"},
	{"00696", "諒"},
	{"00710", "亡 雍"},
	{"00714", "亳 毫"},
	{"00717", "甕"},
	{"00732", "玄 衣 哀 衰 袞 裒 裹 褒 褻 襄 囊 袤 袬 袌 袲 裛 褎 褭 褱 褢 饔"},
	{"00747", "麚"},
	{"00772", "罋"},
	{"00800", "六"},
	{"00802", "亥"},
	{"00806", "賌 黂"},
	{"00901", "稟"},
	{"00903", "紊"},
	{"00904", "杗 棄 麇"},
	{"00906", "京"},
	{"00914", "雜"},
	{"01104", "壟"},
	{"01136", "蠪"},
	{"01160", "站"},
	{"01186", "顫"},
	{"01211", "龍 龘"},
	{"01217", "瓬 甋"},
	{"01247", "敲"},
	{"01286", "顏 頏"},
	{"01327", "鸗"},
	{"01401", "聾"},
	{"01486", "頝"},
	{"01601", "礱 讋"},
	{"01610", "訌 訿"},
	{"01611", "証 誹 誆 誙 讈"},
	{"01614", "誑 諲 謔"},
	{"01616", "謳"},
	{"01617", "詎 瓿 諕 諕 謯"},
	{"01618", "誣"},
	{"01620", "訂 訶"},
	{"01632", "誫 諑"},
	{"01640", "訐 訏 訝"},
	{"01641", "讘"},
	{"01646", "譚"},
	{"01647", "諏"},
	{"01649", "評 謼"},
	{"01660", "詀"},
	{"01661", "詣 語 諧"},
	{"01666", "諨"},
	{"01691", "謤"},
	{"01696", "謜"},
	{"01732", "襲"},
	{"01801", "龔"},
	{"01886", "頦"},
	{"01903", "龒"},
	{"02114", "氈 氃"},
	{"02127", "端"},
	{"02157", "竫"},
	{"02200", "剷 劑 剫 劘"},
	{"02227", "鄜"},
	{"02422", "彰"},
	{"02427", "斒"},
	{"02600", "剖 訓 詶"},
	{"02613", "誂"},
	{"02614", "託 諈"},
	{"02617", "謕"},
	{"02618", "證"},
	{"02621", "訢"},
	{"02627", "誘 諯 譑"},
	{"02631", "訴"},
	{"02634", "訞 謑"},
	{"02637", "讔"},
	{"02640", "詆"},
	{"02641", "誕"},
	{"02644", "諉"},
	{"02647", "諼"},
	{"02653", "譏"},
	{"02657", "諍"},
	{"02661", "詬"},
	{"02663", "誻"},
	{"02664", "話 諙"},
	{"02669", "譒"},
	{"02670", "訕"},
	{"02677", "詘"},
	{"02710", "瓤"},
	{"02800", "刻"},
	{"02921", "新"},
	{"03134", "竤"},
	{"03147", "竣"},
	{"03327", "鷲"},
	{"03440", "斌"},
	{"03534", "讞"},
	{"03600", "訃"},
	{"03611", "詑"},
	{"03614", "詫 訧"},
	{"03616", "諠"},
	{"03617", "誼 謐"},
	{"03627", "誧 諞 謆"},
	{"03632", "詠 誏"},
	{"03634", "誒"},
	{"03640", "試"},
	{"03647", "詙"},
	{"03650", "誠 誡 識 讖 戠 諴"},
	{"03653", "諓"},
	{"03660", "詒"},
	{"03669", "讅"},
	{"03694", "訹"},
	{"03806", "贇"},
	{"03914", "就"},
	{"04127", "勯"},
	{"04132", "竑"},
	{"04147", "皽"},
	{"04281", "麒"},
	{"04400", "對"},
	{"04600", "計 討 謝"},
	{"04610", "訛"},
	{"04611", "諶 謊 詵 譊"},
	{"04612", "訑"},
	{"04614", "謹 讙"},
	{"04617", "詍"},
	{"04627", "訥 誇 詏 詴 諵 譪"},
	{"04631", "誌 讌"},
	{"04634", "謨"},
	{"04635", "韺"},
	{"04637", "譿"},
	{"04640", "誁"},
	{"04641", "詩 詿 譸"},
	{"04647", "詖 護 誖 頀"},
	{"04654", "譁"},
	{"04656", "諱"},
	{"04660", "詁 諸"},
	{"04661", "詰 誥 譆"},
	{"04664", "諾 譇"},
	{"04670", "詌"},
	{"04681", "諆 謓"},
	{"04686", "讀 讚"},
	{"04689", "詼"},
	{"04690", "諃"},
	{"04694", "謀 諜"},
	{"04698", "誺"},
	{"04727", "勷"},
	{"04827", "劾"},
	{"04927", "勍"},
	{"05104", "塾"},
	{"05127", "靖"},
	{"05196", "竦"},
	{"05331", "熟"},
	{"05417", "孰"},
	{"05496", "辣"},
	{"05617", "訰"},
	{"05627", "請"},
	{"05630", "訣 詄 謰"},
	{"05632", "諘 譨"},
	{"05633", "譓"},
	{"05637", "譴"},
	{"05644", "謱"},
	{"05657", "講"},
	{"05661", "譖"},
	{"05686", "謮"},
	{"05690", "誅 誄"},
	{"05694", "謋"},
	{"05696", "諫"},
	{"06127", "竭"},
	{"06240", "髜"},
	{"06446", "嚲"},
	{"06456", "嚲"},
	{"06610", "覾"},
	{"06614", "韹 諻"},
	{"06627", "謁 謂 諤"},
	{"06630", "諰 謥"},
	{"06640", "諀"},
	{"06641", "譯 諿"},
	{"06647", "謖 謾"},
	{"06656", "譂"},
	{"06660", "讄"},
	{"06681", "誤 諟"},
	{"06686", "韻"},
	{"06694", "課 譟"},
	{"06910", "親"},
	{"07104", "望"},
	{"07110", "颯"},
	{"07111", "屔"},
	{"07120", "竘 翊"},
	{"07127", "鴗 鸇"},
	{"07137", "斔 螤"},
	{"07141", "竮"},
	{"07147", "殶"},
	{"07227", "鄗 鄘 鷓 邟 邡 鄺 鶊 鶙 鶶 鷛"},
	{"07233", "旞"},
	{"07247", "毅 毃"},
	{"07282", "歊"},
	{"07327", "鷇 鷾"},
	{"07338", "戇"},
	{"07420", "斕"},
	{"07427", "郊 郭 鶉 鄣 鳼 鵁"},
	{"07486", "贛"},
	{"07610", "訊 詛 諷"},
	{"07611", "譅"},
	{"07612", "詭"},
	{"07616", "讒"},
	{"07617", "記 譝"},
	{"07620", "詞 詢 調 訒 詗 詡 詷 詷 譋 讕"},
	{"07622", "謬"},
	{"07627", "部 誦 譎 誃 鄐 誽 諝 謅 謣 謻"},
	{"07631", "誋"},
	{"07632", "認"},
	{"07637", "諛"},
	{"07640", "諔"},
	{"07641", "謘"},
	{"07647", "設 謏 譭 讂"},
	{"07654", "韸"},
	{"07656", "諢"},
	{"07661", "譫"},
	{"07662", "詔 韶 詺 謵"},
	{"07664", "詻"},
	{"07668", "諮"},
	{"07672", "謠"},
	{"07677", "諂"},
	{"07680", "畝"},
	{"07681", "譔 譺"},
	{"07682", "歆"},
	{"07720", "翃"},
	{"07727", "邙"},
	{"07747", "氓"},
	{"07771", "罊"},
	{"07820", "翸"},
	{"07882", "欬 歕"},
	{"07927", "鶁"},
	{"08211", "旎"},
	{"08212", "施"},
	{"08213", "旐 旒"},
	{"08214", "旌 旄"},
	{"08217", "斻"},
	{"08221", "旖 旂"},
	{"08227", "膂 旆 旓"},
	{"08232", "旅"},
	{"08233", "於"},
	{"08234", "族"},
	{"08237", "旍"},
	{"08240", "放 敵"},
	{"08247", "斿 旃"},
	{"08266", "旝"},
	{"08269", "旛"},
	{"08281", "旋 旗 旟"},
	{"08291", "旚"},
	{"08327", "鷟 鷟"},
	{"08334", "憝"},
	{"08432", "龑"},
	{"08440", "效 敦"},
	{"08447", "竷"},
	{"08504", "撉"},
	{"08611", "詐"},
	{"08614", "詮"},
	{"08616", "說"},
	{"08617", "訖 諡 謚"},
	{"08621", "諭"},
	{"08622", "診"},
	{"08627", "論 譾"},
	{"08631", "譕"},
	{"08632", "訟 諗"},
	{"08637", "謙 詅"},
	{"08640", "許 敨 譈 譀"},
	{"08646", "譐"},
	{"08651", "詳"},
	{"08653", "議"},
	{"08657", "誨"},
	{"08661", "譜 譗"},
	{"08667", "謒"},
	{"08686", "譣"},
	{"08732", "玈"},
	{"09259", "麟"},
	{"09620", "訬"},
	{"09627", "誚"},
	{"09631", "讜"},
	{"09639", "謎"},
	{"09650", "詊"},
	{"09689", "談"},
	{"09720", "玅"},
	{"10000", "一"},
	{"10100", "二 工"},
	{"10101", "三 正 歪 巠"},
	{"10103", "玉 璽"},
	{"10104", "王 至 亟 堊 玊 垔"},
	{"10106", "亙 噩"},
	{"10107", "互 五 亞 盂 盃"},
	{"10108", "巫 豆 靈 霯"},
	{"10109", "丕"},
	{"10111", "霏 靋"},
	{"10112", "巰"},
	{"10113", "琉 疏 珫 雿 霮"},
	{"10114", "霪"},
	{"10118", "翋"},
	{"10121", "聤"},
	{"10123", "璾"},
	{"10127", "璃 霈 霠 霘"},
	{"10131", "璡"},
	{"10132", "瓖 玹 霐 瓋"},
	{"10136", "蝁 蠠"},
	{"10140", "玟"},
	{"10146", "璋"},
	{"10148", "珓"},
	{"10153", "霵"},
	{"10161", "霑 琣"},
	{"10164", "露"},
	{"10167", "瑭"},
	{"10177", "雪"},
	{"10181", "霟"},
	{"10196", "翞"},
	{"10200", "丁"},
	{"10201", "亍"},
	{"10207", "丐 歹"},
	{"10210", "兀 兀"},
	{"10211", "元 靂 靇"},
	{"10212", "死"},
	{"10213", "霢"},
	{"10214", "霍 霾 雡 靃"},
	{"10217", "霓"},
	{"10220", "丌"},
	{"10221", "亓"},
	{"10223", "霽"},
	{"10227", "丙 而 兩 雨 甭 鬲 爾 需 霄 霧 万 襾 雱 雰 雺"},
	{"10230", "下"},
	{"10232", "汞 豕 弦 泵 震 豖 霥"},
	{"10240", "牙"},
	{"10242", "霨"},
	{"10247", "夏 憂 霞 覆"},
	{"10248", "霰 覈 霺"},
	{"10261", "殕"},
	{"10264", "霿"},
	{"10282", "豥"},
	{"10296", "弶"},
	{"10307", "零 覂"},
	{"10327", "焉"},
	{"10331", "惡"},
	{"10332", "恧"},
	{"10333", "忑"},
	{"10336", "奡"},
	{"10394", "霂"},
	{"10400", "于 干 耳"},
	{"10401", "雯 霆"},
	{"10404", "耍 要 霎"},
	{"10406", "覃 霋 鞷"},
	{"10407", "夒"},
	{"10409", "平 雽"},
	{"10410", "旡"},
	{"10414", "雃"},
	{"10427", "霩"},
	{"10430", "天"},
	{"10432", "耎"},
	{"10439", "奀"},
	{"10440", "幵"},
	{"10441", "弄 聶"},
	{"10447", "再 孬"},
	{"10482", "孩"},
	{"10503", "戛"},
	{"10506", "更"},
	{"10507", "霉"},
	{"10527", "霸"},
	{"10530", "雵 霙"},
	{"10600", "石 百 西 酉 面"},
	{"10601", "吾 晉 霅"},
	{"10602", "霤 霫"},
	{"10603", "雷"},
	{"10609", "否"},
	{"10613", "硫"},
	{"10614", "碓 砫 醀"},
	{"10617", "醯"},
	{"10618", "砬"},
	{"10620", "可"},
	{"10621", "哥 碠"},
	{"10627", "磅 靄 碲 碻 醨"},
	{"10631", "礁 醮"},
	{"10632", "釀"},
	{"10636", "醷"},
	{"10641", "霹 礔"},
	{"10647", "醇"},
	{"10648", "碎 醉"},
	{"10661", "磊 碚 醅"},
	{"10662", "霝"},
	{"10667", "醣 磄"},
	{"10669", "馫"},
	{"10686", "礦"},
	{"10694", "磼 醾"},
	{"10712", "雹"},
	{"10716", "電 黿"},
	{"10717", "瓦"},
	{"10727", "雩 丏"},
	{"10731", "云 丟 雲"},
	{"10772", "函"},
	{"10774", "雸"},
	{"10777", "臿"},
	{"10801", "霬"},
	{"10806", "頁 貢 賈 霣"},
	{"10900", "不"},
	{"10901", "示 票"},
	{"10904", "栗 粟"},
	{"10922", "霦"},
	{"10963", "霜"},
	{"10994", "霖"},
	{"11101", "韭"},
	{"11107", "瓕"},
	{"11110", "北 玒 玭 羾 玼 豇"},
	{"11111", "玩 非 瓏 聇 琲"},
	{"11114", "玨 班 斑 臸"},
	{"11116", "疆"},
	{"11117", "琥 甄 瓨 臦 虣"},
	{"11120", "玎 珂"},
	{"11121", "珩"},
	{"11127", "巧 瑪 瓀"},
	{"11131", "璱"},
	{"11132", "琢 璩"},
	{"11136", "蠶 蜚 蜑"},
	{"11140", "玕 玗 玡 珥"},
	{"11149", "玶"},
	{"11160", "玷 玷"},
	{"11161", "珸 瑎"},
	{"11163", "璿"},
	{"11186", "項 頊 頸 頭 顳"},
	{"11194", "瑮"},
	{"11207", "琴"},
	{"11211", "麗 弳 殌 麉"},
	{"11213", "豗"},
	{"11216", "彊 貆 彄 殭"},
	{"11217", "豟"},
	{"11223", "臩"},
	{"11227", "背 脊 翡 彌"},
	{"11232", "張 豩"},
	{"11240", "弭 豻 豜"},
	{"11286", "頂 預 頑 頨 顟"},
	{"11296", "豲"},
	{"11331", "悲 瑟"},
	{"11400", "斐"},
	{"11406", "迺"},
	{"11417", "孲"},
	{"11420", "耵"},
	{"11427", "孺 聏"},
	{"11431", "奜"},
	{"11440", "聑"},
	{"11441", "婓"},
	{"11486", "頇 頇 頲"},
	{"11500", "羋"},
	{"11502", "揅"},
	{"11506", "輩"},
	{"11601", "朁"},
	{"11610", "矼 矹 砒"},
	{"11611", "硜 翫 礱 釃"},
	{"11612", "砸"},
	{"11613", "砡"},
	{"11614", "礭"},
	{"11616", "礓 醧"},
	{"11617", "礛"},
	{"11620", "酊 砢"},
	{"11627", "碼 礪 磭 礝 醹"},
	{"11632", "醵"},
	{"11640", "研 矸 砑 酐"},
	{"11646", "硬 磹 醰"},
	{"11649", "砰"},
	{"11660", "砧 砳 硒 皕 酟 磠"},
	{"11662", "礌 礵 醽"},
	{"11681", "酯"},
	{"11686", "碩 磌 頵"},
	{"11691", "醥"},
	{"11694", "磲"},
	{"11711", "琵"},
	{"11717", "琶"},
	{"11732", "裴 餥"},
	{"11786", "顄"},
	{"11801", "冀"},
	{"11809", "烎 燛 燹"},
	{"11904", "棐"},
	{"11986", "顙 顠"},
	{"12100", "到 琍 玔 剄 剕"},
	{"12104", "型"},
	{"12108", "登"},
	{"12110", "耴"},
	{"12113", "珧"},
	{"12114", "璀"},
	{"12127", "瑞 琇 琌 瑀 濷 瓗"},
	{"12134", "璞 聧"},
	{"12141", "珽"},
	{"12147", "璦 琈 瑗 翪"},
	{"12153", "璣"},
	{"12157", "琤"},
	{"12163", "瑙"},
	{"12164", "聒"},
	{"12169", "璠"},
	{"12172", "聯"},
	{"12194", "璅 瓅"},
	{"12200", "引 列 刓 剢 劀 劌"},
	{"12214", "氄"},
	{"12217", "凳 卍"},
	{"12222", "耏"},
	{"12230", "水 弘 弧 沝"},
	{"12232", "淼"},
	{"12234", "殀 豯 貕"},
	{"12240", "弤"},
	{"12247", "發 弢 殍 鬷"},
	{"12264", "殙"},
	{"12277", "貀"},
	{"12327", "鴷"},
	{"12330", "烈"},
	{"12333", "愻"},
	{"12336", "鮤"},
	{"12400", "刊 刑 刵"},
	{"12401", "廷 延"},
	{"12404", "姴"},
	{"12407", "癹"},
	{"12410", "孔"},
	{"12413", "飛"},
	{"12414", "毦 毲"},
	{"12422", "形"},
	{"12427", "鄾"},
	{"12430", "孤 癸"},
	{"12493", "孫"},
	{"12600", "副 硎 酬"},
	{"12603", "呇 沓"},
	{"12614", "矺 酕 硾 磪"},
	{"12617", "磃"},
	{"12618", "磴 磑"},
	{"12621", "斫"},
	{"12627", "碥 酳 磞 礄"},
	{"12630", "砅 砯"},
	{"12631", "醺"},
	{"12634", "醭"},
	{"12635", "磎"},
	{"12637", "砭"},
	{"12640", "砥"},
	{"12643", "酹"},
	{"12646", "釂"},
	{"12647", "醱"},
	{"12653", "磯"},
	{"12657", "碀"},
	{"12669", "磻"},
	{"12670", "酗"},
	{"12686", "礩"},
	{"12689", "碳"},
	{"12694", "酥 礫"},
	{"12732", "裂"},
	{"12747", "靉"},
	{"12900", "剽"},
	{"12922", "彯"},
	{"12930", "瓢"},
	{"13100", "恥 珌"},
	{"13112", "豌 琬"},
	{"13116", "瑄"},
	{"13121", "聹"},
	{"13132", "琅 球"},
	{"13134", "瓛"},
	{"13140", "武 玳"},
	{"13150", "職 珴 臹 戤 瑊"},
	{"13153", "琖"},
	{"13160", "珆"},
	{"13168", "瑢"},
	{"13177", "琯"},
	{"13186", "璸"},
	{"13191", "琮"},
	{"13214", "殧"},
	{"13232", "殏 瑏"},
	{"13236", "強"},
	{"13250", "戮 戳 殲"},
	{"13253", "殘"},
	{"13260", "殆"},
	{"13282", "貁"},
	{"13286", "殯 殥"},
	{"13291", "倧"},
	{"13410", "聜"},
	{"13450", "戣 聝"},
	{"13491", "孮"},
	{"13601", "謽"},
	{"13611", "硿 砣 酡 醡"},
	{"13612", "碗 硥"},
	{"13617", "砨"},
	{"13622", "磣"},
	{"13627", "酺"},
	{"13634", "醭"},
	{"13640", "碔"},
	{"13647", "酸"},
	{"13650", "硪 戩 磩"},
	{"13653", "醆"},
	{"13661", "磍"},
	{"13681", "碇"},
	{"13686", "礗"},
	{"13760", "齝"},
	{"14111", "珗"},
	{"14112", "耽"},
	{"14114", "珪 瑾 瓘"},
	{"14117", "玴 瓂"},
	{"14121", "琦"},
	{"14127", "功 勁 珛 琋 璊 鳿"},
	{"14131", "琺 聽"},
	{"14132", "耾"},
	{"14134", "瑛"},
	{"14141", "瓙"},
	{"14147", "玻 豉 珔 瓁"},
	{"14156", "瑋"},
	{"14161", "聐"},
	{"14170", "玵"},
	{"14181", "琪 珙"},
	{"14186", "璜 瓚 瑱"},
	{"14190", "琳"},
	{"14194", "瑹"},
	{"14200", "耐"},
	{"14212", "弛"},
	{"14214", "殣"},
	{"14216", "殖 殑 殗"},
	{"14218", "殪 豷"},
	{"14227", "豽 豨 殢"},
	{"14240", "弣"},
	{"14247", "翍"},
	{"14260", "豬"},
	{"14261", "矠"},
	{"14286", "彉 殰 豶"},
	{"14288", "殎"},
	{"14420", "聈"},
	{"14600", "酎"},
	{"14610", "硭"},
	{"14611", "碪 磽"},
	{"14612", "酏 酖"},
	{"14614", "確 硅 醛"},
	{"14617", "磕 磕 醃 醓 醢"},
	{"14621", "碕"},
	{"14627", "劭 磡"},
	{"14631", "砝 醼"},
	{"14632", "礞"},
	{"14634", "磢"},
	{"14635", "碤"},
	{"14638", "硤"},
	{"14640", "砵"},
	{"14642", "礡"},
	{"14647", "破 酵"},
	{"14653", "礣"},
	{"14660", "酤 醏"},
	{"14661", "酷 醋 硈 硞 碏 礂"},
	{"14670", "酣"},
	{"14681", "礎"},
	{"14686", "磺 礸"},
	{"14690", "碄 醂"},
	{"14691", "礤"},
	{"14694", "碟"},
	{"14740", "妀"},
	{"14904", "櫫"},
	{"15100", "玤"},
	{"15106", "珅 翀"},
	{"15107", "珒"},
	{"15117", "璶"},
	{"15127", "聘"},
	{"15130", "玦 翐 璉 翴"},
	{"15143", "瑼"},
	{"15153", "琫"},
	{"15157", "珃"},
	{"15181", "琠"},
	{"15190", "珠"},
	{"15194", "臻 瑧"},
	{"15207", "肂 貄"},
	{"15213", "虺"},
	{"15230", "殃"},
	{"15232", "殔"},
	{"15236", "融"},
	{"15281", "倢"},
	{"15290", "殊"},
	{"15400", "建"},
	{"15417", "孻"},
	{"15447", "聃"},
	{"15501", "甦"},
	{"15600", "硨"},
	{"15606", "砷"},
	{"15607", "硉"},
	{"15617", "醠"},
	{"15618", "醴"},
	{"15627", "砩 碃"},
	{"15630", "砆"},
	{"15632", "醲"},
	{"15643", "磚"},
	{"15657", "舑 碡"},
	{"15681", "碘"},
	{"15686", "磧"},
	{"15690", "硃"},
	{"15694", "磔"},
	{"15733", "靆"},
	{"16100", "珀 珈 珚"},
	{"16104", "聖"},
	{"16110", "現 覡"},
	{"16111", "琨"},
	{"16113", "瑰"},
	{"16114", "理 珵"},
	{"16115", "瑆"},
	{"16127", "琄 瑒"},
	{"16130", "聰 璁"},
	{"16132", "環 瑔"},
	{"16140", "豍"},
	{"16141", "琝"},
	{"16144", "瓔"},
	{"16150", "玾"},
	{"16160", "瑁 琩 瓃"},
	{"16180", "珼"},
	{"16181", "珿"},
	{"16194", "璪"},
	{"16196", "璟"},
	{"16217", "殟 豱"},
	{"16232", "彋"},
	{"16234", "殠"},
	{"16247", "彏 貜"},
	{"16254", "彃"},
	{"16256", "彈 殫"},
	{"16286", "殞"},
	{"16300", "迴"},
	{"16600", "硱 碅"},
	{"16601", "碧"},
	{"16610", "硯 靦 覗"},
	{"16613", "醜 磈"},
	{"16614", "醒 酲"},
	{"16617", "醞"},
	{"16627", "碣 碭"},
	{"16632", "碨"},
	{"16640", "碑"},
	{"16641", "醳"},
	{"16646", "磾"},
	{"16648", "釅 礹"},
	{"16660", "礧"},
	{"16681", "醍"},
	{"16693", "磥"},
	{"16713", "魂"},
	{"16810", "覝"},
	{"17103", "丞"},
	{"17104", "圣"},
	{"17105", "丑"},
	{"17107", "孟 盈 盄"},
	{"17108", "翌"},
	{"17109", "銎"},
	{"17110", "虱 珮 珇"},
	{"17112", "玸"},
	{"17113", "瑵"},
	{"17118", "璒"},
	{"17120", "刁 刁 羽 玥 聊 瑚 玓 珋 珣 珝 翑 琱"},
	{"17122", "璆"},
	{"17127", "邶 耶 弱 琊 瑯 鄧 鵡 邛 邳 郅 郖 郰 鄄 璚 翵 鵛"},
	{"17132", "琭 瑑"},
	{"17134", "瑍 翭"},
	{"17135", "璭"},
	{"17136", "蚤 蛋 蝨 蛩 蟊"},
	{"17140", "取 珊 玬 珘 琡"},
	{"17146", "璕"},
	{"17147", "瑕 瓊"},
	{"17148", "璻"},
	{"17156", "琿"},
	{"17162", "玿"},
	{"17164", "珞 琚 璐"},
	{"17167", "珺 瑂"},
	{"17172", "瑤"},
	{"17180", "玖"},
	{"17181", "璵"},
	{"17182", "歅"},
	{"17194", "琛 璨"},
	{"17202", "予 翏"},
	{"17207", "了 弓"},
	{"17210", "殂 殈"},
	{"17212", "卼"},
	{"17214", "翟 殛"},
	{"17217", "弝 豝"},
	{"17220", "刀 殉 翩 翮 歾 弸"},
	{"17222", "矛 沀"},
	{"17232", "承 聚 豫 氶 豤"},
	{"17247", "及 歿 豭"},
	{"17262", "弨"},
	{"17327", "鄢 鵋"},
	{"17331", "忌 恐 烝"},
	{"17332", "忍 恿"},
	{"17334", "焣"},
	{"17336", "焄"},
	{"17346", "尋"},
	{"17400", "又 叉 孓"},
	{"17404", "娶 翣"},
	{"17407", "子 孑 孕"},
	{"17408", "翠"},
	{"17412", "孢"},
	{"17413", "兔"},
	{"17420", "刃 覅"},
	{"17427", "邢 勇 邗 邘 郠 郔 鄈 鳱 鳵 鳽 鵽 鷣"},
	{"17438", "翜"},
	{"17440", "翇"},
	{"17441", "异"},
	{"17442", "羿"},
	{"17447", "孖"},
	{"17461", "聸"},
	{"17482", "欼"},
	{"17502", "翬"},
	{"17506", "鞏 鞪"},
	{"17507", "尹"},
	{"17510", "丮"},
	{"17527", "弔 那"},
	{"17602", "召 習"},
	{"17607", "君"},
	{"17610", "砠 飁"},
	{"17612", "砲 硊"},
	{"17617", "配"},
	{"17620", "司 矽 砌 酌 碉 硼 卲 硐 酠 碙 酮 醄 醐"},
	{"17622", "磟 醪"},
	{"17627", "邵 郡 郚 确 鄑 碢 醑 鵘 酃 鶝"},
	{"17632", "碌 碾 硍 硠 醁"},
	{"17640", "砃"},
	{"17647", "矷 砐 砓 酘 碫 碬 醊 醙"},
	{"17650", "砪"},
	{"17660", "酩"},
	{"17664", "酪 硌"},
	{"17681", "礙"},
	{"17682", "砍 歌"},
	{"17686", "礥"},
	{"17694", "磉 磉"},
	{"17710", "乙"},
	{"17714", "毣"},
	{"17717", "己 已 巹"},
	{"17727", "邔"},
	{"17801", "疋 翼 跫 翨"},
	{"17902", "尕"},
	{"17904", "朵 柔 桑 棸"},
	{"17910", "飄"},
	{"17920", "翲"},
	{"17927", "鴀 鷅"},
	{"18104", "堥"},
	{"18109", "鍪"},
	{"18111", "瑳"},
	{"18120", "玠"},
	{"18121", "瑜 瑐"},
	{"18122", "珍"},
	{"18127", "玢 耹 珶 聬"},
	{"18133", "璲"},
	{"18136", "蝥"},
	{"18137", "玲 聆 豏 豏"},
	{"18140", "攻 玫 政 致 敢 玝 璈 璥 璷"},
	{"18150", "珜"},
	{"18161", "珨"},
	{"18162", "琀"},
	{"18166", "璔 璯"},
	{"18167", "瑲"},
	{"18181", "琁 璇 瑽"},
	{"18222", "殄"},
	{"18227", "矜 務 殤 翂 鬺"},
	{"18240", "攷"},
	{"18281", "豵"},
	{"18286", "殮"},
	{"18327", "騖 鶩"},
	{"18334", "憨 憨"},
	{"18404", "婺"},
	{"18440", "孜 敪"},
	{"18604", "瞀"},
	{"18610", "醝"},
	{"18611", "砟 磋 酢"},
	{"18612", "碰"},
	{"18617", "矻"},
	{"18620", "砎"},
	{"18627", "砏 砱 酚 碖"},
	{"18632", "磁 硹"},
	{"18637", "磏"},
	{"18640", "敔 磝 礅 礉"},
	{"18651", "群"},
	{"18653", "礒"},
	{"18666", "磳"},
	{"18694", "酴 硢"},
	{"18727", "霒"},
	{"18732", "餮"},
	{"18740", "改"},
	{"18904", "楘"},
	{"19111", "珖"},
	{"19159", "璘"},
	{"19166", "璫"},
	{"19180", "耿"},
	{"19186", "瑣"},
	{"19189", "琰"},
	{"19227", "弰"},
	{"19616", "碴"},
	{"19620", "砂"},
	{"19627", "硝"},
	{"19639", "醚"},
	{"19659", "磷"},
	{"19666", "礑"},
	{"19693", "礯"},
	{"19732", "褧"},
	{"20027", "牖 牓 牓"},
	{"20101", "盉"},
	{"20104", "壬 垂 重"},
	{"20111", "乖"},
	{"20114", "雌"},
	{"20127", "黐"},
	{"20132", "黍"},
	{"20136", "蚕 蠥"},
	{"20202", "彳"},
	{"20211", "魋"},
	{"20212", "魑"},
	{"20214", "住 往 隹 僮 侂 倠 雔 儺 讎 雥"},
	{"20216", "覓 儃"},
	{"20217", "伉 禿"},
	{"20218", "位"},
	{"20221", "停"},
	{"20222", "豸"},
	{"20223", "儕"},
	{"20227", "仿 彷 秀 為 傍 喬 傭 徬 雋 矞 儰"},
	{"20231", "僬 儦"},
	{"20232", "依 偯 伭 儴 忀"},
	{"20236", "億"},
	{"20240", "俯"},
	{"20241", "僻 辭"},
	{"20246", "傽"},
	{"20247", "愛"},
	{"20248", "佼 倅"},
	{"20252", "舜"},
	{"20261", "信 倍 偣"},
	{"20282", "侅"},
	{"20296", "倞"},
	{"20307", "乏"},
	{"20314", "鵻"},
	{"20316", "鱣"},
	{"20317", "魧"},
	{"20327", "魴 鰝 鶭"},
	{"20331", "焦 熏"},
	{"20333", "忝"},
	{"20339", "悉"},
	{"20341", "魰"},
	{"20344", "鯜"},
	{"20346", "鱆"},
	{"20347", "鯙"},
	{"20348", "鮫"},
	{"20396", "鯨"},
	{"20400", "千"},
	{"20401", "隼"},
	{"20404", "妥 委"},
	{"20407", "孚 受 季 隻 雙"},
	{"20409", "乎"},
	{"20414", "雛 雞 艟"},
	{"20417", "航"},
	{"20423", "艩"},
	{"20427", "禹 舫 艕"},
	{"20430", "夭 奚"},
	{"20432", "舷 齉"},
	{"20447", "爰 艭"},
	{"20500", "手"},
	{"20501", "犨"},
	{"20507", "爭"},
	{"20514", "犝"},
	{"20527", "犒"},
	{"20531", "犥"},
	{"20547", "犉"},
	{"20552", "掱"},
	{"20601", "售"},
	{"20603", "吞 昋"},
	{"20604", "舌 看"},
	{"20609", "香 番"},
	{"20614", "雊 雒"},
	{"20627", "皜"},
	{"20631", "皫"},
	{"20648", "皎"},
	{"20714", "毛 乇 毳 雝"},
	{"20715", "嵼"},
	{"20716", "毰"},
	{"20721", "嵉"},
	{"20722", "嵃 齴"},
	{"20727", "崹"},
	{"20731", "嶕"},
	{"20732", "么"},
	{"20746", "爵 嶂"},
	{"20747", "崞"},
	{"20767", "嵣"},
	{"20777", "舀"},
	{"20782", "峐"},
	{"20901", "乘"},
	{"20903", "系"},
	{"20904", "禾 采 集"},
	{"20907", "秉"},
	{"20909", "釆"},
	{"20913", "統"},
	{"20914", "稚 維 纏 紸 穜"},
	{"20916", "繵"},
	{"20923", "穧"},
	{"20927", "紡 稿 締 縞 縍 縭"},
	{"20931", "穛 穮"},
	{"20932", "絃 縗 纊 穰 纕"},
	{"20935", "縗"},
	{"20936", "繶"},
	{"20940", "紋"},
	{"20943", "繂"},
	{"20947", "稕 綧"},
	{"20948", "絞 綷"},
	{"20953", "縴"},
	{"20982", "絯"},
	{"20986", "穬"},
	{"20996", "綡"},
	{"21047", "版"},
	{"21086", "順"},
	{"21100", "上 止"},
	{"21101", "些"},
	{"21103", "衍"},
	{"21104", "街 衝 坒"},
	{"21106", "暨"},
	{"21109", "銜 鈭"},
	{"21110", "此"},
	{"21111", "魖"},
	{"21117", "甀"},
	{"21136", "螚"},
	{"21140", "衈"},
	{"21160", "黏"},
	{"21186", "顗"},
	{"21190", "衃"},
	{"21209", "步"},
	{"21210", "仁 仳 仜 仩 佌"},
	{"21211", "征 虐 俳 徑 能 徘 儷 仨 俓 傂 儱 儱 儮 徿"},
	{"21212", "虛 魎 僊"},
	{"21214", "偃 虍 侄 俇 躽"},
	{"21216", "僵 軀 傴 貙"},
	{"21217", "伍 虎 盧 佢 佤 虤 甗 齇"},
	{"21219", "伾 魒"},
	{"21220", "仃 何"},
	{"21221", "行 衡 衢 衎 衖 衕 衚"},
	{"21227", "肯 倆 虜 膚 衛 儒 虧 侕 偝 傌 胔 胔 傿 觜 歶 鬳"},
	{"21231", "卡 伝 佧 虙"},
	{"21232", "倀 侲 豦 觨"},
	{"21236", "慮 儢"},
	{"21240", "虔 鼾 佴"},
	{"21241", "處"},
	{"21244", "佞 偠"},
	{"21246", "便 倬"},
	{"21247", "優"},
	{"21249", "伻 虖"},
	{"21253", "歲"},
	{"21260", "佔 佰 偭 貊 徆"},
	{"21261", "偕 俉"},
	{"21266", "偪"},
	{"21269", "俖"},
	{"21277", "偛"},
	{"21281", "徙 虞 虡 虡"},
	{"21286", "偵 須 傾 價 頻 頹 顓 顱 潁 頠 顪"},
	{"21290", "伓"},
	{"21291", "僄"},
	{"21294", "偨"},
	{"21299", "僳"},
	{"21310", "魟 魤"},
	{"21311", "鯡 鱺"},
	{"21314", "鰋"},
	{"21317", "鱸 虢 魱 鱋"},
	{"21319", "魾"},
	{"21320", "魺"},
	{"21327", "鮞 鰤 鷌 鶳 鱱"},
	{"21331", "態 熊 忐 毖"},
	{"21332", "愆"},
	{"21333", "鱁"},
	{"21336", "鮆"},
	{"21344", "鰬"},
	{"21346", "鯁"},
	{"21347", "魬"},
	{"21361", "鮨 鯃"},
	{"21374", "鱈"},
	{"21382", "鱖"},
	{"21391", "鰾"},
	{"21394", "鮛"},
	{"21404", "嬃"},
	{"21406", "卓 顰"},
	{"21407", "与"},
	{"21410", "舡 舡"},
	{"21417", "瓾 齀 艫"},
	{"21420", "舸"},
	{"21427", "駂"},
	{"21447", "舨"},
	{"21486", "頯 顊"},
	{"21510", "牝"},
	{"21511", "牼"},
	{"21527", "犡"},
	{"21550", "拜"},
	{"21561", "牾"},
	{"21600", "占 鹵 卣"},
	{"21601", "旨 皆 衙 訾 呰 眥 砦 讆"},
	{"21608", "睿"},
	{"21610", "皉"},
	{"21611", "馡"},
	{"21617", "瓵 甔"},
	{"21647", "皈 敁"},
	{"21710", "比 齜 屼 齔"},
	{"21711", "岏"},
	{"21714", "毞 峌"},
	{"21716", "嶇 峘 毢"},
	{"21717", "岠 罏"},
	{"21719", "岯"},
	{"21727", "師 峏"},
	{"21732", "衒 飺"},
	{"21740", "岍 岈 齖"},
	{"21746", "罈"},
	{"21761", "齬 峿"},
	{"21771", "嶀"},
	{"21772", "齒"},
	{"21786", "頃 崸 頧"},
	{"21801", "真 躗"},
	{"21806", "貞 貲 贙"},
	{"21886", "顛 熲"},
	{"21901", "祡"},
	{"21903", "紫"},
	{"21904", "桌 柴 術"},
	{"21909", "粊"},
	{"21910", "紅 紕 秕"},
	{"21911", "經 緋 綖 纚"},
	{"21912", "緪"},
	{"21913", "絰"},
	{"21914", "絰 秷 穊"},
	{"21917", "秬 甈 纑"},
	{"21919", "秠"},
	{"21920", "糽"},
	{"21921", "絎"},
	{"21927", "緉 繻"},
	{"21931", "紜"},
	{"21934", "緛"},
	{"21940", "紆"},
	{"21943", "縟"},
	{"21946", "綽 綆 緶"},
	{"21947", "敊 纋"},
	{"21949", "秤"},
	{"21953", "穢"},
	{"21960", "緬 絔"},
	{"21961", "縉"},
	{"21966", "稫"},
	{"21981", "縰"},
	{"21986", "穎 顈 纈"},
	{"21990", "紑"},
	{"21991", "縹"},
	{"21996", "縓"},
	{"22000", "川"},
	{"22010", "儿 胤"},
	{"22027", "片"},
	{"22100", "剝 剴 劙"},
	{"22104", "峚"},
	{"22108", "豈 岦"},
	{"22109", "鑾 崟"},
	{"22127", "傰 巋"},
	{"22136", "蚩 蠻 蠜 蠫 蠿"},
	{"22147", "崶"},
	{"22153", "嶯"},
	{"22163", "濌"},
	{"22182", "嶔"},
	{"22187", "崁"},
	{"22200", "刎 例 制 俐 倒 側 劇 劓 爿 侀 觓 剬 剻 剼 劖"},
	{"22202", "嵾"},
	{"22207", "岑 彎"},
	{"22210", "亂"},
	{"22211", "巃"},
	{"22212", "彪 崺 鬿"},
	{"22213", "佻 嵬"},
	{"22214", "任 崖 崔 催 倕 偅 毿"},
	{"22216", "儠"},
	{"22217", "兇 嵐 郺"},
	{"22221", "鼎 伒 斨"},
	{"22222", "虨"},
	{"22227", "耑 偽 崩 崙 崗 嵩 僑 屴 侺 峛 偊 偳 嶲 貒 巂 雟 臠 觿"},
	{"22228", "岕"},
	{"22230", "俬 觚"},
	{"22234", "僕 嶽 傒 徯"},
	{"22236", "嵹"},
	{"22239", "僁"},
	{"22240", "仟 低 彽 觝"},
	{"22241", "岸 侹"},
	{"22243", "俀 嶈"},
	{"22244", "倭"},
	{"22247", "岌 俘 後 偁 僾"},
	{"22248", "巖"},
	{"22253", "崴 幾 嵅 巀 魕"},
	{"22257", "嵂"},
	{"22264", "循 佸"},
	{"22269", "僠"},
	{"22270", "仙"},
	{"22282", "嶡"},
	{"22286", "嵿"},
	{"22289", "炭"},
	{"22291", "傺"},
	{"22293", "係"},
	{"22294", "觻"},
	{"22300", "劁"},
	{"22310", "鮿"},
	{"22313", "鮡"},
	{"22314", "魠"},
	{"22317", "鷈"},
	{"22327", "鷥 鸞 鵀 鱎"},
	{"22331", "恁"},
	{"22336", "崽"},
	{"22339", "懸 戀"},
	{"22347", "鯚 鱍 鱍"},
	{"22363", "鯔"},
	{"22369", "鱕"},
	{"22386", "嶺"},
	{"22393", "鯀"},
	{"22394", "穌 鱳"},
	{"22400", "矧"},
	{"22401", "孌"},
	{"22404", "崣"},
	{"22407", "孿 屮"},
	{"22408", "變 崒"},
	{"22410", "乳"},
	{"22413", "巍"},
	{"22417", "齆"},
	{"22427", "峟"},
	{"22441", "艇"},
	{"22447", "艸 芔 茻 艀"},
	{"22448", "艐"},
	{"22470", "舢"},
	{"22481", "嶷"},
	{"22500", "犁"},
	{"22502", "掣 攣 輋"},
	{"22504", "峷 崋"},
	{"22514", "嶊"},
	{"22516", "犣"},
	{"22521", "嶄"},
	{"22527", "岪 犞"},
	{"22540", "牴"},
	{"22550", "掰 搿"},
	{"22600", "刮 甾"},
	{"22601", "岩 峇 嶜"},
	{"22602", "岧"},
	{"22603", "曫"},
	{"22604", "峉"},
	{"22607", "崮"},
	{"22609", "轡 矕"},
	{"22610", "乩 癿"},
	{"22614", "嶉"},
	{"22618", "皚"},
	{"22621", "岢 斪"},
	{"22633", "舔"},
	{"22640", "舐"},
	{"22646", "皭"},
	{"22653", "畿"},
	{"22669", "皤"},
	{"22694", "皪"},
	{"22700", "刨"},
	{"22711", "崑 鬯"},
	{"22712", "峞"},
	{"22714", "鼮"},
	{"22717", "邕"},
	{"22718", "嶝"},
	{"22721", "斷 岓 齗"},
	{"22727", "齲 嶠 嶠"},
	{"22732", "製 崀"},
	{"22734", "岆"},
	{"22737", "峎"},
	{"22741", "嶭"},
	{"22747", "嵕"},
	{"22757", "崢"},
	{"22760", "崰"},
	{"22761", "缿"},
	{"22764", "崏"},
	{"22769", "嶓"},
	{"22770", "山 凶 幽 豳 凵 丱 屾"},
	{"22772", "出 巒"},
	{"22782", "嵌"},
	{"22791", "嵊"},
	{"22793", "繇"},
	{"22800", "劗"},
	{"22801", "奱"},
	{"22806", "賃"},
	{"22809", "災"},
	{"22811", "岝"},
	{"22827", "崱"},
	{"22886", "巔"},
	{"22900", "利 糾 剩 剿 紃 紖 絒"},
	{"22901", "祟 崇"},
	{"22903", "糸"},
	{"22904", "梨 樂 栠 嶪 欒"},
	{"22906", "嶚"},
	{"22910", "乿"},
	{"22913", "繼 絩"},
	{"22914", "種 綞 秅 秏 秏 紝 嵀 緟 繀"},
	{"22922", "彩 絼"},
	{"22927", "繃 穚 繑 纗"},
	{"22930", "私"},
	{"22931", "纁"},
	{"22937", "穩"},
	{"22938", "崧"},
	{"22940", "紙 秖 秖 秪"},
	{"22941", "綎"},
	{"22944", "綏 緌"},
	{"22946", "穱"},
	{"22947", "緩 嵙 稃 綒 稯"},
	{"22953", "穖"},
	{"22957", "稱"},
	{"22963", "緇 秮"},
	{"22969", "繙"},
	{"22970", "秈"},
	{"22977", "絀 稻 縚"},
	{"22993", "絲"},
	{"22994", "綵 繅 秝"},
	{"23000", "卜"},
	{"23053", "牋"},
	{"23115", "魆"},
	{"23134", "獃 獃"},
	{"23200", "仆 外 伈"},
	{"23202", "參"},
	{"23210", "允"},
	{"23211", "佗 倥"},
	{"23212", "倇"},
	{"23214", "僱 优 侘 僦 僿 魃"},
	{"23215", "魊"},
	{"23221", "佇 儜"},
	{"23227", "偏"},
	{"23232", "傢 俍 俅 觩"},
	{"23234", "伏 俟 獻"},
	{"23240", "代 倵"},
	{"23242", "傅"},
	{"23244", "侒"},
	{"23247", "俊"},
	{"23250", "伐 戕 俄 臧 戲 侔 傶"},
	{"23253", "俴 虥"},
	{"23260", "佁"},
	{"23268", "傛"},
	{"23277", "倌"},
	{"23286", "儐"},
	{"23290", "佖"},
	{"23291", "徖"},
	{"23300", "鮅"},
	{"23311", "鴕 鮀 鯇"},
	{"23314", "魷"},
	{"23327", "鯆 鸑"},
	{"23331", "黛"},
	{"23332", "鯄"},
	{"23333", "然"},
	{"23336", "怠"},
	{"23347", "鵔"},
	{"23350", "鰔"},
	{"23360", "鮐"},
	{"23368", "鰫"},
	{"23411", "舵"},
	{"23427", "艑"},
	{"23430", "矣"},
	{"23440", "弁"},
	{"23486", "軉"},
	{"23500", "牟"},
	{"23504", "牮"},
	{"23506", "軬"},
	{"23512", "牻"},
	{"23547", "牸 牸"},
	{"23550", "我"},
	{"23561", "犗"},
	{"23600", "台 馝"},
	{"23603", "畚"},
	{"23611", "皖"},
	{"23650", "鹹 皒"},
	{"23711", "崆 岮"},
	{"23713", "毬 鼣"},
	{"23715", "毧"},
	{"23727", "峬"},
	{"23732", "袋"},
	{"23734", "巘"},
	{"23744", "峖"},
	{"23747", "峻 鼥"},
	{"23750", "峨 峸 巇"},
	{"23768", "嵱"},
	{"23772", "岱 齾"},
	{"23782", "岤"},
	{"23806", "貸 貵"},
	{"23809", "炱"},
	{"23900", "秘"},
	{"23903", "絫"},
	{"23904", "枲 柋"},
	{"23911", "紽 綄"},
	{"23912", "綩"},
	{"23914", "紌 秺"},
	{"23921", "紵"},
	{"23922", "縿 穇"},
	{"23927", "編 稨"},
	{"23932", "稼 稂 絿"},
	{"23934", "秫 紎 綟 纀"},
	{"23936", "繈"},
	{"23941", "縡"},
	{"23942", "縛"},
	{"23944", "紱"},
	{"23947", "稄"},
	{"23950", "絨 緘 織 纖 稢 緎"},
	{"23960", "紿"},
	{"23961", "稽 縮 縖"},
	{"23971", "嵇"},
	{"23977", "綰"},
	{"23981", "綻"},
	{"23986", "縯 繽"},
	{"23991", "綜"},
	{"24086", "牘"},
	{"24094", "牒"},
	{"24111", "靠"},
	{"24127", "動"},
	{"24141", "歭"},
	{"24147", "歧"},
	{"24153", "衊"},
	{"24200", "什 付 射 豺 斛"},
	{"24210", "化 仕 壯 魁"},
	{"24211", "先 佐 佬 僥 侁 偡 兟"},
	{"24212", "他 勉"},
	{"24214", "佳 僅 傕 觟 鬾 儓"},
	{"24216", "值 俺"},
	{"24217", "仇 伳 甝"},
	{"24218", "魌"},
	{"24221", "倚 徛 舿 觭"},
	{"24227", "佈 侑 觔 偽 備 仂 侉 俙 勴"},
	{"24231", "佉 觾"},
	{"24234", "傸 貘"},
	{"24235", "偀"},
	{"24236", "德"},
	{"24238", "俠"},
	{"24240", "妝"},
	{"24241", "侍 待 倖 儔 偫 傇"},
	{"24247", "彼 伎 倰 皻"},
	{"24256", "偉 徫"},
	{"24260", "估 佑 儲 觰"},
	{"24261", "借 僖 牆 佶"},
	{"24264", "偌"},
	{"24266", "傮"},
	{"24281", "供 徒 倛 傎 儊"},
	{"24286", "僨 儥 儹"},
	{"24290", "休 貅"},
	{"24291", "倷 僸"},
	{"24294", "偞"},
	{"24296", "僚 膫"},
	{"24298", "徠"},
	{"24300", "鮒"},
	{"24311", "鱙"},
	{"24314", "鮭 鯥 鱹"},
	{"24327", "勳 鮪 魶 鰳"},
	{"24330", "怤"},
	{"24331", "魼"},
	{"24332", "憊 怹"},
	{"24337", "憩"},
	{"24339", "烋"},
	{"24341", "鰣"},
	{"24343", "鱴"},
	{"24347", "鯪"},
	{"24360", "鮕"},
	{"24361", "鰭 鮚"},
	{"24366", "鰽"},
	{"24370", "魽"},
	{"24381", "鯕 鶀"},
	{"24394", "鰈"},
	{"24398", "鯠"},
	{"24400", "升"},
	{"24417", "鼽"},
	{"24427", "艜"},
	{"24430", "奘"},
	{"24431", "奊"},
	{"24432", "艨"},
	{"24440", "姇"},
	{"24447", "皴 皺 矱"},
	{"24481", "舼"},
	{"24494", "艓"},
	{"24500", "犐"},
	{"24510", "牡"},
	{"24512", "牠 犆"},
	{"24521", "犄"},
	{"24527", "牞 劮 犕"},
	{"24541", "特"},
	{"24560", "牯 牯"},
	{"24561", "牿"},
	{"24586", "犢"},
	{"24601", "告"},
	{"24616", "馣"},
	{"24627", "劬 勂 勓 勫"},
	{"24647", "馞"},
	{"24661", "皓 齰"},
	{"24670", "甜"},
	{"24711", "峔 毨 嵁 嶢"},
	{"24713", "氁"},
	{"24714", "巏"},
	{"24716", "崦"},
	{"24717", "齛"},
	{"24721", "崎 齮"},
	{"24727", "幼 帥 崤 岰 嵽 嶱"},
	{"24732", "裝"},
	{"24738", "峽"},
	{"24741", "峙"},
	{"24744", "巕"},
	{"24747", "岐 岥 崚"},
	{"24760", "岵"},
	{"24767", "嶆"},
	{"24781", "齻"},
	{"24786", "巑"},
	{"24798", "崍"},
	{"24806", "貨 贊"},
	{"24809", "焋"},
	{"24900", "科 紂 紁 紏 紨"},
	{"24911", "繞 穘"},
	{"24912", "紞"},
	{"24914", "絓 稑"},
	{"24916", "稙"},
	{"24917", "紲"},
	{"24921", "綺"},
	{"24927", "納 稀 勦 絺"},
	{"24931", "紶"},
	{"24932", "紘"},
	{"24934", "縸 繨"},
	{"24947", "稜 綾 穫 綍"},
	{"24956", "緯 緙 稦"},
	{"24960", "緒"},
	{"24961", "結 穡 秸 稓"},
	{"24970", "紺"},
	{"24981", "緹 縝 稘"},
	{"24986", "續 稹 穔"},
	{"24990", "綝"},
	{"24994", "縥"},
	{"24996", "繚"},
	{"25000", "牛"},
	{"25030", "失"},
	{"25060", "牰"},
	{"25100", "生"},
	{"25110", "甡"},
	{"25200", "仗 件 舛"},
	{"25206", "仲 伸 使"},
	{"25207", "律 倳"},
	{"25217", "儘 伅"},
	{"25219", "魅"},
	{"25227", "佛 彿 倩 伂 俜 儚"},
	{"25230", "伕 佚 体 佒 觖 僆"},
	{"25232", "儂 侇 俵 齂 齈"},
	{"25236", "触"},
	{"25240", "健"},
	{"25243", "傳"},
	{"25244", "僂 貗"},
	{"25247", "傋"},
	{"25253", "俸"},
	{"25261", "僭"},
	{"25263", "偆 僣"},
	{"25281", "倎"},
	{"25286", "債 僓 穨"},
	{"25290", "侏"},
	{"25293", "傃"},
	{"25294", "傑"},
	{"25296", "觫"},
	{"25299", "傣"},
	{"25317", "魨"},
	{"25318", "鱧"},
	{"25327", "鯖 鱐"},
	{"25330", "鴃 鰱"},
	{"25343", "鱄"},
	{"25344", "鰎"},
	{"25363", "鰆"},
	{"25386", "鰿"},
	{"25390", "鮇 鮢"},
	{"25406", "舯"},
	{"25407", "肄"},
	{"25432", "齈"},
	{"25444", "艛"},
	{"25460", "舳"},
	{"25466", "艚"},
	{"25500", "牪"},
	{"25510", "牲"},
	{"25527", "牬"},
	{"25544", "犍"},
	{"25601", "眚"},
	{"25681", "疀"},
	{"25706", "齥"},
	{"25714", "毽"},
	{"25721", "崝"},
	{"25730", "岟"},
	{"25732", "峓 嶩"},
	{"25744", "嶁 嶁"},
	{"25760", "岫"},
	{"25781", "崨"},
	{"25794", "嵥"},
	{"25796", "崠"},
	{"25900", "朱"},
	{"25904", "桀"},
	{"25906", "紳 种 絏"},
	{"25916", "繣"},
	{"25917", "純 紈"},
	{"25927", "紼 繡 秭 綪"},
	{"25930", "秧 秩 紩 紻 縺"},
	{"25932", "穠 繷"},
	{"25933", "穗 絊 繐"},
	{"25937", "繾"},
	{"25943", "縳"},
	{"25944", "縷 緀"},
	{"25960", "釉 秞 紬"},
	{"25981", "緁"},
	{"25986", "積 績 繢 繢 纘"},
	{"25990", "秣 絑"},
	{"25993", "縤"},
	{"25996", "練 綀"},
	{"26000", "白 自 囪 囟"},
	{"26032", "儤"},
	{"26040", "牌"},
	{"26104", "皇 堡"},
	{"26110", "覬"},
	{"26127", "甥"},
	{"26200", "伽 佃 伯 徊 個 佪 侞"},
	{"26207", "粵"},
	{"26210", "但 侃 貌 俔 觛 覤 儭 覷 覷 覶"},
	{"26211", "倱 貔"},
	{"26213", "鬼 傀"},
	{"26214", "俚 徨 貍 儸 偟"},
	{"26217", "俋"},
	{"26227", "帛 偶 觸 偈 傝 儩"},
	{"26230", "偲"},
	{"26232", "泉 偎 儇 忁 灥"},
	{"26233", "儑"},
	{"26234", "俁"},
	{"26237", "伬"},
	{"26240", "俾 貏"},
	{"26241", "得 偮"},
	{"26246", "貚"},
	{"26247", "傻 僈"},
	{"26248", "儼"},
	{"26256", "僤 觶"},
	{"26260", "侶 倡 儡"},
	{"26280", "伿"},
	{"26281", "促 俱 偍 徥"},
	{"26293", "儽"},
	{"26294", "保"},
	{"26300", "鮂"},
	{"26311", "鯤"},
	{"26314", "鯉 鰉"},
	{"26322", "鱞"},
	{"26327", "鱷 鰅 鰨"},
	{"26330", "息 鰓"},
	{"26332", "鸔"},
	{"26333", "鰥"},
	{"26340", "鵿"},
	{"26347", "鰻"},
	{"26350", "魻"},
	{"26360", "鯧"},
	{"26381", "鯷"},
	{"26394", "鱢"},
	{"26400", "卑 舶 皁"},
	{"26401", "睪 睾"},
	{"26403", "皋"},
	{"26410", "覣"},
	{"26411", "艎"},
	{"26413", "魏"},
	{"26430", "臭"},
	{"26446", "鼻"},
	{"26450", "舺"},
	{"26460", "艒"},
	{"26501", "犩"},
	{"26511", "犤"},
	{"26532", "犦"},
	{"26534", "犑"},
	{"26610", "覘"},
	{"26613", "魄"},
	{"26617", "馧"},
	{"26653", "皞"},
	{"26660", "皛"},
	{"26700", "岶 齫"},
	{"26710", "峴"},
	{"26711", "皂 嶵"},
	{"26713", "毸"},
	{"26714", "崲"},
	{"26727", "崿 崵 嵑 嵎 齵 齶"},
	{"26740", "崥"},
	{"26741", "嶧"},
	{"26750", "岬"},
	{"26780", "齞"},
	{"26781", "齪 崼"},
	{"26794", "嵲"},
	{"26801", "吳"},
	{"26809", "煲"},
	{"26880", "臮"},
	{"26900", "和 細 綑 絪 稒 稛 稛 緗"},
	{"26904", "臬"},
	{"26911", "緄"},
	{"26913", "繉"},
	{"26914", "程 纆 纙"},
	{"26916", "繩"},
	{"26917", "縕"},
	{"26922", "穆"},
	{"26927", "絹 綿 緆"},
	{"26930", "總 緦"},
	{"26932", "線 繯"},
	{"26940", "稗 綼"},
	{"26941", "稈 緝 繹 釋"},
	{"26943", "繌"},
	{"26944", "纓 縪"},
	{"26947", "稷 縵 繓"},
	{"26956", "繟"},
	{"26960", "絽"},
	{"26986", "縜"},
	{"26993", "縲"},
	{"26994", "稞 繰"},
	{"27027", "牖 鳪"},
	{"27062", "牊"},
	{"27100", "血"},
	{"27101", "韰"},
	{"27104", "墾 壑 垼 墏"},
	{"27107", "盤 盝"},
	{"27108", "豋"},
	{"27109", "錖 鎥"},
	{"27110", "凱 颽"},
	{"27115", "衄"},
	{"27117", "龜"},
	{"27120", "勻 卹"},
	{"27127", "郵 歸 鵖"},
	{"27132", "黎"},
	{"27136", "蟹 蠡 蛗 螿 螽 蠁"},
	{"27200", "夕"},
	{"27207", "多"},
	{"27210", "佩 仉 伔 侐 徂 偑"},
	{"27212", "危 魍 夗 佹 觤"},
	{"27213", "毚 儳"},
	{"27214", "偓"},
	{"27216", "俛"},
	{"27217", "倪 俷 鳧 僶 觬"},
	{"27222", "僇"},
	{"27227", "仍 角 侈 俑 侷 躬 嚮 伄 甮 鄇 鄅 幋 翛 僪 鵂 鵚 鵵 酁 鶨 觺 酅 鷮 鸆 鸕"},
	{"27231", "儵 虪"},
	{"27232", "很 眾 象 傯 像 漿 佷 佷 彔 彖"},
	{"27233", "佟"},
	{"27234", "侯 候 倏 偰"},
	{"27236", "鯈"},
	{"27240", "伢 侜 俶"},
	{"27241", "偋"},
	{"27242", "將"},
	{"27247", "仔 伋 役 侵 殷 假 觼 岋 彶 觙 徦 僝 貑"},
	{"27252", "解"},
	{"27253", "徲"},
	{"27256", "鞗"},
	{"27257", "伊"},
	{"27261", "詹 儋"},
	{"27262", "貂"},
	{"27264", "倨 貉 佫 崌 觡"},
	{"27272", "倔 傜 徭"},
	{"27281", "僎 儗"},
	{"27282", "欳 歂 僛 歑 歔"},
	{"27286", "偩"},
	{"27290", "你"},
	{"27292", "你"},
	{"27294", "躲"},
	{"27303", "冬"},
	{"27310", "鳦"},
	{"27312", "鮑 鮠"},
	{"27314", "鰹"},
	{"27316", "鮸"},
	{"27317", "鯢 鱦"},
	{"27320", "勺 鯽 鯛 魛 魡 鮈 鮦 鰗"},
	{"27327", "烏 鳥 鴛 鄬 鄔 鄎 鄩 駌 鯞 鵹 鱊 鷦"},
	{"27331", "怨 黧"},
	{"27332", "忽 鱌"},
	{"27333", "懇"},
	{"27334", "惄 鯸"},
	{"27336", "魚 鯬"},
	{"27337", "急 炰"},
	{"27339", "您"},
	{"27340", "鯓 鯫"},
	{"27346", "鱘"},
	{"27362", "鰡 鰼"},
	{"27364", "鮥"},
	{"27367", "鮶"},
	{"27372", "鰩"},
	{"27381", "鱮"},
	{"27382", "歍"},
	{"27391", "鰶"},
	{"27394", "鰇 鰷"},
	{"27400", "身"},
	{"27404", "妴 媻"},
	{"27407", "阜 敻"},
	{"27413", "艬"},
	{"27414", "艉"},
	{"27416", "免"},
	{"27417", "艋 舥"},
	{"27420", "翱 勼 匉 舠 匑"},
	{"27427", "芻 鄒 郛 郫 鴅 鴘 鵃 鵫 鵯 鶢 鶵 鷎"},
	{"27430", "奐 奧 獎"},
	{"27440", "舟"},
	{"27442", "彝"},
	{"27447", "般 艘"},
	{"27449", "彝"},
	{"27450", "匆"},
	{"27454", "舽 艂"},
	{"27463", "艣"},
	{"27481", "疑"},
	{"27482", "欸"},
	{"27502", "搫"},
	{"27504", "夆 鞶"},
	{"27520", "物 牣 犅"},
	{"27527", "鵝 觕 犓 鴩 鴾"},
	{"27547", "犌"},
	{"27550", "牳"},
	{"27581", "犋"},
	{"27600", "名"},
	{"27601", "磐 醬 響 眢"},
	{"27602", "曶"},
	{"27603", "魯"},
	{"27604", "各 督"},
	{"27611", "馜"},
	{"27620", "句 旬 甸 的 匐 翻 訇 匒"},
	{"27627", "鄱 鵠 邰 郇 郋 郜 鴝 鴰 鵅 鶅 鶛 鷭"},
	{"27640", "叡"},
	{"27682", "欨"},
	{"27710", "齟 岨 颻"},
	{"27711", "彘"},
	{"27712", "包 峗 齙"},
	{"27714", "齷"},
	{"27716", "龜 巉 氌"},
	{"27717", "色 屺 齯"},
	{"27720", "勾 幻 匈 峒 齣 卬 屻 岉 匋 岣 岣 峋 匎"},
	{"27722", "嵺"},
	{"27727", "島 鄉 鷂 嵨 鴔 鴢 鴭 齺"},
	{"27732", "裊 餐 饗 齦 裻 褩"},
	{"27740", "齱"},
	{"27747", "岷"},
	{"27752", "嶰"},
	{"27754", "峰"},
	{"27762", "嵧 嶍 齠"},
	{"27764", "峈"},
	{"27767", "峮 嵋"},
	{"27770", "峊"},
	{"27772", "崛 嶴"},
	{"27781", "嶼"},
	{"27782", "欿 歃"},
	{"27800", "久"},
	{"27802", "欠"},
	{"27806", "負 夤"},
	{"27809", "灸 炙"},
	{"27827", "酇"},
	{"27901", "祭 禦"},
	{"27903", "縏"},
	{"27904", "梟 彙 槃 槳 粲"},
	{"27910", "租 組"},
	{"27911", "秜"},
	{"27912", "臲"},
	{"27913", "纔"},
	{"27914", "糶"},
	{"27915", "紐"},
	{"27916", "絻"},
	{"27917", "紀 絕 繩"},
	{"27920", "紉 約 絢 稠 網 綱 綱 綢 匊 絅 絇 絧 綯"},
	{"27922", "穋 繆 紓"},
	{"27927", "移 綁 縐 邾 稰 鄛 縃 緺 縎 鴸 繘 鵴"},
	{"27932", "綠 緣"},
	{"27933", "終"},
	{"27934", "縫 緱"},
	{"27937", "縋"},
	{"27940", "叔 緅"},
	{"27947", "級 綴 緞 綅"},
	{"27950", "緷"},
	{"27952", "繲"},
	{"27954", "絳"},
	{"27962", "紹"},
	{"27963", "穭"},
	{"27964", "絡 緡"},
	{"27982", "絘"},
	{"27991", "穄 縩"},
	{"27994", "縔"},
	{"28100", "以"},
	{"28107", "盭"},
	{"28140", "敳"},
	{"28200", "似 仈"},
	{"28211", "作 傞"},
	{"28214", "佺 侳"},
	{"28216", "侻"},
	{"28217", "仡"},
	{"28220", "价"},
	{"28221", "偷 牏 腧 貐"},
	{"28222", "修"},
	{"28227", "份 佾 倫 脩 傷 觴 仱 彾"},
	{"28232", "飧 伀 彸 倯"},
	{"28237", "伶 傔"},
	{"28240", "攸 倣 做 傚 傲 微 徹 徵 徽 黴 仵 徶 儆 儌 徼 敿 徾 鰴"},
	{"28241", "併"},
	{"28246", "僔"},
	{"28247", "復"},
	{"28251", "佯 徉 牂"},
	{"28253", "儀"},
	{"28255", "觲"},
	{"28257", "侮"},
	{"28261", "佮 偤"},
	{"28264", "偺"},
	{"28266", "僧 儈 徻"},
	{"28267", "傖 牄"},
	{"28268", "俗"},
	{"28270", "佡"},
	{"28281", "從 傱"},
	{"28286", "儉 僋"},
	{"28293", "絛"},
	{"28294", "徐 條"},
	{"28311", "鮓"},
	{"28316", "鮵"},
	{"28327", "魵 鸄"},
	{"28332", "鯰"},
	{"28334", "悠 煞 煞 懲"},
	{"28337", "鰜"},
	{"28338", "慫"},
	{"28340", "鷻"},
	{"28346", "鱒"},
	{"28347", "鰒"},
	{"28351", "鮮"},
	{"28353", "鸃 鱵"},
	{"28361", "鱔 鮯"},
	{"28364", "鯦"},
	{"28366", "鱠"},
	{"28394", "鮽 鵌"},
	{"28401", "聳"},
	{"28411", "舴"},
	{"28412", "艖"},
	{"28413", "艞"},
	{"28417", "艦 艗"},
	{"28437", "舲"},
	{"28453", "艤"},
	{"28460", "船"},
	{"28461", "艏"},
	{"28467", "艙"},
	{"28468", "谿"},
	{"28494", "艅"},
	{"28514", "牷"},
	{"28540", "牧"},
	{"28547", "犪"},
	{"28553", "犧"},
	{"28601", "譥"},
	{"28604", "咎 昝"},
	{"28610", "鹺"},
	{"28627", "皊"},
	{"28637", "馦"},
	{"28640", "皦"},
	{"28641", "皏"},
	{"28647", "馥"},
	{"28686", "鹼"},
	{"28711", "嵯"},
	{"28716", "氆"},
	{"28717", "屹 齕 齸"},
	{"28720", "齘"},
	{"28721", "崳"},
	{"28727", "岒 岭"},
	{"28732", "嵫"},
	{"28737", "齡"},
	{"28740", "收"},
	{"28741", "缾 缾"},
	{"28746", "嶟"},
	{"28753", "嶬"},
	{"28761", "峆 崷"},
	{"28766", "嶒"},
	{"28767", "嵢"},
	{"28768", "峪"},
	{"28781", "嵷"},
	{"28786", "嶮"},
	{"28801", "跾"},
	{"28808", "熧"},
	{"28809", "焂"},
	{"28911", "縒"},
	{"28912", "絁"},
	{"28914", "絟"},
	{"28916", "稅 纜"},
	{"28917", "紇 縊"},
	{"28920", "紒"},
	{"28921", "緰"},
	{"28922", "紾"},
	{"28927", "紛 綸 秎 紟 稊 稐 綈"},
	{"28932", "稔"},
	{"28933", "穟"},
	{"28934", "縌 繺"},
	{"28937", "縑"},
	{"28940", "緻 繳 敹 繖"},
	{"28941", "絣"},
	{"28946", "繜"},
	{"28947", "緮"},
	{"28961", "給 繕 緧"},
	{"28964", "綹"},
	{"28966", "繒 繪"},
	{"28968", "綌"},
	{"28981", "縱 縼"},
	{"28994", "稌"},
	{"29111", "皝"},
	{"29136", "蝵"},
	{"29211", "觥"},
	{"29212", "倦 魈"},
	{"29227", "俏 倘 徜 僗 軂"},
	{"29231", "儻"},
	{"29238", "僽"},
	{"29250", "伴 牉"},
	{"29259", "僯"},
	{"29262", "偗"},
	{"29266", "儅"},
	{"29280", "伙 偢"},
	{"29286", "償"},
	{"29289", "倓"},
	{"29320", "魦"},
	{"29327", "鮹 鶖"},
	{"29338", "愁"},
	{"29359", "鱗"},
	{"29361", "鱨"},
	{"29380", "鰍"},
	{"29404", "媝"},
	{"29427", "躺 艄"},
	{"29466", "艡"},
	{"29502", "揫"},
	{"29512", "犈"},
	{"29689", "舕"},
	{"29717", "甃"},
	{"29718", "毯"},
	{"29727", "峭 嶗"},
	{"29759", "嶙"},
	{"29766", "巆"},
	{"29789", "燄 燄"},
	{"29794", "嶸"},
	{"29911", "絖"},
	{"29912", "綣"},
	{"29919", "繼"},
	{"29920", "秒 紗 緲 蕱"},
	{"29927", "稍 綃"},
	{"29933", "繸"},
	{"29950", "絆"},
	{"29959", "繗"},
	{"29980", "秋"},
	{"29989", "緂"},
	{"30101", "空"},
	{"30104", "室 窒 塞 窐"},
	{"30106", "宣"},
	{"30107", "宜 寍"},
	{"30109", "鎏"},
	{"30110", "汒"},
	{"30111", "漉 灖"},
	{"30112", "湸"},
	{"30113", "窕 宨"},
	{"30114", "注 准 淮 窪 潼 濰 灘 澭 濉 瀍 灉 灕"},
	{"30115", "滻"},
	{"30116", "澶 竀"},
	{"30117", "沆 瀛 褅 灗"},
	{"30118", "泣"},
	{"30121", "渟"},
	{"30123", "濟"},
	{"30124", "濟"},
	{"30127", "滂 漓 滴 汸 淯 湇 渧 滈 滽 窷"},
	{"30130", "汴"},
	{"30131", "潐 瀌"},
	{"30132", "滾 濠 泫 滖 漮 瀤 瀼 灢"},
	{"30136", "蜜 澺"},
	{"30137", "濂 瘐"},
	{"30140", "汶"},
	{"30141", "窏 澼"},
	{"30146", "漳"},
	{"30147", "淳 液 渡 寑 寖"},
	{"30148", "淬 洨"},
	{"30153", "窢"},
	{"30161", "涪 湆"},
	{"30163", "滀"},
	{"30167", "溏"},
	{"30177", "涫"},
	{"30181", "邅"},
	{"30186", "瀇"},
	{"30191", "凜"},
	{"30194", "潗"},
	{"30196", "涼"},
	{"30201", "寧 宁"},
	{"30202", "寥"},
	{"30207", "穹 穸"},
	{"30211", "完 窄 扉 寵"},
	{"30212", "宛"},
	{"30213", "裗"},
	{"30214", "寇 雇 窿"},
	{"30216", "寬 襢"},
	{"30221", "窬"},
	{"30227", "帘 房 肩 宥 扁 宵 扇 寡 窩 窮 祊 窉 窌 寪 寎 甯 禘 寯 褯 褵"},
	{"30232", "永 家 宸 禳 扆 窊 袨 寙 窳"},
	{"30234", "戾"},
	{"30241", "穿"},
	{"30247", "寢 戽 泙"},
	{"30248", "竅 祽"},
	{"30253", "宬"},
	{"30261", "宿 寤 寣"},
	{"30272", "窟"},
	{"30277", "戶"},
	{"30289", "扊"},
	{"30294", "窱 寱"},
	{"30295", "寐"},
	{"30301", "進 迒"},
	{"30302", "適"},
	{"30303", "寒 遮"},
	{"30304", "避 遧"},
	{"30306", "這"},
	{"30307", "之 窆"},
	{"30327", "寫 騫 窵 鶱"},
	{"30331", "窯 惌"},
	{"30332", "宓"},
	{"30336", "憲"},
	{"30339", "窸"},
	{"30342", "守"},
	{"30401", "宇 宰 準 穻"},
	{"30404", "安 宴 寠 窶"},
	{"30407", "字"},
	{"30408", "窔 窣"},
	{"30417", "究 宄"},
	{"30427", "寓"},
	{"30430", "突 寞"},
	{"30432", "宏 宎 穾 窫"},
	{"30447", "窙"},
	{"30481", "寲"},
	{"30502", "牢 搴"},
	{"30516", "窺"},
	{"30558", "阱"},
	{"30601", "害 窖 宕 窨 謇"},
	{"30602", "宙"},
	{"30604", "客"},
	{"30606", "宮 富"},
	{"30607", "窘 宭"},
	{"30608", "容 窗 窅"},
	{"30609", "審"},
	{"30621", "寄"},
	{"30711", "它"},
	{"30712", "窇 寋"},
	{"30714", "宅 宒"},
	{"30715", "竁"},
	{"30717", "灶 宦 竄 穵 窀 宧"},
	{"30727", "窈"},
	{"30732", "良 寰 褰"},
	{"30773", "密"},
	{"30777", "官 窋 窞"},
	{"30801", "定 寁 寔 寘 窴 蹇"},
	{"30802", "穴"},
	{"30806", "寅 實 賓 賽 寶 竇 竇 寊 賨"},
	{"30901", "宗 察"},
	{"30904", "宋 案 窠 窠 寨 寀"},
	{"30906", "寮"},
	{"30927", "竊"},
	{"30947", "寂"},
	{"30948", "窲"},
	{"30982", "窾"},
	{"31107", "盓"},
	{"31110", "江 沘 沚 沎 泚 渱"},
	{"31111", "沅 涇 瀝 灑 洭 瀧"},
	{"31114", "汪 涯 湮 溉 溼 洷 凐 淲 湹 瀖"},
	{"31116", "洹 漚 漚"},
	{"31117", "沍 瀘 冱 洰 洍"},
	{"31118", "浢"},
	{"31120", "汀 河"},
	{"31121", "滒"},
	{"31127", "污 沔 馮 濡 瀰 灞 洏 滆 溤 溮 漘 漹 濔 濿 灊"},
	{"31129", "涉"},
	{"31131", "沄 澐 濏"},
	{"31132", "涿 漲 澽"},
	{"31134", "渜 澞"},
	{"31136", "濾"},
	{"31137", "澪"},
	{"31140", "汗 汙 洱 汧 涆 渳"},
	{"31141", "灄"},
	{"31143", "溽"},
	{"31146", "潭 浭"},
	{"31147", "汳 淖 瀀"},
	{"31149", "泙 滹"},
	{"31150", "湃"},
	{"31153", "濊"},
	{"31160", "沾 酒 湎 滷 沰 洒"},
	{"31161", "浯 湝 溍"},
	{"31162", "灀"},
	{"31166", "湢"},
	{"31168", "濬"},
	{"31172", "涵"},
	{"31181", "漇"},
	{"31186", "澦 瀨 瀕 湞 澒 瀩 灝"},
	{"31191", "漂 沶"},
	{"31194", "溧"},
	{"31196", "源"},
	{"31210", "祉"},
	{"31211", "裶 褦 襱 襹"},
	{"31212", "褼"},
	{"31214", "禋 褗"},
	{"31218", "裋"},
	{"31227", "裲 禡 褙 禰 禲 襦"},
	{"31232", "祳 裖"},
	{"31240", "衧"},
	{"31243", "褥"},
	{"31246", "禫"},
	{"31260", "祏 袹"},
	{"31266", "福 褔"},
	{"31281", "褷"},
	{"31286", "禎 頫 顧 襭 禷"},
	{"31301", "逗 逕 遷 邐 迋"},
	{"31302", "邇"},
	{"31303", "逐 遽 遯"},
	{"31304", "迂 返 迓 逴 逴"},
	{"31306", "迺 逼 迠 逜 逌"},
	{"31308", "遉"},
	{"31309", "邍"},
	{"31332", "憑"},
	{"31336", "惉"},
	{"31391", "褾"},
	{"31486", "頞"},
	{"31686", "額"},
	{"31886", "顁"},
	{"31904", "渠"},
	{"32000", "州"},
	{"32022", "浵"},
	{"32100", "冽 洲 洌 涮 淵 測 瀏 汌 浰 淛"},
	{"32104", "垽"},
	{"32109", "鋈"},
	{"32110", "湚"},
	{"32112", "洐 滮"},
	{"32113", "兆 洮"},
	{"32114", "淫 湩 凗 漼"},
	{"32116", "漞"},
	{"32118", "澄"},
	{"32119", "溰"},
	{"32121", "沂 浙 淅 漸 凘 澌"},
	{"32122", "澎"},
	{"32123", "潻"},
	{"32127", "涔 湍 灣 沜 溈 漰"},
	{"32130", "冰 泓 泒"},
	{"32132", "派"},
	{"32133", "添"},
	{"32134", "沃 溪 濮 湀"},
	{"32136", "滍"},
	{"32137", "泛 漒 濦"},
	{"32140", "泜 汦"},
	{"32141", "涎 泝"},
	{"32144", "浽"},
	{"32146", "灂"},
	{"32147", "浮 湲 潑 叢"},
	{"32157", "淨 凈"},
	{"32160", "淄"},
	{"32161", "洉"},
	{"32163", "涾"},
	{"32164", "活 涽 湉"},
	{"32169", "潘"},
	{"32170", "汕"},
	{"32177", "滔 泏"},
	{"32189", "湠"},
	{"32191", "溗"},
	{"32194", "灤 漅 澲 濼"},
	{"32200", "剜 剜 裫"},
	{"32213", "祧"},
	{"32214", "衽"},
	{"32217", "褫 禠"},
	{"32221", "祈"},
	{"32222", "衫"},
	{"32227", "褊 黹"},
	{"32234", "祆 祅 襆"},
	{"32240", "祇 祗 衹 袛"},
	{"32247", "禐 褑 襏"},
	{"32253", "禨"},
	{"32300", "迾"},
	{"32301", "逃 逛 遞 邋"},
	{"32302", "近 逝 透 遄"},
	{"32303", "巡 迗"},
	{"32304", "逶"},
	{"32306", "逅 遁 适"},
	{"32307", "辿"},
	{"32309", "遜"},
	{"32413", "魙"},
	{"32600", "割"},
	{"32700", "剆"},
	{"32904", "巢 業 樂"},
	{"32947", "綬"},
	{"33000", "心 必"},
	{"33100", "沁 泌"},
	{"33111", "沱 沇 浣 涳"},
	{"33112", "涴"},
	{"33114", "沋 滱 漥"},
	{"33116", "渲"},
	{"33117", "滬"},
	{"33121", "濘 泞"},
	{"33122", "滲"},
	{"33127", "浦 瀉"},
	{"33132", "泳 浤 溛"},
	{"33134", "狀 淚 汱 沭 洑 涘 涋"},
	{"33136", "瀗"},
	{"33141", "滓"},
	{"33142", "溥"},
	{"33143", "湥"},
	{"33144", "洝"},
	{"33147", "浚 冹 沷 漃"},
	{"33150", "減 滅 泧 洠 涐 淢 渽 濈 澸 瀸 瀻"},
	{"33152", "浶"},
	{"33153", "淺 濺"},
	{"33160", "冶 治"},
	{"33168", "溶"},
	{"33169", "瀋"},
	{"33173", "滵"},
	{"33181", "淀"},
	{"33186", "演 濱"},
	{"33187", "泬"},
	{"33191", "淙"},
	{"33194", "浨 淭"},
	{"33200", "祕 褂"},
	{"33211", "袉"},
	{"33222", "襂 襂"},
	{"33227", "補 黼"},
	{"33234", "袱"},
	{"33244", "袚"},
	{"33247", "祓 黻"},
	{"33250", "祴 襶 襳"},
	{"33268", "褣"},
	{"33282", "袕"},
	{"33300", "逃"},
	{"33302", "遍 逋"},
	{"33303", "邃 迖 逑"},
	{"33304", "逡"},
	{"33306", "迨"},
	{"33307", "逭"},
	{"33309", "述"},
	{"33330", "惢"},
	{"33850", "戭"},
	{"33903", "繠"},
	{"33904", "梁 粱 橤"},
	{"34000", "斗"},
	{"34027", "為"},
	{"34100", "汁 對 泭 澍 濧"},
	{"34109", "鍌 鍙"},
	{"34110", "壯"},
	{"34111", "洗 湛 澆 冼 淽 灆"},
	{"34112", "池 沈"},
	{"34113", "流"},
	{"34114", "灌 洼 淕 溎 漜"},
	{"34116", "淹 渣 淔"},
	{"34117", "泄 港 溘 氿 滼 濭 灩"},
	{"34121", "漪 渮"},
	{"34122", "灪"},
	{"34127", "洧 淆 渤 滿 滯 潸 瀟 氻 汭 泐 泑 洿 洘 浠 淓 湳 澫 灡"},
	{"34130", "汰 汏 汯"},
	{"34131", "法 浾"},
	{"34132", "漆 濛 溒 濍 瀡"},
	{"34134", "漠 漢 漺"},
	{"34135", "渶"},
	{"34138", "浹"},
	{"34140", "汝"},
	{"34141", "濤 涬 溡"},
	{"34143", "漭"},
	{"34144", "渀"},
	{"34147", "波 凌 濩 汥 洊 浡 涍 淩"},
	{"34153", "瀎"},
	{"34154", "澕"},
	{"34156", "湋"},
	{"34160", "沽 渚 渵 瀦"},
	{"34161", "浩 潛 洁 澔 濇"},
	{"34164", "渃"},
	{"34170", "泔"},
	{"34181", "洪 淇 滇 濋"},
	{"34186", "瀆 濆 潢 灒"},
	{"34189", "洃"},
	{"34190", "沐 淋"},
	{"34191", "渿 澿"},
	{"34193", "溹"},
	{"34194", "渫 濝"},
	{"34196", "潦"},
	{"34198", "淶"},
	{"34200", "祔"},
	{"34210", "社"},
	{"34211", "襓"},
	{"34212", "祂 衪 衴"},
	{"34216", "裺"},
	{"34227", "褲 衲 袎 襺"},
	{"34231", "祛 袪 襼"},
	{"34236", "襫"},
	{"34238", "裌"},
	{"34241", "禱"},
	{"34247", "被 衼 袸 裬"},
	{"34252", "襻"},
	{"34253", "襪"},
	{"34256", "禕"},
	{"34260", "祐 祜"},
	{"34261", "褡 祰 袺"},
	{"34264", "褚"},
	{"34265", "禧"},
	{"34281", "祺 禛"},
	{"34286", "襩 禶"},
	{"34291", "襟"},
	{"34294", "禖 褋"},
	{"34301", "迆 逵 遳 遶"},
	{"34302", "邁 迶 遰"},
	{"34303", "遠"},
	{"34304", "達 違"},
	{"34306", "造 迼 逽"},
	{"34307", "迣"},
	{"34309", "遼"},
	{"34330", "懟"},
	{"34332", "懣 懘"},
	{"34404", "婆"},
	{"34547", "皸"},
	{"34601", "碆"},
	{"34904", "染 柒"},
	{"35100", "汫"},
	{"35104", "堻"},
	{"35106", "沖 洩 浺"},
	{"35107", "津"},
	{"35110", "泩"},
	{"35116", "澅"},
	{"35117", "汍 沌 濜"},
	{"35118", "澧 灃"},
	{"35127", "沛 沸 清 泲 凊 涄 潚 瀳"},
	{"35130", "決 泱 漣 泆 泍 漶"},
	{"35132", "濃 洟 溙"},
	{"35133", "潓"},
	{"35134", "湊"},
	{"35136", "瀜"},
	{"35138", "瀢"},
	{"35143", "漙"},
	{"35144", "淒 凄 湕 漊"},
	{"35147", "溝"},
	{"35160", "油 浀"},
	{"35161", "潛 湱"},
	{"35163", "湷"},
	{"35166", "漕"},
	{"35181", "淟"},
	{"35186", "漬 潰 濻"},
	{"35190", "沫 沬 洙"},
	{"35194", "溱 滐"},
	{"35196", "凍 涑 涷 湅"},
	{"35200", "祌"},
	{"35206", "神 衶"},
	{"35218", "禮"},
	{"35230", "祑 衭 袟 褳"},
	{"35232", "襛"},
	{"35237", "袂"},
	{"35244", "褸"},
	{"35256", "褘"},
	{"35257", "袡"},
	{"35260", "袖"},
	{"35290", "祩 袾"},
	{"35292", "襋"},
	{"35300", "連"},
	{"35301", "迍"},
	{"35303", "迭 逮"},
	{"35305", "遘"},
	{"35306", "迪 遭"},
	{"35307", "遣"},
	{"35308", "遺"},
	{"35309", "速"},
	{"35332", "裱"},
	{"36010", "覕"},
	{"36100", "汨 泗 泅 泊 洎 洎 涸 湘 汩 沺 泇 洳 洄 洇 凅 涃 溷 漍 潿"},
	{"36103", "璗"},
	{"36104", "塣"},
	{"36107", "盪"},
	{"36110", "況 涀 瀙"},
	{"36111", "混 滉"},
	{"36112", "泹"},
	{"36113", "溾"},
	{"36114", "浬 涅 湟 浧 湦 灈 灅"},
	{"36116", "覜"},
	{"36117", "浥 溫"},
	{"36121", "淠 瀱"},
	{"36127", "涓 渭 湯 渴 濁 湡 濎"},
	{"36131", "潶"},
	{"36132", "澴 瀑 渨"},
	{"36133", "濕"},
	{"36134", "溴 洖 淏 湨"},
	{"36141", "澤 淂 湒"},
	{"36143", "滜"},
	{"36144", "瀴"},
	{"36146", "潬 濞"},
	{"36147", "漫"},
	{"36154", "滭"},
	{"36160", "淐 潪"},
	{"36180", "浿"},
	{"36181", "浞 湜 潩"},
	{"36182", "潀"},
	{"36186", "溳 灦"},
	{"36193", "漯"},
	{"36194", "澡 淉"},
	{"36196", "澋"},
	{"36200", "衵 裀 袽 裍"},
	{"36202", "袙"},
	{"36210", "祝 袒 視 襯"},
	{"36211", "襬"},
	{"36214", "裡 裎"},
	{"36217", "褞"},
	{"36227", "褐 裐 禓 裼 禢 禤 褟 襡"},
	{"36230", "昶 禗"},
	{"36232", "襮"},
	{"36236", "襁"},
	{"36240", "裨"},
	{"36241", "襗"},
	{"36246", "襣"},
	{"36256", "禪 襌"},
	{"36260", "裮"},
	{"36281", "禔 褆"},
	{"36294", "裸 褓 祼 襙"},
	{"36300", "迦 迫 迴"},
	{"36301", "逞 遑 暹 邈 邏"},
	{"36302", "遇 遏 遢 邊 逿"},
	{"36303", "還"},
	{"36304", "遻"},
	{"36809", "燙"},
	{"37027", "邲"},
	{"37104", "塱"},
	{"37107", "盜"},
	{"37109", "鑿"},
	{"37110", "汛 汎 沉 沮 洫 洬 渢"},
	{"37111", "泥 澀 瀣"},
	{"37112", "氾 泡 洈"},
	{"37113", "瀺"},
	{"37114", "渥 濯 浘"},
	{"37116", "浼 灚"},
	{"37117", "澠 汜 淝 淣 瀊"},
	{"37122", "漻"},
	{"37127", "涌 湧 渦 溺 滑 漏 潟 鴻 湑 漷 滫 潏 灟 鸂"},
	{"37132", "浪 涊 淥 淴 潒 濄"},
	{"37134", "渙 澳"},
	{"37136", "漁 溞"},
	{"37140", "淑 汊 洀"},
	{"37146", "潯"},
	{"37147", "沒 汲 泯 浸 潺 澱 溲 濲 瀔 瀫"},
	{"37148", "濢"},
	{"37152", "澥"},
	{"37154", "洚"},
	{"37156", "渾"},
	{"37157", "洢"},
	{"3716", "潞"},
	{"37161", "澹 滘"},
	{"37162", "沼 溜 洺"},
	{"37164", "洛 湣 涺 潳 潞"},
	{"37167", "湄 涒"},
	{"37172", "淈"},
	{"37177", "淈 淊"},
	{"37180", "溟"},
	{"37181", "潠 凝 瀷"},
	{"37182", "次 漱"},
	{"37186", "澬 灨"},
	{"37191", "漈"},
	{"37193", "潔"},
	{"37194", "深 澯"},
	{"37210", "祖 袓"},
	{"37212", "袍 祪"},
	{"37214", "冠"},
	{"37217", "冗 祀"},
	{"37220", "初 祠 裯 礿 袀 祤 袧 禂 襉 襴"},
	{"37227", "祁 禍 冪 礽 扃 祹 鵷 鶣 鸋"},
	{"37232", "冢 祿 裉 禒 褖 襐"},
	{"37233", "褪"},
	{"37234", "襖 禊 褉"},
	{"37240", "衩"},
	{"37246", "襑"},
	{"37247", "祋 衱 祲 裰"},
	{"37250", "禈"},
	{"37254", "袶"},
	{"37256", "褌"},
	{"37261", "襜"},
	{"37262", "褶 祒 袑"},
	{"37264", "袼 裾"},
	{"37267", "裙"},
	{"37294", "褬"},
	{"37300", "迉"},
	{"37301", "迅 逸 邈 迡 邆"},
	{"37302", "迎 迥 通 週 過 迵 迿 迻 遹"},
	{"37303", "退 遝 逯"},
	{"37304", "逢 運 遐 遲 邂"},
	{"37305", "逄"},
	{"37306", "迢 遛"},
	{"37307", "追 遙"},
	{"37308", "選"},
	{"37327", "鶐"},
	{"37331", "凞"},
	{"37338", "恣"},
	{"37401", "罕"},
	{"37404", "姿"},
	{"37413", "冤"},
	{"37427", "鴳 鶟"},
	{"37506", "軍"},
	{"37527", "鶤"},
	{"37608", "咨"},
	{"37627", "鶷"},
	{"37717", "瓷"},
	{"37720", "朗"},
	{"37727", "郎"},
	{"37732", "餈"},
	{"37782", "欴"},
	{"37800", "冥"},
	{"37806", "資"},
	{"37827", "鴥"},
	{"37904", "栥 秶 粢 楶"},
	{"37927", "鄴 鷍"},
	{"38100", "汃"},
	{"38104", "塗"},
	{"38112", "湤 溠"},
	{"38116", "涗 灠"},
	{"38117", "汽 溢 濫 汔 湴 湓 滊 漧"},
	{"38118", "澨"},
	{"38119", "淦 凎 滏"},
	{"38121", "湔 渝"},
	{"38122", "沴"},
	{"38127", "冷 汾 涕 淪 瀚 滃 溣 潃 漡 潝 瀄 瀹"},
	{"38131", "溔 潕"},
	{"38132", "淞 滋 漾 淰 瀁"},
	{"38133", "淤 濨 襚"},
	{"38134", "浂"},
	{"38135", "渼"},
	{"38137", "泠 溓"},
	{"38140", "澈 激 瀲 汻 浟 溦 滸 潎 漵 滶 澉 澂 潡 濣"},
	{"38141", "洴 澣"},
	{"38146", "渰"},
	{"38147", "游 澓"},
	{"38151", "洋"},
	{"38157", "海 潷"},
	{"38160", "沿"},
	{"38161", "洽 冾 湁 潽"},
	{"38164", "涻"},
	{"38166", "潧 澮"},
	{"38167", "滄 凔"},
	{"38168", "浴"},
	{"38181", "漩 漎"},
	{"38186", "澰"},
	{"38193", "瀿"},
	{"38194", "滌 涂 滁"},
	{"38211", "祚"},
	{"38212", "袘"},
	{"38216", "裞"},
	{"38217", "襤"},
	{"38221", "褕"},
	{"38222", "袗"},
	{"38227", "衿 衯 黺 禴"},
	{"38231", "禚"},
	{"38232", "祣"},
	{"38233", "禭"},
	{"38247", "複"},
	{"38251", "祥"},
	{"38261", "祫 袷"},
	{"38266", "禬 襘"},
	{"38268", "裕"},
	{"38286", "襝"},
	{"38290", "裰"},
	{"38301", "迄 迤 迮 遾"},
	{"38302", "逾"},
	{"38303", "送 遂"},
	{"38304", "逆 遊 遨 遵 邀 迕 遫"},
	{"38305", "迸"},
	{"38306", "道 遒"},
	{"38309", "途"},
	{"38320", "祄"},
	{"38340", "襒"},
	{"38343", "導"},
	{"38507", "肇"},
	{"38604", "啟"},
	{"38668", "豁"},
	{"38903", "綮"},
	{"39111", "洸"},
	{"39113", "瀅"},
	{"39114", "漟"},
	{"39120", "沙 渺"},
	{"39127", "消 淌 澇 潲"},
	{"39132", "濴"},
	{"39150", "泮 溿"},
	{"39151", "潾"},
	{"39162", "渻"},
	{"39166", "澢 瀯"},
	{"39180", "湫"},
	{"39181", "瀵"},
	{"39189", "淡"},
	{"39193", "潫 瀠"},
	{"39212", "裷 裷"},
	{"39250", "袢"},
	{"39266", "襠"},
	{"39289", "裧"},
	{"39302", "逍 逤"},
	{"39305", "遴"},
	{"39308", "逖"},
	{"39309", "迷"},
	{"39336", "鯊"},
	{"39404", "娑"},
	{"39502", "挲"},
	{"39601", "硰"},
	{"39732", "裟"},
	{"40000", "十 乂"},
	{"40010", "尢"},
	{"40011", "左"},
	{"40014", "雄 隿"},
	{"40016", "訄"},
	{"40017", "九"},
	{"40027", "力"},
	{"40030", "大 太"},
	{"40034", "爽"},
	{"40036", "奭"},
	{"40038", "夾"},
	{"40047", "友"},
	{"40100", "土 士"},
	{"40104", "圭 奎 臺 坴 桽"},
	{"40107", "查 盍 盔 壺 壼"},
	{"40108", "壹 壴"},
	{"40111", "塶"},
	{"40114", "堆 垚 墥"},
	{"40116", "境 壇"},
	{"40117", "坑"},
	{"40118", "垃"},
	{"40123", "奫"},
	{"40127", "坊 塝 塙 墉 墑"},
	{"40132", "壕 壤"},
	{"40136", "蠹 蟗"},
	{"40141", "垶"},
	{"40146", "墇"},
	{"40147", "垿 埻 鼖"},
	{"40148", "埣"},
	{"40161", "培 堷"},
	{"40167", "塘"},
	{"40182", "垓"},
	{"40186", "壙"},
	{"40194", "壈"},
	{"40200", "才"},
	{"40207", "夸 麥 奓"},
	{"40211", "堯"},
	{"40212", "冘"},
	{"40214", "在 帷 幢 獞"},
	{"40216", "克 獍"},
	{"40217", "犺"},
	{"40222", "夼"},
	{"40227", "巾 內 布 有 肉 希 肴 南 脅 冇 禸 鼒 臡"},
	{"40232", "桼 獽"},
	{"40240", "幮"},
	{"40246", "幛 獐"},
	{"40247", "皮 存"},
	{"40248", "狡 猝"},
	{"40261", "狺"},
	{"40267", "赯"},
	{"40281", "獷"},
	{"40286", "幩"},
	{"40300", "寸"},
	{"40331", "志 赤 恚 戁"},
	{"40334", "燾"},
	{"40336", "熹 惷"},
	{"40339", "杰"},
	{"40341", "寺 奪"},
	{"40400", "女 爻"},
	{"40401", "幸 辜 辜 耷"},
	{"40403", "本"},
	{"40407", "支 孛 李 夌"},
	{"40414", "妵"},
	{"40416", "嬗"},
	{"40421", "婷"},
	{"40427", "妨 姊 嫡 夯 夯 嫞 麶"},
	{"40431", "嫶"},
	{"40432", "嬤 孃 妶 娹 嫝"},
	{"40434", "嫉"},
	{"40437", "嫬 嬚"},
	{"40440", "卉"},
	{"40441", "妏"},
	{"40444", "奔 姦"},
	{"40446", "嫜"},
	{"40447", "孇"},
	{"40448", "姣"},
	{"40461", "嘉 娮 婄"},
	{"40496", "婛"},
	{"40501", "羍"},
	{"40503", "舝"},
	{"40506", "韋"},
	{"40514", "難"},
	{"40518", "鞡"},
	{"40547", "韕"},
	{"40557", "毐"},
	{"40600", "古 右"},
	{"40601", "吉 喜 嗇 奮"},
	{"40604", "奢"},
	{"40609", "杏 杳"},
	{"40621", "奇"},
	{"40641", "壽"},
	{"40710", "七 匕"},
	{"40716", "奄 直 奩 矗"},
	{"40717", "鼁 鼀"},
	{"40727", "奅"},
	{"40731", "去 套"},
	{"40732", "袁 喪"},
	{"40801", "走 真 疐 趡"},
	{"40803", "趭"},
	{"40806", "賁 賣 賚"},
	{"40814", "黈"},
	{"40900", "木"},
	{"40901", "奈 柰"},
	{"40903", "索"},
	{"40904", "橐"},
	{"40908", "來"},
	{"40913", "梳"},
	{"40914", "柱 椎 橦"},
	{"40916", "檀 樈"},
	{"40917", "杭"},
	{"40918", "柆"},
	{"40921", "楟"},
	{"40922", "楌"},
	{"40923", "櫅"},
	{"40927", "枋 榜 槁 楴 樀 槦 檇"},
	{"40931", "樵"},
	{"40932", "榱 橠 檺 櫰 欀"},
	{"40934", "槉"},
	{"40936", "檍"},
	{"40940", "櫥"},
	{"40941", "梓"},
	{"40944", "椄"},
	{"40946", "樟"},
	{"40947", "櫠"},
	{"40948", "校 椊"},
	{"40961", "棓"},
	{"40967", "榶"},
	{"40982", "核"},
	{"40991", "檁"},
	{"40994", "森"},
	{"40996", "椋"},
	{"41011", "尪"},
	{"41017", "虓"},
	{"41027", "獳"},
	{"41086", "頰 頄 幊"},
	{"41110", "址"},
	{"41111", "壢"},
	{"41112", "埡 堩"},
	{"41114", "堰 垤 堐 堙"},
	{"41116", "垣"},
	{"41117", "墟 壾 壚"},
	{"41119", "坯"},
	{"41120", "坷 圢"},
	{"41127", "圬 壩 塥 壖"},
	{"41132", "壉"},
	{"41134", "堧"},
	{"41140", "圩"},
	{"41146", "埂"},
	{"41147", "圾"},
	{"41149", "坪"},
	{"41160", "坫"},
	{"41166", "堛"},
	{"41181", "填"},
	{"41190", "坏"},
	{"41191", "墂"},
	{"41194", "塛"},
	{"41214", "狂 狴"},
	{"41216", "狟"},
	{"41217", "猇 瓻"},
	{"41219", "狉"},
	{"41220", "帄"},
	{"41227", "獅 麵 獮 獼 獼"},
	{"41232", "帳"},
	{"41240", "犽 皯"},
	{"41246", "麵"},
	{"41247", "獶 獿"},
	{"41253", "獩"},
	{"41260", "帖"},
	{"41266", "幅"},
	{"41286", "幀 頗 幁 赬 顢 顢 顤 顴"},
	{"41291", "狋"},
	{"41296", "獂"},
	{"41327", "鵟"},
	{"41410", "妣 妅"},
	{"41411", "妧 姃 娙 孋"},
	{"41414", "姪 娾"},
	{"41416", "嫗 姮 嫟"},
	{"41417", "姬 姖 婭"},
	{"41420", "婀 靪"},
	{"41427", "媽 嫣 嫮 嬭 嬭 嬬"},
	{"41431", "妘 嫕"},
	{"41432", "娠"},
	{"41440", "奸 妍 犴"},
	{"41443", "媷"},
	{"41446", "婥"},
	{"41447", "娵"},
	{"41449", "嫭"},
	{"41460", "妒 媔"},
	{"41463", "孀"},
	{"41486", "頍"},
	{"41491", "嫖"},
	{"41496", "嫄"},
	{"41512", "靰"},
	{"41516", "韁"},
	{"41531", "韆"},
	{"41532", "韔"},
	{"41540", "靬"},
	{"41546", "鞭"},
	{"41647", "敧 敼"},
	{"41669", "嚭"},
	{"41686", "頡"},
	{"41804", "趣 趠"},
	{"41910", "杠 枇 杌 杹"},
	{"41911", "框 欐 杬 桱 棑 榧 櫳 櫳 櫪"},
	{"41912", "枙"},
	{"41914", "枉 極 概 桎 梐 椻 欞"},
	{"41916", "桓 樞 橿 櫮"},
	{"41917", "枑 柜 椏 樝 櫨"},
	{"41918", "柩 櫃 梪 欞"},
	{"41919", "柸"},
	{"41920", "柯 朾"},
	{"41921", "桁 椼"},
	{"41923", "椓"},
	{"41927", "朽 柄 杇 栭 榪 樗 檽 檷"},
	{"41931", "枟 櫏"},
	{"41932", "桭"},
	{"41940", "杆 杅 枅 枒 栮"},
	{"41941", "梇"},
	{"41946", "梗 棹 楩 橝"},
	{"41947", "板 榎 櫌"},
	{"41953", "檅"},
	{"41960", "柘 枮 栖"},
	{"41961", "梧 楷 栺 榗"},
	{"41962", "檑"},
	{"41963", "櫺"},
	{"41966", "楅"},
	{"41969", "桮"},
	{"41981", "楨"},
	{"41982", "橛 橛"},
	{"41986", "槓 檟 櫇"},
	{"41989", "槱"},
	{"41990", "杯"},
	{"41991", "標 檦"},
	{"41996", "榞"},
	{"42000", "刈"},
	{"42011", "尰"},
	{"42012", "尨"},
	{"42013", "沊"},
	{"42027", "撝"},
	{"42037", "抸"},
	{"42100", "圳 刲"},
	{"42110", "圠 亄"},
	{"42111", "坵 坵"},
	{"42113", "垗"},
	{"42114", "埵 堹 墔"},
	{"42118", "塏"},
	{"42121", "圻 斳"},
	{"42122", "彭"},
	{"42127", "埁 塴"},
	{"42131", "壎"},
	{"42135", "墣"},
	{"42136", "蚻 蜤 蟴"},
	{"42140", "坁 坻"},
	{"42141", "坼 埏"},
	{"42147", "垺"},
	{"42149", "垀 埒"},
	{"42157", "埩"},
	{"42161", "垢"},
	{"42169", "墦"},
	{"42172", "壣"},
	{"42194", "埰"},
	{"42200", "刳 猁 猘 蒯"},
	{"42210", "剋"},
	{"42213", "狣"},
	{"42214", "狅 毻 氋"},
	{"42216", "獵"},
	{"42217", "獵"},
	{"42221", "狾 獑 玂"},
	{"42227", "獢"},
	{"42230", "狐 瓠"},
	{"42231", "獯"},
	{"42234", "獛"},
	{"42241", "狿"},
	{"42247", "猣"},
	{"42257", "猙"},
	{"42269", "幡"},
	{"42277", "幍"},
	{"42293", "猻 猻 綔"},
	{"42300", "刌"},
	{"42332", "惁"},
	{"42400", "娳 嬼"},
	{"42411", "奼"},
	{"42413", "姚"},
	{"42414", "妊 婬 娷"},
	{"42421", "妡"},
	{"42427", "嬌 媯 媥 媏 孈"},
	{"42430", "瓡"},
	{"42433", "婖"},
	{"42434", "妖 嬽 轐"},
	{"42441", "娗"},
	{"42444", "娞 婑"},
	{"42447", "媛 嬡"},
	{"42461", "姤"},
	{"42464", "婚 姡"},
	{"42469", "嬏"},
	{"42470", "奾"},
	{"42477", "嫍"},
	{"42480", "奷"},
	{"42494", "姀 婇"},
	{"42500", "靷"},
	{"42508", "髼"},
	{"42521", "靳"},
	{"42530", "鞃"},
	{"42563", "鞜"},
	{"42577", "韜"},
	{"42594", "鞂"},
	{"42600", "剒 剞"},
	{"42602", "皙"},
	{"42621", "斮"},
	{"42717", "甏"},
	{"42800", "赳 趔"},
	{"42801", "趒 踅"},
	{"42802", "趫"},
	{"42804", "赶"},
	{"42806", "趏"},
	{"42807", "赸 趉"},
	{"42821", "斯"},
	{"42900", "剎 朻 栵 栦 棩"},
	{"42903", "紮"},
	{"42910", "札"},
	{"42913", "桃"},
	{"42914", "橇 枆 棰"},
	{"42917", "梔 榹 槴"},
	{"42918", "橙 榿"},
	{"42921", "析"},
	{"42922", "杉 彬"},
	{"42927", "橋 梣 梤 楀 椯 欈"},
	{"42930", "柧 槬"},
	{"42934", "樸 楑 榽"},
	{"42937", "柉"},
	{"42940", "柢"},
	{"42941", "柝 梃 梴"},
	{"42944", "桵"},
	{"42947", "桴 榩"},
	{"42950", "杽"},
	{"42953", "機"},
	{"42960", "椔"},
	{"42964", "栝 棔 楯"},
	{"42969", "橎"},
	{"42972", "柮"},
	{"42977", "槄"},
	{"42986", "櫍"},
	{"42993", "槂"},
	{"42994", "樔 櫟 櫯"},
	{"43000", "弋 扑"},
	{"43010", "尤"},
	{"43017", "攛"},
	{"43030", "犬"},
	{"43040", "犮"},
	{"43046", "博"},
	{"43100", "式 卦"},
	{"43107", "盚"},
	{"43111", "坨 垸"},
	{"43114", "垞"},
	{"43122", "墋"},
	{"43127", "埔"},
	{"43130", "垘"},
	{"43132", "求 埌"},
	{"43134", "埃"},
	{"43144", "垵"},
	{"43150", "城 域 堿 臷 蛓"},
	{"43168", "塎"},
	{"43210", "朮 狁"},
	{"43221", "獰"},
	{"43222", "幓"},
	{"43227", "猏 猵"},
	{"43232", "狼 幏"},
	{"43234", "獄"},
	{"43236", "幰"},
	{"43242", "狩"},
	{"43246", "猼"},
	{"43247", "帗 狻 狻"},
	{"43250", "截 幟 狘 狨 胾 戫"},
	{"43253", "帴"},
	{"43282", "狖"},
	{"43300", "忒 忒"},
	{"43327", "鳶 鸑"},
	{"43331", "怷"},
	{"43333", "憖"},
	{"43400", "妼"},
	{"43405", "麰"},
	{"43412", "婉 娏"},
	{"43416", "媗"},
	{"43421", "嬣"},
	{"43432", "娘 嫁"},
	{"43434", "娭 猋"},
	{"43442", "姲"},
	{"43450", "娥 戟 娀 嬂 孅"},
	{"43460", "始"},
	{"43468", "嫆"},
	{"43469", "嬸"},
	{"43477", "婠"},
	{"43481", "婝"},
	{"43486", "嬪"},
	{"43491", "婃"},
	{"43511", "鞚"},
	{"43544", "鞍"},
	{"43547", "韍"},
	{"43550", "載"},
	{"43650", "哉 酨"},
	{"43732", "裘"},
	{"43750", "裁 戡"},
	{"43800", "赴 貳"},
	{"43805", "越"},
	{"43806", "貣"},
	{"43850", "戴"},
	{"43900", "朴 杺 柲"},
	{"43911", "梡 榨 柁 椌"},
	{"43916", "楦"},
	{"43917", "榓"},
	{"43921", "檸"},
	{"43922", "槮"},
	{"43927", "楄"},
	{"43932", "梂 桹"},
	{"43933", "橪"},
	{"43934", "猌"},
	{"43940", "弒 杙 栻"},
	{"43941", "榳"},
	{"43942", "榑"},
	{"43944", "桉"},
	{"43947", "梭 柭 欉"},
	{"43950", "栽 械 槭 棫 椷 樴 橶"},
	{"43953", "棧"},
	{"43964", "楁"},
	{"43968", "榕"},
	{"43977", "棺"},
	{"43981", "椗"},
	{"43982", "柼"},
	{"43985", "樾"},
	{"43986", "檳"},
	{"43991", "棕"},
	{"43996", "橑"},
	{"44000", "廾 卅 卌"},
	{"44017", "芞"},
	{"44027", "協"},
	{"44043", "芅"},
	{"44100", "封 尌"},
	{"44101", "芷 莖 虀"},
	{"44104", "荃 基 耋 董 墓 薹 芏 茥 荎 埜 堇 莝 菫 菙 葟 蓳 蘲 鼞"},
	{"44106", "萱 薑 荁 蘁"},
	{"44107", "蓋 藍 苴 萓 葐 藎"},
	{"44108", "苙 荳 莁 蘴"},
	{"44109", "苤 菳"},
	{"44110", "茫"},
	{"44111", "堪 菲 茳 茈 墝"},
	{"44112", "地 范 莐 菢"},
	{"44113", "蔬 蓅 藱"},
	{"44114", "墐"},
	{"44116", "埴"},
	{"44117", "茿 菹 菃 蓺 壒 薀 薽"},
	{"44120", "菿 藰"},
	{"44121", "埼 菏 蕍"},
	{"44127", "芍 垮 堉 勤 蒲 蕩 坳 荂 荺 莇 堶 塉 葝 墆 墈 翥 蒟 薃 蘙 蘬"},
	{"44129", "莎"},
	{"44131", "蕓"},
	{"44132", "壞 蒎 蒗 藜 蘾"},
	{"44133", "塨"},
	{"44134", "塽 塻 蒺"},
	{"44136", "蟆 茧 蛬 蠆 鼜"},
	{"44140", "葑 薱"},
	{"44141", "塒 壔"},
	{"44146", "薄 藫"},
	{"44147", "坡 菠 鼓 蔆 蕞 堎 菆 薣"},
	{"44149", "萍"},
	{"44153", "蕺 蘵 虃"},
	{"44160", "堵"},
	{"44161", "塔"},
	{"44162", "菬"},
	{"44164", "落 萿 蕗"},
	{"44169", "藩"},
	{"44170", "坩"},
	{"44171", "蔧"},
	{"44180", "苡"},
	{"44182", "茨 莰"},
	{"44186", "墳"},
	{"44191", "蒤 薸"},
	{"44194", "藻 堞"},
	{"44201", "苧 艼 葶 薴"},
	{"44202", "蓼 蔘"},
	{"44207", "考 萼 夢 芩 茤 棽"},
	{"44210", "兙"},
	{"44211", "荒 莞 薨 麓 芫 芢 狫 苨 茪 莋 葄 獟 蔍 蕘 薧 薤 藣 蘢 藶 蘼"},
	{"44212", "苑 帎 菀 葹 葂 蓏 薍"},
	{"44213", "蒐 茺 萒"},
	{"44214", "花 荏 莊 薩 茌 茬 萑 雈 蒮 蔻 蕥 蕹 藋 薶 雚 藿 獾 虇"},
	{"44215", "莥"},
	{"44216", "莧 兢 藐 莌"},
	{"44217", "梵 蘆 犰 芃 苀 萉 蔖 蔰 檒"},
	{"44218", "蒞"},
	{"44220", "茢 萷"},
	{"44221", "芹 荷 荇 猗 葥 蘅 蘮"},
	{"44222", "茅"},
	{"44223", "薺"},
	{"44224", "蓩 鼘"},
	{"44228", "芥"},
	{"44230", "犿"},
	{"44231", "蔗 蔭 芐 蕤 藨"},
	{"44232", "猿 蒙 藤 苰 莍 菉 蕵 幪 薞"},
	{"44233", "菸"},
	{"44234", "苯 茯 菮 葔 幙 蔟 貘"},
	{"44236", "藘"},
	{"44237", "萸 蒹 薕 蘟"},
	{"44238", "狹"},
	{"44240", "蔚 苻 菧"},
	{"44241", "芽 葞 幬"},
	{"44242", "蔣 蘉"},
	{"44243", "葰 蓐"},
	{"44247", "荐 菔 葭 獲 帔 芨 葠 蒑 蕧 薆 藙"},
	{"44248", "蔽 薇 蔜 薂 藢"},
	{"44250", "荈 蕆"},
	{"44252", "蕣 薢 藦"},
	{"44253", "茂 蔑 藏 茷 荿 葴 葳 蒧 薉 薎 幭"},
	{"44256", "幃"},
	{"44257", "葎"},
	{"44260", "貓 狜 帾"},
	{"44261", "蓓 蓿 蘑 狤 茩 蕕 薝 蘠"},
	{"44264", "藸"},
	{"44267", "蓎"},
	{"44281", "蓗 蓰 蓯 蔙"},
	{"44282", "蕨 藃"},
	{"44286", "蘋 獚 蕦 蕷 藬"},
	{"44289", "荻"},
	{"44294", "葆 茠 蒢 蓧"},
	{"44296", "蒝 獠 蔯"},
	{"44301", "蓔"},
	{"44302", "蓪 薖 藡"},
	{"44303", "鼕 苳 蓫 薳 蘧"},
	{"44304", "蓮 蓬 蕸 薘"},
	{"44307", "芝 苓 蕶"},
	{"44308", "藗"},
	{"44320", "薊"},
	{"44327", "驀 蒍 蔫 蔦 蕮 鶿 鷰"},
	{"44330", "芯 苾"},
	{"44331", "蒸 赫 燕 蕉 蕪 薰 蘸 莣 葾 爇"},
	{"44332", "蔥 荵 懃"},
	{"44333", "慕 蕊 蕙 菾"},
	{"44334", "藂 藯"},
	{"44336", "煮 惹 葸 蒠 蔒 薏"},
	{"44338", "恭 惎"},
	{"44339", "懋"},
	{"44341", "蓱"},
	{"44343", "蓴"},
	{"44346", "蒪 蕁"},
	{"44347", "莈 蔋"},
	{"44351", "蘚"},
	{"44360", "赭"},
	{"44394", "蘇 莯"},
	{"44400", "艾 荊"},
	{"44401", "芋 茸 莘 芠 莛 莚 葺"},
	{"44402", "芊 僰"},
	{"44403", "麮"},
	{"44404", "婪 萋 萎 荌 荽 菨 蒆 葽 蔞 蘡"},
	{"44406", "草 蕈 鼙 萆 蕇"},
	{"44407", "孝 芟 芰 荸 孳 菱 蔓 孽 夔 芓 芧 莩 荾 蓌 藑"},
	{"44408", "萃 茭"},
	{"44409", "苹"},
	{"44410", "芤 蓻 蘺"},
	{"44411", "姥 姺 荖"},
	{"44412", "她 嬈"},
	{"44413", "菟 蒬 蘶"},
	{"44414", "娃 嬞 嬯 薙"},
	{"44417", "艽"},
	{"44421", "婍"},
	{"44427", "勃 募 萬 妠 姱 姷 莮 婻 葧 蒴 勱 嫷 藭 轕"},
	{"44430", "莫 葵 樊 芺 薁"},
	{"44431", "嬿"},
	{"44432", "菰 媴"},
	{"44433", "葖 嬨"},
	{"44434", "嫫 嫨"},
	{"44441", "葬 荓 婞 媶 嫴 嬦"},
	{"44443", "莽 薅"},
	{"44444", "奻 葌"},
	{"44446", "萛"},
	{"44447", "妓 苃 茇 婈 萲 葮 蒰 蕔"},
	{"44448", "藪"},
	{"44453", "茙"},
	{"44454", "嬅"},
	{"44456", "韓"},
	{"44460", "姑 茄 茹 媎 媌"},
	{"44461", "姞 嬙"},
	{"44464", "婼 菇"},
	{"44465", "嬉"},
	{"44470", "姏"},
	{"44481", "娸 薿"},
	{"44486", "嫹 蘱"},
	{"44491", "媟"},
	{"44493", "蓀"},
	{"44494", "媒"},
	{"44496", "嫽"},
	{"44500", "莗 犎"},
	{"44502", "摯 摹 攀 蒘 藆"},
	{"44503", "拲 菶 輂"},
	{"44504", "華 蓽"},
	{"44506", "革 葷 葦 鞤"},
	{"44507", "莓 芛 苺"},
	{"44510", "靴 蒫"},
	{"44514", "鞋 蓷"},
	{"44517", "芄 靾"},
	{"44518", "菈"},
	{"44521", "蔪 蘄"},
	{"44527", "勒 韉 茀 蒱 靿 蘜"},
	{"44529", "莏"},
	{"44530", "芙 英 芵 苵"},
	{"44532", "荑"},
	{"44534", "韃"},
	{"44535", "荴"},
	{"44541", "蓒 蘀"},
	{"44547", "菝 鞁 韄"},
	{"44553", "莪 鞿"},
	{"44554", "韡"},
	{"44557", "苒"},
	{"44560", "菗"},
	{"44561", "鞊 鞳"},
	{"44564", "葀"},
	{"44586", "韇 韥"},
	{"44594", "鞢 韘"},
	{"44600", "者 苗 苜 茵 茴 菌 苖 苬 莔 蔨 蔮"},
	{"44601", "昔 耆 菩 薔 礬 苫 茜 荅 莤 菪 萻 蓍 蓾 諅 鼛"},
	{"44602", "苕 菑 瞢"},
	{"44603", "苔 蓄 暮 蕾"},
	{"44604", "苦 若 著 薯 瞽 茖 蒏"},
	{"44606", "莒 菖 葍 萺 薈"},
	{"44607", "茗 蒼 莙"},
	{"44608", "蓉 萶"},
	{"44609", "蕃 莕 榃 萫"},
	{"44611", "葃"},
	{"44614", "蓶"},
	{"44617", "葩"},
	{"44621", "苛"},
	{"44626", "藅"},
	{"44627", "苟 荀 萌 葫 蔔 藹 劼 茍 耇 荶 菂 蔀 蘤"},
	{"44631", "蘸"},
	{"44634", "藈"},
	{"44641", "薜 蒔 薵"},
	{"44647", "攲 皵 蔎"},
	{"44661", "藞 囍"},
	{"44662", "蘦"},
	{"44664", "藷"},
	{"44666", "藟 虈"},
	{"44694", "蔝"},
	{"44695", "菋"},
	{"44700", "斟"},
	{"44710", "芒"},
	{"44711", "老 甚 芘 菎 葚 蓖 虌"},
	{"44712", "也 苞 茞 菤"},
	{"44714", "耄 芚 芼 蔇"},
	{"44716", "菴 蓲"},
	{"44717", "世 芭 巷 苣 甍 芑"},
	{"44722", "鬱"},
	{"44727", "茆 勘 萄 葛 芎 芶 苭 蘛"},
	{"44731", "芸 藝"},
	{"44732", "茲 萇 蓑 茛 莨 葨 蔉 蘘 鼚"},
	{"44735", "蒛"},
	{"44741", "薛"},
	{"44747", "苠 菣"},
	{"44748", "荍"},
	{"44757", "蕼"},
	{"44770", "廿 甘"},
	{"44772", "菡"},
	{"44773", "蔤"},
	{"44777", "茁 菅 舊 萏"},
	{"44781", "蕻"},
	{"44800", "蓂 斢"},
	{"44801", "共 其 楚 躉 萣 萐 萁 藇 趬 躠"},
	{"44802", "芡 赲 荄"},
	{"44806", "黃 貰 萯 趌 蔩 蕡 蕢 薋 藚"},
	{"44808", "趪 趲"},
	{"44809", "焚 苂 菼 藀"},
	{"44811", "苲"},
	{"44814", "蘣 蘳"},
	{"44817", "葅"},
	{"44820", "萴"},
	{"44827", "勩"},
	{"44847", "皾"},
	{"44848", "蘞"},
	{"44886", "薠 薟"},
	{"44900", "材 村 枓 榭 樹 柎 綦 槲 藄 蘻"},
	{"44901", "芣 禁 蔡 蔈 蘌"},
	{"44902", "茦"},
	{"44903", "蔂 蕠 蘩 虆"},
	{"44904", "某 茉 茶 茱 荼 棻 菜 葉 藥 蘗 葇 蓁 蕖 蔾 櫱 蘪"},
	{"44906", "菄 萰"},
	{"44908", "莢 萊 苶"},
	{"44910", "杜 梉 櫆"},
	{"44911", "橈 栳 椹 葒"},
	{"44912", "枕 杝"},
	{"44914", "桂 榷 檯 權 蘿 楏 槿"},
	{"44916", "植 楂 檶 櫙 藲 藽"},
	{"44917", "蘊 朹 枻 榼 蒩 蕝"},
	{"44920", "莉 莿"},
	{"44921", "椅 薪 菥"},
	{"44927", "菊 楠 橢 藕 朸 枘 柪 栲 栯 桍 桸 菞 葯 槆 蒶 蕛 藒 櫹 欗"},
	{"44930", "杕"},
	{"44932", "檬 菘 榬 蘹"},
	{"44933", "蔠"},
	{"44934", "模 樉"},
	{"44941", "檮 榯 榵 蔊 橭"},
	{"44942", "欂"},
	{"44947", "枝 菽 柀 栫 桲 蔱 薐 檴"},
	{"44948", "蓛"},
	{"44954", "樺"},
	{"44958", "樥"},
	{"44960", "枯 楮 葙 櫧"},
	{"44961", "桔 檣 藉 梏 棤 榰 榙"},
	{"44964", "楛 楉"},
	{"44970", "柑"},
	{"44981", "棋 栱 槙 槙 檚"},
	{"44982", "蔌"},
	{"44986", "橫 櫝 橨 藾 欑"},
	{"44989", "萩"},
	{"44990", "林 椕 楙"},
	{"44991", "蒜"},
	{"44992", "蕀"},
	{"44993", "蕬"},
	{"44994", "菻 楪"},
	{"44998", "棶"},
	{"45044", "鞬"},
	{"45104", "墊"},
	{"45106", "坤"},
	{"45107", "垏"},
	{"45117", "坉 埶"},
	{"45127", "坲 埥"},
	{"45130", "坱"},
	{"45132", "埭"},
	{"45136", "蟄"},
	{"45138", "壝"},
	{"45143", "塼 塼"},
	{"45144", "塿"},
	{"45153", "埲"},
	{"45196", "埬 堜"},
	{"45206", "狆"},
	{"45210", "狌"},
	{"45218", "麷"},
	{"45227", "猜 狒"},
	{"45230", "帙"},
	{"45236", "赨"},
	{"45243", "麩"},
	{"45286", "幘"},
	{"45294", "獉"},
	{"45327", "鷙"},
	{"45331", "熱 慹"},
	{"45400", "妦"},
	{"45406", "妽"},
	{"45410", "姓"},
	{"45413", "嬔"},
	{"45416", "嫿"},
	{"45417", "執 嬧"},
	{"45427", "娉 勢 婧"},
	{"45430", "姎"},
	{"45432", "姨 婊"},
	{"45443", "嫥"},
	{"45447", "姌"},
	{"45457", "媾"},
	{"45460", "妯"},
	{"45463", "媋"},
	{"45481", "婕 婰"},
	{"45486", "嬇"},
	{"45490", "妹 妺 姝"},
	{"45493", "嫊"},
	{"45494", "嫀"},
	{"45496", "娕"},
	{"45502", "摰"},
	{"45530", "鞅"},
	{"45544", "鞻"},
	{"45557", "韝"},
	{"45590", "靺 韎"},
	{"45601", "謺"},
	{"45802", "趀"},
	{"45803", "赽"},
	{"45806", "贄"},
	{"45809", "趎"},
	{"45900", "杖"},
	{"45903", "縶"},
	{"45906", "柛"},
	{"45917", "杶 槸"},
	{"45927", "柿 柫 梬 棈 橚"},
	{"45930", "枎 柍 柣 槤"},
	{"45932", "棣 隸 桋"},
	{"45933", "橞"},
	{"45934", "楱"},
	{"45943", "槫"},
	{"45944", "棲 樓 楗"},
	{"45947", "構"},
	{"45953", "棒"},
	{"45956", "椲"},
	{"45957", "柟"},
	{"45960", "柚"},
	{"45963", "椿"},
	{"45966", "槽"},
	{"45971", "槥"},
	{"45977", "樁"},
	{"45986", "樍"},
	{"45990", "株 枺"},
	{"45992", "栜"},
	{"45993", "榡"},
	{"45994", "榛 榤"},
	{"45996", "棟 楝 梀 樄"},
	{"46000", "加"},
	{"46010", "旭"},
	{"46100", "堌"},
	{"46110", "坦 覲"},
	{"46111", "堽"},
	{"46113", "塊"},
	{"46114", "埋 埕 堭"},
	{"46117", "塭"},
	{"46127", "場 塌 塌 埸 堣 堨 堮"},
	{"46128", "界"},
	{"46140", "埤"},
	{"46141", "墿"},
	{"46147", "墁"},
	{"46148", "壧"},
	{"46156", "墠"},
	{"46181", "堤"},
	{"46186", "塤"},
	{"46194", "堁"},
	{"46200", "帕 幗"},
	{"46210", "觀 狚 狚"},
	{"46211", "幌 猑"},
	{"46214", "狸 猩 玀"},
	{"46227", "狷 獨 帤 猲"},
	{"46232", "猥 獧"},
	{"46240", "猈"},
	{"46247", "幔 獌 玃"},
	{"46248", "玁"},
	{"46250", "狎"},
	{"46256", "幝"},
	{"46260", "猖 帽"},
	{"46280", "狽"},
	{"46294", "猓 幧"},
	{"46296", "幜"},
	{"46310", "覟"},
	{"46327", "駕 鴐 鴽 鸉"},
	{"46330", "恕 想"},
	{"46400", "如 姻 婟"},
	{"46410", "妲 娊"},
	{"46411", "媲"},
	{"46413", "媿"},
	{"46414", "娌 媓"},
	{"46417", "媼"},
	{"46427", "娟 婸 媦 齃"},
	{"46430", "媳 勰"},
	{"46432", "嬛"},
	{"46440", "婢"},
	{"46447", "嫚"},
	{"46448", "孍"},
	{"46456", "嬋"},
	{"46460", "娼 媢"},
	{"46481", "娛 娖 媞 鞮"},
	{"46493", "嫘"},
	{"46494", "婐 媬 嬠"},
	{"46502", "挐"},
	{"46510", "靼"},
	{"46517", "韞"},
	{"46527", "鞙 鞨 韣"},
	{"46533", "韅"},
	{"46540", "鞞"},
	{"46543", "韟"},
	{"46621", "哿"},
	{"46656", "奲"},
	{"46714", "毠"},
	{"46727", "朅"},
	{"46732", "袈"},
	{"46801", "趧"},
	{"46804", "趕 趕"},
	{"46806", "賀"},
	{"46809", "趮"},
	{"46810", "覿"},
	{"46900", "柏 相 梱 枷 棝 棞 椥 槶"},
	{"46903", "絮"},
	{"46904", "架"},
	{"46910", "櫬 柷 柦 槻"},
	{"46911", "棍 榥 檌"},
	{"46913", "槐"},
	{"46914", "桯 梩 檉 欋 欏"},
	{"46927", "枴 棉 楊 楞 榻 枵 柺 梋 楬 櫋"},
	{"46930", "楒"},
	{"46932", "椳"},
	{"46940", "椑"},
	{"46941", "桿 楫 檡"},
	{"46943", "槔"},
	{"46944", "櫻"},
	{"46947", "槾"},
	{"46950", "柙"},
	{"46956", "樿"},
	{"46960", "梠 櫑"},
	{"46980", "枳 梖"},
	{"46981", "椇"},
	{"46993", "樏 欙"},
	{"46994", "棵 橾"},
	{"47012", "尥 尳"},
	{"47027", "鳩 鴆 邥 郟 鵊 鷞"},
	{"47109", "鋆 鏧"},
	{"47110", "堸"},
	{"47111", "坭"},
	{"47112", "垝"},
	{"47113", "堍"},
	{"47117", "圯 圮 堄"},
	{"47118", "墱"},
	{"47120", "均 圴 坰 垌 堈 堋 壛"},
	{"47127", "堝 塢 鄞 邽 埆 埇 垹 埽 墎 鵱"},
	{"47132", "垠 塚"},
	{"47134", "堠 墺"},
	{"47136", "螜 蟿"},
	{"47138", "懿"},
	{"47140", "坍 埱"},
	{"47147", "圾 埠 埐"},
	{"47150", "坶"},
	{"47153", "墀"},
	{"47160", "塯"},
	{"47167", "堳"},
	{"47172", "堀"},
	{"47177", "埳"},
	{"47180", "塓"},
	{"47181", "埧"},
	{"47182", "坎"},
	{"47191", "堔"},
	{"47194", "垛"},
	{"47207", "弩"},
	{"47210", "帆 狙 猦 飌"},
	{"47211", "狔"},
	{"47212", "犯 皰 匏 翹"},
	{"47214", "幄"},
	{"47215", "狃"},
	{"47217", "猛 帊 猊"},
	{"47220", "狗 狪 猢 猢"},
	{"47227", "帑 郁 猾 鶴 鸛 郗 猧 獝 獡 鄸 鴮 鶜 酄 毊 鸏"},
	{"47232", "狠 猭 漀"},
	{"47234", "猴 猰"},
	{"47241", "麭"},
	{"47242", "麴"},
	{"47247", "殼 殽 猳 彀 獀 觳 豰"},
	{"47250", "狦"},
	{"47252", "獬"},
	{"47261", "幨"},
	{"47271", "峱"},
	{"47272", "猺"},
	{"47280", "幎"},
	{"47282", "歡 欷"},
	{"47286", "獺"},
	{"47294", "猱 猱"},
	{"47298", "斄"},
	{"47317", "赩"},
	{"47327", "郝 駑 邿 酀 鶦"},
	{"47334", "怒 愨"},
	{"47347", "赧 赮"},
	{"47401", "聲"},
	{"47402", "翅"},
	{"47404", "姭 攳"},
	{"47407", "孥"},
	{"47410", "姐 姵 飆"},
	{"47411", "妮"},
	{"47412", "姽"},
	{"47414", "娓 嬥"},
	{"47415", "妞"},
	{"47416", "娩"},
	{"47417", "妃 婗"},
	{"47418", "嬁"},
	{"47420", "妁 朝 嫻 姁 姛 姠 婤 媩 靮"},
	{"47422", "妤 嫪"},
	{"47427", "奶 努 娜 婦 婿 媧 嬝 劦 姼 郣 婂 郩 嫋 媰 鄚 鳷 鴇 鴱 鵓 鵓 鵗 孎"},
	{"47436", "媸"},
	{"47440", "奴 姍 婌"},
	{"47447", "好 報 嫂 婽"},
	{"47450", "姆"},
	{"47462", "妱 姳 媹"},
	{"47467", "媚"},
	{"47472", "媱"},
	{"47480", "嫇"},
	{"47486", "嬾"},
	{"47492", "妳"},
	{"47494", "媃"},
	{"47502", "拏"},
	{"47510", "靻"},
	{"47512", "鞄"},
	{"47516", "鞔"},
	{"47517", "靶"},
	{"47520", "鞠 鞫"},
	{"47526", "鞔"},
	{"47527", "郼 鄿 鞹 鶧 鷨"},
	{"47532", "艱 鞎"},
	{"47547", "韌 轂 靸"},
	{"47552", "韗"},
	{"47562", "鞀"},
	{"47582", "歎"},
	{"47594", "鞣 韖"},
	{"47601", "磬 砮 謦 韾"},
	{"47602", "旮"},
	{"47609", "馨"},
	{"47620", "胡 翿"},
	{"47627", "都 鴣 鵲 鄀 鴶 鵸 鶘"},
	{"47647", "嗀 嗀 嘏 瞉"},
	{"47682", "欯 欹 歖"},
	{"47712", "乜"},
	{"47714", "氂"},
	{"47720", "切 劫"},
	{"47727", "鵪 邯"},
	{"47731", "厹"},
	{"47732", "袃"},
	{"47774", "罄"},
	{"47782", "歁"},
	{"47801", "起 趄 趯"},
	{"47802", "趨 赹 趍 趐 趜"},
	{"47806", "超"},
	{"47808", "趑"},
	{"47809", "趓"},
	{"47820", "期"},
	{"47827", "鷏 鷬"},
	{"47882", "欺"},
	{"47910", "楓 机 杋 柤"},
	{"47911", "柅"},
	{"47912", "桅 枹"},
	{"47913", "欃"},
	{"47914", "櫂"},
	{"47915", "杻 杻"},
	{"47917", "杞 杷 楹"},
	{"47920", "杓 枸 柳 栩 桐 棚 櫚 欄 构 枃 柌 栒 楖 棡 椈 椆 楜 橍 閷"},
	{"47922", "杼 樛"},
	{"47927", "栘 桶 梆 榔 椰 槨 橘 桏 梮 桷 梛 郴 郲 楈 榍 榾 樇 鶆 鷋 鷯 欘"},
	{"47932", "根 橡 椽 榐 檛 櫞"},
	{"47933", "柊"},
	{"47934", "楔"},
	{"47936", "欚"},
	{"47937", "槌 楰"},
	{"47940", "柵 椒 杈 杍 棷"},
	{"47947", "殺 穀 极 杸 梫 棳 棴 椵 椴 榖 樧 樼 縠 檓"},
	{"47950", "楎"},
	{"47952", "檞 櫸"},
	{"47953", "樨"},
	{"47954", "桻"},
	{"47961", "檐"},
	{"47962", "榴 槢"},
	{"47963", "櫓"},
	{"47964", "格 椐"},
	{"47967", "楣 桾"},
	{"47972", "榣"},
	{"47980", "榠"},
	{"47982", "款 杴 栨 樕"},
	{"47986", "樻"},
	{"47994", "樑 棎 楺"},
	{"48011", "尷"},
	{"48012", "尬"},
	{"48016", "馗"},
	{"48046", "撙"},
	{"48107", "盩"},
	{"48117", "圪 墘 壏"},
	{"48121", "堬"},
	{"48127", "坅 坋 塕"},
	{"48136", "螫 螯 蟼"},
	{"48137", "坽"},
	{"48140", "救 墽"},
	{"48146", "墫 壿"},
	{"48147", "墩"},
	{"48151", "垟"},
	{"48161", "垥 墡"},
	{"48166", "增"},
	{"48216", "帨"},
	{"48217", "犵 麧"},
	{"48227", "狑 幯"},
	{"48231", "幠"},
	{"48240", "敖 散 獙 獥"},
	{"48241", "帡"},
	{"48261", "猶 帢"},
	{"48264", "猞"},
	{"48266", "獪"},
	{"48267", "獊"},
	{"48286", "獫"},
	{"48294", "狳"},
	{"48327", "驚"},
	{"48334", "慦 憼"},
	{"48336", "鰲"},
	{"48340", "赦"},
	{"48400", "姒"},
	{"48401", "聱"},
	{"48414", "姾"},
	{"48417", "乾"},
	{"48420", "妎"},
	{"48421", "媮 媊"},
	{"48427", "娣 翰 妗 妢 姈 鶾"},
	{"48431", "嫵"},
	{"48432", "妐"},
	{"48435", "媄"},
	{"48437", "嫌"},
	{"48440", "教 嫩 斡 媺 嬓"},
	{"48441", "姘 幹"},
	{"48446", "媕"},
	{"48450", "姩"},
	{"48461", "姶 嫸"},
	{"48481", "嫙"},
	{"48486", "嬐"},
	{"48494", "榦"},
	{"48502", "擎 擎"},
	{"48516", "鞥"},
	{"48527", "靲"},
	{"48561", "鞈 韐"},
	{"48601", "警"},
	{"48640", "故 敬"},
	{"48717", "鼇"},
	{"48801", "趖 趛"},
	{"48802", "趁"},
	{"48806", "贅 趥"},
	{"48900", "朳"},
	{"48904", "檠"},
	{"48911", "柞 槎"},
	{"48912", "柂 椪 椸"},
	{"48914", "栓 樦"},
	{"48916", "欖 梲"},
	{"48917", "檻"},
	{"48921", "榆 檹"},
	{"48927", "梯 櫛 枍 枌 枔 柃 棆 橁 檎"},
	{"48931", "榚"},
	{"48932", "松 樣 棯"},
	{"48933", "棜 棇 檖"},
	{"48935", "栚"},
	{"48936", "檤"},
	{"48937", "槏"},
	{"48940", "杵 枚 橄 檄 橔"},
	{"48941", "栟"},
	{"48946", "樽"},
	{"48947", "栴"},
	{"48953", "檥"},
	{"48957", "梅"},
	{"48961", "楢 橏"},
	{"48962", "梒"},
	{"48964", "櫡"},
	{"48966", "檜 橧"},
	{"48967", "槍"},
	{"48981", "樅"},
	{"48982", "檨"},
	{"48986", "檢"},
	{"48994", "梌"},
	{"49111", "垙"},
	{"49112", "埢"},
	{"49150", "坢"},
	{"49189", "埮 燅"},
	{"49220", "猀"},
	{"49227", "帩"},
	{"49280", "狄"},
	{"49327", "騺"},
	{"49338", "悐"},
	{"49412", "婘"},
	{"49420", "妙"},
	{"49427", "嫦"},
	{"49450", "姅 靽"},
	{"49489", "婒"},
	{"49527", "鞘 鞝"},
	{"49580", "鞦"},
	{"49720", "尟"},
	{"49802", "趙 趟 赻"},
	{"49911", "桄"},
	{"49914", "樘"},
	{"49917", "橩"},
	{"49920", "杪 桫"},
	{"49927", "梢 棬 橯"},
	{"49931", "欓"},
	{"49941", "橕"},
	{"49950", "柈"},
	{"49959", "橉"},
	{"49977", "檔"},
	{"49980", "梑 楸"},
	{"49989", "棪"},
	{"49996", "橖"},
	{"50000", "丈 丰"},
	{"50006", "中 史 申 吏 曳 串 車"},
	{"50007", "聿 事"},
	{"50011", "摝 摝 轆 攠"},
	{"50012", "抭"},
	{"50014", "拄 推 撞 擁 攤 軴 攡"},
	{"50016", "擅 摬"},
	{"50017", "丸 抗 扽 攍"},
	{"50018", "拉"},
	{"50021", "揨"},
	{"50023", "擠"},
	{"50027", "搞 摘 揥 搒 摛 樆"},
	{"50030", "夫 央 抃"},
	{"50032", "夷 攘 挔 擿 攮"},
	{"50037", "摭 夬"},
	{"50041", "抆 擗 擗"},
	{"50043", "摔"},
	{"50044", "接"},
	{"50047", "掖"},
	{"50048", "較 挍 捽"},
	{"50061", "掊 掊 掂"},
	{"50063", "搐"},
	{"50067", "搪"},
	{"50082", "輆"},
	{"50086", "擴"},
	{"50094", "攗"},
	{"50096", "掠 輬"},
	{"50106", "晝 畫"},
	{"50107", "盅 盎 盡 蠱 衋"},
	{"50110", "虻"},
	{"50111", "螰"},
	{"50114", "蛀 蜼"},
	{"50116", "蟺"},
	{"50117", "蚢"},
	{"50121", "蝏"},
	{"50123", "蠐"},
	{"50127", "螃 螃 螪 螭"},
	{"50131", "蟭"},
	{"50132", "泰 蠔 蚿 蠰"},
	{"50134", "螏"},
	{"50136", "虫 蟲 蠢"},
	{"50137", "蟅 蠊"},
	{"50140", "蚊"},
	{"50143", "蟀"},
	{"50146", "蟑"},
	{"50147", "蜳 蝷"},
	{"50148", "蛟"},
	{"50167", "螗"},
	{"50227", "青 冑 胄 肅 巿"},
	{"50230", "本"},
	{"50327", "鴦"},
	{"50333", "惠"},
	{"50336", "忠 患"},
	{"50337", "憃"},
	{"50343", "專"},
	{"50404", "妻 婁"},
	{"50430", "奏"},
	{"50503", "奉"},
	{"50507", "毒"},
	{"50556", "轟"},
	{"50557", "冉"},
	{"50600", "由"},
	{"50601", "書 砉"},
	{"50603", "春"},
	{"50717", "屯"},
	{"50727", "甹"},
	{"50732", "表 衷"},
	{"50777", "舂"},
	{"50801", "疌"},
	{"50806", "責 貴 賮"},
	{"50900", "未 末 耒"},
	{"50902", "棗 朿"},
	{"50903", "素"},
	{"50904", "秦 櫜"},
	{"50906", "束 東 柬"},
	{"50917", "橀"},
	{"50927", "耪"},
	{"50993", "纛"},
	{"51010", "扛 批 扯 軏 輒 扤 朼"},
	{"51011", "排 輕 攏 抏 抏 挳 摡 搋 攦 轣"},
	{"51012", "扼 軛 揯"},
	{"51014", "捱 捱 輊 挃 挃 挃 揠 攉"},
	{"51016", "摳"},
	{"51017", "拒 挋 掗 軶 攎 轤"},
	{"51020", "打 軻"},
	{"51021", "捗"},
	{"51027", "揹 輛 擄 掯 搹 輀 摴 擩"},
	{"51031", "抎"},
	{"51032", "振 據 掁"},
	{"51034", "擫"},
	{"51036", "攄"},
	{"51040", "軒 扜 扞 挕 搟"},
	{"51041", "攝"},
	{"51046", "掉 撢 挭"},
	{"51047", "扳 擾 掫"},
	{"51049", "抨 抨 軯"},
	{"51060", "拓 拈"},
	{"51061", "指 捂 揩 搢 搢"},
	{"51063", "擂"},
	{"51066", "輻 揊"},
	{"51082", "獗 摃 撅"},
	{"51086", "擷"},
	{"51090", "抔"},
	{"51091", "摽"},
	{"51094", "搮"},
	{"51109", "鑋"},
	{"51110", "虹 蚍"},
	{"51111", "蚖 蛵 蠬"},
	{"51112", "蚅"},
	{"51114", "蛭 蜌 蝘"},
	{"51117", "蠦"},
	{"51119", "蚽"},
	{"51120", "蚵 虰"},
	{"51127", "螞 蠕 蠣 蛃 螄"},
	{"51132", "蜄"},
	{"51134", "蝡"},
	{"51140", "蚜 虷"},
	{"51146", "蟫"},
	{"51150", "蝆"},
	{"51160", "蛅 蛨 蝒"},
	{"51161", "蝔"},
	{"51166", "蝠"},
	{"51186", "蝢"},
	{"51191", "螵"},
	{"51194", "蟝"},
	{"51196", "螈"},
	{"51286", "顑 顣"},
	{"51486", "媜 顜"},
	{"51786", "頓"},
	{"51931", "耘"},
	{"51932", "棖"},
	{"51943", "耨"},
	{"51947", "耰"},
	{"51986", "賴 頛"},
	{"52000", "划 捌 刜 剚"},
	{"52010", "扎 軋"},
	{"52013", "挑"},
	{"52014", "托 捶 摧 撬 拰 軞 軠 揰"},
	{"52016", "擸"},
	{"52018", "撜"},
	{"52020", "捯"},
	{"52021", "折 斬 撕 摲"},
	{"52027", "揣 轎 攜 拶 撟 輲"},
	{"52030", "抓 軱 摦"},
	{"52031", "拆"},
	{"52032", "挀"},
	{"52033", "掭"},
	{"52034", "揆 撲 扷"},
	{"52040", "抵 扦 扺 軝 軧"},
	{"52041", "挺 挻"},
	{"52043", "捋 捋"},
	{"52044", "捼"},
	{"52047", "授 援 撥 捊 挼"},
	{"52057", "掙 棦"},
	{"52063", "輜"},
	{"52064", "括 揗 輴"},
	{"52069", "播 轓"},
	{"52072", "拙 搖"},
	{"52077", "插 插 搯"},
	{"52093", "搎"},
	{"52094", "採 摷 擽 轈 轢"},
	{"52100", "蚓 蜊 劃 虯 蛚 蜵"},
	{"52104", "塹"},
	{"52109", "鏨 銴"},
	{"52111", "蚯"},
	{"52114", "虴 蝩"},
	{"52115", "蚝"},
	{"52116", "蠟"},
	{"52117", "螔"},
	{"52118", "螘"},
	{"52121", "蜥 蚚 螹"},
	{"52122", "蟛"},
	{"52127", "蟡 蝺 蟜 蠵"},
	{"52130", "蛌"},
	{"52131", "蜓 蚸"},
	{"52135", "螇"},
	{"52136", "蜇"},
	{"52139", "蟋"},
	{"52140", "蚔 蚳"},
	{"52141", "蜒"},
	{"52143", "蛶"},
	{"52144", "蜲"},
	{"52147", "蜉 蝂 蝯 蝬"},
	{"52153", "蟣"},
	{"52164", "蛞"},
	{"52169", "蟠"},
	{"52257", "靜"},
	{"52300", "剸"},
	{"52332", "悊 焎"},
	{"52414", "氀"},
	{"52502", "揧"},
	{"52601", "誓 硩 磛"},
	{"52602", "哲 暫 晢"},
	{"52732", "裚"},
	{"52801", "蹔"},
	{"52900", "刺 剌 楋"},
	{"52904", "梊 槧"},
	{"52914", "耗"},
	{"52947", "楥"},
	{"52994", "棌"},
	{"53000", "戈 掛"},
	{"53010", "抁"},
	{"53011", "控 搾 捖 輐"},
	{"53012", "捥"},
	{"53014", "扰 挓"},
	{"53016", "揎"},
	{"53017", "挖 攛"},
	{"53021", "擰"},
	{"53022", "摻"},
	{"53027", "捕 輔 掮 揙 搧"},
	{"53032", "捄 攐"},
	{"53033", "撚"},
	{"53034", "挨 捩"},
	{"53035", "撼 轗"},
	{"53036", "攇"},
	{"53040", "拚 拭 軾"},
	{"53042", "搏"},
	{"53044", "按"},
	{"53047", "拔 捘 軷"},
	{"53050", "找 掝 搣 摵 撠 攕"},
	{"53053", "輚"},
	{"53060", "抬 軩"},
	{"53061", "轄 搳 摍"},
	{"53081", "掟 攓"},
	{"53086", "擯"},
	{"53091", "擦"},
	{"53100", "或 彧"},
	{"53107", "盛 盞"},
	{"53111", "蛇"},
	{"53112", "蜿 蛖"},
	{"53114", "蚘 螲"},
	{"53116", "蝖"},
	{"53127", "蝙 蜅"},
	{"53132", "蜋 蛷"},
	{"53143", "蜧"},
	{"53144", "蛂"},
	{"53150", "蛾 蛑 蜮 蝛 蟙"},
	{"53161", "螛"},
	{"53186", "螾 蟘 蠙"},
	{"53200", "戊 戌 戍 成 咸 威 戚"},
	{"53227", "甫"},
	{"53281", "靛"},
	{"53330", "惑 感 慼"},
	{"53342", "尃"},
	{"53400", "戎 戒"},
	{"53503", "戔"},
	{"53700", "戉"},
	{"53801", "蹙"},
	{"53940", "樲"},
	{"53950", "櫼"},
	{"53960", "耛"},
	{"54000", "抖 拊 軵 轛"},
	{"54011", "撓 揕"},
	{"54012", "拋 扡 抌"},
	{"54014", "挂 奿 搉"},
	{"54016", "掩"},
	{"54017", "軌 抴 搕 搕"},
	{"54021", "掎"},
	{"54027", "拗 拷 扐 抪 挎 拹 軜 揇 搚 撱 樠 擖"},
	{"54030", "軑"},
	{"54031", "抾 捇"},
	{"54032", "轅"},
	{"54034", "摸 撻"},
	{"54038", "挾 梜"},
	{"54041", "持 擭 擣"},
	{"54047", "技 披 拵 挬 棱 輘"},
	{"54060", "描"},
	{"54061", "拮 措 搭 捁 搘 轖"},
	{"54064", "撦"},
	{"54070", "拑"},
	{"54081", "拱 掑 搷 輁"},
	{"54086", "撗 轒 攢"},
	{"54089", "拻"},
	{"54091", "捺 攃"},
	{"54092", "拺"},
	{"54094", "搽 搽 揲 擛"},
	{"54096", "撩 轑"},
	{"54100", "蚪 蝌 蚹"},
	{"54111", "蟯"},
	{"54114", "蛙 螼 蠸"},
	{"54117", "豔"},
	{"54127", "蚋 蚴 蝻 螮 蠨"},
	{"54132", "蠓"},
	{"54134", "蟆"},
	{"54135", "蝧"},
	{"54138", "蛺 蛺"},
	{"54143", "蟒"},
	{"54147", "蚑 蚾 蠖"},
	{"54153", "蠛"},
	{"54160", "蛄 蝫 蠩"},
	{"54161", "蛣 蜡 蟢"},
	{"54170", "蚶"},
	{"54181", "蜞"},
	{"54186", "蟦 蟥"},
	{"54190", "蚞"},
	{"54194", "蝶 蠂"},
	{"54196", "蟟"},
	{"54267", "螬"},
	{"54500", "斠"},
	{"54827", "勣"},
	{"54911", "栳"},
	{"54927", "耡"},
	{"54961", "耤"},
	{"55000", "井 丼 扙 捙"},
	{"55006", "拽 拽 丳 抻"},
	{"55010", "扥"},
	{"55017", "軘"},
	{"55027", "弗 拂 掅 輤"},
	{"55030", "扶 抉 軼 抶 抰 軮 摙 轋"},
	{"55032", "捸 擃"},
	{"55034", "揍 輳"},
	{"55043", "轉 摶"},
	{"55044", "摟 摟 揵"},
	{"55047", "搆"},
	{"55053", "捧 攆"},
	{"55057", "抩"},
	{"55060", "抽 軸"},
	{"55081", "捷 捵"},
	{"55086", "摜 撌"},
	{"55090", "抹"},
	{"55094", "轃"},
	{"55096", "揀 朄"},
	{"55100", "蚌"},
	{"55104", "蕫"},
	{"55108", "豐 豊"},
	{"55127", "蜻"},
	{"55130", "蚨 蚗 蛈"},
	{"55132", "蛦"},
	{"55133", "蟪"},
	{"55144", "螻"},
	{"55157", "蚺 蝳"},
	{"55160", "蛐 蚰"},
	{"55174", "彗"},
	{"55181", "蜨"},
	{"55190", "蛛"},
	{"55191", "螓"},
	{"55196", "蝀"},
	{"55232", "農"},
	{"55327", "蕅"},
	{"55337", "慧"},
	{"55506", "輦"},
	{"55557", "冓"},
	{"55600", "曲"},
	{"55603", "替"},
	{"55606", "曹"},
	{"55801", "典"},
	{"55806", "費"},
	{"55900", "耕"},
	{"55904", "槷"},
	{"55944", "耬"},
	{"55957", "耩"},
	{"55992", "棘"},
	{"56000", "扣 拍 捆 摑 抇 攌"},
	{"56010", "規 挸 軦 摫"},
	{"56011", "輥 輥 擺 掍"},
	{"56014", "捏 捚 揘"},
	{"56017", "挹 搵 轀"},
	{"56027", "拐 捐 揭 揚 暢 搨 擉 輵"},
	{"56030", "揌 摁 摠"},
	{"56032", "揋 擐 轘"},
	{"56034", "捑"},
	{"56040", "捭"},
	{"56041", "捍 揖 擇 輯"},
	{"56044", "攖"},
	{"56046", "擤"},
	{"56047", "撮 攫"},
	{"56050", "押"},
	{"56056", "撣"},
	{"56060", "轠"},
	{"56064", "撂"},
	{"56080", "軹"},
	{"56081", "捉 提"},
	{"56086", "損"},
	{"56093", "摞"},
	{"56094", "操 捰 輠"},
	{"56100", "蛔 蜘 蟈 蚎 蜠"},
	{"56110", "蜆"},
	{"56113", "螝"},
	{"56114", "蝗 蟶 蠷"},
	{"56116", "蠅"},
	{"56117", "蝹"},
	{"56127", "蜴 蜎 蝪 蝎 蝟 蠋"},
	{"56130", "螅 蟌"},
	{"56131", "蟔"},
	{"56132", "蠉"},
	{"56134", "蜈 螑"},
	{"56140", "蜱"},
	{"56141", "蠌"},
	{"56144", "蠳"},
	{"56147", "蠼"},
	{"56156", "蟬"},
	{"56160", "蝐 蠝"},
	{"56181", "蝭"},
	{"56193", "螺"},
	{"56194", "蜾"},
	{"56210", "靚"},
	{"56404", "嫢"},
	{"56510", "覯"},
	{"56900", "柶 耞"},
	{"56904", "槼"},
	{"56914", "楻"},
	{"56927", "耦"},
	{"57010", "抯 軓"},
	{"57011", "抳"},
	{"57012", "抱"},
	{"57013", "拯 攙 攙"},
	{"57014", "握 擢"},
	{"57015", "扭 扭"},
	{"57016", "挽 輓 攪"},
	{"57017", "把 掜 艴 輗"},
	{"57020", "抑 拘 軔 捫 掬 掏 輞 擱 攔 攔 扚 抈 挏 揤 掤 翉 揈 軥 搠 撋 撊 輣 輖 輷"},
	{"57022", "抒 摎 轇"},
	{"57027", "扔 邦 挪 掃 搗 擲 邞 拸 捅 挶 捔 揶 揟 搦 搰 搊 搊 摀 鳺"},
	{"57032", "撾 輾 拫 掾 搌 擙"},
	{"57034", "換 揳 揳"},
	{"57035", "摓"},
	{"57036", "搔 攭"},
	{"57037", "搥 搥"},
	{"57040", "扠 輈"},
	{"57041", "摒"},
	{"57046", "撏"},
	{"57047", "投 抿 搬 搜 輟 扱 掇 掇 掇 軗 摋 轏"},
	{"57050", "拇"},
	{"57053", "摨"},
	{"57054", "捀"},
	{"57056", "揮"},
	{"57061", "擔"},
	{"57062", "招 摺 軺"},
	{"57063", "擼"},
	{"57064", "挌 据 輅"},
	{"57067", "捃 輑"},
	{"57072", "掘"},
	{"57077", "掐"},
	{"57080", "撳"},
	{"57081", "撰 擬"},
	{"57082", "掀 軟 扻 擨"},
	{"57094", "探 揉 搡 輮"},
	{"57104", "墼"},
	{"57110", "蛆 虮"},
	{"57112", "蛫"},
	{"57114", "蠗"},
	{"57117", "蜢 蠅 艷 蚆 蚷 蜺"},
	{"57120", "蜩 蝴 虭 虳 蚐 蚼 蝍 蜪"},
	{"57122", "蝑 蟉"},
	{"57127", "蛹 螂 蝸 螖 螐 蟂 酆 蠮 蠾"},
	{"57132", "蛝 蝝 蟓"},
	{"57133", "螁"},
	{"57136", "蛪"},
	{"57137", "蚇"},
	{"57146", "蟳"},
	{"57147", "蝦 蝃 蟃"},
	{"57154", "蜂"},
	{"57157", "蛜"},
	{"57161", "蟾"},
	{"57162", "蛁"},
	{"57164", "蜛"},
	{"57167", "蝞"},
	{"57172", "蜬"},
	{"57177", "蜭"},
	{"57180", "螟"},
	{"57181", "蟤"},
	{"57182", "蠍"},
	{"57186", "蝜 蠀"},
	{"57194", "蝚"},
	{"57217", "靘"},
	{"57227", "郙 郬 觢 鄪 鵏 鶄 鷫"},
	{"57232", "洯"},
	{"57327", "鄟 鷒"},
	{"57332", "恝"},
	{"57427", "郪 鶈 鷜"},
	{"57432", "契"},
	{"57502", "挈 擊"},
	{"57504", "轚"},
	{"57527", "鄻"},
	{"57647", "毄"},
	{"57772", "齧"},
	{"57903", "繫 絜"},
	{"57904", "栔 檕"},
	{"57917", "耙 耟"},
	{"57927", "鶇 鶒"},
	{"57932", "檭"},
	{"57947", "耔"},
	{"57977", "耜"},
	{"57982", "欶"},
	{"58000", "扒"},
	{"58011", "搓"},
	{"58012", "拖 拖 揓"},
	{"58014", "拴 挫 輇 雗"},
	{"58016", "攬 挩"},
	{"58017", "扢 掽 搤 轞"},
	{"58020", "扴"},
	{"58021", "輸 揃 揄"},
	{"58022", "抮 軫"},
	{"58027", "扮 掄 輪 擒 扲 軡 摥 擳"},
	{"58031", "撫"},
	{"58032", "捻 攁"},
	{"58036", "螒"},
	{"58037", "拎 軨 搛"},
	{"58040", "撇 撤 撒 擻 轍 撖 擏 撽"},
	{"58041", "拼 軿"},
	{"58046", "揜"},
	{"58047", "輹"},
	{"58053", "轙"},
	{"58057", "挴"},
	{"58060", "揂"},
	{"58061", "拾 捨 摿 撘 輶"},
	{"58064", "揝"},
	{"58067", "搶"},
	{"58068", "輍"},
	{"58081", "摐"},
	{"58086", "撿 撿"},
	{"58091", "捈"},
	{"58093", "攥"},
	{"58101", "整"},
	{"58109", "鏊"},
	{"58111", "蚱 蜣"},
	{"58116", "蛻"},
	{"58117", "虼"},
	{"58120", "蚧"},
	{"58121", "蝓"},
	{"58127", "蚙 蚡 蜦 螉"},
	{"58132", "蚣 蜙"},
	{"58137", "蛉"},
	{"58140", "蚥"},
	{"58141", "蛢"},
	{"58147", "蝣 蝮"},
	{"58151", "蛘"},
	{"58153", "蟻"},
	{"58161", "蛤 蝤"},
	{"58181", "蜁"},
	{"58194", "蜍"},
	{"58214", "釐"},
	{"58227", "剺 驁"},
	{"58232", "漦"},
	{"58240", "敷"},
	{"58244", "嫠"},
	{"58247", "孷"},
	{"58251", "犛 犛"},
	{"58327", "鷘"},
	{"58334", "熬"},
	{"58401", "聱"},
	{"58430", "獒"},
	{"58440", "數"},
	{"58502", "摮"},
	{"58601", "謷"},
	{"58917", "杚"},
	{"58940", "敕"},
	{"59012", "捲"},
	{"59020", "抄"},
	{"59027", "捎 撈 輎"},
	{"59031", "攩"},
	{"59050", "拌"},
	{"59052", "撐 撐"},
	{"59059", "轔"},
	{"59066", "擋"},
	{"59080", "揪"},
	{"59089", "掞"},
	{"59112", "蜷"},
	{"59114", "螳"},
	{"59127", "蛸 蟧"},
	{"59166", "蟷"},
	{"59194", "蠑"},
	{"59920", "耖"},
	{"60000", "口 囗"},
	{"60010", "甿 盳"},
	{"60014", "唯 睢 瞳 暀 噰 曈 囃"},
	{"60017", "吭 喨"},
	{"60018", "啦"},
	{"60022", "喭"},
	{"60023", "嚌"},
	{"60027", "唷 哼 啼 嘀 昉 嗃 嗙 瞝"},
	{"60031", "瞧"},
	{"60032", "眩 嚎 嚷 昡 囔"},
	{"60036", "噫"},
	{"60040", "呅 旼"},
	{"60044", "唼"},
	{"60046", "暲 瞕"},
	{"60047", "啍 喥"},
	{"60048", "咬 啐 啐 晬 睟"},
	{"60061", "唁 暗 喑"},
	{"60082", "咳"},
	{"60086", "曠 瞚 嚝 矌"},
	{"60094", "嘛"},
	{"60096", "晾"},
	{"60100", "日 曰 旦"},
	{"60101", "目 罡"},
	{"60104", "呈 里 星 量 墨 壘 罜 罣 罣 罿"},
	{"60107", "疊 罝 圔"},
	{"60108", "昱"},
	{"60111", "罪 蹗"},
	{"60113", "晁"},
	{"60114", "雖 跓 踓 躔"},
	{"60123", "躋"},
	{"60127", "昂 勗 蜀 蹄 昮 蹢"},
	{"60130", "跡 罫"},
	{"60132", "暴 躟"},
	{"60137", "蹠"},
	{"60141", "晸"},
	{"60144", "踥"},
	{"60147", "最 踱 躞"},
	{"60148", "跤 踤"},
	{"60153", "國 罭"},
	{"60161", "踣 踮"},
	{"60210", "兄 四 見"},
	{"60211", "晃 罷 囮 囥"},
	{"60221", "畀 罽"},
	{"60223", "昦"},
	{"60227", "吊 囫 易 囿 胃 圃 囧 肙 昜 昺 晑 罞 圊 圇 晜 圌 罥 暠 曏 羃 髇"},
	{"60228", "界"},
	{"60232", "晨 園 圂 罛"},
	{"60240", "罻"},
	{"60253", "晟"},
	{"60281", "昃"},
	{"60307", "囹"},
	{"60327", "罵 鷕"},
	{"60330", "思 恩 慁"},
	{"60331", "黑 羆"},
	{"60332", "愚"},
	{"60336", "罳"},
	{"60343", "團"},
	{"60361", "黯"},
	{"60396", "黥"},
	{"60400", "田 早 旻"},
	{"60401", "旱 圉 咠 圛"},
	{"60404", "晏 囡"},
	{"60406", "罩"},
	{"60407", "囝 曼 畟 罦"},
	{"60416", "冕"},
	{"60417", "旯"},
	{"60427", "另 男 禺"},
	{"60430", "因 昊 旲"},
	{"60433", "狊"},
	{"60436", "奰"},
	{"60440", "昇"},
	{"60447", "罬"},
	{"60500", "甲"},
	{"60504", "罼"},
	{"60506", "圍 暈"},
	{"60507", "畢"},
	{"60521", "羇"},
	{"60527", "羈"},
	{"60600", "回 呂 昌 冒 圖"},
	{"60601", "圄 圁 詈 碞 謈 礨"},
	{"60602", "罶"},
	{"60604", "固 罟 暑 晷 署"},
	{"60606", "罾"},
	{"60620", "罰"},
	{"60641", "冔"},
	{"60660", "品 晶 畾"},
	{"60711", "昆 毘"},
	{"60712", "圈"},
	{"60716", "置 罨"},
	{"60717", "吧 囤 囤 邑"},
	{"60727", "曷 昴"},
	{"60731", "曇"},
	{"60732", "畏 曩 褁 瞏 圜"},
	{"60747", "罠"},
	{"60770", "旵"},
	{"60772", "嵒 罍"},
	{"60776", "喦"},
	{"60800", "只 囚 貝"},
	{"60801", "足 具 是 異"},
	{"60806", "員 買 圓 圚"},
	{"60809", "炅"},
	{"60817", "貥"},
	{"60848", "賥"},
	{"60861", "賠"},
	{"60882", "賅"},
	{"60886", "贔"},
	{"60901", "罘"},
	{"60903", "累 纍"},
	{"60904", "呆 困 果 杲 囷 喿 罺 櫐 圞 圞"},
	{"60906", "景"},
	{"60914", "罹 羅"},
	{"60993", "羉"},
	{"60994", "罧"},
	{"61010", "毗 吪 呲"},
	{"61011", "啡 眶 嚨 嚨 矓 曬 眐 嚦 曨"},
	{"61012", "呃 咂 咂"},
	{"61014", "旺 唬 喱 咥 晊 啀 睚 曤 矐"},
	{"61016", "晅 嘔 暱 咺"},
	{"61017", "啞 噓 嚧"},
	{"61019", "呸"},
	{"61020", "叮 盯 呵 啊 町 咑"},
	{"61027", "啃 嗎 嘴 嚅 眄 啢 嗝 嘕 曘 曞"},
	{"61031", "眃 噁 噁"},
	{"61032", "啄 噱"},
	{"61034", "噳"},
	{"61040", "吁 呀 旰 旴 盱 盰 咡 眲"},
	{"61041", "囁 哢"},
	{"61043", "嗕"},
	{"61044", "喓"},
	{"61046", "哽 啅 嘾 曋 瞫"},
	{"61047", "昄 畈 眅 嗄 嚘"},
	{"61049", "呯"},
	{"61050", "噦"},
	{"61053", "嘎 噦"},
	{"61060", "哂 晒 呫 唒 喕"},
	{"61061", "唔 晤 喈 噆"},
	{"61072", "嚙 囓"},
	{"61077", "喢"},
	{"61081", "瞋 嗔"},
	{"61086", "噸 嗊 暊 嚬 嚬"},
	{"61087", "噘"},
	{"61090", "吥"},
	{"61091", "瞟 嘌"},
	{"61094", "喍"},
	{"61110", "趾 跐"},
	{"61111", "躘 躘"},
	{"61114", "跮"},
	{"61117", "距"},
	{"61121", "踄"},
	{"61127", "蹐 躎"},
	{"61131", "躚"},
	{"61132", "躆"},
	{"61140", "趶 趼 躕"},
	{"61141", "躡"},
	{"61146", "踔"},
	{"61147", "斀"},
	{"61160", "跖 跕 跴"},
	{"61166", "踾"},
	{"61181", "蹝"},
	{"61182", "蹶"},
	{"61186", "蹞"},
	{"61211", "號"},
	{"61286", "顎 顒"},
	{"61314", "黖 黫"},
	{"61360", "點"},
	{"61386", "顯"},
	{"61532", "辴"},
	{"61732", "饕"},
	{"61801", "匙"},
	{"61808", "題"},
	{"61809", "煚"},
	{"61832", "賑 賬"},
	{"61846", "贉"},
	{"61847", "販"},
	{"61860", "貼"},
	{"61947", "敤"},
	{"61986", "顆 顥"},
	{"62000", "甽 咧 喇 唎 唰"},
	{"62010", "吼"},
	{"62013", "眺 咷"},
	{"62014", "吒 唾 睡 眊 嗺 畽"},
	{"62017", "嗈"},
	{"62018", "瞪 暟"},
	{"62021", "听 昕 晰 嘶 盺 哳"},
	{"62027", "喘 噅 嘺"},
	{"62030", "呱"},
	{"62031", "唌 曛 矄"},
	{"62032", "吆 眽"},
	{"62034", "睽 暌"},
	{"62035", "噗 瞨"},
	{"62036", "嗤"},
	{"62037", "眨 眨"},
	{"62040", "呧"},
	{"62043", "哷"},
	{"62046", "嚼"},
	{"62047", "暖 噯 曖 哸"},
	{"62049", "呼"},
	{"62052", "瞬"},
	{"62053", "嘰"},
	{"62057", "睜"},
	{"62064", "咶 睧 瞃"},
	{"62072", "咄"},
	{"62077", "昢"},
	{"62094", "睬 啋"},
	{"62110", "踂"},
	{"62113", "跳"},
	{"62114", "踵 毾"},
	{"62116", "躐"},
	{"62118", "蹬"},
	{"62127", "踹 蹦 踽 蹻"},
	{"62131", "跅"},
	{"62134", "蹊 蹼"},
	{"62143", "蹡"},
	{"62144", "踒"},
	{"62147", "蹳"},
	{"62163", "踏"},
	{"62169", "蹯"},
	{"62170", "躖"},
	{"62177", "蹈"},
	{"62186", "躓"},
	{"62194", "踩 躒"},
	{"62200", "別 剔"},
	{"62214", "氍"},
	{"62327", "黟"},
	{"62372", "黜"},
	{"62441", "婩"},
	{"62614", "毷"},
	{"62715", "毼"},
	{"62800", "則"},
	{"62837", "貶"},
	{"62840", "貾"},
	{"62900", "劋"},
	{"62914", "氉"},
	{"62922", "影"},
	{"62993", "縣"},
	{"63000", "咇"},
	{"63007", "昈"},
	{"63010", "吮"},
	{"63011", "晥 睆"},
	{"63012", "哤 晼 畹 睕"},
	{"63014", "吒 噈"},
	{"63016", "喧 暄"},
	{"63021", "嚀 眝"},
	{"63027", "哺 晡"},
	{"63032", "昹"},
	{"63034", "吠 畎 唉 唳 睙"},
	{"63047", "唆 晙 畯"},
	{"63050", "哦 眸 喊 哞 眓 睋 嘁"},
	{"63060", "咍 眙"},
	{"63061", "瞎 嗐 噾"},
	{"63064", "喀"},
	{"63073", "嘧"},
	{"63081", "啶"},
	{"63086", "矉"},
	{"63091", "嚓"},
	{"63111", "跎"},
	{"63112", "踠"},
	{"63114", "蹴"},
	{"63117", "躥"},
	{"63132", "踉"},
	{"63136", "蠈"},
	{"63144", "跋"},
	{"63147", "踆"},
	{"63150", "戢 戥"},
	{"63153", "踐"},
	{"63160", "跆"},
	{"63161", "蹜"},
	{"63234", "猒"},
	{"63312", "黦"},
	{"63322", "黲"},
	{"63334", "默"},
	{"63340", "黓"},
	{"63550", "戰"},
	{"63634", "獸"},
	{"63821", "貯"},
	{"63822", "贂"},
	{"63832", "賕"},
	{"63840", "賦"},
	{"63842", "賻"},
	{"63850", "賊 贓 賳"},
	{"63853", "賤"},
	{"63860", "貽"},
	{"63889", "贆"},
	{"64000", "叫 吋 咐 呏 嘝"},
	{"64010", "叱 吐"},
	{"64011", "曉 咾 嘵"},
	{"64012", "眈"},
	{"64013", "啿"},
	{"64014", "哇 畦 睦 眭 嚾 矔"},
	{"64016", "喳 唵 唵 晻"},
	{"64017", "嗑 瞌 瞌"},
	{"64018", "噎 曀"},
	{"64021", "畸"},
	{"64027", "叻 吶 唏 晞 喃 噶 瞞 呦 咘 晇 眑 睎 嗋 暔 嘜 暪 嚆"},
	{"64030", "呔"},
	{"64031", "嚇 嚥 囈 呿 呿 哧 曣"},
	{"64032", "矇 吰 曚"},
	{"64034", "映 嘆 嗼 暵 暯 噠 瞙"},
	{"64036", "囆"},
	{"64038", "唊"},
	{"64040", "哎"},
	{"64041", "時 疇 啈 畤"},
	{"64047", "吱 哮 哱 啵 睖 嚄"},
	{"64054", "嘩 曄 瞱"},
	{"64056", "喡 暐"},
	{"64060", "咕 睹 瞄 唶 喵"},
	{"64061", "嗜 嘻 咭 哠 嗒"},
	{"64064", "喏"},
	{"64067", "嘈"},
	{"64070", "咁"},
	{"64081", "哄 嚏 唗 唭"},
	{"64086", "噴 囋"},
	{"64090", "咻"},
	{"64091", "噤"},
	{"64093", "嗦"},
	{"64094", "喋 囌"},
	{"64096", "嘹 嘹 暸 瞭"},
	{"64098", "睞 唻 嗏"},
	{"64100", "跗"},
	{"64111", "蹺 跣 踸"},
	{"64114", "跬 踛"},
	{"64116", "蹅"},
	{"64117", "跇"},
	{"64121", "踦"},
	{"64127", "跨 蹣 蹛"},
	{"64135", "躂"},
	{"64141", "躊 跱"},
	{"64147", "跛 跂 踍 踜"},
	{"64160", "跍"},
	{"64161", "踖 躤"},
	{"64164", "躇"},
	{"64166", "蹧"},
	{"64181", "跿 踑 蹎"},
	{"64186", "躦"},
	{"64194", "蹀"},
	{"64311", "黮"},
	{"64312", "黕"},
	{"64316", "黤"},
	{"64327", "黝"},
	{"64361", "黠"},
	{"64370", "黚"},
	{"64381", "黰"},
	{"64386", "黷"},
	{"64627", "勖"},
	{"64800", "財"},
	{"64805", "韙"},
	{"64812", "貤"},
	{"64827", "勛 賄"},
	{"64863", "賭"},
	{"64886", "贖"},
	{"65000", "吽"},
	{"65006", "呻 眒"},
	{"65017", "盹 吨 旽 嚍"},
	{"65027", "晴 睛 嘯 咈 昲"},
	{"65030", "映 吷 呠 昳 眣 嗹 瞣"},
	{"65032", "咦 噥 眱"},
	{"65043", "囀 暷"},
	{"65044", "嘍 嘍 瞜"},
	{"65047", "呥"},
	{"65053", "唪"},
	{"65066", "嘈"},
	{"65068", "暙"},
	{"65071", "嘒"},
	{"65081", "咦 睫 啑 晪"},
	{"65086", "嘖 嘳 曊 瞶"},
	{"65090", "味 昧 咮 眛"},
	{"65093", "嗉"},
	{"65096", "暕"},
	{"65106", "跩"},
	{"65130", "趺 跌 趹 蹥"},
	{"65162", "踳"},
	{"65177", "蹖"},
	{"65181", "踕"},
	{"65186", "蹟 聵 蹪"},
	{"65194", "跦"},
	{"65806", "賗"},
	{"65810", "貹"},
	{"65817", "贐"},
	{"65857", "購"},
	{"65863", "賰"},
	{"65881", "賟"},
	{"66000", "咖 咽 咱 啪 睏 呬 昍 嘓"},
	{"66010", "呾 晛 睍 瞡 嚫"},
	{"66014", "哩 囉 囉 喤 嚜"},
	{"66017", "唈 嗢"},
	{"66027", "喝 喟 暘 暍 呺 喁 晹 睊 噣 矊 矏"},
	{"66030", "嗯"},
	{"66031", "嘿"},
	{"66032", "喂 曝 噮 嚗"},
	{"66033", "瞁 嚃"},
	{"66034", "嗅"},
	{"66040", "啤 睥"},
	{"66041", "哻 睅"},
	{"66043", "嗥"},
	{"66044", "嚶"},
	{"66046", "暺"},
	{"66047", "嘬"},
	{"66048", "曮"},
	{"66050", "呷"},
	{"66054", "嗶"},
	{"66056", "嘽"},
	{"66060", "唱"},
	{"66064", "曙"},
	{"66080", "唄"},
	{"66081", "哫 睼"},
	{"66086", "嘪"},
	{"66094", "噪 矂"},
	{"66096", "暻"},
	{"66100", "踟 跏"},
	{"66104", "壨"},
	{"66114", "躣"},
	{"66127", "踢 踢 蹋 躅 踼"},
	{"66132", "跠"},
	{"66147", "躩"},
	{"66150", "蹕"},
	{"66181", "踀 踶"},
	{"66194", "踝 躁"},
	{"66207", "咢"},
	{"66210", "覞"},
	{"66214", "瞿"},
	{"66217", "咒"},
	{"66248", "嚴"},
	{"66320", "喌"},
	{"66402", "斝"},
	{"66404", "嬰"},
	{"66407", "矍"},
	{"66427", "嬲"},
	{"66430", "哭"},
	{"66506", "單"},
	{"66601", "譻"},
	{"66660", "嘂"},
	{"66661", "嚚"},
	{"66663", "器"},
	{"66668", "囂"},
	{"66717", "甖 鼉"},
	{"66772", "罌"},
	{"66810", "貺"},
	{"66827", "賜"},
	{"66860", "賵"},
	{"66880", "賏"},
	{"67000", "咿"},
	{"67010", "咀"},
	{"67011", "呢 曬 昵"},
	{"67012", "咆"},
	{"67013", "嚵"},
	{"67014", "喔 曜 嚁"},
	{"67015", "吜"},
	{"67016", "晚"},
	{"67017", "吧 睨 唲 晲 睌"},
	{"67022", "嘐"},
	{"67027", "咿 哪 嗚 嘟 鳴 囑 矚 哆 哆 唃 眵 眵 啷 喎 嘄 噊 瞗 瞲"},
	{"67032", "眼 喙 哏 睩"},
	{"67033", "咚"},
	{"67034", "喚 喉 喫 噢"},
	{"67040", "呶"},
	{"67046", "噚"},
	{"67047", "吸 眠 啜 暇 吇 呡 昅 唚 嗖 畷 瞍 矎"},
	{"67048", "噿"},
	{"67050", "呣"},
	{"67056", "暉"},
	{"67061", "瞻"},
	{"67062", "昭 眧 眳"},
	{"67063", "嚕"},
	{"67064", "咯 略"},
	{"67072", "嗂"},
	{"67077", "啗 啒 矙"},
	{"67080", "暝 瞑"},
	{"67081", "噀"},
	{"67082", "吹 嗽 欥 欭 噷"},
	{"67086", "嚽"},
	{"67087", "呎"},
	{"67094", "嗓"},
	{"67101", "曌"},
	{"67104", "墅"},
	{"67107", "盟"},
	{"67110", "跙"},
	{"67111", "跜"},
	{"67112", "跑 跪"},
	{"67114", "躍"},
	{"67117", "跁"},
	{"67120", "躪 趵 踘 躝"},
	{"67122", "野"},
	{"67127", "郢 跼 踴 躑 跢 踊 蹁 鴠 鸀"},
	{"67131", "跽"},
	{"67132", "跟 蹍 蹍"},
	{"67140", "跚 踙 踧"},
	{"67147", "趿"},
	{"67160", "蹓"},
	{"67164", "路 踞"},
	{"67180", "歜"},
	{"67194", "跺 蹂"},
	{"67220", "嗣"},
	{"67227", "鄂 鵑 郻 鴞 鶚 鷐"},
	{"67327", "鷺"},
	{"67332", "煦 喣"},
	{"67336", "照"},
	{"67361", "黵"},
	{"67382", "歞"},
	{"67427", "鸚 郹 鄤 鶪 鷃 鷝 鷤 鸅"},
	{"67527", "鴨 鄲"},
	{"67532", "囅"},
	{"67627", "鄙 郘 鸓"},
	{"67720", "翾"},
	{"67727", "鶡"},
	{"67782", "歇"},
	{"67820", "賙"},
	{"67827", "郥 鄖 鵙 鶗 鷶"},
	{"67852", "賱"},
	{"67861", "贍"},
	{"67864", "賂"},
	{"67894", "賝"},
	{"67927", "夥 鄵"},
	{"68000", "叭"},
	{"68011", "咋 昨 嗟 唴"},
	{"68012", "暆"},
	{"68014", "唑"},
	{"68017", "吃 盵 嗌 嚂"},
	{"68018", "噬"},
	{"68020", "吤"},
	{"68021", "喻 睮"},
	{"68022", "畛 眕"},
	{"68027", "吩 吟 盼 嗡 噙 昑 昐 盻 睇 嗲 睔 暡 瞈"},
	{"68031", "嘸 瞴"},
	{"68032", "唸"},
	{"68033", "唹"},
	{"68034", "嗾"},
	{"68035", "眹"},
	{"68037", "昤 呤 嗛"},
	{"68040", "畋 嗷 瞰 吘 噉 噭 暾 曒"},
	{"68046", "啽 噂"},
	{"68050", "哖"},
	{"68051", "咩 眻"},
	{"68053", "曦"},
	{"68057", "晦 嗨"},
	{"68061", "哈"},
	{"68062", "唅"},
	{"68064", "啥 喒"},
	{"68066", "噌 噲 瞺"},
	{"68067", "嗆"},
	{"68081", "暰"},
	{"68086", "瞼 嗿 噞"},
	{"68094", "唋 畬"},
	{"68100", "趴"},
	{"68111", "蹉"},
	{"68114", "跧"},
	{"68117", "踫 趷"},
	{"68121", "踰"},
	{"68122", "跈"},
	{"68127", "踚"},
	{"68132", "踗"},
	{"68140", "躈"},
	{"68141", "跰"},
	{"68146", "蹲"},
	{"68147", "躨"},
	{"68151", "躌"},
	{"68157", "踇"},
	{"68161", "跲"},
	{"68166", "蹭"},
	{"68167", "蹌"},
	{"68181", "蹤"},
	{"68327", "黔"},
	{"68346", "黭"},
	{"68440", "斁"},
	{"68681", "瞛"},
	{"68817", "賹"},
	{"68837", "賺"},
	{"68840", "敗"},
	{"68866", "贈"},
	{"68891", "賒 賒"},
	{"69012", "睠"},
	{"69014", "瞠"},
	{"69020", "吵 眇 唦"},
	{"69027", "哨 嘮 嘮 睄"},
	{"69031", "曭 矘"},
	{"69039", "瞇"},
	{"69050", "畔"},
	{"69059", "暽 疄 瞵"},
	{"69061", "嚐"},
	{"69066", "噹"},
	{"69080", "啾 吙 炚 瞅"},
	{"69086", "嗩"},
	{"69089", "啖 晱 睒"},
	{"69094", "咪 眯"},
	{"69112", "踡"},
	{"69114", "蹚"},
	{"69127", "踃"},
	{"69150", "跘"},
	{"69159", "蹸"},
	{"69180", "踿"},
	{"69227", "腃"},
	{"69889", "賧"},
	{"70103", "璧"},
	{"70104", "壁"},
	{"70114", "雎"},
	{"70214", "雅 雕 臃 脽 朣 膧 膧"},
	{"70215", "隡"},
	{"70216", "膻"},
	{"70217", "阬 骯 肮"},
	{"70223", "臍 隮"},
	{"70227", "防 肪 膀 劈 臂 脝 幦 臇"},
	{"70231", "膲 臕"},
	{"70232", "胘"},
	{"70236", "臆"},
	{"70240", "腑"},
	{"70243", "膟"},
	{"70246", "障"},
	{"70247", "腋"},
	{"70248", "脺 骹"},
	{"70261", "陪 腤"},
	{"70282", "骸 陔 胲"},
	{"70294", "髍"},
	{"70314", "駐 騅"},
	{"70316", "驙"},
	{"70327", "鷿"},
	{"70332", "驤"},
	{"70334", "憵"},
	{"70340", "駇"},
	{"70341", "騂"},
	{"70346", "騿"},
	{"70348", "駮"},
	{"70382", "駭"},
	{"70404", "嬖"},
	{"70502", "擘"},
	{"70601", "譬"},
	{"70641", "辟"},
	{"70711", "鼊"},
	{"70717", "甓"},
	{"70732", "襞"},
	{"70740", "鼤"},
	{"70801", "躄"},
	{"70903", "繴"},
	{"70904", "檗 糪"},
	{"71104", "塈"},
	{"71136", "蜃 螶 蟨 瓥"},
	{"71200", "厂"},
	{"71210", "肛 阢 阰 阯 骴"},
	{"71211", "阮 陘 腓 歷 隴 朧 厏 朊 厞 脛 陫"},
	{"71212", "厄 陋 阨 厖"},
	{"71213", "魘 飋"},
	{"71214", "陛 廄 雁 壓 厔 厘 胵 厜 颬 臛"},
	{"71216", "颭"},
	{"71217", "臚 虒"},
	{"71218", "脰"},
	{"71219", "胚"},
	{"71220", "阿"},
	{"71221", "胻 陟"},
	{"71227", "脣 隔 膈 厲 陃 陑 胹 鴈 隬 臑 鬵"},
	{"71232", "辰 脤 豚 脹 臄"},
	{"71234", "厭 陾"},
	{"71237", "甂"},
	{"71240", "肝 骭"},
	{"71241", "厊 厗"},
	{"71242", "厎"},
	{"71244", "腰"},
	{"71246", "骾"},
	{"71247", "反 阪 厚 陬"},
	{"71250", "厙"},
	{"71256", "厙"},
	{"71260", "陌 阽"},
	{"71261", "厝 脂 階 磿"},
	{"71263", "厬"},
	{"71266", "腷"},
	{"71269", "曆"},
	{"71274", "厒"},
	{"71280", "仄"},
	{"71281", "厧"},
	{"71282", "厥"},
	{"71286", "願 贗 頎 顅 顝"},
	{"71289", "灰"},
	{"71291", "膘"},
	{"71294", "厤"},
	{"71296", "原"},
	{"71311", "驪 騑"},
	{"71314", "駤"},
	{"71316", "驅"},
	{"71317", "驢 駏 驉"},
	{"71319", "駓"},
	{"71327", "馬 鷢 驫"},
	{"71331", "慝 黶"},
	{"71336", "鱀"},
	{"71339", "愿"},
	{"71340", "馯 駬"},
	{"71343", "辱"},
	{"71344", "騕"},
	{"71346", "驔"},
	{"71349", "駍"},
	{"71362", "驦"},
	{"71381", "驥"},
	{"71391", "驃"},
	{"71396", "騵"},
	{"71404", "嬮"},
	{"71442", "馵"},
	{"71506", "馽 厴"},
	{"71586", "顐"},
	{"71601", "靨"},
	{"71603", "唇"},
	{"71647", "敯"},
	{"71710", "匚"},
	{"71711", "匹 匡 匪 匯 匜 匟 匭 匷"},
	{"71712", "匝 匠 匾 匾 匢"},
	{"71714", "既 鼴 匽 匰 匴"},
	{"71715", "匣"},
	{"71716", "叵 匿 區 鼯 匼 鼫"},
	{"71717", "巨 臣 甌"},
	{"71718", "匱"},
	{"71732", "長 饜"},
	{"71747", "敺"},
	{"71761", "鼯"},
	{"71786", "頤"},
	{"72031", "乓"},
	{"72100", "劉 刞"},
	{"72101", "丘"},
	{"72104", "髽"},
	{"72109", "髬"},
	{"72111", "髭"},
	{"72121", "斲"},
	{"72147", "脬"},
	{"72200", "刖 刷 剛 劂 剭 剮"},
	{"72201", "乒"},
	{"72202", "鬖"},
	{"72210", "阠 颲"},
	{"72211", "髡"},
	{"72212", "卮 颩"},
	{"72213", "朓 脁"},
	{"72214", "陲 腫 垕 隀 腄 膗"},
	{"72215", "膬"},
	{"72216", "颳"},
	{"72217", "卮 扈 臘"},
	{"72218", "隑"},
	{"72221", "斤 所 肵 鬋 鬐 斸"},
	{"72222", "彫 膨 肜"},
	{"72227", "髣 髳 髾 鬅 鬌 鬗"},
	{"72230", "爪 瓜 胍"},
	{"72231", "斥 臐"},
	{"72232", "脈 鬞"},
	{"72237", "隱 鬑"},
	{"72240", "阡 胝 阺"},
	{"72241", "脡"},
	{"72243", "脟"},
	{"72244", "腇"},
	{"72247", "朡 髲"},
	{"72261", "后 扂"},
	{"72263", "腦"},
	{"72264", "盾 腯"},
	{"72269", "膰"},
	{"72272", "朏"},
	{"72277", "胐"},
	{"72286", "鬚"},
	{"72294", "髹"},
	{"72300", "馴"},
	{"72313", "駣 騛"},
	{"72314", "馲"},
	{"72327", "驕 驨"},
	{"72334", "騃 騤 騱"},
	{"72391", "騬"},
	{"72400", "刪 刐"},
	{"72407", "髶 鬘"},
	{"72412", "髧"},
	{"72422", "彤"},
	{"72447", "髮"},
	{"72557", "髯"},
	{"72601", "髻"},
	{"72602", "髫 髷"},
	{"72603", "鬊"},
	{"72604", "昏 髺"},
	{"72606", "鬙 鬠"},
	{"72627", "鬍"},
	{"72700", "刡"},
	{"72712", "髱 鬈 鬄"},
	{"72713", "鼷"},
	{"72714", "髦"},
	{"72716", "鬣 鼶"},
	{"72722", "髟"},
	{"72732", "鬟 鬤"},
	{"72734", "镺 鼷"},
	{"72740", "氏 氐"},
	{"72747", "孵"},
	{"72772", "岳"},
	{"72801", "兵 鬒"},
	{"72806", "質 鬢 鬕"},
	{"72900", "剁"},
	{"72901", "鬃"},
	{"72904", "檃"},
	{"72922", "鬁 鬎"},
	{"72932", "鬆"},
	{"73210", "阭"},
	{"73211", "陀 院 腔 脘"},
	{"73212", "腕"},
	{"73214", "膣"},
	{"73216", "颱 髖 臗"},
	{"73227", "脯 觱"},
	{"73232", "脙"},
	{"73236", "膙"},
	{"73240", "膩"},
	{"73242", "膊 髆"},
	{"73244", "胺"},
	{"73247", "胈 朘 脧 瞂"},
	{"73250", "戙 隇 膱"},
	{"73260", "胎"},
	{"73264", "髂"},
	{"73286", "臏 髕"},
	{"73300", "駜"},
	{"73310", "馻"},
	{"73311", "駝"},
	{"73312", "駹"},
	{"73322", "驂"},
	{"73327", "騙 騸"},
	{"73332", "駺"},
	{"73347", "駿"},
	{"73350", "駥 駴 驖"},
	{"73360", "駘"},
	{"73386", "驞"},
	{"73734", "鼵"},
	{"74104", "墮"},
	{"74109", "鐆"},
	{"74127", "助"},
	{"74200", "肘 附 尉 胕"},
	{"74210", "肚"},
	{"74211", "隓 隢 膮 髐"},
	{"74214", "陞 陸"},
	{"74216", "腌"},
	{"74219", "飉"},
	{"74221", "陭"},
	{"74227", "肋 胯 隋 勵 阞 肭 陏 陓 朒 腩 膌 骻"},
	{"74231", "阹 胠 臙"},
	{"74232", "肱 膝 隨 朦 髓"},
	{"74234", "膜"},
	{"74235", "朠"},
	{"74238", "陝 陜 脥"},
	{"74241", "髒"},
	{"74247", "肢 陂 脖 陵 骳 臌 臒"},
	{"74248", "膵"},
	{"74253", "臟"},
	{"74260", "骷 陼"},
	{"74261", "腊"},
	{"74281", "陡"},
	{"74286", "臢 膹 贕"},
	{"74294", "腜"},
	{"74300", "駙"},
	{"74311", "驍 駪"},
	{"74312", "馳"},
	{"74314", "騹 驩"},
	{"74321", "騎"},
	{"74330", "馱 慰"},
	{"74331", "驠"},
	{"74338", "隳"},
	{"74340", "駁"},
	{"74346", "騲"},
	{"74354", "驊"},
	{"74381", "騏"},
	{"74398", "騋"},
	{"74400", "斞"},
	{"74447", "雘"},
	{"74500", "犚"},
	{"74713", "鼸"},
	{"74727", "劻"},
	{"74732", "褽"},
	{"74741", "鼭"},
	{"74771", "嶞"},
	{"74796", "镽"},
	{"74809", "熨"},
	{"75043", "膞"},
	{"75200", "胂"},
	{"75206", "陣"},
	{"75210", "胜"},
	{"75212", "阤"},
	{"75217", "肫 肒 骫"},
	{"75218", "體"},
	{"75227", "肺 胇 胏"},
	{"75230", "胅 胦"},
	{"75232", "胰 膿"},
	{"75233", "瓞"},
	{"75234", "腠"},
	{"75240", "腱"},
	{"75244", "髏"},
	{"75246", "膢"},
	{"75281", "腆"},
	{"75286", "隤"},
	{"75290", "陎"},
	{"75293", "膆"},
	{"75296", "陳 螴"},
	{"75306", "駛"},
	{"75327", "騁 驌"},
	{"75337", "駃"},
	{"75344", "騝"},
	{"75360", "駎"},
	{"75361", "騞"},
	{"75396", "駷"},
	{"75707", "肆"},
	{"75711", "鼪"},
	{"75716", "鼬"},
	{"75727", "鼱"},
	{"75730", "镻"},
	{"75786", "賾"},
	{"76140", "陴"},
	{"76200", "胭 胉 膕"},
	{"76210", "覛"},
	{"76211", "膍"},
	{"76212", "颺 颺"},
	{"76213", "隗 颸"},
	{"76214", "隍 腥 脭 臞"},
	{"76217", "膃"},
	{"76218", "颶"},
	{"76227", "陽 隅 腸 髑 腢 斶 臅"},
	{"76230", "腮"},
	{"76232", "腺 隈 腲"},
	{"76233", "隰"},
	{"76240", "脾 髀"},
	{"76250", "胛"},
	{"76280", "胑"},
	{"76281", "隄"},
	{"76286", "隕"},
	{"76294", "髁 臊 臊"},
	{"76300", "駟 馹 駰"},
	{"76311", "騉"},
	{"76313", "騩"},
	{"76314", "騜"},
	{"76327", "駽 騔"},
	{"76330", "驄"},
	{"76341", "驛 駻"},
	{"76344", "騴 驆"},
	{"76347", "騣"},
	{"76356", "驒"},
	{"76381", "騠"},
	{"76393", "騾"},
	{"76394", "騍"},
	{"76718", "鼰"},
	{"76734", "鼳"},
	{"76808", "咫"},
	{"76810", "覭"},
	{"77100", "且 皿"},
	{"77101", "閆"},
	{"77103", "瑿 璺"},
	{"77104", "堅 閏 閨 堲 朢 墬 壂 壆 闉 闛"},
	{"77107", "閂 盥 闔 舋"},
	{"77108", "豎 毉 闓"},
	{"77109", "鋻"},
	{"77114", "鬥"},
	{"77117", "鬮"},
	{"77127", "邱 翳 闒"},
	{"77136", "閩 蜸 蜰"},
	{"77147", "毀"},
	{"77148", "闞 鬫"},
	{"77153", "閾"},
	{"77164", "闊"},
	{"77207", "尸"},
	{"77210", "几 凡 夙 肌 阻 風 凰 鳳"},
	{"77211", "尼 屁 屍 屝 閌 颮"},
	{"77212", "甩 胞 脆 飂"},
	{"77213", "颾"},
	{"77214", "尾 屋 隆 颼 隉 腛 閵"},
	{"77216", "閱 覺 飀"},
	{"77217", "兒 兕 兕 肥 兜 屜 尻 肊 戺 脕 鬩"},
	{"77220", "月 用 同 周 岡 朋 罔 胴 胸 陶 腳 网 冏 肕 朐 胊 陱 翢"},
	{"77221", "屙"},
	{"77222", "膠"},
	{"77230", "瓟"},
	{"77231", "爬"},
	{"77232", "尿 限 展 瓝 腞 澩 膼"},
	{"77233", "腿 閼"},
	{"77234", "隩"},
	{"77237", "臾 腴 膇"},
	{"77241", "屏 屖"},
	{"77244", "屢 屢"},
	{"77247", "服 股 屐 閉 孱 殿 骰 履 屨 腏 腶 毈"},
	{"77251", "犀 羼"},
	{"77253", "閥"},
	{"77254", "降"},
	{"77261", "膽"},
	{"77264", "居 胳 屠 骼 腒"},
	{"77266", "層"},
	{"77267", "眉 屇"},
	{"77272", "屈 屆"},
	{"77277", "陷"},
	{"77280", "閡"},
	{"77281", "屣 屣"},
	{"77282", "欣 佽 歋"},
	{"77286", "屭"},
	{"77287", "屄"},
	{"77291", "際"},
	{"77294", "屎 屧"},
	{"77296", "屪"},
	{"77304", "闥"},
	{"77310", "駔 颿"},
	{"77320", "駒 馰 駉 駧 騊 騆 驧"},
	{"77327", "闖 舄 鄏 駶 騧 騶 驈 鷖 鷽 鸒"},
	{"77330", "閟"},
	{"77331", "熙 黳"},
	{"77332", "驟 騄"},
	{"77334", "慇"},
	{"77336", "騷 鱟"},
	{"77337", "悶"},
	{"77340", "馭"},
	{"77347", "馺 駸 騢 騪 驏"},
	{"77362", "駋 騮 騽"},
	{"77364", "駱"},
	{"77394", "騥"},
	{"77400", "閔"},
	{"77401", "聞 閈 媐 閮"},
	{"77404", "婜 嫛 閺"},
	{"77407", "叟 學 殳 閿 闅"},
	{"77409", "閛"},
	{"77427", "舅 鄋"},
	{"77430", "閎 闃"},
	{"77431", "闋"},
	{"77440", "丹 冊"},
	{"77441", "開"},
	{"77442", "閞"},
	{"77447", "段 舁"},
	{"77482", "闕"},
	{"77500", "毋 母"},
	{"77502", "舉 掔"},
	{"77506", "閘 闈 闡 轝"},
	{"77508", "舉"},
	{"77516", "闚"},
	{"77527", "鄆"},
	{"77600", "閫"},
	{"77601", "閤 醫 譽 硻 誾 闇 礐 礜 嚳"},
	{"77602", "留"},
	{"77604", "閣 闍"},
	{"77605", "閽"},
	{"77606", "閭 閶 闣"},
	{"77607", "問 間"},
	{"77621", "閜"},
	{"77627", "鶹"},
	{"77641", "闢"},
	{"77666", "闆"},
	{"77682", "歠"},
	{"77712", "闀 鼩"},
	{"77713", "鼨"},
	{"77714", "閐"},
	{"77716", "閹"},
	{"77717", "巳 巴 鼠 黽"},
	{"77720", "卯 印 即 卵 卿"},
	{"77727", "邸 郾 鷗 鴄 鄳 鴟 鶠"},
	{"77732", "艮 閬 闤"},
	{"77747", "民 毆"},
	{"77750", "毌"},
	{"77752", "鼲"},
	{"77770", "凹 臼"},
	{"77771", "岊"},
	{"77772", "關 嶨"},
	{"77777", "凸 門 閻 镼 閰"},
	{"77782", "歐"},
	{"77801", "巽 與 興 鬨 輿 闐"},
	{"77806", "貫 貿 賢 黌 贀 闠"},
	{"77807", "尺 閃"},
	{"77809", "爨 焛 燢 爂"},
	{"77817", "鼆"},
	{"77827", "鄍 鄮"},
	{"77882", "歟"},
	{"77903", "緊 繄"},
	{"77904", "閑 冞 闑"},
	{"77906", "闌"},
	{"77927", "鄡 鶔"},
	{"77947", "毇"},
	{"78104", "墜"},
	{"78107", "監 鹽 盬"},
	{"78109", "鑒"},
	{"78211", "阼 胙"},
	{"78212", "胣 髊"},
	{"78214", "脞 覹"},
	{"78216", "脫 覽"},
	{"78217", "隘 阣 肐 肐 膉"},
	{"78221", "隃"},
	{"78222", "胗"},
	{"78227", "肣 陯"},
	{"78231", "陰 膴"},
	{"78232", "隊 腍"},
	{"78233", "隧"},
	{"78234", "朕"},
	{"78237", "隒"},
	{"78240", "肸 隞 敶"},
	{"78241", "胼 骿"},
	{"78247", "腹"},
	{"78257", "脢"},
	{"78265", "膳"},
	{"78266", "膾"},
	{"78286", "險 臉"},
	{"78294", "除"},
	{"78314", "駩"},
	{"78316", "駾"},
	{"78321", "騚"},
	{"78322", "駗"},
	{"78334", "愍"},
	{"78336", "驗"},
	{"78337", "駖"},
	{"78340", "驐"},
	{"78341", "駢"},
	{"78364", "騇"},
	{"78366", "驓"},
	{"78391", "駼"},
	{"78604", "暋 睯"},
	{"78700", "臥"},
	{"78727", "鼢"},
	{"78740", "敃"},
	{"78766", "臨"},
	{"78820", "骱"},
	{"78904", "棨"},
	{"79211", "胱"},
	{"79214", "膛 塍"},
	{"79227", "勝 騰 騭"},
	{"79232", "滕"},
	{"79236", "螣"},
	{"79244", "媵"},
	{"79250", "胖"},
	{"79259", "膦"},
	{"79261", "謄"},
	{"79286", "賸"},
	{"79293", "縢"},
	{"79296", "隙"},
	{"79359", "驎"},
	{"80000", "人 入 八"},
	{"80017", "气"},
	{"80101", "企 仝"},
	{"80102", "並"},
	{"80104", "全 坌"},
	{"80107", "盆 益 盒 盦"},
	{"80109", "金 釜"},
	{"80111", "鏕"},
	{"80113", "銃"},
	{"80114", "錐 鐘 鉒"},
	{"80115", "鏟"},
	{"80116", "鏡"},
	{"80117", "氫 氬 氳 鈧"},
	{"80119", "鑫"},
	{"80123", "鑇"},
	{"80127", "翁 翕 爺 鎊 鎬 鏑 鐫 鈁 鈰 翦 錥 鍗 鏞"},
	{"80131", "鑣 鐎"},
	{"80132", "鉉 鑲 銥 鏮"},
	{"80136", "蠤 鐿"},
	{"80137", "鐮 鏣"},
	{"80141", "鋅 鎨"},
	{"80147", "鍍 錞"},
	{"80148", "鉸 鉸"},
	{"80167", "鎕"},
	{"80182", "羨 羡"},
	{"80191", "錼"},
	{"80194", "鏶"},
	{"80200", "丫"},
	{"80207", "丫 今 兮 爹 爹"},
	{"80211", "乍 羌 差 龕"},
	{"80214", "雂"},
	{"80215", "羞"},
	{"80216", "兌"},
	{"80217", "氖 氛 氕 氘 氚 氝 氪 氰"},
	{"80220", "介"},
	{"80221", "斧 俞 前"},
	{"80227", "分 弟 侖 剪 肏 龠"},
	{"80232", "汆 羕"},
	{"80237", "兼"},
	{"80251", "舞"},
	{"80253", "羲"},
	{"80307", "令"},
	{"80317", "忥 氡"},
	{"80331", "怎 恙 羔 無"},
	{"80332", "念 忿 愈 煎"},
	{"80333", "慈"},
	{"80337", "缹"},
	{"80339", "悆"},
	{"80346", "尊"},
	{"80400", "午 父 父"},
	{"80404", "姜"},
	{"80407", "复"},
	{"80408", "傘"},
	{"80414", "雉"},
	{"80427", "氨 禽"},
	{"80430", "矢 奠"},
	{"80431", "美"},
	{"80441", "并"},
	{"80442", "弅"},
	{"80446", "弇"},
	{"80500", "年"},
	{"80501", "羊"},
	{"80502", "拿"},
	{"80507", "每"},
	{"80510", "氟"},
	{"80513", "毓"},
	{"80517", "氧 羶 氠"},
	{"80527", "弚 羛"},
	{"80530", "羹 羹"},
	{"80547", "羻"},
	{"80553", "義"},
	{"80601", "合 酋 首 普 酓"},
	{"80602", "含"},
	{"80604", "舍"},
	{"80605", "善"},
	{"80606", "曾 會 畣"},
	{"80607", "倉"},
	{"80608", "谷"},
	{"80617", "氤 氥"},
	{"80627", "命"},
	{"80661", "韽"},
	{"80717", "乞 爸 氙 瓮 饘"},
	{"80732", "公 食 養 衾 饟"},
	{"80748", "餃"},
	{"80770", "仚 屳"},
	{"80772", "缶 岔 齹"},
	{"80779", "峹 嵞"},
	{"80806", "貪 貧"},
	{"80807", "羑"},
	{"80809", "炃"},
	{"80817", "氦 氮"},
	{"80886", "僉"},
	{"80900", "尒"},
	{"80901", "佘"},
	{"80904", "余"},
	{"80914", "雓"},
	{"80917", "氣 氯"},
	{"80921", "樖"},
	{"80994", "橆"},
	{"81110", "釭"},
	{"81111", "鈚 鉦 鋞 鑨"},
	{"81112", "鉔"},
	{"81113", "鈺"},
	{"81114", "銍"},
	{"81116", "鏂 鑩"},
	{"81117", "鉅 鑪 錏"},
	{"81118", "鋀"},
	{"81120", "釘 鈳 錒"},
	{"81127", "鈣 鎘 釫 錹 鎷 鐪 鑐 鑈"},
	{"81131", "鉲 銩"},
	{"81132", "鋠 鋹 鐻"},
	{"81136", "鑢"},
	{"81140", "釬 釪 鈃 鉺"},
	{"81141", "鑷"},
	{"81143", "鎒"},
	{"81146", "鐔"},
	{"81147", "鈑 鈙 鋄"},
	{"81149", "銔 鏬"},
	{"81153", "鐬"},
	{"81160", "鉆 鉐 銆 鏀"},
	{"81161", "鋙 鍇"},
	{"81162", "鐳"},
	{"81163", "鐕"},
	{"81177", "鍤"},
	{"81186", "鍞 顉"},
	{"81191", "鏢"},
	{"81217", "瓴"},
	{"81261", "龤"},
	{"81286", "頒 籲"},
	{"81317", "甒"},
	{"81386", "領"},
	{"81417", "矩 瓶"},
	{"81418", "短"},
	{"81461", "啎"},
	{"81486", "頩"},
	{"81511", "羥"},
	{"81527", "羺"},
	{"81596", "羱"},
	{"81611", "豅"},
	{"81617", "甑"},
	{"81647", "敆"},
	{"81686", "頜 頷"},
	{"81710", "缸"},
	{"81714", "飪"},
	{"81716", "饇"},
	{"81718", "餖"},
	{"81720", "飣"},
	{"81721", "餰"},
	{"81734", "餪"},
	{"81740", "餌"},
	{"81747", "飯"},
	{"81749", "罅"},
	{"81753", "饖"},
	{"81764", "餂"},
	{"81786", "頌"},
	{"81886", "顩"},
	{"82100", "釧 剉 鈏 鉶 銂 鋓 鍘"},
	{"82110", "釓 釽"},
	{"82113", "銚"},
	{"82114", "錘 鍾 銋 鏙"},
	{"82116", "鑞"},
	{"82118", "鎧 鐙"},
	{"82121", "釿"},
	{"82122", "釤"},
	{"82127", "鏽 鑴"},
	{"82130", "鈲"},
	{"82132", "鎃"},
	{"82135", "鏷"},
	{"82141", "鋌 鋋 錌"},
	{"82143", "鋝"},
	{"82147", "鍰 鍐 鏺 鑀"},
	{"82153", "錚 鐖"},
	{"82160", "錙"},
	{"82161", "銗 鐠"},
	{"82163", "錔 鎦"},
	{"82164", "銛 錉 鍎"},
	{"82169", "鐇"},
	{"82186", "鑕"},
	{"82194", "鑠 鉌"},
	{"82200", "剃"},
	{"82211", "毤"},
	{"82214", "毹"},
	{"82294", "龢"},
	{"82336", "懖"},
	{"82400", "剟"},
	{"82427", "矯"},
	{"82434", "矨"},
	{"82444", "矮"},
	{"82540", "羝"},
	{"82569", "羳"},
	{"82589", "羰"},
	{"82600", "創 劊"},
	{"82700", "刉"},
	{"82714", "飥"},
	{"82734", "飫"},
	{"82744", "餒 餧 餧"},
	{"82753", "饑"},
	{"82800", "劍"},
	{"83100", "釙 鉍 鈊"},
	{"83110", "鈗"},
	{"83111", "鉈 鋎"},
	{"83112", "鋺 鑏"},
	{"83116", "鍹"},
	{"83122", "鏒"},
	{"83127", "鋪"},
	{"83132", "鋐 鋃 銶 鎵"},
	{"83134", "鉥 钀"},
	{"83136", "鏹"},
	{"83140", "釴 鉽 鋱"},
	{"83142", "鎛"},
	{"83144", "銨"},
	{"83147", "鋑"},
	{"83150", "鐵 鉞 鋮 銊 鉾 鋨 鍼 韱 鏚 鑯"},
	{"83153", "錢"},
	{"83160", "鈶"},
	{"83168", "鎔"},
	{"83177", "錧"},
	{"83181", "錠 鑳"},
	{"83186", "鏔 鑌"},
	{"83191", "錝"},
	{"83199", "銢"},
	{"83511", "羦"},
	{"83521", "羜"},
	{"83547", "羧"},
	{"83550", "羢 羬"},
	{"83611", "谾"},
	{"83627", "舖"},
	{"83634", "猷"},
	{"83650", "戧 馘"},
	{"83700", "飶"},
	{"83727", "餔"},
	{"83742", "餺"},
	{"83747", "餕 餕"},
	{"83750", "餓"},
	{"83753", "餞"},
	{"83760", "飴"},
	{"83777", "館"},
	{"84100", "針 釮 鈄 鑆"},
	{"84110", "釷 鋩"},
	{"84111", "銑 鐃 銠 鍖"},
	{"84112", "鈂"},
	{"84114", "銈 錴 錵 鍷 鑝 鑵"},
	{"84117", "釚 鎑 鑉"},
	{"84121", "錡"},
	{"84127", "鈉 鈽 銬 鋤 銪 銙"},
	{"84130", "釱 鈦"},
	{"84131", "鉣 鋕"},
	{"84132", "鈜 鎱"},
	{"84134", "鏌 鐽"},
	{"84138", "鋏"},
	{"84140", "鈸"},
	{"84141", "鑄"},
	{"84142", "鑮"},
	{"84144", "釹 錛"},
	{"84147", "鈹 銌 鋍 錂 鑊 鑊"},
	{"84153", "鑶"},
	{"84154", "鏵"},
	{"84156", "鍏"},
	{"84160", "鈷 錨 鍺"},
	{"84161", "錯 銡 鋯 鎝 鐑"},
	{"84162", "鍣"},
	{"84170", "鉗"},
	{"84181", "鎮 錤"},
	{"84186", "鑽 鐼"},
	{"84190", "銝"},
	{"84193", "鎍"},
	{"84194", "鍱 鐷"},
	{"84196", "鐐"},
	{"84198", "錸"},
	{"84586", "羵"},
	{"84632", "谹"},
	{"84681", "谼"},
	{"84711", "饒"},
	{"84714", "饉 罐"},
	{"84717", "饁"},
	{"84718", "饐"},
	{"84727", "餚"},
	{"84732", "饛"},
	{"84734", "饃"},
	{"84740", "餀"},
	{"84747", "餑"},
	{"84749", "缽"},
	{"84761", "饎"},
	{"84786", "饙 饡"},
	{"84900", "斜"},
	{"85110", "鉎"},
	{"85117", "鈍"},
	{"85127", "錆"},
	{"85130", "鈇 鏈 鈌 鉠"},
	{"85132", "錶 銕"},
	{"85133", "鏸"},
	{"85140", "鍵"},
	{"85143", "鏄"},
	{"85144", "鏤"},
	{"85160", "鈾"},
	{"85174", "鏏"},
	{"85181", "錪"},
	{"85186", "鐨 鐀"},
	{"85190", "銖 銇"},
	{"85196", "鍊 鋉"},
	{"85532", "羠"},
	{"85717", "飩"},
	{"85730", "缺"},
	{"85736", "蝕"},
	{"85786", "饋"},
	{"85796", "餗"},
	{"86100", "釦 鉑 鈿 錮 鈤 銦 銣"},
	{"86110", "鉭 鋧"},
	{"86111", "錕 鎞 鎤"},
	{"86114", "鋰 鑼 鍠 鑸"},
	{"86127", "錫 錦 鍚 鍔 鐲 鋗 鍻 鎉 鐋 鐊 蠲"},
	{"86130", "鍶 鎴"},
	{"86132", "鍡 鐶"},
	{"86134", "鋘"},
	{"86140", "錍"},
	{"86141", "銲 鐸"},
	{"86144", "鏎"},
	{"86147", "鏝 钁"},
	{"86150", "鉀"},
	{"86160", "鋁 錩"},
	{"86180", "鋇"},
	{"86181", "鍉"},
	{"86193", "鏍"},
	{"86194", "錁 鐰"},
	{"86210", "覦"},
	{"86400", "知"},
	{"86411", "矲"},
	{"86527", "羯"},
	{"86600", "智"},
	{"86711", "餛"},
	{"86713", "餽"},
	{"86714", "餭"},
	{"86727", "餳 餲"},
	{"86732", "餵 餵"},
	{"86747", "饅"},
	{"87091", "暩"},
	{"87104", "塑"},
	{"87110", "釩 釔 鉬"},
	{"87111", "鈮"},
	{"87112", "鉋 鉏"},
	{"87113", "鑱"},
	{"87114", "鏗"},
	{"87115", "鈕"},
	{"87117", "錳 鈀 銫"},
	{"87120", "卸 釗 釣 鈞 鉤 鉚 銅 鋼 釸 鈅 鉰 鍆 錭 錋 鋾 鍧 鎙 鑭"},
	{"87122", "鎀 鏐"},
	{"87127", "鍋 鎢 釕 釢 鉹 鋦 鎯 鐍 鷁 鶲 鷑 钃"},
	{"87132", "銀 錄 鐌 鐹 鑗"},
	{"87133", "鉖"},
	{"87134", "鍥 鍭"},
	{"87136", "螸"},
	{"87137", "鎚"},
	{"87140", "釵 銵 鋷"},
	{"87142", "鏘"},
	{"87147", "鍛 釨 鈒 鈱 鋟 錣 鍜 鎪 鎩"},
	{"87150", "鉧"},
	{"87152", "鍕"},
	{"87154", "鋒"},
	{"87160", "銘"},
	{"87162", "鉊"},
	{"87164", "鉻 鋸"},
	{"87177", "錎"},
	{"87181", "鐉"},
	{"87182", "欽 歙"},
	{"87194", "鎳 鍒 鎟"},
	{"87227", "邠 邠 鄃 鳹 鳻 鵜 鸙"},
	{"87280", "歈"},
	{"87282", "歉"},
	{"87320", "翎"},
	{"87327", "鴒 鄦 鶼 鷷 鷡"},
	{"87332", "愬 憌"},
	{"87338", "慾"},
	{"87417", "艵"},
	{"87420", "朔"},
	{"87427", "鄭 郱 鴙 鵧"},
	{"87450", "刱"},
	{"87520", "翔"},
	{"87547", "羖"},
	{"87610", "谻"},
	{"87620", "卻"},
	{"87622", "舒 豂"},
	{"87627", "郃 鴿 郤 鄯 鄫 鄶 鵒 鵨 鶬"},
	{"87682", "欲 欱"},
	{"87710", "飢"},
	{"87712", "飽"},
	{"87713", "饞"},
	{"87720", "飼 餉 飹 餇 餬"},
	{"87731", "餯"},
	{"87734", "餱"},
	{"87747", "餿 餿 餟"},
	{"87752", "餫"},
	{"87762", "餾"},
	{"87777", "餡"},
	{"87781", "饌"},
	{"87782", "飲"},
	{"87810", "俎"},
	{"87882", "歛"},
	{"87904", "槊"},
	{"87914", "糴"},
	{"88100", "鉯"},
	{"88101", "竺 箜"},
	{"88104", "坐 笙 篁 箠 笁 筌 筀 簊 籉"},
	{"88106", "笪"},
	{"88107", "籃 鈖 篕 簋 簠"},
	{"88108", "笠 筮 簦"},
	{"88111", "錓"},
	{"88112", "笵 鎈"},
	{"88113", "筄"},
	{"88114", "銓 銼 籦"},
	{"88116", "銳"},
	{"88117", "筑 鎰 鑑 釳 鎎 籈"},
	{"88120", "箌"},
	{"88123", "箌"},
	{"88127", "鈐 筠 銻 篛 鑰 笉 筇 笻 鉓 錀 簜"},
	{"88132", "鈆 鎡 籙"},
	{"88133", "鐩"},
	{"88134", "鏃"},
	{"88135", "鎂"},
	{"88137", "鈴 鎌"},
	{"88140", "鐓 鏾"},
	{"88141", "鉼"},
	{"88146", "簿 鐏"},
	{"88147", "鍑"},
	{"88153", "籤 籛"},
	{"88157", "鋂"},
	{"88160", "鉛"},
	{"88161", "鉿"},
	{"88162", "鋡"},
	{"88163", "箔 箈"},
	{"88164", "簬"},
	{"88167", "鎗"},
	{"88168", "鋊"},
	{"88169", "籓"},
	{"88171", "篲"},
	{"88181", "篊 鏇 鏦"},
	{"88186", "鐱"},
	{"88192", "鏼"},
	{"88202", "篸"},
	{"88207", "笒 笭"},
	{"88211", "笮 籠 笎 筅 筦 筰 簏"},
	{"88212", "箷"},
	{"88214", "篧 簆 籊 籗"},
	{"88215", "簅"},
	{"88216", "筧"},
	{"88217", "笐 箎 篪 籚 籯"},
	{"88220", "竹"},
	{"88221", "箭 箅"},
	{"88223", "箾"},
	{"88227", "第 筒 筋 篇 篙 簫 簡 籣 籥 笏 笫 筩 筲 箐 篣 篜 篟 篽 篱 簢 簥"},
	{"88232", "篆 籐 笊 籇"},
	{"88233", "箊"},
	{"88234", "笨 篌 簇"},
	{"88237", "簾"},
	{"88240", "攽 敓"},
	{"88243", "符"},
	{"88246", "箯 簰"},
	{"88247", "笈 箙"},
	{"88248", "筱"},
	{"88253", "筏 箴 篾"},
	{"88261", "簷"},
	{"88281", "簁"},
	{"88293", "篠"},
	{"88294", "篨"},
	{"88302", "簻 籩"},
	{"88303", "篴 籧"},
	{"88304", "篷"},
	{"88306", "簉"},
	{"88311", "篞"},
	{"88323", "鱭"},
	{"88327", "篤"},
	{"88340", "敜"},
	{"88341", "等"},
	{"88343", "篿"},
	{"88401", "竿 竽 筵 筳 筸"},
	{"88404", "簍"},
	{"88406", "箄 簟"},
	{"88407", "夎"},
	{"88408", "笅 筊 箤"},
	{"88414", "籬 矬"},
	{"88427", "竻 篘 簩 闟"},
	{"88432", "笑 箛"},
	{"88438", "筴"},
	{"88441", "笄 笲 簳"},
	{"88442", "簙"},
	{"88446", "算"},
	{"88447", "笯"},
	{"88448", "籔"},
	{"88463", "笳 筎"},
	{"88486", "矰"},
	{"88500", "笚"},
	{"88502", "篫"},
	{"88503", "箋"},
	{"88504", "篳"},
	{"88506", "簞"},
	{"88507", "筆 箏"},
	{"88512", "範 箍"},
	{"88521", "羭"},
	{"88527", "羒 笰"},
	{"88537", "羚"},
	{"88540", "敏"},
	{"88541", "籜"},
	{"88557", "篝"},
	{"88561", "簎"},
	{"88562", "籀"},
	{"88563", "筘"},
	{"88575", "箝"},
	{"88582", "簌 簐"},
	{"88586", "簼 羷"},
	{"88600", "簂"},
	{"88601", "答 簪 簪 笘 筶"},
	{"88602", "笤 箵"},
	{"88603", "笛 笞 箇 笝 箘"},
	{"88604", "箸 筈 箬"},
	{"88606", "筥 簹"},
	{"88608", "簭"},
	{"88621", "笴"},
	{"88623", "劄"},
	{"88627", "筍 笥 笱 篰"},
	{"88629", "篎"},
	{"88640", "豃"},
	{"88641", "籌"},
	{"88662", "谽"},
	{"88710", "笀"},
	{"88711", "筐 篦 笓 篚"},
	{"88712", "笣 篹"},
	{"88713", "篋"},
	{"88715", "饈"},
	{"88716", "笸"},
	{"88717", "笆 餼"},
	{"88721", "籪"},
	{"88727", "飭 節 飾 篩"},
	{"88732", "簑 篡 筤"},
	{"88741", "餅"},
	{"88747", "笢"},
	{"88777", "管"},
	{"88782", "餩"},
	{"88794", "餘"},
	{"88801", "箕 箑 簨 籅"},
	{"88806", "簧 簣 篔 篢 簀 籫"},
	{"88840", "斂"},
	{"88847", "簸"},
	{"88886", "簽"},
	{"88901", "篻"},
	{"88902", "策"},
	{"88903", "繁 纂"},
	{"88904", "築 筡 篥 瀪"},
	{"88906", "簝"},
	{"88908", "箂"},
	{"88914", "籮"},
	{"88920", "筣"},
	{"88927", "箹 簃"},
	{"88934", "筷"},
	{"88940", "敘"},
	{"88961", "籍"},
	{"88963", "箱"},
	{"88986", "籟"},
	{"88994", "箖"},
	{"89111", "銧"},
	{"89112", "錈"},
	{"89114", "鏜"},
	{"89116", "鎲"},
	{"89120", "鈔"},
	{"89127", "銷 鋿 鐒"},
	{"89131", "钂"},
	{"89150", "鉡"},
	{"89159", "鏻"},
	{"89166", "鐺"},
	{"89180", "鍬 鈥"},
	{"89186", "鎖"},
	{"89189", "錟"},
	{"89194", "銤 鏿 鑅"},
	{"89789", "餤"},
	{"89794", "饓"},
	{"90000", "小"},
	{"90010", "忙"},
	{"90014", "惟 憧"},
	{"90023", "懠"},
	{"90027", "慵"},
	{"90030", "忭"},
	{"90031", "憔"},
	{"90032", "慷 惤 懁 懹"},
	{"90036", "憶"},
	{"90046", "慞"},
	{"90047", "惇"},
	{"90048", "悴 恔"},
	{"90061", "惦 愔"},
	{"90063", "慉"},
	{"90086", "懭"},
	{"90094", "懍"},
	{"90096", "惊"},
	{"90104", "堂"},
	{"90200", "少"},
	{"90211", "光 麊"},
	{"90214", "雀"},
	{"90216", "党"},
	{"90227", "肖 券 尚 常 帣 觠"},
	{"90232", "豢"},
	{"90240", "牚"},
	{"90300", "尐"},
	{"90331", "黨"},
	{"90336", "鯗"},
	{"90427", "劣"},
	{"90430", "尖"},
	{"90500", "半 牶"},
	{"90502", "拳 掌"},
	{"90506", "韏"},
	{"90601", "嘗"},
	{"90602", "省"},
	{"90603", "眷"},
	{"90606", "當"},
	{"90712", "卷"},
	{"90717", "瓽"},
	{"90727", "弮"},
	{"90732", "裳"},
	{"90772", "齤"},
	{"90800", "火"},
	{"90801", "糞 烡"},
	{"90806", "賞"},
	{"90809", "炎"},
	{"90811", "熝"},
	{"90814", "炷"},
	{"90817", "炕"},
	{"90827", "熇 熵"},
	{"90831", "燋 爊"},
	{"90832", "炫 爙"},
	{"90836", "燱"},
	{"90841", "炆"},
	{"90843", "焞"},
	{"90847", "焲"},
	{"90848", "焠"},
	{"90861", "焙"},
	{"90867", "煻"},
	{"90882", "烗"},
	{"90886", "爌"},
	{"90889", "焱"},
	{"90903", "絭"},
	{"90904", "米 棠 燊"},
	{"90918", "粒"},
	{"90932", "糠"},
	{"90948", "粹"},
	{"90967", "糖"},
	{"91011", "怔 忨 恇 悱"},
	{"91013", "愜"},
	{"91014", "慨 愝"},
	{"91016", "恆 慪"},
	{"91017", "恆"},
	{"91019", "怌"},
	{"91027", "懦 怲"},
	{"91032", "悵 懅"},
	{"91034", "懨"},
	{"91041", "懾"},
	{"91046", "悼 憛"},
	{"91047", "懮"},
	{"91049", "怦"},
	{"91060", "怗 恓 愐"},
	{"91061", "悟 恉 憯"},
	{"91066", "愊"},
	{"91086", "愩"},
	{"91090", "怀"},
	{"91091", "慓"},
	{"91094", "慄 憟"},
	{"91217", "甐"},
	{"91486", "類"},
	{"91547", "叛"},
	{"91586", "頖"},
	{"91686", "顲"},
	{"91810", "灴"},
	{"91811", "炡 烴"},
	{"91814", "煙 爧"},
	{"91816", "烜 熰"},
	{"91817", "炬 爐"},
	{"91821", "烆"},
	{"91827", "炳 燸"},
	{"91832", "烼"},
	{"91846", "焯 燂"},
	{"91860", "煔"},
	{"91861", "焐 焟 熸"},
	{"91886", "煩 顃"},
	{"91891", "熛"},
	{"91917", "粔 糮"},
	{"91927", "糯 糲"},
	{"91932", "粻"},
	{"91946", "粳"},
	{"91947", "粄"},
	{"91960", "粘 粨"},
	{"91963", "粞"},
	{"91986", "纇"},
	{"92000", "惻 懰"},
	{"92013", "恌"},
	{"92014", "慛"},
	{"92018", "愷"},
	{"92021", "慚 忻"},
	{"92022", "憉"},
	{"92027", "惴 憍"},
	{"92033", "悿"},
	{"92034", "慀"},
	{"92040", "忏 忯"},
	{"92047", "悸 惾 愋"},
	{"92063", "惱"},
	{"92064", "恬 惛"},
	{"92070", "忷"},
	{"92077", "慆"},
	{"92086", "懫"},
	{"92200", "削 粼"},
	{"92210", "亃"},
	{"92500", "判"},
	{"92502", "揱"},
	{"92800", "剡"},
	{"92813", "烑"},
	{"92814", "煄"},
	{"92817", "熩"},
	{"92818", "燈"},
	{"92821", "炘"},
	{"92822", "烿"},
	{"92827", "煸 煓 燆"},
	{"92831", "燻"},
	{"92841", "烶 烻"},
	{"92846", "爝"},
	{"92847", "煖 烰 燰"},
	{"92861", "敥"},
	{"92869", "燔"},
	{"92894", "爍"},
	{"92900", "粌"},
	{"92914", "粍"},
	{"92917", "虩"},
	{"92940", "粁"},
	{"93000", "怭"},
	{"93011", "悾"},
	{"93012", "惋"},
	{"93014", "憱"},
	{"93016", "愃"},
	{"93021", "懧"},
	{"93022", "慘"},
	{"93027", "惼"},
	{"93032", "悢"},
	{"93034", "悷"},
	{"93035", "憾"},
	{"93047", "悛 愯"},
	{"93050", "懺 怴 悈 懱"},
	{"93060", "怡"},
	{"93064", "愘"},
	{"93077", "悺"},
	{"93091", "悰 悰"},
	{"93094", "怵"},
	{"93136", "蠽"},
	{"93800", "烞"},
	{"93811", "烷 焥 焢"},
	{"93814", "烢"},
	{"93827", "煽 烳"},
	{"93832", "烺"},
	{"93833", "燃"},
	{"93847", "焌 焌"},
	{"93850", "熾 烒 煘"},
	{"93868", "熔"},
	{"93922", "糝"},
	{"93936", "糨"},
	{"93942", "糐"},
	{"93991", "粽"},
	{"94000", "忖"},
	{"94011", "慌 恅 愖 憢"},
	{"94012", "忱"},
	{"94014", "懂 慬 懽"},
	{"94027", "怖 惰 慟 怮 悕 愶 慲"},
	{"94030", "忕"},
	{"94031", "怯"},
	{"94032", "懷 懞"},
	{"94034", "慔 慡 熯"},
	{"94036", "慥"},
	{"94041", "恃 悻 懤"},
	{"94047", "悖 忮"},
	{"94056", "愅"},
	{"94060", "怙"},
	{"94061", "惜 恄 悎"},
	{"94062", "懵"},
	{"94067", "慒"},
	{"94081", "慎 懥 懻"},
	{"94086", "憤"},
	{"94089", "恢"},
	{"94090", "恘 惏"},
	{"94094", "惵"},
	{"94096", "憭"},
	{"94104", "墯"},
	{"94800", "炓"},
	{"94811", "燒 烍 煁"},
	{"94814", "烓 煃 爟"},
	{"94817", "熆"},
	{"94822", "爩"},
	{"94827", "烤 烯 烠 熁 燤"},
	{"94835", "煐"},
	{"94841", "燽"},
	{"94854", "燁"},
	{"94856", "煂"},
	{"94881", "烘"},
	{"94886", "熿 燲"},
	{"94890", "炑"},
	{"94894", "煤 煠"},
	{"94896", "燎"},
	{"94900", "料 籵 籿"},
	{"94927", "糒 糷"},
	{"94934", "糢"},
	{"94936", "糙"},
	{"94944", "籹"},
	{"95006", "忡"},
	{"95010", "性"},
	{"95017", "忳"},
	{"95027", "怫 情"},
	{"95030", "快 怏 怢"},
	{"95032", "恞"},
	{"95033", "憓"},
	{"95036", "爞"},
	{"95043", "慱"},
	{"95044", "慺"},
	{"95047", "悽"},
	{"95060", "怞"},
	{"95086", "憒"},
	{"95093", "愫"},
	{"95096", "悚"},
	{"95817", "燼 灺 炖"},
	{"95827", "熽"},
	{"95830", "炔 炴"},
	{"95840", "煡"},
	{"95844", "熡"},
	{"95856", "煒"},
	{"95896", "煉"},
	{"95900", "粀"},
	{"95927", "精"},
	{"95966", "糟"},
	{"95990", "粖"},
	{"96000", "怕 怬 恛 悃 慖"},
	{"96010", "怛 怳"},
	{"96011", "惃"},
	{"96013", "愧"},
	{"96014", "惺 惶 懼 悝 悜"},
	{"96017", "慍 悒"},
	{"96027", "惕 愣 愕 愒 悁"},
	{"96030", "熜"},
	{"96032", "愄 懪"},
	{"96041", "悍 懌"},
	{"96047", "慢 戄"},
	{"96054", "熚"},
	{"96056", "憚"},
	{"96081", "惿"},
	{"96094", "惈 懆"},
	{"96096", "憬"},
	{"96810", "炟 覢"},
	{"96811", "焜 熀"},
	{"96812", "炾"},
	{"96814", "煌 爅"},
	{"96815", "煋"},
	{"96817", "熅"},
	{"96818", "煜"},
	{"96827", "煬 燭 焆 焨 煟"},
	{"96830", "熄"},
	{"96832", "煨 煨 爆"},
	{"96840", "焺"},
	{"96841", "焊 燡"},
	{"96847", "熳"},
	{"96856", "燀"},
	{"96860", "煰"},
	{"96881", "熼"},
	{"96886", "熉"},
	{"96894", "燥"},
	{"96900", "粕 糰"},
	{"96910", "粯"},
	{"96914", "糧 粴"},
	{"96934", "糗"},
	{"96940", "粺"},
	{"96964", "糬"},
	{"96994", "粿"},
	{"97010", "恤 怚"},
	{"97011", "怩"},
	{"97012", "怉"},
	{"97014", "怪 慳 熞"},
	{"97015", "忸"},
	{"97016", "悗"},
	{"97017", "憴"},
	{"97020", "恫 惘 惆 憫 忉 忉 怐 恂 恟 恦 憪"},
	{"97022", "憀"},
	{"97027", "恀 悀 愲 憰"},
	{"97032", "恨 惚"},
	{"97034", "懊"},
	{"97036", "慅"},
	{"97040", "怓"},
	{"97046", "憳"},
	{"97047", "忣 怋 惙 惸"},
	{"97052", "懈 惲"},
	{"97061", "憺"},
	{"97062", "怊 慴"},
	{"97064", "恪"},
	{"97072", "愮"},
	{"97080", "慏"},
	{"97082", "忺"},
	{"97086", "慣 懶"},
	{"97136", "蟞"},
	{"97214", "耀"},
	{"97220", "翷"},
	{"97227", "鄰"},
	{"97256", "輝"},
	{"97301", "蹩"},
	{"97327", "鷩"},
	{"97330", "憋"},
	{"97336", "鱉"},
	{"97434", "獘"},
	{"97717", "鄨"},
	{"97727", "彆"},
	{"97810", "烅"},
	{"97812", "炮"},
	{"97814", "燿"},
	{"97815", "炄"},
	{"97818", "熤"},
	{"97820", "灼 炯 燜 爛 灱 烔 燘 爓"},
	{"97827", "焗 郯 熪 燏"},
	{"97832", "熥"},
	{"97833", "炵"},
	{"97834", "煥 燠"},
	{"97846", "燖"},
	{"97847", "煆 燬"},
	{"97850", "煇"},
	{"97854", "烽"},
	{"97862", "炤 熠"},
	{"97864", "烙"},
	{"97867", "煝"},
	{"97877", "焰"},
	{"97880", "焮 熐"},
	{"97882", "炊 欻"},
	{"97894", "燦 煣"},
	{"97910", "粗 籸"},
	{"97915", "粈"},
	{"97917", "粑"},
	{"97920", "糊 粅 粡"},
	{"97927", "糈 糑"},
	{"97936", "糔"},
	{"97940", "粣"},
	{"97947", "籽"},
	{"97994", "糅"},
	{"98011", "怍"},
	{"98014", "恮"},
	{"98016", "悅"},
	{"98017", "愾 忔"},
	{"98019", "惍"},
	{"98021", "愉"},
	{"98027", "悌 忴 惀 愓"},
	{"98031", "憮"},
	{"98032", "忪 懩"},
	{"98037", "怜 慊"},
	{"98040", "忤 憿"},
	{"98041", "恲"},
	{"98047", "愎"},
	{"98055", "悔"},
	{"98061", "恰"},
	{"98066", "憎"},
	{"98067", "愴"},
	{"98086", "憸"},
	{"98092", "憡"},
	{"98094", "悇"},
	{"98211", "斃"},
	{"98227", "幣"},
	{"98240", "敝 敞"},
	{"98336", "鱉"},
	{"98404", "嫳"},
	{"98444", "弊"},
	{"98604", "瞥"},
	{"98710", "氅"},
	{"98811", "炸"},
	{"98814", "烇"},
	{"98816", "爦"},
	{"98817", "熂 爁"},
	{"98827", "炩 焍 爚"},
	{"98832", "炂"},
	{"98833", "燧"},
	{"98840", "燉"},
	{"98846", "燇"},
	{"98851", "烊"},
	{"98853", "燨 爔"},
	{"98857", "烸"},
	{"98861", "烚 煪 熗"},
	{"98862", "焓"},
	{"98866", "燴"},
	{"98868", "焀"},
	{"98917", "籺"},
	{"98921", "糋"},
	{"98927", "粉"},
	{"98931", "糕"},
	{"98940", "敉"},
	{"98964", "糌"},
	{"99011", "恍"},
	{"99012", "惓"},
	{"99027", "悄 惝"},
	{"99031", "戃"},
	{"99050", "怑"},
	{"99059", "憐"},
	{"99080", "愀"},
	{"99089", "惔"},
	{"99094", "爃"},
	{"99103", "瑩"},
	{"99104", "塋"},
	{"99109", "鎣"},
	{"99136", "螢"},
	{"99216", "覮"},
	{"99227", "膋"},
	{"99232", "滎"},
	{"99327", "鶯"},
	{"99404", "嫈"},
	{"99407", "燮"},
	{"99417", "煢"},
	{"99427", "勞"},
	{"99441", "筭"},
	{"99502", "犖"},
	{"99601", "謍 醟"},
	{"99606", "營"},
	{"99717", "甇"},
	{"99732", "褮"},
	{"99772", "罃"},
	{"99809", "熒"},
	{"99820", "炒"},
	{"99831", "爣"},
	{"99859", "燐"},
	{"99880", "煍"},
	{"99889", "燚"},
	{"99901", "禜"},
	{"99903", "縈"},
	{"99904", "榮"},
	{"17227", "乃 甬 邪 帚 胥 弼 粥 鴉 鄹 鶸 酈 夃 邧 邴 脀 鄁 鳭 鄠 鄝 殦 鼐 翯 鴯 鷊 鶺 糱 鬻 鷚 鷸 鸍 鸐 鸝"},
	{"27220", "勿 仞 卯 仰 向 伺 佣 佝 匍 徇 們 豹 夠 御 僩 仴 彴 彴 甪 侗 侗 侚 牁 倗 倜 徟 翗 翽 齁"},
	{"37120", "汐 泖 洞 洶 洵 凋 淘 湖 溯 潮 潤 澗 瀾 汋 沏 沕 泂 泃 泀 浻 淜 淗 淍 渹 澖 潣 灁 灛"},
	{"44227", "芳 芬 芾 荔 帶 莠 莆 菁 蒂 萵 葡 幕 蒿 蓆 蓊 蕭 幫 薦 繭 勸 藺 蘭 芀 艿 芮 芴 勀 苪 狶 茼 荋 莃 莦 棼 菵 菕 菺 菛 葋 萭 萹 萳 蒡 蒚 蒻 蓇 蒨 蔏 蔕 蓨 蓹 獦 獦 蕄 蕑 蕎 薌 薚 薡 薷 薾 蘥 虋"},
	{"67020", "叩 叨 叼 吻 明 昀 唧 晌 啕 啣 啁 喲 嘲 呁 旳 呴 昒 哃 哅 咰 昫 畇 盷 眴 嗍 睭 瞷 嚪"},
	{"77227", "局 屑 骨 腎 閒 鬧 臀 鵬 屬 釁 咼 屌 帠 郕 郈 陊 屙 郳 郿 閍 腡 鳲 鼏 膷 屩 鶋 鶌 鵰 鵩 鵳 鶂 觷 鶞 鶻 鷵 鷴 鷳"},
	{NIL_PTR}
};
