unit Clanky;
{$I defines.inc}
{$R-}
{$Q-}
{$S-}
interface
uses Vaznik;

type
     pclanek = ^tclanek;
     tclanek = record
     pocet_radek:longint;
     nadpis:pstring;
     text:pchar;
     end;

     tdpole = array[0..0] of pointer;
     pdpole = ^tdpole;


Function Nacti_Data(co:string):pdpole;
Function hlll(hl:pdpole;s:string):PClanek;
Function hlla(const s:string):string;
Function hllp(hl:pdpole;const s:string):pchar;
Function hllp(const s:string):pchar;

var vaznik_s_hlaskami:pdpole;
    otazniky:string[2];
    clKonecRadky:string[5];
    CL_bylo_nalezeno:boolean;

implementation
uses FnFont2,Lacrt,tedradky;

const CL_NENALEZENO = '???';

Function Trideni_S(p,q:pointer):boolean;
var v1,v2:pclanek;
begin
v1:=p;v2:=q;
Trideni_S:=v1^.nadpis^<v2^.nadpis^;
end;

Function DoPole(p:PVaznik):pdpole;
var d:pdpole;
    i,j:longint;

    e:PClanek;

begin
i:=p^.pocet;
GetMem(d,(i+1)*4);
d^[0]:=pointer(i);
j:=1;
p^.Reset;
while not p^.Konec do
   begin
   e:=p^.Nacti;
   d^[j]:=e;
   inc(j);
   end;
DoPole:=d;
end;


Function Nacti_Data(co:string):pdpole;
var f:text;
    s:string;
    p:PVaznik;
    v:pclanek;
    e:PEdRadek;
    h:pchar;
    hd,hn0,hnx:longint;
    bylo_prazdnych_radku,a:byte;
    byl_uz_nejaky_titulek:boolean;

begin
Assign(f,co);
Reset(f);
p:=NovyVaznik;
p^.porovnejproc:=@Trideni_S;
e:=nil;
byl_uz_nejaky_titulek:=false;
while not Eof(f) do
   begin
   hd:=NactiRadkuTextovehoSouboru(f,h);
   hn0:=Prvni_za_mezerami(h);

   if hn0=-1
      then if byl_uz_nejaky_titulek=true then inc(bylo_prazdnych_radku)
      {Co delat s uplne prazdnymi radky? Kdyz jsou mezi ne-prazdnymi
       radky, tak je proste chape jako prazdne radky. Kdyz jsou ale na
       konci clanku, tak je vyradime, protoze je povazujeme za formatovaci
       zalezitost vlozenou pro lepsi prehlednost clankoveho souboru.
       Pokus skutecne chces prazdne radky na konci, tak je vloz do
       pascalovskych uvozovek ' '}
      else
   else begin  {hd<>0}
   if h[hn0]='#' then  {1.varianta - radek zacina znakem #}
      begin
      s:=h;                  {vime, ze neb++udeme delsi nez 255 znaku...}
      s:=SkipAllSpaces(s);   {...takze prevod na string pro lepsi manilulaci}
      if s[2]<>'#' then    {zacatek ## se bude chapat jako komentar}
         begin
         byl_uz_nejaky_titulek:=true;
         if e<>nil then
            begin          {uzaveni rozdelaneho clanku (abychom byli pripraveni na novy)}
            v^.text:=e^.p;      {nutne - pri e^.VlozS se muze menit e^.p}
            e^.p:=nil;
            Dispose(e,Done);
            end;
         delete(s,1,1);
         s:=Convert_down(s);
         bylo_prazdnych_radku:=0;
         new(v);
         e:=New(PEdRadek,Init);
         v^.nadpis:=NaPstring(s);
         v^.text:=e^.p;
         v^.pocet_radek:=0;
         p^.InsertSort(v);
         end;
      end
      else begin    {2.varianta - na zacatku radky neni #}
      if byl_uz_nejaky_titulek=true then
         begin
         hnx:=Posledni_pred_Mezerami(h,hd);
         if h[hn0]=#39     {znak "'"}
             then begin
                  inc(hn0);
                  dec(hnx);
                  end
                  else begin
                  {hn0:=0;
                  hnx:=hd;}
                  end;

         if bylo_prazdnych_radku<>0 then
            begin
            inc(v^.pocet_radek,bylo_prazdnych_radku);
            for a:=1 to bylo_prazdnych_radku do e^.VlozS(#13#10,e^.spp);
            bylo_prazdnych_radku:=0;
            end;
         inc(v^.pocet_radek);
         if v^.pocet_radek<>1 then e^.VlozS(#13#10,e^.spp);
         e^.Vloz(@h[hn0],hnx-hn0+1,e^.spp);
         end;
      end;
   end;
   FreeMem(h);
   end;
v^.text:=e^.p;      {nutne - pri e^.VlozS se muze menit e^.p}
e^.p:=nil;
Dispose(e,Done);
Close(f);
Nacti_Data:=DoPole(p);
Vaznik_Done_All(p);
end;


Function hlll(hl:pdpole;s:string):PClanek;
var i,j,a:longint;
    v:pclanek;
begin
j:=longint(hl^[0]);
i:=1;
s:=Convert_down(s);
CL_bylo_nalezeno:=true;
repeat
a:=(j+i) div 2;
v:=hl^[a];
if s<v^.nadpis^ then j:=a-1 else
if s>v^.nadpis^ then i:=a+1 else
if s=v^.nadpis^ then Exit(v);
until j-i<0;
CL_bylo_nalezeno:=false;
hlll:=nil;
end;

Function hllp(hl:pdpole;const s:string):pchar;
var i,j,a:longint;
    v:pclanek;
begin
v:=hlll(hl,s);
if v=nil then hllp:=CL_NENALEZENO else hllp:=v^.text;
end;

Function hlla(const s:string):string;
var p:pchar;
begin
p:=hllp(vaznik_s_hlaskami,s);
hlla:=p;
end;

Function hllp(const s:string):pchar;
begin
hllp:=hllp(vaznik_s_hlaskami,s);
end;

end.
