unit Vaznik;
{$I defines.inc}
interface
uses Objects;       {jsen kvuli operacim se soubory}
type



ActionType = procedure(var p:pointer);
SizeDetectproc = function(p:pointer):longint;

Pvaznik = ^Tvaznik;
Tvaznik = object
    dalsi:Pvaznik;
    predchozi:Pvaznik;
    vazba:pointer;
    Constructor Init(_pre,_dal:PVaznik);
    Function InitNext(q:pointer):PVaznik;
    Procedure Insert(p:PVaznik);
    Procedure InsertNew(q:pointer);
    Function OsetriZacykleni:pointer;virtual;
    Function Vem:PVaznik;               {vem:=dalsi}
    Function SearchFirst:PVaznik;
    Function SearchLast:PVaznik;
    Function SearchRecord(id:integer):PVaznik;
    Function PocetPrvku:longint; {hlava se nezapocitava}
    Procedure PozpatkuPrvky;
    Procedure For_Each(action:ActionType);
    Function Je_ve_vazniku(p:pvaznik):boolean;
    Function Kolikaty_ve_Vazniku(p:pvaznik):longint; {pokud neni, vraci -1}
    Function Kolik_prede_mnou:longint;
    Function DejDalsi:PVaznik;
    Function DejPredchozi:Pvaznik;
    Function Duplicate:Pvaznik;
    Procedure Setrid;
    Destructor Done;
    end;

PStrom = ^TStrom;
TStrom = object(TVaznik)
    rodic,potomek:Pstrom;
    skok:PStrom;         {korenova polozka ukazuje na posledni a vsechny ostatni na prvni}
    Constructor Init(_rod,_pre,_dal:PStrom);
    Function InitNext(q:pointer):PStrom;
    Procedure Insert(p:PStrom);
    Function InitOffspring(q:pointer):PStrom;
    Function SearchFirst:PStrom;
    Function SearchLast:PStrom;
    Function Search_Offsprings(p:pointer):PStrom;
    Function Search_Parents(p:pointer):PStrom;
    Function Root:PStrom;
    Function Deepness(p:Pstrom):longint;
    Function Save(s:string):byte;
    Function Load(s:string):byte;       {st_OK nebo st_BADFORMAT}
    Function Num_Childerns:longint;
    Function Num_Offsprings:longint;
    Function Vem:Pstrom;                {vem:=potomek^.dalsi}
    Procedure InzertVaznik(p:PVaznik);  {Pripoji jenom vazby}
    Procedure PridejPodstrom(p:Pstrom); {Pripoji primo jednotlive prvky}
    Procedure PozpatkuPrvky;
    Function Linearize:PVaznik;
    Procedure For_Each(action:ActionType);
    Function DejDalsi:PStrom;
    Function DejPredchozi:Pstrom;
    Function Vaznik_z_predku:PVaznik;
    Function Duplicate:Pstrom;
    Destructor Done;

    { Tyto procedury se budou v potomcich predefinovavat podle typu dat }
    { V teto zakladni forme ovladaji typ PString  }
    end;

pstring=^string;

const
    st_OK                     = 0;
    st_NOT_FOUND              = 1;
    st_NOT_EMPTY              = 2;
    st_NO_DATA                = 3;
    st_DATA_SIZE_NOT_ASSIGNED = 4;
    st_BADFORMAT              = 5;
    st_FILENOTEXIST           = 6;

    st_VERZESOUBORU = 1;
    st_BUFFERSIZE = $4000;


Function StromDef(p:PStrom):PStrom;
Function SvazejS(p:PStrom):PStrom;
Function Vetev(objekt:pointer;spodek,dal:PStrom):PStrom;
Function UzelS(objekt:pointer;dal:PStrom):PStrom;
Function Uzel(objekt:pointer;dal:PVaznik):PVaznik;
Function Svazej(p:PVaznik):PVaznik; {Vaze uzly}
{Urceno k takovymto definicim:
<uses Strings>
p:=Svazej(
   Uzel(StrNew('prvni polozka'),
   Uzel(StrNew('druha polozka'),
   Uzel(StrNew('treti polozka'),
   Uzel(StrNew('ctvrta polozka'),
   Uzel(StrNew('pata polozka'),nil))))));
}
Procedure Vaznik_Done_All(var p:PVaznik);
Procedure Vaznik_Done_All(var p:PVaznik;action:ActionType);
Procedure Strom_Done_All(var p:PStrom;action:ActionType);
Procedure Skomprimuj(var p:PVaznik;sz:SizeDetectproc);
Procedure SkomprimujPStringy(var p:PVaznik);

var procSortComp:function(p,q:pointer):boolean;
    procMySizeOf:function(p:pointer):longint;
    procSaveMyData:procedure(f:PBufStream;p:pointer;j:longint);
    procSaveHeaderOfMyData:procedure(f:PBufStream);
    procLoadHeaderOfMyData:function(f:PBufStream):boolean;
    procLoadMyData:function(f:PBufStream):pointer;
    procCompMyData:function(p,q:pointer):boolean;


implementation
const tkadlo:PVaznik = nil;
      skadlo:PStrom = nil;
      seznam_vetveni:PVaznik = nil; {funguje jako zasobnik (LIFO)}

Constructor TVaznik.Init(_pre,_dal:PVaznik);
begin                        { Zalozi uzel }
predchozi:=_pre;
dalsi:=_dal;
vazba:=nil;
end;

Function TVaznik.OsetriZacykleni:pointer;
begin
OsetriZacykleni:=nil;
end;

Function TVaznik.Vem:PVaznik;
begin
Vem:=DejDalsi;
end;

Function TVaznik.SearchLast:PVaznik;
var p,q:PVaznik;               { Vrati uzel na posledni uzel seznamu }
begin
p:=@self;
q:=p;
while p^.dalsi<>nil do
   if p^.dalsi<>q then p:=p^.dalsi else  { Osetreni zacykleni. Nikdy by nemelo nastat. }
      begin
      SearchLast:=p^.OsetriZacykleni;
      Exit;
      end;
SearchLast:=p;
end;

Function TVaznik.SearchFirst:PVaznik;
var p,q:PVaznik;               { Vrati odkaz na prvni uzel seznamu }
begin
p:=@self;
q:=p;
while p^.predchozi<>nil do
   if p^.predchozi<>q then p:=p^.predchozi else  { Osetreni zacykleni. Nikdy by nemelo nastat. }
      begin
      SearchFirst:=p^.OsetriZacykleni;
      Exit;
      end;
SearchFirst:=p;
end;

Function TVaznik.InitNext(q:pointer):PVaznik;
var p:PVaznik;               { Vlozi dalsi uzel na konec seznamu }
begin
p:=SearchLast;
p^.dalsi:=New(PVaznik, Init(p, nil));
p^.dalsi^.vazba:=q;
InitNext:=p^.dalsi;
end;

Procedure TVaznik.Insert(p:PVaznik);
var q:PVaznik;
    x:pointer;
begin  { Vlozi dalsi (existujici) uzly mezi volany (self) a jeho naslednika }
x:=p^.dalsi;
q:=p^.SearchLast;
q^.dalsi:=dalsi;
p^.predchozi:=@self;
if dalsi<>nil then dalsi^.predchozi:=q;
if (p^.predchozi=nil) and (x<>nil) then dalsi:=p^.dalsi else dalsi:=p;
end;

Procedure TVaznik.InsertNew(q:pointer);
var p:PVaznik;
begin
p:=New(PVaznik,Init(nil,nil));
p^.vazba:=q;
Insert(p);
end;

Function TVaznik.DejDalsi:PVaznik;
begin
DejDalsi:=dalsi;
end;

Function TVaznik.DejPredchozi:PVaznik;
begin
DejPredchozi:=predchozi;
end;


Function TVaznik.SearchRecord(id:integer):PVaznik;
var a:PVaznik;
    b:integer;
begin
a:=@self;
for b:=1 to id do a:=a^.dalsi;
SearchRecord:=a;
end;

Function TVaznik.Je_ve_vazniku(p:pvaznik):boolean;
begin
while p<>nil do
   begin
   if p=@self then Exit(true);
   p:=p^.dalsi;
   end;
Je_ve_vazniku:=false;
end;

Function TVaznik.Kolikaty_ve_Vazniku(p:pvaznik):longint;
var l:longint;
begin
l:=0;
while p<>nil do
   begin
   if p=@self then Exit(l);
   p:=p^.dalsi;
   inc(l);
   end;
Kolikaty_ve_Vazniku:=-1;
end;

Function TVaznik.Kolik_prede_mnou:longint;
var l:longint;
    p:PVaznik;
begin
p:=@self;
l:=0;
while p^.predchozi<>nil do
   begin
   inc(l);
   p:=p^.predchozi;
   end;
Kolik_prede_mnou:=l;
end;


Function TVaznik.PocetPrvku:longint;
var a:PVaznik;         {Zjisti pocet uzlu v seznamu. Hlava se nezapocitava}
    b:longint;
begin
a:=dalsi;
b:=0;
while a<>nil do begin inc(b);a:=a^.dalsi;end;
PocetPrvku:=b;
end;

Procedure TVaznik.PozpatkuPrvky;
var p,q:PVaznik;
    v2:pointer;
begin
p:=Pstrom(SearchLast);
q:=@self;
if p=q then Exit;
if q^.predchozi=nil then q:=q^.DejDalsi;
while 1=1 do
   begin
   v2:=p^.vazba;
   p^.vazba:=q^.vazba;
   q^.vazba:=v2;
   p:=p^.predchozi;
   q:=q^.dalsi;
   if (p=q) or (p^.dalsi=q) then Exit;
   end;
end;

Procedure TVaznik.For_each(action:ActionType);
var p:pvaznik;
begin
if action=nil then Exit;
p:=dalsi;
while p<>nil do
   begin
   action(p^.vazba);
   p:=p^.dalsi;
   end;
end;

Function TVaznik.Duplicate:Pvaznik;
var p,q,r:PVaznik;
begin
r:=New(PVaznik,Init(nil,nil));
p:=r;
q:=@self;
r^.vazba:=q^.vazba;
q:=q^.dejdalsi;
while q<>nil do
   begin
   r^.Insert(New(PVaznik,Init(r,nil)));
   r:=r^.dejdalsi;
   r^.vazba:=q^.vazba;
   q:=q^.dalsi;
   end;
Duplicate:=p;
end;

Function DefaultSortComp(p,q:pointer):boolean;
begin
{nevime, s jakymi budeme pracovat daty, tak to defaultne vypnu}
{pro konkretni ulohu si napis vlastni porovnavac}
DefaultSortComp:=false;
end;

Procedure TVaznik.Setrid;
   function MergeSort(TheList:PVaznik;N:longint):PVaznik;
   var
      TempNode1 :PVaznik;
      TempNode2 :PVaznik;
      Count     :longint;
      Size1     :longint;
      Size2     :longint;
      UsingList1:boolean;

   begin
   if N <= 2 then                 {dva prvky nebo mene?}
      begin
      if N = 1 then               {v seznamu je jenom jeden prvek?...}
         MergeSort := TheList     {...tak to je pro tentokrat dotrideno}
         else
         begin                       {dva prvky?}
         if procSortComp(TheList^.vazba,TheList^.dejdalsi^.vazba) then MergeSort := TheList
            else begin               {eventualne je prohod}
            TempNode1 := TheList;
            TempNode2 := TheList^.dejdalsi;
            TempNode1^.predchozi := TempNode2;
            TempNode2^.dalsi := TempNode1;
            TempNode1^.dalsi := nil;
            TempNode2^.predchozi := nil;
            MergeSort := TempNode2;
            end;
         end;
      end
      else
      begin
      {vice nez dva prvky?}
      {rozdelim seznam na dve poloviny}
      {TempNode1 pokryje prvni polovinu a}
      {TempNode2 druhou}

      TempNode2 := TheList;
      Size1 := N div 2;
      Size2 := n - Size1;
      for Count := 1 to Size1 - 1 do TempNode2 := TempNode2^.dejdalsi;
      TempNode1 := TempNode2;
      TempNode2 := TempNode2^.dejdalsi;
      TempNode1^.dalsi:=nil;
      TempNode2^.predchozi:=nil;
      TempNode1:=TheList;

      {tyto dve poloviny setridi}

      TempNode1 := MergeSort(TempNode1,Size1);
      TempNode2 := MergeSort(TempNode2,Size2);

      {obe poloviny zase spoji}
      {musi se ale napred rozhodnout, ktera bude prvni}

      if procSortComp(TempNode1^.vazba,TempNode2^.vazba) then
         begin
         MergeSort := TempNode1;
         UsingList1 := true;
         end
         else begin
         MergeSort := TempNode2;
         UsingList1 := false;
         end;

      while (TempNode1 <> nil) and (TempNode2 <> nil) do
         begin
         {a ted je spojim}
         if UsingList1 then
            begin
            while (TempNode1^.dejdalsi <> nil) and
                  procSortComp(TempNode1^.dejdalsi^.vazba,TempNode2^.vazba) do
               TempNode1 := TempNode1^.dejdalsi;
            TempNode2^.predchozi := TempNode1;
            TempNode1 := TempNode1^.dejdalsi;
            TempNode2^.dejpredchozi^.dalsi := TempNode2;
            if TempNode1 = nil then Exit;
            end
            else
            begin
            while (TempNode2^.dejdalsi <> nil) and
                  procSortComp(TempNode2^.dejdalsi^.vazba,TempNode1^.vazba) do
               TempNode2 := TempNode2^.dejdalsi;
            TempNode1^.predchozi := TempNode2;
            TempNode2 := TempNode2^.dejdalsi;
            TempNode1^.dejpredchozi^.dalsi := TempNode1;
            if TempNode2 = nil then Exit;
            end;
            UsingList1 := not UsingList1;
         end;
      end;
   end;

var i:longint;
begin
i:=PocetPrvku;
if i>1 then
   begin
   dalsi:=MergeSort(dalsi,i);
   dalsi^.predchozi:=@self;
   end;
end;

Destructor TVaznik.Done;
begin
if predchozi<>nil then       { Zrusi uzel a vyjme odkaz na nej v  }
   begin                     { predchozim a nasledujicim uzlu     }
   predchozi^.dalsi:=dalsi;
   if dalsi<>nil then dalsi^.predchozi:=predchozi;
   end else if dalsi<>nil then dalsi^.predchozi:=nil;
end;

Procedure Skomprimuj(var p:PVaznik;sz:SizeDetectproc);
{Jednotlive pametove prostory alokovane pro navazane objekty slije do jednoho
velkeho buferu, takze se usetri na granularite pameti. Jednotlive prvky vazniku
uz nebudou moci rusit svoje vazby samostatne, ale musi se to provest centralne
pres hlavu vazniku. HLAVA^.VAZBA=ZACATEK_BUFFERU}
{vlastnim datum z vazeb predchazi 10-bajtova "hlavicka": 'komp:'+#0;delka:longint}
{Diky teto hlavicce je mozne detekovat, ze je vaznik komprimovany a diky tomu
ho procedura Vaznik_Done_All dokaze zrusit}
var q:PVaznik;
    l:longint;
    m,n:pchar;
    magic:pchar;
begin
magic:='komp:';
q:=p^.dalsi;
l:=10;
while q<>nil do
   begin
   if q^.vazba<>nil then l:=l+sz(q^.vazba);
   q:=q^.dalsi;
   end;
GetMem(m,l);
n:=m;
p^.vazba:=m;
Move(magic^,m[0],6); {na zacatku buferu dam znacku, abych vedel, ze je slity}
Move(l,m[6],4);      {za ni napisu velikost celeho bufferu}
inc(n,10);

q:=p^.dalsi;
while q<>nil do
   begin
   if q^.vazba<>nil then
      begin
      l:=sz(q^.vazba);
      Move(q^.vazba^,n^,l);
      FreeMem(q^.vazba,l);
      q^.vazba:=n;
      inc(n,l);
      end;
   q:=q^.dalsi;
   end;
end;

Function _delkapstringu(p:pointer):longint;
var v:pstring;
begin
v:=p;
_delkapstringu:=Length(v^)+1;
end;

Procedure SkomprimujPStringy(var p:PVaznik);
{implementace komprese pro PStringy}
begin
Skomprimuj(p,@_delkapstringu);
end;

Procedure Vaznik_Done_All(var p:PVaznik;action:ActionType);
var v:pointer;
    n:pchar;
    l,i1,i2:dword;
    b:boolean;
begin
if p=nil then Exit;
if p^.predchozi<>nil then Exit;
b:=false;
if p^.vazba<>nil then
   begin
   n:=p^.vazba;
   if n='komp:' then {neni to nahodou komprimovany vaznik?}
      begin
      b:=true;
      inc(n,6);
      move(n^,l,4);
      i1:=dword(p^.vazba); {rozsah adres}
      i2:=i1+l-1;          {komprimovaneho prostoru}
      FreeMem(p^.vazba,l);
      p^.vazba:=nil;
      end;
   end;
while p^.dalsi<>nil do
   begin
   v:=p^.dalsi^.vazba;
   if v<>nil then
      if action<>nil then
         if b=false then action(v)
            else begin
            l:=dword(v);
            if (l<i1) or (l>i2) then action(v); {co kdyz je ve skomprimovanem vazniku}
            end;   {nektery, ktery ukazuje cizi, neskomprimovane misto?}

   Dispose(p^.dalsi,Done);
   end;
if p^.vazba<>nil then
      if action<>nil then action(p^.vazba);
Dispose(p,Done);
p:=nil;
end;

Procedure Vaznik_Done_All(var p:PVaznik);
begin
Vaznik_Done_All(p,nil);
end;

Constructor TStrom.Init(_rod,_pre,_dal:PStrom);
begin
inherited Init(_pre,_dal);
potomek:=nil;
rodic:=_rod;  {POZOR, pripadnou vazbu "rodic^.potomek:=@self" si musis udelat sam}
skok:=@self;
end;

Function TStrom.Vem:PStrom;
begin
Vem:=potomek^.dejdalsi;
end;

Function TStrom.InitOffspring(q:pointer):PStrom;
var p:Pstrom;
begin
if potomek=nil then
   begin
   potomek:=New(PStrom,Init(@self,nil,nil));
   p:=potomek^.InitNext(q);
   Exit(p);
   end else
   begin
   p:=potomek^.InitNext(q);
   Exit(p);
   end;
end;

Function DefaultMySizeOf(p:pointer):longint;
var v:pstring;
begin
v:=p;
DefaultMySizeOf:=Length(v^)+1;
end;

Function DefaultCompMyData(p,q:pointer):boolean;
   {Function Copy_of_MySizeOf(p:pointer):longint;
   var v:pstring;
   begin
   v:=p;
   Copy_of_MySizeOf:=Length(v^)+1;
   end;}

var b:longint;
    pv,qv:longint;
begin
if p=nil then Exit(false);
pv:={Copy_of_MySizeOf(p);}procMySizeOf(p);
qv:={Copy_of_MySizeOf(q);}procMySizeOf(p);
if pv<>qv then Exit(false); { nevim, jestli si to muzu dovolit }
b:=CompareByte(p^,q^,qv);
DefaultCompMyData:=b=0;
end;

Function TStrom.SearchLast:PStrom;
begin
if predchozi=nil then
   SearchLast:=skok else SearchLast:=skok^.skok;
end;

Function TStrom.SearchFirst:PStrom;
begin
if predchozi=nil then
   SearchFirst:=@self else SearchFirst:=skok;
end;

Function TStrom.Search_Offsprings(p:pointer):PStrom;
var q,r:PStrom;
{ Vrstvove prochazeni.
1. Prohleda vsechny deti.
2. Pro kazde dite hleda vsechny jeho deti
...

Tzn. nikdy se nevraci zezdola nahoru (od vnoucat k detem)
}
begin
if p=vazba then Exit(@self);
if potomek<>nil then
   begin
   q:=pstrom(potomek^.dalsi);
   while q<>nil do
      begin
      (*if q^.vazba=p then Exit(q);*)
      if procCompMyData(q^.vazba,p) then Exit(q);
      q:=pstrom(q^.dalsi);
      end;

   q:=pstrom(potomek^.dalsi);
   while q<>nil do
      begin
      r:=q^.Search_Offsprings(p);
      if r<>nil then Exit(r);
      q:=pstrom(q^.dalsi);
      end;
   end;
Search_Offsprings:=nil;
end;

Function TStrom.InitNext(q:pointer):PStrom;
var p:PStrom;
begin
p:=SearchLast;
p^.dalsi:=New(PStrom, Init(rodic,p,nil));
if p^.predchozi=nil then
   begin
   p^.dejdalsi^.skok:=p;
   skok:=p^.dejdalsi;
   end
   else begin
   p^.dejdalsi^.skok:=p^.skok;
   p^.skok^.skok:=p^.dejdalsi;
   end;
p:=p^.dejdalsi;
p^.vazba:=q;
p^.potomek:=nil;
InitNext:=p;
end;

Procedure TStrom.Insert(p:PStrom);
var q,r1,r2:PStrom;
begin  { Vlozi dalsi (existujici) uzly mezi volany (self) a jeho naslednika }
q:=p^.SearchLast;
r2:=dejdalsi;
q^.dalsi:=r2;
p^.predchozi:=@self;
if r2<>nil then r2^.predchozi:=q;
dalsi:=p;
r1:=dejdalsi;
if predchozi=nil then
   begin
   while r1<>r2 do     {soucasne se tim osetri i <> nil}
      begin
      r1^.skok:=@self;
      r1:=r1^.dejdalsi;
      end;
   if r2=nil then skok:=q;
   end
   else
   begin
   while r1<>r2 do     {soucasne se tim osetri i <> nil}
      begin
      r1^.skok:=skok;
      r1:=r1^.dejdalsi;
      end;
   if r2=nil then skok^.skok:=q;
   end;
end;


Procedure TStrom.PozpatkuPrvky;
{krome prvku musi obratit i odkazy na potomky a taky odkazy deti na rodice}
var p,q,r:PStrom;
    v2,v3:pointer;
begin
p:=SearchLast;
q:=@self;
if q^.DejPredchozi=nil then q:=q^.DejDalsi;
if p=q then Exit;
repeat
   {prohozeni vazby}
   v2:=p^.vazba;
   p^.vazba:=q^.vazba;
   q^.vazba:=v2;
   {prohozeni potomku}
   v3:=p^.potomek;
   p^.potomek:=q^.potomek;
   q^.potomek:=v3;
   {prohodit rodice neni treba, protoze je maji vsichni stejne}

   {Zbyva vyresit odkazy na rodice od mych potomku}
   r:=p^.potomek;
   while r<>nil do
      begin
      r^.rodic:=p;
      r:=r^.dejdalsi;
      end;
   r:=q^.potomek;
   while r<>nil do
      begin
      r^.rodic:=q;
      r:=r^.dejdalsi;
      end;

   p:=p^.DejPredchozi;
   q:=q^.DejDalsi;
   until (p=q) or (p^.DejDalsi=q);
end;

Function Tstrom.Search_Parents(p:pointer):PStrom;
begin
if procCompMyData(vazba,p) then Exit(@self);
if rodic<>nil then Search_Parents:=rodic^.Search_Parents(p);
end;

Function TStrom.Root:PStrom;
begin
if rodic=nil then Exit(@self) else Root:=rodic^.root;
end;

Function TStrom.Deepness(p:Pstrom):longint;
begin
if p=@self then Deepness:=0 else
   if rodic<>nil then Deepness:=rodic^.Deepness(p)+1 else Deepness:=-1;
end;

Procedure DefaultSaveHeaderOfMyData(f:PBufStream);
begin end;

Function DefaultLoadHeaderOfMyData(f:PBufStream):boolean;
begin DefaultLoadHeaderOfMyData:=true;end;

Procedure DefaultSaveMyData(f:PBufStream;p:pointer;j:longint);
begin
if p<>nil then
   begin
   f^.write(j,4);
   f^.write(p^,j);
   end
   else
   begin
   j:=0;
   f^.write(j,4);
   end;
end;


Function TStrom.Save(s:string):byte;
var f:PbufStream;
    verze,reserved:byte;

   Procedure _Save(p:PStrom);
   var i:longint;
       q:PStrom;
   begin
   if p=nil then
      begin
      i:=0;
      f^.write(i,4);
      Exit;
      end;
   i:=p^.PocetPrvku;
   f^.write(i,4);   { Pocet prvku v teto generaci }
   q:=Pstrom(p^.dalsi);
   while q<>nil do
      begin
      i:=procMySizeOf(q^.vazba);
      procSaveMyData(f,q^.vazba,i);
      q:=Pstrom(q^.dalsi);
      end;

   q:=Pstrom(p^.dalsi);
   while q<>nil do
      begin
      _Save(q^.potomek);
      q:=Pstrom(q^.dalsi);
      end;
   end;

begin
f:=New(PBufStream,Init(s,{stOpenWrite}stCreate,st_BUFFERSIZE));
verze:=st_VERZESOUBORU;
reserved:=1;
procSaveHeaderOfMyData(f);
f^.Write(verze,1);
f^.Write(reserved,1);
_Save(potomek);
Dispose(f,Done);
Save:=st_OK;
end;


Function DefaultLoadMyData(f:PBufStream):pointer;
var velikost_polozky:longint;
    v:pointer;
begin
f^.read(velikost_polozky,4);
if velikost_polozky=0 then
   begin
   v:=nil;
   end
   else
   begin
   GetMem(v,velikost_polozky);
   f^.read(v^,velikost_polozky);
   end;
DefaultLoadMyData:=v;
end;


Function TStrom.Load(s:string):byte;
var f:PbufStream;
    x:byte;
    xx:boolean;

   Procedure _Load(p:PStrom);
   var q:PStrom;
       i:longint;
       v:pointer;
       pocet_prvku_v_generaci:longint;

   begin
   f^.read(pocet_prvku_v_generaci,4);
   if pocet_prvku_v_generaci=0 then Exit;
   q:=New(PStrom,Init(p,nil,nil));
   p^.potomek:=q;
   for i:=1 to pocet_prvku_v_generaci do
       begin
       v:=procLoadMyData(f);
       q^.InitNext(v);
       end;

   q:=Pstrom(q^.SearchFirst^.dalsi);
   while q<>nil do
      begin
      _Load(q);
      q:=PStrom(q^.dalsi);
      end;
   end;

begin
if potomek<>nil then Exit(st_NOT_EMPTY);
f:=New(PBufStream,init(s,stOpenRead,st_BUFFERSIZE));
if f^.errorinfo in [2,3] then Exit(st_FILENOTEXIST);
if procLoadHeaderOfMyData(f)=false then
   begin
   Dispose(f,Done);
   Exit(st_BADFORMAT);
   end;
f^.read(x,1);      { verze souboru  }
f^.read(xx,1);     { rezervovano? }

_Load(@self);
Dispose(f,Done);
Load:=st_OK;
end;


Function TStrom.Num_Childerns:longint;
begin
if potomek=nil then Num_Childerns:=0 else Num_Childerns:=potomek^.PocetPrvku;
end;

Function TStrom.Num_Offsprings:longint;
var p:PStrom;
    i:longint;
begin
i:=Num_Childerns;
if i=0 then Exit(0);
p:=pstrom(potomek^.dalsi);
while p<>nil do
   begin
   i:=i+p^.Num_Offsprings;
   p:=pstrom(p^.dalsi);
   end;
Num_Offsprings:=i;
end;


Function TStrom.Linearize:PVaznik;
var p:PStrom;
    q,r,t:PVaznik;
    v:pointer;
begin
if potomek=nil then Exit(nil);
q:=New(PVaznik,Init(nil,nil));
p:=pstrom(potomek^.dalsi);
while p<>nil do
   begin
   v:=p^.vazba;
   q^.InitNext(v);
   p:=PStrom(p^.dalsi);
   end;
p:=pstrom(potomek^.dalsi);
while p<>nil do
   begin
   r:=q^.SearchLast;
   t:=p^.Linearize;
   if t<>nil then
      begin
      r^.dalsi:=t;
      t^.predchozi:=r;
      Dispose(t,Done);  { Odstrani rukojet }
      end;
   p:=PStrom(p^.dalsi);
   end;
Linearize:=q;
end;


Procedure TStrom.InzertVaznik(p:PVaznik);
begin
p:=p^.dalsi;
while p<>nil do
   begin
   InitOffspring(p^.vazba);
   p:=p^.dalsi;
   end;
end;

Procedure TStrom.PridejPodstrom(p:Pstrom);
begin
potomek:=p;
while p<>nil do
   begin
   p^.rodic:=@self;
   p:=p^.dejdalsi;
   end;
end;

Procedure TStrom.For_Each(action:ActionType);
var p:PStrom;
    v:pointer;
begin
if potomek=nil then Exit;
p:=pstrom(potomek^.dalsi);
while p<>nil do
   begin
   v:=p^.vazba;
   if v<>nil then action(v);
   p:=PStrom(p^.dalsi);
   end;

p:=pstrom(potomek^.dalsi);
while p<>nil do
   begin
   p^.For_Each(action);
   p:=PStrom(p^.dalsi);
   end;
end;

Function TStrom.DejDalsi:PStrom;
begin
DejDalsi:=pstrom(dalsi);
end;

Function TStrom.DejPredchozi:PStrom;
begin
DejPredchozi:=pstrom(predchozi);
end;

Function TStrom.Vaznik_z_predku:PVaznik;
var p:PVaznik;
    q:PStrom;
begin
p:=New(PVaznik,Init(nil,nil));
q:=@self;
while q<>nil do
   begin
   p^.InitNext(q);
   q:=q^.rodic;
   end;
p^.PozpatkuPrvky;
Vaznik_z_predku:=p;
end;

Destructor TStrom.Done;
var p,q,r:PStrom;
begin
if rodic<>nil then
   if rodic^.potomek=@self then rodic^.potomek:=nil;
if dejdalsi=nil then skok^.skok:=dejpredchozi
   else
   if dejpredchozi=nil then   {rusim hlavicku seznamu, takze musim predelat SKOKY}
      begin                   {a taky vim, ze za hlavickou jeste neco je}
      r:=dejdalsi;
      p:=skok;           {posledni prvek}
      r^.skok:=p;
      q:=r^.dejdalsi;
      while q<>nil do
         begin
         q^.skok:=r;
         q:=q^.dejdalsi;
         end;
      end;
inherited Done;
end;


Procedure Strom_Done_All(var p:PStrom;action:ActionType);
var q,r:PStrom;
    v:pointer;
begin
q:=p;
while q<>nil do
   begin
   if q^.potomek=nil then
      begin
      v:=q^.vazba;
      if v<>nil then
         if action<>nil then action(v);
      r:=Pstrom(q^.dalsi);
      Dispose(q,Done);
      q:=r;
      end
      else begin
      Strom_Done_All(q^.potomek,action);
      q^.potomek:=nil;
      end;
   end;
p:=nil;
end;

Function Uzel(objekt:pointer;dal:PVaznik):PVaznik;
begin
if tkadlo = nil then tkadlo:=New(PVaznik,Init(nil,nil));
tkadlo^.InitNext(objekt);
end;

Function Svazej(p:PVaznik):PVaznik;
begin
tkadlo^.PozpatkuPrvky;
Svazej:=tkadlo;
tkadlo:=nil;
end;

Function UzelS(objekt:pointer;dal:PStrom):PStrom;
begin
if skadlo = nil then skadlo:=New(PStrom,Init(nil,nil,nil));
UzelS:=skadlo^.InitNext(objekt);
end;


Function Vetev(objekt:pointer;spodek,dal:PStrom):PStrom;
var s:PStrom;
    p:PVaznik;
begin
skadlo^.PozpatkuPrvky;
if dal=nil then
   begin
   skadlo:=New(PStrom,Init(nil,nil,nil));
   s:=skadlo^.InitNext(objekt);
   s^.PridejPodstrom(pstrom(spodek^.searchfirst));
   vetev:=s;
   end
   else begin
   {POP HL_VETEV}
   p:=seznam_vetveni^.searchlast;
   s:=p^.vazba;
   s^.InitNext(objekt);
   s:=s^.DejDalsi;
   s^.PridejPodstrom(skadlo);  {spodek je Skadlo}
   skadlo:=pstrom(s^.SearchFirst);
   {skadlo:=pstrom(s^.SearchLast);}
   Dispose(p,Done);  {pop}
   {Vetev:=dal;}
   vetev:=pstrom(s^.Searchlast);
   end;
end;

Function SvazejS(p:PStrom):PStrom;
var s:Pstrom;
{Musi byt vmezeren mezi DAL a SPODEK}
begin
{PUSH HL_VETEV}
if seznam_vetveni = nil then seznam_vetveni:=New(PVaznik,Init(nil,nil));
s:=pstrom(seznam_vetveni^.InitNext(p));  {push} {skadlo^.searchlast}
skadlo:=nil;
SvazejS:=s;  {neni nutne}
end;

Function StromDef(p:PStrom):PStrom;
var s:Pstrom;
    n:PVaznik;
begin
if skadlo=nil then {Pro osetreni (nespravneho) zapisu StromDef(Svazej(...}
   begin
   n:=seznam_vetveni^.SearchLast;
   s:=n^.vazba;
   skadlo:=PStrom(s^.SearchFirst);
   Dispose(n,Done);
   end;
skadlo^.PozpatkuPrvky;
s:=New(Pstrom,Init(nil,nil,nil));
s^.PridejPodstrom(skadlo);
StromDef:=s;
skadlo:=nil;
if seznam_vetveni<>nil then begin Dispose(seznam_vetveni,Done);seznam_vetveni:=nil;end;
end;

Function TStrom.Duplicate:PStrom;
var p,q,r,s,t:PStrom;
begin
r:=New(PStrom,Init(nil,nil,nil));
p:=r;
q:=@self;
r^.vazba:=q^.vazba;
s:=q^.potomek;
if s<>nil then
   begin
   t:=s^.Duplicate;
   r^.PridejPodstrom(t);
   end;
q:=q^.dejdalsi;
while q<>nil do
   begin
   r^.Insert(New(PStrom,Init(nil,nil,nil)));
   r:=r^.dejdalsi;
   r^.vazba:=q^.vazba;
   s:=q^.potomek;
   if s<>nil then
      begin
      t:=s^.Duplicate;
      r^.PridejPodstrom(t);
      end;
   q:=q^.dejdalsi;
   end;
Duplicate:=p;
end;


begin
procSortComp:=@DefaultSortComp;
procMySizeOf:=@DefaultMySizeOf;
procSaveMyData:=@DefaultSaveMyData;
procSaveHeaderOfMyData:=@DefaultSaveHeaderOfMyData;
procLoadMyData:=@DefaultLoadMyData;
procLoadHeaderOfMyData:=@DefaultLoadHeaderOfMyData;
procCompMyData:=@DefaultCompMyData;
end.
