/*  Search

    Copyright (c) Express Software 1997.
    All Rights Reserved.
    
    Created by: Joseph Cosentino.
    
*/

// I N C L U D E S //////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include <string.h>
#include <ctype.h>
#include <direct.h>
#include "dirport.h"

// D E F I N E S ////////////////////////////////////////////////////////////

#define GetDrive(d) _dos_getdrive(&d)
#define SetDrive(d) {unsigned x;_dos_setdrive(d,&x);}

// G L O B A L S ////////////////////////////////////////////////////////////

int count=0;

// F U N C T I O N S ////////////////////////////////////////////////////////

int classify_args(int argc, char *rawargs[], char *fileargs[], char *optargs[])
{
    int index, kndex, jndex;
    char *argptr;

    for (index=0,jndex=0,kndex=0;index<argc;index++)
        {
        argptr = rawargs[index];
        if (*argptr == '/')
            {
            argptr++;
            optargs[kndex++] = argptr;
            } // end if.
        else
            {
            fileargs[jndex++] = argptr;
            } // end else.
            
        } // end for.

   return kndex;
    
} // end if.

/////////////////////////////////////////////////////////////////////////////

int convert(long num, char *des)
{
    char temp[32];
    int c=0, n=0;

    if (num == 0)
        {
        des[0]=0x30;
        des[1]=0;
        n=1;
        } // end if.
    else
        {
        temp[31]=0;
        while (num > 0)
            {
            if (((c+1)%4)==0)
                temp[30-c++]=',';

            temp[30-c++]=(char)(num%10)+0x30;
            num/=10;
            } // end while.

        for (n=0;n<=c;n++)
            des[n]=temp[31-c+n];

        } // end else.

    return n;

} // end convert.

/////////////////////////////////////////////////////////////////////////////

void searchdir(char *path, char *ptrn)
{
    DOSFileData *f;
    char *wholepath;
    unsigned rtn;

    chdir(path);
    wholepath = getcwd(NULL, 80);
    f = malloc(sizeof(*f));

    // Search for filename matches in this directory.
    rtn = FIND_FIRST(ptrn, _A_ANY, f);
    while (rtn == 0)
        {
        if (!(ff_attr(f) & _A_SUBDIR))
            printf("%s\\%s\n",wholepath,ff_name(f));
        else  
            printf("%s\\%s <DIR>\n", wholepath, ff_name(f));

        ++count;
        rtn = FIND_NEXT(f);
        } // end while.

    // Now search any subdirectories under this directory.
    rtn = FIND_FIRST("*.*", _A_SUBDIR, f);
    while (rtn == 0)
        {
        if ((ff_attr(f) & _A_SUBDIR) && (ff_name(f)[0] != '.'))
            {
            searchdir(ff_name(f), ptrn);
            chdir(wholepath);
            } // end if.

        rtn = FIND_NEXT(f);
        } // end while.

    free(wholepath);
    free(f);

} // end searchdir.

/////////////////////////////////////////////////////////////////////////////

int main(int argc, char *argv[])
{
    char *curdir, buffer[32], sought[80], *temp, *fileargs[64], *optargs[64];
    int newdrive, p, n_options, n_files, index, help_flag=0;
    void searchdir(char *dir, char *ptrn);
    unsigned curdrive;

    n_options = classify_args(argc, argv, fileargs, optargs);
    n_files = argc - n_options;

    for (index=0;index<n_options;index++)
        {
        if (optargs[index][0] == '?') help_flag=1;
        else
            {
            printf("Invalid parameter - /%s\n", strupr(optargs[index]));
            exit(1);
            } // end else.

        } // end for.

    if (help_flag)
        {
        printf("Searches for a file.\n\n"
               "Syntax: SEARCH [drive:][path]filename [/?]\n"
               "  [drive:][path]  The drive and path where to search\n"
               "  filename        The file to search for\n"
               "  /?              Displays this help message\n");
        exit(1);
        } // end if.

    if (n_files < 2)
        {
        printf("Required parameter missing\n");
        exit(1);
        } // end if.

    curdir=getcwd(NULL,80);
    GetDrive(curdrive);

    if (argc>1)
        strcpy(sought,argv[1]);
    else
        {
        printf("\n\nPattern to search for: ");
        gets(sought);
        } // end else.

    if (sought[1]==':')
        {
        newdrive=(toupper(sought[0]))-64;
        SetDrive(newdrive);
        p = (sought[2]=='\\') ? 3:2;
        strcpy(sought, &(sought[p]));
        } // end if.

    // Add wildcard prefix/suffix if necessary.
    if (sought[0]=='.')
        {
        temp=strcat("*",sought);
        strcpy(sought,temp);
        } // end if.

    if (!strchr(sought,'.'))
        strcpy(sought,"*.*");

    // Perform search for pattern starting in root.
    searchdir("\\",sought);
    if (count < 1)
        printf("No files found\n");
    else if (count == 1)
        printf("1 file found\n");
    else
        {
        convert(count, buffer);
        printf("%s files found\n", buffer);
        } // end else.

    SetDrive(curdrive);
    chdir(curdir);
    return EXIT_SUCCESS;

} // end main.
