REM
REM  Word-wrapping function
REM  Author: Mateusz Viste <mateusz@viste-family.net>
REM  Last modified: 28 Jun 2009
REM
REM Note, that the function will modify the string variable you will pass to it!
REM Also, it accepts line breaks in the UNIX format (LF-only)

FUNCTION WordWrap(BYREF TextToWrap AS STRING, WrapValue AS INTEGER) AS STRING
  DIM AS STRING Result
  DIM AS INTEGER LastSpace = 0, x, LineBreak
  IF LEN(TextToWrap) <= WrapValue AND INSTR(TextToWrap, CHR(10)) = 0 THEN
      Result = TextToWrap
      TextToWrap = ""
    ELSE
      LineBreak = 0
      FOR x = 1 TO WrapValue + 1
        IF MID(TextToWrap, x, 1) = " " THEN LastSpace = x
        IF MID(TextToWrap, x, 1) = CHR(10) AND LineBreak = 0 THEN LineBreak = x
      NEXT x
      IF LineBreak > 0 THEN LastSpace = LineBreak
      IF LastSpace = 0 THEN
          Result = MID(TextToWrap, 1, WrapValue)
          TextToWrap = MID(TextToWrap, WrapValue + 1)
        ELSE
          Result = MID(TextToWrap, 1, LastSpace - 1)
          TextToWrap = MID(TextToWrap, LastSpace + 1)
      END IF
  END IF
  RETURN Result
END FUNCTION
