DECLARE SUB RefreshDisplay (Xpos%, Ypos%)
DECLARE SUB InitDisplay ()
DECLARE SUB Load (bool&)
DECLARE SUB Save (num&)
DECLARE FUNCTION BIN$ (numb&)
DECLARE FUNCTION Hex2Dec& (a$)
DECLARE FUNCTION Bin2Dec& (value$)

DIM SHARED Table(1 TO 16) AS STRING * 8
DIM SHARED WorkOn(1 TO 16) AS STRING * 8

SCREEN 12
Restart:

FOR x% = 1 TO 16
        WorkOn(x%) = "                                "
NEXT x%

CLS

COLOR 14
PRINT "      Character Editor for FoxType, Copyright (C) Mateusz Viste "; CHR$(34); "Fox"; CHR$(34); " 2006"
COLOR 7
LOCATE 10, 1
LINE INPUT "Please enter the HEX number of the character you want edit: ", num$
CLS
COLOR 14
PRINT "      Character Editor for FoxType, Copyright (C) Mateusz Viste "; CHR$(34); "Fox"; CHR$(34); " 2006"
COLOR 7
PRINT
PRINT "Edited character: "; RIGHT$("0000" + num$, 4);
LOCATE 3, 32: PRINT "SPC: Swap ; ESC: Quit ; S: Save ; L: Load from.. ; W: Work on another one";

num& = Hex2Dec&(num$)
CALL Load(num&)

Xpos% = 1
Ypos% = 1

CALL InitDisplay

DO

CALL RefreshDisplay(Xpos%, Ypos%)

DO: LastKey$ = INKEY$
LOOP UNTIL LastKey$ <> ""
LastKey$ = UCASE$(LastKey$)

IF LastKey$ = CHR$(0) + "H" AND Ypos% > 1 THEN Ypos% = Ypos% - 1
IF LastKey$ = CHR$(0) + "P" AND Ypos% < 16 THEN Ypos% = Ypos% + 1
IF LastKey$ = CHR$(0) + "K" AND Xpos% > 1 THEN Xpos% = Xpos% - 1
IF LastKey$ = CHR$(0) + "M" AND Xpos% < 8 THEN Xpos% = Xpos% + 1

IF LastKey$ = " " THEN
  IF MID$(Table(Ypos%), Xpos%, 1) = "1" THEN MID$(Table(Ypos%), Xpos%, 1) = "0" ELSE MID$(Table(Ypos%), Xpos%, 1) = "1"
END IF
IF LastKey$ = "S" THEN CALL Save(num&)
IF LastKey$ = "L" THEN CALL Load(-1)
IF LastKey$ = "W" THEN GOTO Restart
LOOP UNTIL LastKey$ = CHR$(27)

CLS
SYSTEM

FUNCTION BIN$ (numb&)
REM
REM  Function BIN$ - Converts a decimal number to its binary value
REM
REM  Warning: This function works only with numbers 0..999999 !
REM
REM                                       Fox, Le Bois d'Oingt, July 2006
REM
x& = 0
wynik$ = ""
dzielnik& = 524288
DO
n& = numb& \ dzielnik& MOD 2
dzielnik& = dzielnik& / 2
x& = x& + n&
IF NOT x& = 0 THEN wynik$ = wynik$ + LTRIM$(STR$(n&))
LOOP UNTIL dzielnik& = 0
IF x& = 0 THEN wynik$ = "0"
BIN$ = wynik$
END FUNCTION

FUNCTION Bin2Dec& (value$)
REM
REM  Function Bin2Dec - Converts a binary number to its decimal value
REM
REM  Warning: This function works only with numbers 0..1111111111111111 !
REM
REM                                       Fox, Le Bois d'Oingt, July 2006
REM
DIM TableZ(1 TO 16) AS INTEGER
value$ = RIGHT$("0000000000000000" + value$, 16)

n = 32768
Score& = 0

FOR x% = 1 TO 16
  TableZ(x%) = VAL(MID$(value$, x%, 1))
  Score& = Score& + TableZ(x%) * n
  n = n / 2
NEXT x%
Bin2Dec& = Score&
END FUNCTION

FUNCTION Hex2Dec& (a$)
REM
REM  Function Hex2Dec - Converts a hexadecimal number to its decimal value
REM
REM  Warning: This function works only with numbers 0..FFFF !
REM
REM                                       Fox, Le Bois d'Oingt, July 2006
REM
a$ = RIGHT$("0000" + a$, 4)

DIM aa(1 TO 4) AS LONG

FOR x% = 1 TO 4
aa(x%) = VAL(MID$(a$, x%, 1))

IF UCASE$(MID$(a$, x%, 1)) = "A" THEN aa(x%) = 10
IF UCASE$(MID$(a$, x%, 1)) = "B" THEN aa(x%) = 11
IF UCASE$(MID$(a$, x%, 1)) = "C" THEN aa(x%) = 12
IF UCASE$(MID$(a$, x%, 1)) = "D" THEN aa(x%) = 13
IF UCASE$(MID$(a$, x%, 1)) = "E" THEN aa(x%) = 14
IF UCASE$(MID$(a$, x%, 1)) = "F" THEN aa(x%) = 15

NEXT x%

a& = 0
a& = aa(4) + (aa(3) * 16) + (aa(2) * 256) + (aa(1) * 4096)
Hex2Dec& = a&
END FUNCTION

SUB InitDisplay

REM 88x176
LINE (276, 151)-(372, 343), 1, BF

LINE (409, 109)-(422, 128), 1, B

LINE (276, 151)-(409, 109), 1, , &HFF00
LINE (372, 343)-(422, 128), 1, , &HFF00

END SUB

SUB Load (bool&)

char& = bool&

IF bool& = -1 THEN
   COLOR 7
   LOCATE 26, 1
   LINE INPUT "Please enter the HEX number of the character you want load: ", num$
   LOCATE 26, 1: PRINT SPACE$(80);
   char& = Hex2Dec&(num$)
END IF

OPEN "FOXTYPE.640" FOR BINARY AS #1
FOR x% = 1 TO 16
  GET #1, char& * 16 + x%, Table(x%)
  Table(x%) = RIGHT$("00000000" + BIN(ASC(Table(x%))), 8)
NEXT x%
CLOSE #1
END SUB

SUB RefreshDisplay (Xpos%, Ypos%)

FOR y% = 1 TO 16
  FOR x% = 1 TO 8
    IF MID$(Table(y%), x%, 1) = "1" THEN c% = 2 ELSE c% = 0
    IF MID$(Table(y%), x%, 1) <> MID$(WorkOn(y%), x%, 1) OR Xpos% = x% OR Ypos% = y% THEN
        MID$(WorkOn(y%), x%, 1) = MID$(Table$(y%), x%, 1)
        LINE (277 + 12 * (x% - 1), 152 + 12 * (y% - 1))-(277 + 12 * (x% - 1) + 10, 152 + 12 * (y% - 1) + 10), c%, BF
        PSET (412 + x%, 110 + y%), c% * 5
    END IF
  NEXT x%
NEXT y%

LOCATE 30, 1: PRINT "Position: ["; LTRIM$(STR$(Xpos%)); ","; RTRIM$(STR$(Ypos%)); "] ";
LINE (277 + 12 * (Xpos% - 1), 152 + 12 * (Ypos% - 1))-(277 + 12 * (Xpos% - 1) + 10, 152 + 12 * (Ypos% - 1) + 10), 14, B

END SUB

SUB Save (num&)

LOCATE 26, 29: PRINT "*** PLEASE WAIT... ***";

OPEN "FOXTYPE.640" FOR BINARY AS #1
FOR x% = 1 TO 16
  t$ = ""
  t$ = Table(x%)
  t$ = CHR$(Bin2Dec&(t$))
  PUT #1, num& * 16 + x%, t$
NEXT x%
CLOSE #1

LOCATE 26, 29: PRINT "                      ";
END SUB

