/*

 Nibbles - Copyright (C) 2000 Andrea Fazzi

 This file is part of Nibbles.

 Nibbles is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Nibbles is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Nibbles; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
//---------------------------------------------------------------------------
#ifndef  _FONT_H
#define  _FONT_H

#include "Sprite.h"

//---------------------------------------------------------------------------
class CharBMP: public Sprite {

 public:

  unsigned char col;
  int ID;

   void ReadChr(int x,int y,int width,int height,unsigned char *buf,int id);
   void DrawChr(int x, int y,unsigned char color,unsigned char *dblbuf);

};
//---------------------------------------------------------------------------
struct CursProp {

 int x,y;
 unsigned char col,cfactor,carriage;

};
//---------------------------------------------------------------------------
class FontBMP {

  public:

   int num;
   unsigned char col;
   CharBMP *CharsData;

    FontBMP();
    ~FontBMP();

    void Init(int n);

    void GrabFont(int x0, int y0,int dx,int dy,
                  unsigned char i1,unsigned char i2,
                  unsigned char *buf);

    void SaveToFile(char *filename);
    void LoadFromFile(char *filename);
    void GotoXY(int x,int y);
    int  Print(const char *string,unsigned char *buf);
    void ChangeCol(unsigned char col);
    void Carriage(int carr);

   private:

    CursProp Cursor;


};
//---------------------------------------------------------------------------
#endif

