/*
 * EW Snake - Versione 0.5
 * Copyright (C) 2001 di Federico Marverti (yfede)
 *
 * Questo programma e` distribuito secondo i termini della Licenza
 * Pubblica Generica GNU (GNU GPL: GNU General Public License).
 * Per maggiori informazioni e riguardo leggere il file README.TXT
 * allegato alla distribuzione del presente codice sorgente.
 */

/* --- Inizio di config.c --- */

#include "defs.h"
#include <allegro.h>
#include <stdio.h>

void load_config( struct st_config *cfg );   /* Legge la configurazione da file o attribuisce valori di default */
int save_config( struct st_config *cfg );   /* Salva la configurazione corrente su file */

void load_config( struct st_config *cfg )
{
    FILE *config_file;          /* Handle del file di configurazione */

    config_file = fopen( CONFIG_NAME, "rb" );   /* Apre il file */
    if( !config_file )          /* Se non e` aperto */
    {
        cfg->resx = DE_RESX;    /* Imposta le variabili di configurazione con i valori di default */
        cfg->resy = DE_RESY;
        cfg->level = DE_LEVEL;
        cfg->record = DE_RECORD;
        cfg->cellsize = DE_CELLSIZE;

        cfg->c_background.r = DE_C_BACKGROUNDR;
        cfg->c_background.g = DE_C_BACKGROUNDG;
        cfg->c_background.b = DE_C_BACKGROUNDB;

        cfg->c_snake.r = DE_C_SNAKER;
        cfg->c_snake.g = DE_C_SNAKEG;
        cfg->c_snake.b = DE_C_SNAKEB;

        cfg->c_goal.r = DE_C_GOALR;
        cfg->c_goal.g = DE_C_GOALG;
        cfg->c_goal.b = DE_C_GOALB;

        cfg->c_wall.r = DE_C_WALLR;
        cfg->c_wall.g = DE_C_WALLG;
        cfg->c_wall.b = DE_C_WALLB;

        cfg->c_gui.r = DE_C_GUIR;
        cfg->c_gui.g = DE_C_GUIG;
        cfg->c_gui.b = DE_C_GUIB;

        cfg->c_text.r = DE_C_TEXTR;
        cfg->c_text.g = DE_C_TEXTG;
        cfg->c_text.b = DE_C_TEXTB;

        cfg->c_mouse.r = DE_C_MOUSER;
        cfg->c_mouse.g = DE_C_MOUSEG;
        cfg->c_mouse.b = DE_C_MOUSEB;
    }
    else                        /* Se il file esisteva */
    {
        fread( cfg, sizeof( struct st_config ), 1, config_file );   /* Legge la configurazione */
        fclose( config_file );  /* Chiude il file */
    }
}

int save_config( struct st_config *cfg )
{
    FILE *config_file;          /* Handle del file di configurazione */

    config_file = fopen( CONFIG_NAME, "wb" );   /* Apre il file */
    if( !config_file ) return R_ERR;    /* Se non e` aperto ritorna errore */

    fwrite( cfg, sizeof( struct st_config ), 1, config_file );  /* Scrive la configurazione */
    fclose( config_file );      /* Chiude il file */

    return R_OK;
}
/* --- Fine di config.c --- */