;**********************************************************************;
;*                             M O U S E C A                          *;
;*--------------------------------------------------------------------*;
;*    Aufgabe        : Vom Maustreiber aufgerufener Event-Handler     *;
;*                     zur Einbindung in ein C-Programm, das unter    *;
;*                     dem Speichermodell LARGE kompiliert wurde.     *;
;*--------------------------------------------------------------------*;
;*    Autor          : MICHAEL TISCHER                                *;
;*    entwickelt am  : 20.04.1989                                     *;
;*    letztes Update :  4.12.1991                                     *;
;*    letztes Update : 10.12.93   (M. Braun)                          *;
;*--------------------------------------------------------------------*;
;*    assemblieren   : MASM /MX MOUSECA;   oder   TASM -MX MOUSECA;   *;
;*                     ... mit dem Programm MOUSEC verknpfen         *;
;**********************************************************************;

;== Segmentdeklarationen fr das C-Programm ============================

IGROUP group MOUSECA_TEXT         ;Zusammenfassung der Programm-Segmente
;;;DGROUP group _bss,  _data         ;Zusammenfassung der Daten-Segmente
       assume CS:IGROUP, DS:NOTHING, ES:NOTHING, SS:NOTHING

_BSS   segment word public 'BSS'  ;dieses Segment nimmt alle nicht ini-
_BSS   ends                       ;tialisierten statischen Variablen auf

_DATA  segment word public 'DATA' ;alle initialisierten globalen und
                                  ;statischen Variablen werden in diesem
                                  ;Segment untergebracht
_DATA  ends

;== Programm ===========================================================

MOUSECA_TEXT segment byte public 'CODE' ;das Programmsegment

public     _AssHand               ;gibt dem C-Programm die Mglichkeit,
                                  ;die Adresse des Assembler-Handlers
                                  ;zu ermitteln

extrn     _MouEventHandler : far  ;der auzurufende C-Event-Handler

aktiv     db  0                   ;zeigt an, ob noch ein Aufruf aus-
                                  ;gefhrt wird

;-----------------------------------------------------------------------
;-- _AssHand : der Event-Handler, der zunchst vom Maustreiber auf-
;--            gerufen wird, um seinerseits dann die C-Funktion
;--            MouEventHandler() aufzurufen
;-- Aufruf von C: nicht erlaubt!

_AssHand   proc far

           ;-- zunchst alle Prozessorregister auf dem Stack sichern ---

           cmp  cs:aktiv,0        ;Aufruf noch nicht beendet?
           jne  ende              ;Nein --> Aufruf nicht zulassen

           mov  cs:aktiv,1        ;keine Aufrufe mehr zulassen

           push ax
           push bx
           push cx
           push dx
           push di
           push si
           push bp
           push es
           push ds

           ;-- die Argumente fr den Aufruf der C-Funktion C_FKT auf ---
           ;-- den Stack bringen
           ;-- Aufruf: MouEventHandler( int EvFlags, int ButStatus,
           ;--                          int x,       int y );

           mov  di,cx             ;horizontale Ordinate in DI merken
;;;        mov  cl,3              ;Schiebezhler f. Koordinatenumr.
;;;        shr  dx,cl             ;DX (vertikale Ord.) durch 8 teilen
           push dx                ;und auf den Stack bringen

;;;        shr  di,cl             ;DI (horizontale Ord.) durch 8 teilen
           push di                ;und auf den Stack bringen

           push bx                ;Status der Mausknpfe auf den Stack
           push ax                ;Event-Flags auf den Stack bringen

;;;        mov  ax,DGROUP         ;Segmentadresse des DGROUP nach AX
;;;        mov  ds,ax             ;in von dort in das DS-Register

           call _MouEventHandler  ;Aufruf der C-Funktion

           add  sp,8              ;Argumente vom Stack entfernen

           ;-- die gesicherten Register wieder vom Stack holen ---------

           pop  ds
           pop  es
           pop  bp
           pop  si
           pop  di
           pop  dx
           pop  cx
           pop  bx
           pop  ax

           mov  cs:aktiv,0        ;Aufruf ist wieder erlaubt

ende:      ret                    ;zurck zum Maustreiber

_AssHand   endp

;-------------------------------------------------------------------------

MOUSECA_TEXT ends                   ;Ende des Codesegments
           end                    ;Ende des Programms

/* Modification History */
/* 09.12.93 - _MouEventHandler : far (mousec.c in large model) */
/* 10.12.93 - x/y: no division by 8, full mouse resolution */
/* 24.10.94 - segment references "cs:" for local vars, removed DGROUP */
