{$A-,B-,D+,E-,F-,I-,L+,N-,O-,R-,S-,V-}
Unit Global;
{ **********************************************************
  This unit contains several standard flags which (can) be
  evaluated by the single units.
  So, the main program (or a unit) can set a flag for all
  units.
  This unit takes over (eventually together with the unit
  Error) the global error handling.
  ----------------------------------------------------------
  Version 1.0.    30. September 1991.   Turbo Pascal 5.5.
          1.1     2001/26/06 Borland Pascal 7.01, RQ

  (P) 1991 Dietmar Hhmann.
  **********************************************************
}

Interface

Type
       ErrorAction = (DoNothing,CallErrorExit,CallRunError,ExitToDos);
Const
       OnError     : ErrorAction
                   = ExitToDos;        { Tells what to do in case of an error.}
       ErrorCode   : Byte = 0;         { ErrorCode.}
                                       { 254 = TP-run-time-error}
                                       { 255 = DOS-error. }
                                       { Else module-dependent}
       ExtErrorCode: Word = 0;         { Extended errorcode.}
       ErrorAddr   : Pointer = Nil;    { error position for run-time-error.}
       ErrorFlag   : Boolean = False;
       Module      : Byte = 0;         { Module, in which the last error occurred or was recognized.}
                                       { 0 = Main      }
                                       { 1 = Inter2    }
                                       { 2 = ForComp   }
                                       { 3 = Stack     }
                                       { 4 = PGI       }
                                       { 5 = Driver    }
                                       { 6 = Unknown   }
                                       { 7 = Share     }
                                       { 8 = Fehler    }
                                       { 9 = RS232     }
       TestMode    : Boolean = False;  { Program runs in test mode.}
       DebugMode   : Boolean = False;  { Debug mode.}
       ModuleNames : Array[0..9] of String[11] =
                     ('MAIN','INTER2','FORCOMP','STACK','PGI','DRIVER',
                      '*unknown*','SHARE','ERROR','RS232');


Var    ErrorExit   : Procedure;

Procedure SetError(Modul,Code : Byte; ExtCode : Word);

Function Error : Boolean;



Implementation



Procedure SetError;
Begin
   Module:=Modul;
   ErrorCode:=Code;
   ExtErrorCode:=ExtCode;
   ErrorFlag:=True;
   Case OnError Of
      DoNothing     : ;
      CallErrorExit : ErrorExit;
      CallRunError  : RunError(255);
      ExitToDos     : Begin
{!!RQ!!1.61
                         Writeln('Im Modul ',ModuleNames[Module],' ist der Fehler ',
                                 ErrorCode,' / ',ExtErrorCode,' Aufgetreten.');
}                        WriteLn ('Error ', ErrorCode, '/', ExtErrorCode, ' in module ',
                                   ModuleNames [Module]);
                
                         Halt(ErrorCode);
                      End;
   End;
End;

Function Error;
Begin
   Error:=ErrorFlag;
   ErrorFlag:=False;
End;

End.