/* Linker script for ELKS executables with combined data and text segment,
   without startup files, and with default libraries.  Generated
   from elk-mt.ld.in.  */

OUTPUT_FORMAT(binary)
ENTRY(_start)
GROUP(-lc -lgcc -lelks -lm)
MEMORY
  {
    /* Place header VMA outside of program address space.  */
    hdrlma  (r)	 : ORIGIN = 0x00000, LENGTH = 32
    hdrvma  (r)  : ORIGIN = 0x10000, LENGTH = 32

    /* Account for the 32-byte header.  */
    bseglma (wx) : ORIGIN = 0x00020, LENGTH = 0x10000
    bsegvma (wx) : ORIGIN = 0x00000, LENGTH = 0x10000
  }

SECTIONS
  {
    /* There's no binutils configuration which directly supports the ELKS
       binary format, but's it's easy to create the necessary header.  */
    .hdr : {
		LONG (0x04100301);	/* Magic.  */
		LONG (32);		/* Header length.  */
		LONG (__ltext_padded);
		LONG (__ldata);
		LONG (__lbss);
		LONG (_start);		/* Entry point.  */
		LONG (_total_adjusted);	/* Total memory allocated.  */
		LONG (0);
	} >hdrvma AT>hdrlma

    /* Target text sections.  */
    .text : {
		__stext = .;
		*(.startupA)
		*(.init)
		*(.startupB)
		*(.fini)
		*(.startupC)
		*(.text) *(.text.*)
		__etext = .;

		/* Work around linker bug.  The linker will 4-byte align the VMA
		 * without being asked to do so, but won't do the same for the
		 * LMA.  Result: VMA out of sync with LMA.
		 * GNU ld version 2.17.50.0.12-3 20070128  */
		. = ALIGN(4);
		__etext_padded = .;
	} >bsegvma AT>bseglma
	__ltext = __etext - __stext;
	__ltext_padded = __etext_padded - __stext;

    /* Target data sections.  */
    .data : {
		__sdata = .;

		/* Build lists of constructors and destructors.  */
		KEEP (*crtbegin*.o(.ctors))
		KEEP (*(EXCLUDE_FILE (*crtend*.o ) .ctors))
		KEEP (*(SORT(.ctors.*)))
		KEEP (*(.ctors))

		KEEP (*crtbegin*.o(.dtors))
		KEEP (*(EXCLUDE_FILE (*crtend*.o ) .dtors))
		KEEP (*(SORT(.dtors.*)))
		KEEP (*(.dtors))

		*(.rodata) *(.rodata.*)
		*(.data) *(.data.*)
		__edata = .;

		__sbss = .;
		*(.bss) *(.bss.*)
		*(COMMON)
		__ebss = .;
		. = ALIGN (8);
		__ebss_padded = .;

		/* Minimum address allowed for sbrk() to use.  */
		__heap_end_minimum = .;
		ASSERT (. + 0x100 <= 0x10000,
		    "Error: too large for a tiny-model ELKS a.out file.");
	} >bsegvma AT>bseglma
	__ldata = __edata - __sdata;
	__lbss  = __ebss  - __sbss;

	PROVIDE (_total = 0);
	_total_adjusted = _total == 0 ? 0
			  : MIN (0x10000, MAX (. + 0x100, _total));

    /DISCARD/ : { *(*) }
  }
