; CRC-32 table generation routine in Assembly
; Copyright (C) 2002 Davi T. Figueiredo
;
; Used in crc32.e (version 1.32), available from http://www16.brinkster.com/davitf/
;
; Please read crc32.txt for more information and for its license terms
; and disclaimer.


PUSH EAX            ; store old registers
PUSH EBX
PUSH ECX
PUSH EDX

MOV  EDX, table_address     ; EDX stores the address of the current word
MOV  EBX, 0         ; EBX stores the current character

ComputeTable:       ; run once for each character in the table

    MOV EAX,  EBX

    MOV CH,   0     ; CH is the loop count

    ComputeCRC:     ; we have to do this 8 times (one for each bit)

        MOV CL, AL  ; get character
        AND CL, 1   ; get least-significant bit

        SHR EAX,1   ; right-shift word

        CMP CL, 1   ; xor word with polynomial only if least-significant bit is 1
        JNE SkipXor
        XOR EAX, polynomial
        SkipXor:

        INC CH      ; increase loop count

    CMP CH, 8
    JB ComputeCRC   ; go back if loop count is less than 8

    MOV [EDX],EAX   ; write the word to the table
    INC EBX         ; move to next char
    ADD EDX,4       ; move to next address

CMP EBX,256
JB ComputeTable     ; any other character to process?

POP  EDX            ; restore registers
POP  ECX
POP  EBX
POP  EAX
RET

