REM ********************************************
REM * This file is part of the ANSiMat project *
REM ********************************************
REM
REM  These functions are using:
REM   Cursor.x       - x position (column)
REM   Cursor.y       - y position (line)
REM   Cursor.FgColor - foreground color index
REM   Cursor.BgColor - background color index
REM

SUB PrintChar(BYREF AscChar AS UBYTE, xPos AS INTEGER, yPos AS INTEGER)
REM Print char at xPos, yPos (if not provided, will use Cursor.x and Cursor.y)
DIM ColorNormal(0 TO 7) AS UBYTE
DIM ColorBright(0 TO 7) AS UBYTE
DIM ColorFaint(0 TO 7) AS UBYTE
ColorNormal(0) = 0 : ColorNormal(1) = 1
ColorNormal(2) = 2 : ColorNormal(3) = 3
ColorNormal(4) = 4 : ColorNormal(5) = 5
ColorNormal(6) = 6 : ColorNormal(7) = 7
ColorFaint(0) = 0 : ColorFaint(1) = 8
ColorFaint(2) = 9 : ColorFaint(3) = 10
ColorFaint(4) = 11 : ColorFaint(5) = 12
ColorFaint(6) = 13 : ColorFaint(7) = 14
ColorBright(0) = 15 : ColorBright(1) = 16
ColorBright(2) = 17 : ColorBright(3) = 18
ColorBright(4) = 19 : ColorBright(5) = 20
ColorBright(6) = 21 : ColorBright(7) = 22
DIM AS UBYTE FgColor, BgColor
DIM AS BYTE x, y

FOR y = 1 TO 16
  FOR x = 1 TO 8
    FgColor = ColorNormal(Cursor.FgColor)
    BgColor = ColorNormal(Cursor.BgColor)
    IF Cursor.Bright = 1 THEN FgColor = ColorBright(Cursor.FgColor)
    IF Cursor.Faint = 1 THEN FgColor = ColorFaint(Cursor.FgColor)
    IF Cursor.FastBlink = 1 OR Cursor.SlowBlink = 1 THEN BgColor = ColorBright(Cursor.BgColor)
    IF Cursor.Negative = 1 THEN
      BgColor = ColorNormal(Cursor.FgColor)
      FgColor = ColorNormal(Cursor.BgColor)
      IF Cursor.Bright = 1 THEN FgColor = ColorBright(Cursor.BgColor)
      IF Cursor.Faint = 1 THEN FgColor = ColorFaint(Cursor.BgColor)
      IF Cursor.FastBlink = 1 OR Cursor.SlowBlink = 1 THEN BgColor = ColorBright(Cursor.FgColor)
    END IF

    IF ((xPos - 1) * 8) + (x - 1) < 0 OR ((xPos - 1) * 8) + (x - 1) > 2047 THEN
      PRINT "xcoord! -> " & ((xPos - 1) * 8) + (x - 1)
      PRINT "xPos = " & xPos
      SLEEP 5000, 1
      CLOSE
      END(1)
    END IF
    IF ((yPos - 1) * 16) + (y - 1) < 0 OR ((yPos - 1) * 16) + (y - 1) > ((MaxAnsiHeight * 16) - 1) THEN
      PRINT "ERROR: This ANSI file is too high. You might want to try playing with the MaxAnsiHeight config parameter."
      PRINT "ycoord -> " & ((yPos - 1) * 16) + (y - 1)
      SLEEP 5000, 1
      CLOSE
      END(1)
    END IF

    IF BIT(FontData(AscChar, y), 8 - x) <> 0 OR Cursor.Invisible = 1 THEN
        BigScreenBuffer(((xPos - 1) * 8) + (x - 1), ((yPos - 1) * 16) + (y - 1)) = FgColor
      ELSE
        BigScreenBuffer(((xPos - 1) * 8) + (x - 1), ((yPos - 1) * 16) + (y - 1)) = BgColor
    END IF
  NEXT x
NEXT y
END SUB


FUNCTION GetAnsiParam(BYREF AnsiCmd AS STRING, BYREF IndexCmd AS INTEGER) AS STRING
  DIM AS STRING Result, WorkString, CharBuffer
  DIM AS INTEGER CurParam = 1
  IF LEFT(AnsiCmd, 2) = CHR(27) + "[" AND LEN(AnsiCmd) > 2 THEN
    WorkString = MID(AnsiCmd, 3) ' Strip first two chars
    WorkString = LEFT(WorkString, LEN(WorkString) - 1) ' Strip last char
    DO
      CharBuffer = LEFT(WorkString, 1)
      WorkString = MID(WorkString, 2)
      IF CharBuffer = ";" THEN
          CurParam += 1
        ELSE
          IF CurParam = IndexCmd THEN
            Result += CharBuffer
          END IF
      END IF
    LOOP UNTIL LEN(WorkString) = 0
  END IF
  RETURN Result
END FUNCTION
