#define USEWATTCP
/*
 * A note about include files. You will note that the Harvard PCIP that this
 * runs with uses its own non-standard header files. Thus we have to include
 * the prototypes for a number of functions that really should be in the
 * standard headers. Also, PCIP is bad as far as type consistency is concerned.
 * Since it is hopelessly tied to "small" memory model, we have just punted
 * so far as prototypes for pointers to functions.
 */

#include <stdio.h>

#ifdef USEWATTCP

#include <tcp.h>
#include <conio.h>
#define MAGIC 123   /* dunno */

#else /* pcip */
#include <types.h>
#include <task.h>
#include <q.h>
#include <netq.h>
#include <net.h>
#include <custom.h>
#include <netbuf.h>
#include <icmp.h>
#include <ip.h>
#include <timer.h>
#define MAGIC 123

int             ngetc(void);
int             ngetche(void);
void            clearscreen(void);
int             tcpwrite(int, char *, int);
void            usleep(void);
void            xabort(void);
void            reversevideo(char *);
void            normalvideo(void);
int             tcpread(int, char *, int);
int             tcpopen(char *, int);
void            tcp_open(in_name *, int, int, unsigned, unsigned);
int             twrite(char *, int);
int             kbhit(void);
void            exit(int);
int             getche(void);
int             write(int, char *, unsigned);

static task    *mtask;

static int      state;
static int      first = 1;

void            us_open(), us_cls(), no_op();
int             us_tmo(), us_yld();
int             us_data();

void            tcpclose(int);
in_name         resolve_name(char *);
void            tcp_init();

int
tcpopen(char *host, int port)
{
in_name         fhost;

    state = 0;
    tcp_init(512, us_open, us_data, us_yld, us_cls, us_tmo, no_op, no_op);

    if ((fhost = resolve_name(host)) == 0L) {
	fprintf(stderr, "Host %s unknown.\n", host);
	return (-1);
    }
    if (fhost == 1L) {
	fprintf(stderr, "Name servers not responding.\n");
	return (-1);
    }
    mtask = tk_cur;
    tcp_open(&fhost, port, 0, custom.c_telwin, custom.c_tellowwin);
    while (!state)
	tk_block();
    if (first) {
	first = 0;
	onexit(tcpclose);
    }
    return (MAGIC);
}

void
tcpclose(int fd)
{
    if (state) {
	tcp_close();
	tcp_reset();
	tk_yield();
    }
}

int
tcpwrite(int fd, char *p, int cnt)
{

    return (twrite(p, cnt));
}

#define BSZ (8*1024)
static char far buf[BSZ];
char far       *head = buf;
char far       *tail = buf;
int             bufcnt;


tcpread(int fd, char *p, int cnt)
{
register int    c;

    while (!bufcnt) {
	if (!state)
	    return (-1);
	tk_block();
    }
    if (cnt > bufcnt)
	cnt = bufcnt;
    c = cnt;
    bufcnt -= c;
    while (c--) {
	*p++ = *tail++;
	if (tail >= &buf[BSZ])
	    tail = buf;
    }
    return (cnt);
}

us_data(p, cnt, urg)
    register char  *p;
    register int    cnt, urg;
{
    while (cnt--) {
	while (bufcnt >= BSZ) {
	    tk_wake(mtask);
	    tk_yield();
	}
	*head++ = *p++;
	if (head >= &buf[BSZ])
	    head = buf;
	bufcnt++;
    }
    tk_wake(mtask);
}

us_tmo()
{
    fprintf(stderr, "Host not responding\n");
    tcp_close();
    tcp_reset();
    tk_yield();
    tk_wake(mtask);
}

void
no_op()
{
}

void
us_open()
{
    state = 1;
    tk_wake(mtask);
}

void
us_cls()
{

    state = 0;

    fflush(stdin);
    printf("Closed: hit any key to quit ");
    while (!kbhit());
    fflush(stdin);
    exit(3);
}

int
us_yld()
{
    return (1);
}
int
ngetche(void)
{
int             i;
    while (!kbhit())
	tk_yield();

    i = getche();
    if (!i) {
	getche();
	return 0;
    }
    return i;
}

int
ngetc(void)
{
register int    c;

    c = ngetche();
    write(1, "\n", 1);
    return (c);
}

#include <dos.h>
int             int86(int, union REGS *, union REGS *);


/*
 * The follwing routines all use BIOS calls (except xabort, which is the DOS
 * terminate program call). Int 16 is video, 0x1a is the clock. They are of
 * course rather arcane. If you don't understand them, I suggest the book
 * "DOS Programmer's Reference" by Terry R. Dettmann, Que Corp., Carmel,
 * Indiana. It is what I used to do the programming.
 */


void
backline(void)
{

union REGS      rg;
int             c, r;

    rg.h.ah = 3;   /* get cursor position */
    rg.h.bh = 0;
    int86(16, &rg, &rg);
    c = rg.h.dl;
    r = rg.h.dh - 1;

    rg.h.ah = 2;   /* set cursor position */
    rg.h.bh = 0;
    rg.h.dl = 0;
    rg.h.dh = r;
    int86(16, &rg, &rg);
    rg.h.ah = 9;   /* write character and attribute */
    rg.h.al = ' ';
    rg.h.bh = 0;
    rg.h.bl = 7;   /* normal attribute */
    rg.x.cx = 160;
    int86(16, &rg, &rg);

}

unsigned        strlen(char *);

void
reversevideo(char *buf)
{

union REGS      rg;
int             i, c, r;

    rg.h.ah = 3;   /* get cursor position */
    rg.h.bh = 0;
    int86(16, &rg, &rg);
    c = rg.h.dl;
    r = rg.h.dh;

    for (i = 0; i < strlen(buf); i++) {
	rg.h.ah = 2;	/* set cursor position */
	rg.h.bh = 0;
	rg.h.dl = i;
	rg.h.dh = r;
	int86(16, &rg, &rg);
	rg.h.ah = 9;	/* write character and attribute */
	rg.h.al = buf[i];
	rg.h.bh = 0;
	rg.h.bl = 16 * 7;	/* reverse video */
	rg.x.cx = 1;
	int86(16, &rg, &rg);
    }
}
void
normalvideo(void)
{

union REGS      rg;
int             c, r;

    rg.h.ah = 3;   /* get cursor position */
    rg.h.bh = 0;
    int86(16, &rg, &rg);
    c = rg.h.dl;
    r = rg.h.dh;

    rg.h.ah = 2;   /* set cursor position */
    rg.h.bh = 0;
    rg.h.dl = 0;
    rg.h.dh = r;
    int86(16, &rg, &rg);
    rg.h.ah = 9;   /* write character and attribute */
    rg.h.al = ' ';
    rg.h.bh = 0;
    rg.h.bl = 7;   /* normal attribute */
    rg.x.cx = 80;  /* number of characters */
    int86(16, &rg, &rg);

}


void
clearscreen(void)
{
union REGS      rg;

    rg.h.ah = 2;   /* see above, etc */
    rg.h.bh = 0;
    rg.h.dl = 0;
    rg.h.dh = 0;
    int86(16, &rg, &rg);

    rg.h.ah = 9;
    rg.h.al = ' ';
    rg.h.bh = 0;
    rg.h.bl = 16 * 7;
    rg.x.cx = 240;
    int86(16, &rg, &rg);

    rg.h.ah = 2;
    rg.h.bh = 0;
    rg.h.dl = 0;
    rg.h.dh = 3;
    int86(16, &rg, &rg);

    rg.h.ah = 9;
    rg.h.al = ' ';
    rg.h.bh = 0;
    rg.h.bl = 7;
    rg.x.cx = 22 * 80;
    int86(16, &rg, &rg);
    rg.h.ah = 2;
    rg.h.bh = 0;
    rg.h.dl = 0;
    rg.h.dh = 0;
    int86(16, &rg, &rg);
}


void
usleep(void)
{
int             i;
union REGS      rg;
union {
    unsigned int    i[2];
    unsigned long   l;
}               u;
unsigned long   t;

    rg.h.ah = 0;   /* get current time */
    int86(0x1a, &rg, &rg);
    u.i[1] = rg.x.cx;
    u.i[0] = rg.x.dx;

    t = u.l + 9;   /* add 9 ticks = 1/2 second */

    for (i = 0; i < 20000; i++) {	/* wait loop */
	rg.h.ah = 0;
	int86(0x1a, &rg, &rg);
	u.i[1] = rg.x.cx;
	u.i[0] = rg.x.dx;
	if (u.l >= t)
	    break;
    }

}

void
xabort()
{
union REGS      rg;

    /* this avoids onexit processing */
    rg.h.ah = 0x4c;
    rg.h.al = 0;
    int86(0x21, &rg, &rg);
    /* this interrupt never returns */
}

#endif /* USEWATTCP */

#ifdef USEWATTCP
/*
 * The follwing routines all use TURBO C calls
 */


void
backline(void)
{
    int temp;
    if ( temp = wherey() ) temp--;
    gotoxy( 1, temp );
    normvideo();
    putch( ' ' );
}

void
reversevideo(char *buf)
{
    highvideo();
    cputs( buf );
    normvideo();
}
void
normalvideo(void)
{
    normvideo();
    gotoxy( 1, wherey() );
    clreol();
}


void
clearscreen(void)
{
    clrscr();
}

void
xabort()
{
    exit( 30 );
}
int
ngetc(void)
{
register int    c;

    while ( !kbhit() )
        tcp_tick( NULL );

    c = getch();
    gotoxy(1, wherey());
    clreol();
    return (c);
}

#endif /* USEWATTCP */
                                                                                
