/*

 Nibbles - Copyright (C) 2000 Andrea Fazzi

 This file is part of Nibbles.

 Nibbles is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Nibbles is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Nibbles; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
//---------------------------------------------------------------------------
#include <stdio.h>
#include <pc.h>
#include <unistd.h>
#include <string.h>
#include <dos.h>
#include <conio.h>

#include "Vga256.h"
#include "Sprite.h"
#include "Font.h"
//---------------------------------------------------------------------------
#define   MODIFY 1
#define   NEW    2
//---------------------------------------------------------------------------
DblBuf *DBuffer;
unsigned char pal[768],openmode;

Sprite   *ptrRAW;
Sprite   *OutSPR;
FontBMP  *SystemFNT;

char *srcfile,*sprfile;

struct GrabRect {

  int x,y,W,H;

};

GrabRect Rect;
//---------------------------------------------------------------------------
void UpDateRect() {

  DBuffer->Rect(Rect.x,Rect.y,Rect.W,Rect.H);

}
//---------------------------------------------------------------------------
void print_help() {

 printf("\n");
 printf("                             **Sprite Grabber** v0.1\n");
 printf("             Nibbles sprite grabber Copyright (C) 2000 Andrea Fazzi\n");
 printf("\n");
 printf(" usage: sprgrab -options sourcefile.raw outputfile.spr\n");
 printf(" \n");

}
//---------------------------------------------------------------------------
int parse(int argcnt,char *argstring[]) {

 if(argcnt==1) return 0;

  else if(argcnt==3) {

   srcfile=argstring[1];
   sprfile=argstring[2];


   return 1;

 }

 else return 0;

}
//---------------------------------------------------------------------------
int main(int argc,char *argv[]) {

 int c=0,grabch=0;
 int i=0,cnt=0;

 unsigned char *scr;

 switch(parse(argc,argv)) {

  case 0: print_help();
          return 0;


 }

 SystemFNT=new FontBMP;
 SystemFNT->Init(255);
 SystemFNT->LoadFromFile("calisto.fnt");

 SetVgaMode(GRAPH256_MODE);
 scr=GrabScreenPtr();

 LoadPalette("nib1.pal",&pal[0]);
 SetPalette(&pal[0]);

 DBuffer=new DblBuf;
 ptrRAW= new Sprite;

  DBuffer->Init(scr);
  DBuffer->ClearBuf(0);

  ptrRAW->LoadFrom_RAW_File(srcfile);
  DBuffer->ClearBufPat(ptrRAW->PtrSprite);


  Rect.x=0;Rect.y=0;
  Rect.W=10;Rect.H=10;


    while(c!=27) {

     DBuffer->ClearBufPat(ptrRAW->PtrSprite);

      switch(c) {

       case '.': Rect.x++;
                 break;
       case ',': Rect.x--;
                 break;
       case 'a': Rect.y--;
                 break;
       case 'z': Rect.y++;
                 break;

       case 'm': Rect.W++;
                 break;
       case 'n': Rect.W--;
                 break;
       case 's': Rect.H--;
                 break;
       case 'x': Rect.H++;
                 break;

       case 13 : OutSPR->ReadSpriteFromBuf_2(DBuffer,Rect.x,Rect.y,Rect.W,Rect.H);
                 break;

       case '1': OutSPR->SaveToFile(sprfile);
                 break;


     }
        UpDateRect();

        WaitForRetrace();
        DBuffer->Flip();
        c=getch();

  }


   Release();
   SetVgaMode(TEXT_MODE);

   return 0;

}
//---------------------------------------------------------------------------