;-----------------------------------------------------------------------------
; name		: TEMACS.ASM
; object	: Tiny Editor - global macro's
; type		: include file
; version	: 1.7
; date		: Feb 20, 2000
; author	: J R Ferguson
;-----------------------------------------------------------------------------

beep		macro
		mov	ax,0E07h
		int	10h
		endm

setsta		macro	mask
		or	byte ptr [status],mask
		endm

ressta		macro	mask
		and	byte ptr [status],not (mask)
		endm

tststa		macro	mask
		test	byte ptr [status],mask
		endm

ifsta		macro	stamask,instrlist
		local	L1
		tststa	&stamask&
		jz	L1
		irp	instr,<&instrlist&>
		instr
		endm
L1:
		endm

asksi		macro	stringoff,maxlen
		mov	di,offset stringoff
		mov	cx,maxlen
		call	getstr
		endm

asksimod	macro	stringoff,maxlen
		mov	di,offset stringoff
		mov	cx,maxlen
		call	getstrmod
		endm

ask		macro	promptoff,stringoff,maxlen
		mov	si,offset promptoff
		asksi	stringoff,maxlen
		endm

xpush		macro	arglist
		irp	arg,<&arglist&>
		push	arg
		endm
		endm

xpop		macro	arglist
		irp	arg,<&arglist&>
		pop	arg
		endm
		endm

jumpif		macro	arg1,cond,arg2,dest
		cmp	arg1,arg2
		j&cond&	dest
		endm

iffalse		macro	value,dest
		jumpif	<&value&>,e,false,dest
		endm

iftrue		macro	value,dest
		jumpif	<&value&>,ne,false,dest
		endm

ifzero		macro	value,dest
		jumpif	<&value&>,e,0,dest
		endm

ifnzero		macro	value,dest
		jumpif	<&value&>,ne,0,dest
		endm

ifspace		macro	value,dest
		jumpif	<&value&>,e,<' '>,dest
		endm

iftab		macro	value,dest
		jumpif	<&value&>,e,tab,dest
		endm

ifntab		macro	value,dest
		jumpif	<&value&>,ne,tab,dest
		endm

ifwhite		macro	value,dest
		ifspace	<&value&>,dest
		iftab	<&value&>,dest
		endm

ifsep		macro	value,dest
		jumpif	<&value&>,be,<' '>,dest
		endm

ifnsep		macro	value,dest
		jumpif	<&value&>,a,<' '>,dest
		endm

ifnctrl		macro	value,dest
		jumpif	<&value&>,ae,<' '>,dest
		endm

caseal		macro	value,dest
		jumpif	al,e,<&value&>,&dest&
		endm

tglparm		macro	switch,TxtStaOff,TxtStaOn,HlpMsg
		mov	bx,offset &switch&
		mov	ax,offset TxtStaOff
		mov	dx,offset TxtStaOn
		mov	di,offset HlpMsg
		endm

toggle		macro	switch,TxtStaOff,TxtStaOn,HlpMsg
		tglparm	switch,TxtStaOff,TxtStaOn,HlpMsg
		jmp	short dotoggle
		endm

stal		macro	locationlist
		irp	location,<&locationlist&>
		mov	[&location&],al
		endm
		endm
		
stax		macro	locationlist
		irp	location,<&locationlist&>
		mov	[&location&],ax
		endm
		endm

staxz		macro	locationlist
		xor	ax,ax
		stax	<&locationlist&>
		endm

ctrcmd		macro	lab,table
&lab&:		mov	si,offset &table&
		endm

ctrcmdx		macro	lab,table
		ctrcmd	lab,table
		jmp	short subcmd
		endm
		
;--- END TEMACS.ASM ----------------------------------------------------------
