(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *)
(*  Soubor: DISK.PAS                                                       *)
(*  Obsah: veci pro praci se soubory a par diagnostickych procedur         *)
(*  Posledni uprava: 8.7.2006                                              *)
(*  Autor: Mircosoft                                                       *)
(*         TrSek (diagnostika, reset)                                      *)
(*         Laaca (napojeni na objekt PVaznik z unity Vaznik)               *)
(*  Pro kompilaci: (VAZNIK, DOS)                                           *)
(*  Pro spusteni: nic                                                      *)
(*  Upozorneni: tyto zdrojove kody pouzivate na vlastni nebezpeci          *)
(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *)
unit disk;
{$INCLUDE defines.inc}

{$I-} {nutne, aby fungoval ioresult a program nepadal}
interface
uses dos,vaznik,lacrt;

function ZkratCestu(C:pathstr;PocetZnaku:byte):pathstr;
{pokud je retezec C delsi nez PocetZnaku, zkrati se tak, ze misto zacatku
budou tri tecky. Vicemene pro kosmeticke ucely, treba pro zobrazovani jmen
souboru na obrazovku na nejaky omezeny prostor tak, aby to nejdulezitejsi -
jmeno souboru - zustalo citelne. Priklad:
 zkratcestu('c:\programy\doom\data\soubor.exe',20)
vrati retezec '...m\data\soubor.exe'}
procedure NastavDisk(dsk:char);
{prepne na dany disk (napr 'c', 'a' apod.)}
function ExistujeSoubor(jmeno:pathstr):boolean;
{zjisti, jestli existuje dany soubor}
function ExistujeAdresar(jmeno:pathstr):boolean;
{zjisti, jestli existuje dany adresar. Nerucim za 100% funkcnost u skrytych
adresaru a podobne (stejne jsem tuhle proceduru jeste nepouzil).}
function Kopiruj(zdroj,cil:pathstr):boolean;
{Kopiruje soubor zdroj do souboru cil. Pokud cil existuje,bude prepsan.
Vraci false, pokud se kopirovani nepovedlo, jinak true.}
function AdresarProgramu:dirstr;
{vraci adresar, ze ktereho byl prave bezici program spusten}
function JmenoSouboru(soubor:pathstr):namestr;
{vraci jmeno souboru bez cesty a koncovky}
function MaMechanikuA:boolean;
function MaMechanikuB:boolean;
{true v pripade, ze dana mechanika existuje, ani v ni nemusi byt disketa}
function TypDisku(ktereho:char):byte;
{vysledek: 0=neexistuje, 1=disketa, 2=harddisk, 3=sitovy disk,
4=prazdna disketova mechanika}
procedure ResetujPocitac;
{Zpusobi "teply restart" (ekvivalent ctrl+alt+del), funguje jen pod DOSem.}
function VymazSoubor(s:pathstr):boolean;
{vymaze soubor, vraci true, pokud se to povedlo, jinak false}
function SifrujSoubor(Zdroj,Cil:pathstr;Heslo:string):boolean;
{obsah souboru Zdroj prekopiruje v zasifrovane podobe do souboru Cil. Koduje
se jednoduchym xorovanim kazdeho bytu vstupniho souboru s jednim znakem Hesla,
z cehoz mimo jine vyplyva, ze zakodovani i rozkodovani se dela tou samou
procedurou (protoze A xor B xor B = A).
Pokud se za behu procedury vyskytne jakakoli chyba (neexistujici soubor atd.),
vraci se False, jinak True.}

Procedure Smaz_VS_S(var n:pointer);
Procedure Smaz_VS_A(var n:pointer);

type{pro nasledujici proceduru}

{Oba nasledujici typy vystupuji jako jednotlive polozky Vazniku (spojoveho seznamu)}
UkNaTSoubor=^TSoubor;
TSoubor=record
        jmeno:pstring;{jmeno a koncovka jsou zvlast, protoze se s tim pak lip pracuje}
        JmenoVelkymi:pstring;
        koncovka:pstring;{koncovka je bez predchazejici tecky}
        atributy:byte;
        velikost:longint;{v bytech}
        zmeneno:longint;{na rozbaleni casu je Unpacktime}
        end;

UkNaTAdresar=^TAdresar;
TAdresar=record
         jmeno:pstring;{predpokladam jmena adresaru bez koncovky}
         JmenoVelkymi:pstring;
         atributy:byte;
         zmeneno:longint;
         end;

const ddbg:boolean=false;

procedure SeznamSouboru(var seznam:PVaznik;maska:string);
{Prohleda aktualni adresar a vrati seznam souboru, ktere v nem najde,
setrideny podle abecedy. Vyhledava vsechny soubory vcetne skrytych.
 seznam^.dalsi - bude ukazovat na prvni soubor se seznamu
 koncovky - jaky typ souboru se ma hledat. Priklad: 'txt', '*' (jakakoli
            koncovka), '' (bez koncovky) apod. (piste bez tecky)}
procedure ZrusSeznamSouboru(var seznam:PVaznik);
{vymaze z pameti seznam vytvoreny procedurou SeznamSouboru}

procedure SeznamAdresaru(var seznam:PVaznik;maska:string);
{Podobne, ale dela seznam adresaru. Pokud existuje adresar '..' (da se jit o
uroven vys), bude v seznamu zaclenen na prvnim miste.}
procedure ZrusSeznamAdresaru(var seznam:PVaznik);
{vymaze seznam z pameti}

implementation

function ZkratCestu(C:pathstr;PocetZnaku:byte):pathstr;
Begin
if byte(c[0])>pocetznaku then{pokud je delka retezce C vetsi nez pozadovany pocet znaku}
  begin
  delete(c,1,byte(c[0])-pocetznaku);{vymazani prebytecnych znaku ze zacatku retezce}
  if byte(c[0])>3 then fillchar(c[1],3,'.');{nahrzeni prvnich tri znaku teckami}
  end;
zkratcestu:=c;
End;{zkratcestu}

procedure nastavdisk(dsk:char);
var b:byte;
Begin
b:=ord(upcase(dsk))-65;
asm
mov DL,b
mov AH,$0E
int $21
end;
End;{nastavdisk}

function existujesoubor(jmeno:pathstr):boolean;
var f:file;
Begin
assign(f,jmeno);
reset(f);
close(f);
existujesoubor:=ioresult=0;
End;{existujesoubor}

function ExistujeAdresar(jmeno:pathstr):boolean;
var info:searchrec;
Begin
findfirst(jmeno,directory,info);{slo by to testovat i tak, ze bych se do toho
adresare zkusil prepnout a pak se zase vratit,ale mam s tim spatne zkusenosti}
existujeadresar:=doserror=0;
End;{existujeadresar}

function kopiruj(zdroj,cil:pathstr):boolean;
var FromF,ToF:file;
    NumRead,NumWritten:Word;
    Buf:array[1..2048] of byte;
Begin                               {viz napovedu k prikazu blockwrite}
Assign(FromF,zdroj);
Reset(FromF,1);
if ioresult=0 then begin
                   Assign(ToF,cil);
                   Rewrite(ToF,1);
                   if ioresult=0 then begin
                                       repeat
                                       BlockRead(FromF,Buf,SizeOf(Buf),NumRead);
                                       BlockWrite(ToF,Buf,NumRead,NumWritten);
                                       until (NumRead=0) or (NumWritten<>NumRead);
                                      Close(FromF);
                                      Close(ToF);
                                      kopiruj:=true;
                                      end
                                 else begin
                                      close(fromf);
                                      kopiruj:=false;
                                      end;
                   end
              else kopiruj:=false;
End;{kopiruj}

function AdresarProgramu:dirstr;
var cesta:dirstr; jmeno:namestr; koncovka:extstr;
Begin
fsplit(paramstr(0),cesta,jmeno,koncovka);
adresarprogramu:=cesta;
End;{adresarprogramu}

function JmenoSouboru(soubor:pathstr):namestr;
var cesta:dirstr; jmeno:namestr; koncovka:extstr;
Begin
fsplit(soubor,cesta,jmeno,koncovka);
jmenosouboru:=jmeno;
End;{jmenosouboru}

function MaMechanikuA:boolean; assembler; {by TrSek, asm by Mircosoft}
Asm
int $11
and AX,1
End;{mamechanikua}

function MaMechanikuB:boolean; assembler; {by TrSek, asm by Mircosoft}
Asm
int $11
and AX,$C0
End;{mamechanikub}

function TypDisku(ktereho:char):byte;
var regAH:byte; regDX:word; cislo:byte;
Begin
cislo:=ord(upcase(ktereho))-65;
if cislo=1 then begin{A:}
                if mamechanikua then if diskfree(cislo)<0 then typdisku:=4{v mechanice neni disketa}
                                                          else typdisku:=1{v mechanice je disketa}
                                else typdisku:=0;{mechanika vubec neexistuje}
                end
 else if cislo=2 then begin{B:}
                      if mamechanikub then if diskfree(cislo)<0 then typdisku:=4
                                                                else typdisku:=1
                                      else typdisku:=0;
                      end
  else begin
       asm
       mov AX,$440F                  {by TrSek, asm by Mircosoft}
       mov BL,cislo
       int $21
       mov regAH,AH
       end;
       if(regAH<>0)or(disksize(cislo)<0)then typdisku:=0{disk neexistuje}
                                        else begin{existuje}
                                             asm
                                             mov AX,$4409
                                             mov BL,cislo          {by TrSek, asm by Mircosoft}
                                             int $21
                                             mov regDX,DX
                                             end;
                                             if (RegDX and $1000)=$1000 then typdisku:=3{network drive}
                                                                        else typdisku:=2;{harddisk}
                                             end;
       end;
End;{typdisku}

procedure ResetujPocitac;      {by TrSek}
var reboot:procedure;
Begin
(*
@reboot:=Ptr($FFFF,$0);
reboot;
*)
End;{resetujpocitac}

function VymazSoubor(s:pathstr):boolean;
var f:file;
Begin
assign(f,s);
erase(f);
vymazsoubor:=ioresult=0;
End;{vymazsoubor}

function SifrujSoubor(zdroj,cil:pathstr;heslo:string):boolean;
var f1,f2:file;
    bafr:array[1..1024]of byte;{bude se cist a psat po kilobytech}
    precteno,{kolik B bylo precteno ze vstupniho souboru}
    zapsano:word;{kolik B se podarilo zapsat do vystupniho souboru}
    i:word;{index pro pohyb v bufferu}
    j:byte;{index pro pohyb v heslu}
Begin
if heslo='' then heslo:='A';{blbuvzdornost musi byt (prazdnym heslem by sifrovat neslo)}
j:=1;{zacit se musi vzdy od prvniho znaku hesla}
sifrujsoubor:=false;{zatim nevime, jestli vsechno dobre dopadne}
assign(f1,zdroj); assign(f2,cil);{priradime promennym soubory}
reset(f1,1);{otevreme vstup}
if ioresult=0 then{kdyz to dobre dopadlo, tak pokracujeme}
  begin
  rewrite(f2,1);{otevreme vystup}
  if ioresult=0 then{kdyz to dobre dopadlo, tak pokracujeme, jinak...*}
    begin
     repeat
     blockread(f1,bafr,1024,precteno);{nacti 1024 bytu ze souboru f1, uloz je do bafru a do promenne Precteno uloz,
                                       kolik se jich ve skutecnosti podarilo precist}
     if precteno>0 then
      for i:=1 to precteno do begin{kodovani}
                              bafr[i]:=bafr[i] xor byte(heslo[j]);{a tohle je cely sifrovaci algoritmus :-)}
                              if j<byte(heslo[0]) then inc(j){a posuneme se v heslu bud na dalsi znak...}
                                                  else j:=1;{...nebo zpatky na zacatek, pokud uz jsme byli na konci}
                              end;
     blockwrite(f2,bafr,precteno,zapsano);{zapis z bafru do f2 tolik bytu, kolik jsi jich predtim nacetl z f1
                                           a do promenne Zapsano uloz, kolik se ti jich povedlo doopravdy zapsat}
     until (precteno<1024){jsme na konci vstupniho souboru}
        or(zapsano<precteno);{nebo doslo misto na disku s vystupnim souborem}
    close(f1); close(f2);{zavreme soubory}
    if (zapsano=precteno)and(ioresult=0)then sifrujsoubor:=true;{a jestli tohle vsechno dobre dopadlo, tak ohlasime,
                                                                 ze je vse v poradku}
    end
                else begin
                     close(f1);{*...zase zavreme vstup a koncime}
                     i:=ioresult;{to uz jen pro jistotu, aby se ioresult vynuloval po pripadnem neuspesnem zavreni}
                     end;
  end;
End;{sifrujsoubor}

Function Trideni_S(p,q:pointer):boolean;
var v1,v2:uknatsoubor;
begin
v1:=p;v2:=q;
Trideni_S:=v1^.JmenoVelkymi^<v2^.JmenoVelkymi^;
end;

Function Trideni_A(p,q:pointer):boolean;
var v1,v2:uknatadresar;
begin
v1:=p;v2:=q;
if v1^.jmeno^='..' then Exit(true) else
if v2^.jmeno^='..' then Exit(false) else
Trideni_A:=v1^.JmenoVelkymi^<v2^.JmenoVelkymi^;
end;

procedure SeznamSouboru(var seznam:PVaznik;maska:string);
var soubor:uknatsoubor;
    vysledek:searchrec;
    _cesta,_jmeno,_koncovka:string;
    _compproc:pointer;

Begin{seznamsouboru}
{vytvareni seznamu souboru:}

seznam:=New(PVaznik,Init(nil,nil));
if maska='' then maska:='*.*';
findfirst(maska,readonly+directory+sysfile+archive,vysledek);
while doserror=0 do{dokud je neco nalezeno...}
   begin
   if (vysledek.attr and directory)=0 then{...a neni to adresar (ma se delat seznam souboru, ne adresaru)}
      begin
      fsplit(vysledek.name,_cesta,_jmeno,_koncovka);
      New(soubor);
      soubor^.jmeno:=NaPstring(_jmeno);
      soubor^.JmenoVelkymi:=NaPstring(Convert_Up(vysledek.name));
      if (_koncovka<>'')and(_koncovka[1]='.') then delete(_koncovka,1,1);{umazani tecky z koncovky}
      soubor^.koncovka:=NaPstring(_koncovka);
      soubor^.atributy:=vysledek.attr;
      soubor^.velikost:=vysledek.size;
      soubor^.zmeneno:=vysledek.time;
      seznam^.InitNext(soubor);
      end;{if}
   findnext(vysledek);
   end;{while}
FindClose(vysledek);
{seznam je hotovy. Ted trideni:}
_compproc:=procSortComp;
procSortComp:=@Trideni_S;
seznam^.Setrid;
move(_compproc,procSortComp,4);
End;{seznamsouboru}


Procedure Smaz_VS_S(var n:pointer);
var p:UKnaTsoubor;
begin
p:=n;
ZrusPstring(p^.jmeno);
ZrusPstring(p^.JmenoVelkymi);
ZrusPstring(p^.koncovka);
Dispose(p);p:=nil;
end;

Procedure Smaz_VS_A(var n:pointer);
var p:UKnaTadresar;
begin
p:=n;
ZrusPstring(p^.jmeno);
ZrusPstring(p^.JmenoVelkymi);
Dispose(p);p:=nil;
end;

procedure ZrusSeznamSouboru(var seznam:PVaznik);
Begin
Vaznik_done_all(seznam,@Smaz_VS_S);
End;


procedure SeznamAdresaru(var seznam:PVaznik;maska:string);
var adresar:uknatadresar;
    vysledek:searchrec;
    _compproc:pointer;

Begin{seznamsouboru}
{vytvareni seznamu souboru:}
seznam:=New(PVaznik,Init(nil,nil));
findfirst(maska,readonly+directory+sysfile+archive,vysledek);
while doserror=0 do{dokud je neco nalezeno...}
   begin
   if ((vysledek.attr and directory)=directory)and(vysledek.name<>'.') then{adresar jiny nez ten, ve kterem zrovna jsme}
      begin
      New(adresar);
      adresar^.jmeno:=NaPstring(vysledek.name);
      adresar^.JmenoVelkymi:=NaPstring(Convert_Up(vysledek.name));
      adresar^.atributy:=vysledek.attr;
      adresar^.zmeneno:=vysledek.time;
      seznam^.InitNext(adresar);
      end;{if}
   findnext(vysledek);
   end;{while}
FindClose(vysledek);
{seznam je hotovy. Ted trideni:}
_compproc:=procSortComp;
procSortComp:=@Trideni_A;
seznam^.Setrid;
move(_compproc,procSortComp,4);
End;{seznamsouboru}

procedure ZrusSeznamAdresaru(var seznam:PVaznik);
Begin
Vaznik_done_all(seznam,@Smaz_VS_A);
End;{zrusseznamadresaru}

END.
