''
''
'' jit-opcode -- header translated with help of SWIG FB wrapper
''
'' NOTICE: This file is part of the FreeBASIC Compiler package and can't
''         be included in other distributions without authorization.
''
''
#ifndef __jit_opcode_bi__
#define __jit_opcode_bi__

#include "jit/jit-defs.bi"

#define JIT_OP_NOP &h0000
#define JIT_OP_TRUNC_SBYTE &h0001
#define JIT_OP_TRUNC_UBYTE &h0002
#define JIT_OP_TRUNC_SHORT &h0003
#define JIT_OP_TRUNC_USHORT &h0004
#define JIT_OP_TRUNC_INT &h0005
#define JIT_OP_TRUNC_UINT &h0006
#define JIT_OP_CHECK_SBYTE &h0007
#define JIT_OP_CHECK_UBYTE &h0008
#define JIT_OP_CHECK_SHORT &h0009
#define JIT_OP_CHECK_USHORT &h000A
#define JIT_OP_CHECK_INT &h000B
#define JIT_OP_CHECK_UINT &h000C
#define JIT_OP_LOW_WORD &h000D
#define JIT_OP_EXPAND_INT &h000E
#define JIT_OP_EXPAND_UINT &h000F
#define JIT_OP_CHECK_LOW_WORD &h0010
#define JIT_OP_CHECK_SIGNED_LOW_WORD &h0011
#define JIT_OP_CHECK_LONG &h0012
#define JIT_OP_CHECK_ULONG &h0013
#define JIT_OP_NFLOAT_TO_INT &h0014
#define JIT_OP_NFLOAT_TO_UINT &h0015
#define JIT_OP_NFLOAT_TO_LONG &h0016
#define JIT_OP_NFLOAT_TO_ULONG &h0017
#define JIT_OP_CHECK_NFLOAT_TO_INT &h0018
#define JIT_OP_CHECK_NFLOAT_TO_UINT &h0019
#define JIT_OP_CHECK_NFLOAT_TO_LONG &h001A
#define JIT_OP_CHECK_NFLOAT_TO_ULONG &h001B
#define JIT_OP_INT_TO_NFLOAT &h001C
#define JIT_OP_UINT_TO_NFLOAT &h001D
#define JIT_OP_LONG_TO_NFLOAT &h001E
#define JIT_OP_ULONG_TO_NFLOAT &h001F
#define JIT_OP_NFLOAT_TO_FLOAT32 &h0020
#define JIT_OP_NFLOAT_TO_FLOAT64 &h0021
#define JIT_OP_FLOAT32_TO_NFLOAT &h0022
#define JIT_OP_FLOAT64_TO_NFLOAT &h0023
#define JIT_OP_IADD &h0024
#define JIT_OP_IADD_OVF &h0025
#define JIT_OP_IADD_OVF_UN &h0026
#define JIT_OP_ISUB &h0027
#define JIT_OP_ISUB_OVF &h0028
#define JIT_OP_ISUB_OVF_UN &h0029
#define JIT_OP_IMUL &h002A
#define JIT_OP_IMUL_OVF &h002B
#define JIT_OP_IMUL_OVF_UN &h002C
#define JIT_OP_IDIV &h002D
#define JIT_OP_IDIV_UN &h002E
#define JIT_OP_IREM &h002F
#define JIT_OP_IREM_UN &h0030
#define JIT_OP_INEG &h0031
#define JIT_OP_LADD &h0032
#define JIT_OP_LADD_OVF &h0033
#define JIT_OP_LADD_OVF_UN &h0034
#define JIT_OP_LSUB &h0035
#define JIT_OP_LSUB_OVF &h0036
#define JIT_OP_LSUB_OVF_UN &h0037
#define JIT_OP_LMUL &h0038
#define JIT_OP_LMUL_OVF &h0039
#define JIT_OP_LMUL_OVF_UN &h003A
#define JIT_OP_LDIV &h003B
#define JIT_OP_LDIV_UN &h003C
#define JIT_OP_LREM &h003D
#define JIT_OP_LREM_UN &h003E
#define JIT_OP_LNEG &h003F
#define JIT_OP_FADD &h0040
#define JIT_OP_FSUB &h0041
#define JIT_OP_FMUL &h0042
#define JIT_OP_FDIV &h0043
#define JIT_OP_FREM &h0044
#define JIT_OP_FREM_IEEE &h0045
#define JIT_OP_FNEG &h0046
#define JIT_OP_DADD &h0047
#define JIT_OP_DSUB &h0048
#define JIT_OP_DMUL &h0049
#define JIT_OP_DDIV &h004A
#define JIT_OP_DREM &h004B
#define JIT_OP_DREM_IEEE &h004C
#define JIT_OP_DNEG &h004D
#define JIT_OP_NFADD &h004E
#define JIT_OP_NFSUB &h004F
#define JIT_OP_NFMUL &h0050
#define JIT_OP_NFDIV &h0051
#define JIT_OP_NFREM &h0052
#define JIT_OP_NFREM_IEEE &h0053
#define JIT_OP_NFNEG &h0054
#define JIT_OP_IAND &h0055
#define JIT_OP_IOR &h0056
#define JIT_OP_IXOR &h0057
#define JIT_OP_INOT &h0058
#define JIT_OP_ISHL &h0059
#define JIT_OP_ISHR &h005A
#define JIT_OP_ISHR_UN &h005B
#define JIT_OP_LAND &h005C
#define JIT_OP_LOR &h005D
#define JIT_OP_LXOR &h005E
#define JIT_OP_LNOT &h005F
#define JIT_OP_LSHL &h0060
#define JIT_OP_LSHR &h0061
#define JIT_OP_LSHR_UN &h0062
#define JIT_OP_BR &h0063
#define JIT_OP_BR_IFALSE &h0064
#define JIT_OP_BR_ITRUE &h0065
#define JIT_OP_BR_IEQ &h0066
#define JIT_OP_BR_INE &h0067
#define JIT_OP_BR_ILT &h0068
#define JIT_OP_BR_ILT_UN &h0069
#define JIT_OP_BR_ILE &h006A
#define JIT_OP_BR_ILE_UN &h006B
#define JIT_OP_BR_IGT &h006C
#define JIT_OP_BR_IGT_UN &h006D
#define JIT_OP_BR_IGE &h006E
#define JIT_OP_BR_IGE_UN &h006F
#define JIT_OP_BR_LFALSE &h0070
#define JIT_OP_BR_LTRUE &h0071
#define JIT_OP_BR_LEQ &h0072
#define JIT_OP_BR_LNE &h0073
#define JIT_OP_BR_LLT &h0074
#define JIT_OP_BR_LLT_UN &h0075
#define JIT_OP_BR_LLE &h0076
#define JIT_OP_BR_LLE_UN &h0077
#define JIT_OP_BR_LGT &h0078
#define JIT_OP_BR_LGT_UN &h0079
#define JIT_OP_BR_LGE &h007A
#define JIT_OP_BR_LGE_UN &h007B
#define JIT_OP_BR_FEQ &h007C
#define JIT_OP_BR_FNE &h007D
#define JIT_OP_BR_FLT &h007E
#define JIT_OP_BR_FLE &h007F
#define JIT_OP_BR_FGT &h0080
#define JIT_OP_BR_FGE &h0081
#define JIT_OP_BR_FEQ_INV &h0082
#define JIT_OP_BR_FNE_INV &h0083
#define JIT_OP_BR_FLT_INV &h0084
#define JIT_OP_BR_FLE_INV &h0085
#define JIT_OP_BR_FGT_INV &h0086
#define JIT_OP_BR_FGE_INV &h0087
#define JIT_OP_BR_DEQ &h0088
#define JIT_OP_BR_DNE &h0089
#define JIT_OP_BR_DLT &h008A
#define JIT_OP_BR_DLE &h008B
#define JIT_OP_BR_DGT &h008C
#define JIT_OP_BR_DGE &h008D
#define JIT_OP_BR_DEQ_INV &h008E
#define JIT_OP_BR_DNE_INV &h008F
#define JIT_OP_BR_DLT_INV &h0090
#define JIT_OP_BR_DLE_INV &h0091
#define JIT_OP_BR_DGT_INV &h0092
#define JIT_OP_BR_DGE_INV &h0093
#define JIT_OP_BR_NFEQ &h0094
#define JIT_OP_BR_NFNE &h0095
#define JIT_OP_BR_NFLT &h0096
#define JIT_OP_BR_NFLE &h0097
#define JIT_OP_BR_NFGT &h0098
#define JIT_OP_BR_NFGE &h0099
#define JIT_OP_BR_NFEQ_INV &h009A
#define JIT_OP_BR_NFNE_INV &h009B
#define JIT_OP_BR_NFLT_INV &h009C
#define JIT_OP_BR_NFLE_INV &h009D
#define JIT_OP_BR_NFGT_INV &h009E
#define JIT_OP_BR_NFGE_INV &h009F
#define JIT_OP_ICMP &h00A0
#define JIT_OP_ICMP_UN &h00A1
#define JIT_OP_LCMP &h00A2
#define JIT_OP_LCMP_UN &h00A3
#define JIT_OP_FCMPL &h00A4
#define JIT_OP_FCMPG &h00A5
#define JIT_OP_DCMPL &h00A6
#define JIT_OP_DCMPG &h00A7
#define JIT_OP_NFCMPL &h00A8
#define JIT_OP_NFCMPG &h00A9
#define JIT_OP_IEQ &h00AA
#define JIT_OP_INE &h00AB
#define JIT_OP_ILT &h00AC
#define JIT_OP_ILT_UN &h00AD
#define JIT_OP_ILE &h00AE
#define JIT_OP_ILE_UN &h00AF
#define JIT_OP_IGT &h00B0
#define JIT_OP_IGT_UN &h00B1
#define JIT_OP_IGE &h00B2
#define JIT_OP_IGE_UN &h00B3
#define JIT_OP_LEQ &h00B4
#define JIT_OP_LNE &h00B5
#define JIT_OP_LLT &h00B6
#define JIT_OP_LLT_UN &h00B7
#define JIT_OP_LLE &h00B8
#define JIT_OP_LLE_UN &h00B9
#define JIT_OP_LGT &h00BA
#define JIT_OP_LGT_UN &h00BB
#define JIT_OP_LGE &h00BC
#define JIT_OP_LGE_UN &h00BD
#define JIT_OP_FEQ &h00BE
#define JIT_OP_FNE &h00BF
#define JIT_OP_FLT &h00C0
#define JIT_OP_FLE &h00C1
#define JIT_OP_FGT &h00C2
#define JIT_OP_FGE &h00C3
#define JIT_OP_FEQ_INV &h00C4
#define JIT_OP_FNE_INV &h00C5
#define JIT_OP_FLT_INV &h00C6
#define JIT_OP_FLE_INV &h00C7
#define JIT_OP_FGT_INV &h00C8
#define JIT_OP_FGE_INV &h00C9
#define JIT_OP_DEQ &h00CA
#define JIT_OP_DNE &h00CB
#define JIT_OP_DLT &h00CC
#define JIT_OP_DLE &h00CD
#define JIT_OP_DGT &h00CE
#define JIT_OP_DGE &h00CF
#define JIT_OP_DEQ_INV &h00D0
#define JIT_OP_DNE_INV &h00D1
#define JIT_OP_DLT_INV &h00D2
#define JIT_OP_DLE_INV &h00D3
#define JIT_OP_DGT_INV &h00D4
#define JIT_OP_DGE_INV &h00D5
#define JIT_OP_NFEQ &h00D6
#define JIT_OP_NFNE &h00D7
#define JIT_OP_NFLT &h00D8
#define JIT_OP_NFLE &h00D9
#define JIT_OP_NFGT &h00DA
#define JIT_OP_NFGE &h00DB
#define JIT_OP_NFEQ_INV &h00DC
#define JIT_OP_NFNE_INV &h00DD
#define JIT_OP_NFLT_INV &h00DE
#define JIT_OP_NFLE_INV &h00DF
#define JIT_OP_NFGT_INV &h00E0
#define JIT_OP_NFGE_INV &h00E1
#define JIT_OP_IS_FNAN &h00E2
#define JIT_OP_IS_FINF &h00E3
#define JIT_OP_IS_FFINITE &h00E4
#define JIT_OP_IS_DNAN &h00E5
#define JIT_OP_IS_DINF &h00E6
#define JIT_OP_IS_DFINITE &h00E7
#define JIT_OP_IS_NFNAN &h00E8
#define JIT_OP_IS_NFINF &h00E9
#define JIT_OP_IS_NFFINITE &h00EA
#define JIT_OP_FACOS &h00EB
#define JIT_OP_FASIN &h00EC
#define JIT_OP_FATAN &h00ED
#define JIT_OP_FATAN2 &h00EE
#define JIT_OP_FCEIL &h00EF
#define JIT_OP_FCOS &h00F0
#define JIT_OP_FCOSH &h00F1
#define JIT_OP_FEXP &h00F2
#define JIT_OP_FFLOOR &h00F3
#define JIT_OP_FLOG &h00F4
#define JIT_OP_FLOG10 &h00F5
#define JIT_OP_FPOW &h00F6
#define JIT_OP_FRINT &h00F7
#define JIT_OP_FROUND &h00F8
#define JIT_OP_FSIN &h00F9
#define JIT_OP_FSINH &h00FA
#define JIT_OP_FSQRT &h00FB
#define JIT_OP_FTAN &h00FC
#define JIT_OP_FTANH &h00FD
#define JIT_OP_DACOS &h00FE
#define JIT_OP_DASIN &h00FF
#define JIT_OP_DATAN &h0100
#define JIT_OP_DATAN2 &h0101
#define JIT_OP_DCEIL &h0102
#define JIT_OP_DCOS &h0103
#define JIT_OP_DCOSH &h0104
#define JIT_OP_DEXP &h0105
#define JIT_OP_DFLOOR &h0106
#define JIT_OP_DLOG &h0107
#define JIT_OP_DLOG10 &h0108
#define JIT_OP_DPOW &h0109
#define JIT_OP_DRINT &h010A
#define JIT_OP_DROUND &h010B
#define JIT_OP_DSIN &h010C
#define JIT_OP_DSINH &h010D
#define JIT_OP_DSQRT &h010E
#define JIT_OP_DTAN &h010F
#define JIT_OP_DTANH &h0110
#define JIT_OP_NFACOS &h0111
#define JIT_OP_NFASIN &h0112
#define JIT_OP_NFATAN &h0113
#define JIT_OP_NFATAN2 &h0114
#define JIT_OP_NFCEIL &h0115
#define JIT_OP_NFCOS &h0116
#define JIT_OP_NFCOSH &h0117
#define JIT_OP_NFEXP &h0118
#define JIT_OP_NFFLOOR &h0119
#define JIT_OP_NFLOG &h011A
#define JIT_OP_NFLOG10 &h011B
#define JIT_OP_NFPOW &h011C
#define JIT_OP_NFRINT &h011D
#define JIT_OP_NFROUND &h011E
#define JIT_OP_NFSIN &h011F
#define JIT_OP_NFSINH &h0120
#define JIT_OP_NFSQRT &h0121
#define JIT_OP_NFTAN &h0122
#define JIT_OP_NFTANH &h0123
#define JIT_OP_IABS &h0124
#define JIT_OP_LABS &h0125
#define JIT_OP_FABS &h0126
#define JIT_OP_DABS &h0127
#define JIT_OP_NFABS &h0128
#define JIT_OP_IMIN &h0129
#define JIT_OP_IMIN_UN &h012A
#define JIT_OP_LMIN &h012B
#define JIT_OP_LMIN_UN &h012C
#define JIT_OP_FMIN &h012D
#define JIT_OP_DMIN &h012E
#define JIT_OP_NFMIN &h012F
#define JIT_OP_IMAX &h0130
#define JIT_OP_IMAX_UN &h0131
#define JIT_OP_LMAX &h0132
#define JIT_OP_LMAX_UN &h0133
#define JIT_OP_FMAX &h0134
#define JIT_OP_DMAX &h0135
#define JIT_OP_NFMAX &h0136
#define JIT_OP_ISIGN &h0137
#define JIT_OP_LSIGN &h0138
#define JIT_OP_FSIGN &h0139
#define JIT_OP_DSIGN &h013A
#define JIT_OP_NFSIGN &h013B
#define JIT_OP_CHECK_NULL &h013C
#define JIT_OP_CALL &h013D
#define JIT_OP_CALL_TAIL &h013E
#define JIT_OP_CALL_INDIRECT &h013F
#define JIT_OP_CALL_INDIRECT_TAIL &h0140
#define JIT_OP_CALL_VTABLE_PTR &h0141
#define JIT_OP_CALL_VTABLE_PTR_TAIL &h0142
#define JIT_OP_CALL_EXTERNAL &h0143
#define JIT_OP_CALL_EXTERNAL_TAIL &h0144
#define JIT_OP_RETURN &h0145
#define JIT_OP_RETURN_INT &h0146
#define JIT_OP_RETURN_LONG &h0147
#define JIT_OP_RETURN_FLOAT32 &h0148
#define JIT_OP_RETURN_FLOAT64 &h0149
#define JIT_OP_RETURN_NFLOAT &h014A
#define JIT_OP_RETURN_SMALL_STRUCT &h014B
#define JIT_OP_SETUP_FOR_NESTED &h014C
#define JIT_OP_SETUP_FOR_SIBLING &h014D
#define JIT_OP_IMPORT &h014E
#define JIT_OP_THROW &h014F
#define JIT_OP_RETHROW &h0150
#define JIT_OP_LOAD_PC &h0151
#define JIT_OP_LOAD_EXCEPTION_PC &h0152
#define JIT_OP_ENTER_FINALLY &h0153
#define JIT_OP_LEAVE_FINALLY &h0154
#define JIT_OP_CALL_FINALLY &h0155
#define JIT_OP_ENTER_FILTER &h0156
#define JIT_OP_LEAVE_FILTER &h0157
#define JIT_OP_CALL_FILTER &h0158
#define JIT_OP_CALL_FILTER_RETURN &h0159
#define JIT_OP_ADDRESS_OF_LABEL &h015A
#define JIT_OP_COPY_LOAD_SBYTE &h015B
#define JIT_OP_COPY_LOAD_UBYTE &h015C
#define JIT_OP_COPY_LOAD_SHORT &h015D
#define JIT_OP_COPY_LOAD_USHORT &h015E
#define JIT_OP_COPY_INT &h015F
#define JIT_OP_COPY_LONG &h0160
#define JIT_OP_COPY_FLOAT32 &h0161
#define JIT_OP_COPY_FLOAT64 &h0162
#define JIT_OP_COPY_NFLOAT &h0163
#define JIT_OP_COPY_STRUCT &h0164
#define JIT_OP_COPY_STORE_BYTE &h0165
#define JIT_OP_COPY_STORE_SHORT &h0166
#define JIT_OP_ADDRESS_OF &h0167
#define JIT_OP_INCOMING_REG &h0168
#define JIT_OP_INCOMING_FRAME_POSN &h0169
#define JIT_OP_OUTGOING_REG &h016A
#define JIT_OP_OUTGOING_FRAME_POSN &h016B
#define JIT_OP_RETURN_REG &h016C
#define JIT_OP_PUSH_INT &h016D
#define JIT_OP_PUSH_LONG &h016E
#define JIT_OP_PUSH_FLOAT32 &h016F
#define JIT_OP_PUSH_FLOAT64 &h0170
#define JIT_OP_PUSH_NFLOAT &h0171
#define JIT_OP_PUSH_STRUCT &h0172
#define JIT_OP_POP_STACK &h0173
#define JIT_OP_FLUSH_SMALL_STRUCT &h0174
#define JIT_OP_SET_PARAM_INT &h0175
#define JIT_OP_SET_PARAM_LONG &h0176
#define JIT_OP_SET_PARAM_FLOAT32 &h0177
#define JIT_OP_SET_PARAM_FLOAT64 &h0178
#define JIT_OP_SET_PARAM_NFLOAT &h0179
#define JIT_OP_SET_PARAM_STRUCT &h017A
#define JIT_OP_PUSH_RETURN_AREA_PTR &h017B
#define JIT_OP_LOAD_RELATIVE_SBYTE &h017C
#define JIT_OP_LOAD_RELATIVE_UBYTE &h017D
#define JIT_OP_LOAD_RELATIVE_SHORT &h017E
#define JIT_OP_LOAD_RELATIVE_USHORT &h017F
#define JIT_OP_LOAD_RELATIVE_INT &h0180
#define JIT_OP_LOAD_RELATIVE_LONG &h0181
#define JIT_OP_LOAD_RELATIVE_FLOAT32 &h0182
#define JIT_OP_LOAD_RELATIVE_FLOAT64 &h0183
#define JIT_OP_LOAD_RELATIVE_NFLOAT &h0184
#define JIT_OP_LOAD_RELATIVE_STRUCT &h0185
#define JIT_OP_STORE_RELATIVE_BYTE &h0186
#define JIT_OP_STORE_RELATIVE_SHORT &h0187
#define JIT_OP_STORE_RELATIVE_INT &h0188
#define JIT_OP_STORE_RELATIVE_LONG &h0189
#define JIT_OP_STORE_RELATIVE_FLOAT32 &h018A
#define JIT_OP_STORE_RELATIVE_FLOAT64 &h018B
#define JIT_OP_STORE_RELATIVE_NFLOAT &h018C
#define JIT_OP_STORE_RELATIVE_STRUCT &h018D
#define JIT_OP_ADD_RELATIVE &h018E
#define JIT_OP_LOAD_ELEMENT_SBYTE &h018F
#define JIT_OP_LOAD_ELEMENT_UBYTE &h0190
#define JIT_OP_LOAD_ELEMENT_SHORT &h0191
#define JIT_OP_LOAD_ELEMENT_USHORT &h0192
#define JIT_OP_LOAD_ELEMENT_INT &h0193
#define JIT_OP_LOAD_ELEMENT_LONG &h0194
#define JIT_OP_LOAD_ELEMENT_FLOAT32 &h0195
#define JIT_OP_LOAD_ELEMENT_FLOAT64 &h0196
#define JIT_OP_LOAD_ELEMENT_NFLOAT &h0197
#define JIT_OP_STORE_ELEMENT_BYTE &h0198
#define JIT_OP_STORE_ELEMENT_SHORT &h0199
#define JIT_OP_STORE_ELEMENT_INT &h019A
#define JIT_OP_STORE_ELEMENT_LONG &h019B
#define JIT_OP_STORE_ELEMENT_FLOAT32 &h019C
#define JIT_OP_STORE_ELEMENT_FLOAT64 &h019D
#define JIT_OP_STORE_ELEMENT_NFLOAT &h019E
#define JIT_OP_MEMCPY &h019F
#define JIT_OP_MEMMOVE &h01A0
#define JIT_OP_MEMSET &h01A1
#define JIT_OP_ALLOCA &h01A2
#define JIT_OP_MARK_OFFSET &h01A3
#define JIT_OP_MARK_BREAKPOINT &h01A4
#define JIT_OP_JUMP_TABLE &h01A5
#define JIT_OP_NUM_OPCODES &h01A6

type jit_opcode_info_t as jit_opcode_info

type jit_opcode_info
	name as zstring ptr
	flags as integer
end type

#define JIT_OPCODE_DEST_MASK &h0000000F
#define JIT_OPCODE_DEST_EMPTY &h00000000
#define JIT_OPCODE_DEST_INT &h00000001
#define JIT_OPCODE_DEST_LONG &h00000002
#define JIT_OPCODE_DEST_FLOAT32 &h00000003
#define JIT_OPCODE_DEST_FLOAT64 &h00000004
#define JIT_OPCODE_DEST_NFLOAT &h00000005
#define JIT_OPCODE_DEST_ANY &h00000006
#define JIT_OPCODE_SRC1_MASK &h000000F0
#define JIT_OPCODE_SRC1_EMPTY &h00000000
#define JIT_OPCODE_SRC1_INT &h00000010
#define JIT_OPCODE_SRC1_LONG &h00000020
#define JIT_OPCODE_SRC1_FLOAT32 &h00000030
#define JIT_OPCODE_SRC1_FLOAT64 &h00000040
#define JIT_OPCODE_SRC1_NFLOAT &h00000050
#define JIT_OPCODE_SRC1_ANY &h00000060
#define JIT_OPCODE_SRC2_MASK &h00000F00
#define JIT_OPCODE_SRC2_EMPTY &h00000000
#define JIT_OPCODE_SRC2_INT &h00000100
#define JIT_OPCODE_SRC2_LONG &h00000200
#define JIT_OPCODE_SRC2_FLOAT32 &h00000300
#define JIT_OPCODE_SRC2_FLOAT64 &h00000400
#define JIT_OPCODE_SRC2_NFLOAT &h00000500
#define JIT_OPCODE_SRC2_ANY &h00000600
#define JIT_OPCODE_IS_BRANCH &h00001000
#define JIT_OPCODE_IS_CALL &h00002000
#define JIT_OPCODE_IS_CALL_EXTERNAL &h00004000
#define JIT_OPCODE_IS_REG &h00008000
#define JIT_OPCODE_IS_ADDROF_LABEL &h00010000
#define JIT_OPCODE_IS_JUMP_TABLE &h00020000
#define JIT_OPCODE_OPER_MASK &h01F00000
#define JIT_OPCODE_OPER_NONE &h00000000
#define JIT_OPCODE_OPER_ADD &h00100000
#define JIT_OPCODE_OPER_SUB &h00200000
#define JIT_OPCODE_OPER_MUL &h00300000
#define JIT_OPCODE_OPER_DIV &h00400000
#define JIT_OPCODE_OPER_REM &h00500000
#define JIT_OPCODE_OPER_NEG &h00600000
#define JIT_OPCODE_OPER_AND &h00700000
#define JIT_OPCODE_OPER_OR &h00800000
#define JIT_OPCODE_OPER_XOR &h00900000
#define JIT_OPCODE_OPER_NOT &h00A00000
#define JIT_OPCODE_OPER_EQ &h00B00000
#define JIT_OPCODE_OPER_NE &h00C00000
#define JIT_OPCODE_OPER_LT &h00D00000
#define JIT_OPCODE_OPER_LE &h00E00000
#define JIT_OPCODE_OPER_GT &h00F00000
#define JIT_OPCODE_OPER_GE &h01000000
#define JIT_OPCODE_OPER_SHL &h01100000
#define JIT_OPCODE_OPER_SHR &h01200000
#define JIT_OPCODE_OPER_SHR_UN &h01300000
#define JIT_OPCODE_OPER_COPY &h01400000
#define JIT_OPCODE_OPER_ADDRESS_OF &h01500000
#define JIT_OPCODE_DEST_PTR &h00000001
#define JIT_OPCODE_SRC1_PTR &h00000010
#define JIT_OPCODE_SRC2_PTR &h00000100
extern jit_opcodes(0 to JIT_OP_NUM_OPCODES-1) alias "jit_opcodes" as jit_opcode_info_t

#endif
