;	FILE CUTMACS.ASM
;	10/16/84
;	REVISED 12/19/84
;
;	A SET OF GENERAL-PURPOSE MACROS FOR 8086 ASSEMBLY LANGUAGE.
;
;	AUTHOR: MIKE BARALL
;
;
;	INNER MACROS
;
;
IFNDEF	M186
M186	=	0		;DISALLOW 80186/80286 INSTRUCTIONS
ENDIF

IFNDEF	M187
M187	=	0		;NOT 187/387 PROCESSOR
ELSE

IFNDEF	M186
M186	=	1		;ALLOW 186/286/386 INSTRUCTIONS
ENDIF

ENDIF

IF (M186 EQ 0)
	.8086
	.8087
ELSE
	.286
	.287
ENDIF



MMGLD	MACRO	?REG,?VAL
	IFDIF	<?REG>,<?VAL>
	MOV	?REG,?VAL
	ENDIF
	ENDM
;
;	REGISTER IDENTIFICATION MACROS
;
ISREG	MACRO	?VAR
	ISREGB	<?VAR>
	MMIRGW	<?VAR>
	IRP	?REG,<DS,ES,CS,SS>
	IFIDNI	<?REG>,<?VAR>
REGTYPE	=	3
	ENDIF
	ENDM
	ENDM
;
ISREGB	MACRO	?VAR
REGTYPE	=	0
	IRP	?REG,<AL,AH,BL,BH,CL,CH,DL,DH>
	IFIDNI	<?REG>,<?VAR>
REGTYPE	=	1
	ENDIF
	ENDM
	ENDM
;
ISREGW	MACRO	?VAR
REGTYPE	=	0
	MMIRGW	<?VAR>
	ENDM
;
MMIRGW	MACRO	?VAR
	IRP	?REG,<AX,BX,CX,DX,SI,DI,BP,SP>
	IFIDNI	<?REG>,<?VAR>
REGTYPE	=	2
	ENDIF
	ENDM
	ENDM
;
;	MEMORY-TO-MEMORY MACROS
;
;
MOVW	MACRO	?DST,?SRC
	MOV	AX,?SRC
	MOV	?DST,AX
	ENDM
;
MOVB	MACRO	?DST,?SRC
	MOV	AL,?SRC
	MOV	?DST,AL
	ENDM

;	BLOCK MOVE MACRO -- SOURCE & DESTINATION IN  DATA SEGMENT

BLKMOV	MACRO	?DST,?SRS,?NBYTES
	PUSHM	ES,SI,DI,CX
	PUSH	DS
	POP	ES
	LEA	CX,?SRS
	LEA	DI,?DST
	MOV	SI,CX
	CLD
	IF (?NBYTES) AND 1
	MOV	CX,?NBYTES
	REP	MOVSB
	ELSE
	MOV	CX,(?NBYTES) SHR 1
	REP	MOVSW
	ENDIF
	POPM	ES,SI,DI,CX
	ENDM

;
;	PUSH/POP MACROS
;
PUSHM	MACRO	?A,?B,?C,?D,?E,?F,?G,?H,?I,?J,?K,?L
	IFNB	<?A>
	PUSHM	<?B>,<?C>,<?D>,<?E>,<?F>,<?G>,<?H>,<?I>,<?J>,<?K>,<?L>
	IFIDNI	<?A>,<F>
	PUSHF
	ELSE
	PUSH	?A
	ENDIF
	ENDIF
	ENDM
;
;jrc041989    FORMER -POPF- SEQUENCE:
;;;	DB	0EBH,1,0CFH,0EH,0E8H,0FBH,0FFH
;jrc041989


POPM	MACRO	?A,?B,?C,?D,?E,?F,?G,?H,?I,?J,?K,?L
	IFNB	<?A>
	IFIDNI	<?A>,<F>
	IF	M186
        POPF
	ELSE
	JMP	$+3
	IRET
	PUSH	CS
	CALL	$-2
	ENDIF
	ELSE
	POP	?A
	ENDIF
	POPM	<?B>,<?C>,<?D>,<?E>,<?F>,<?G>,<?H>,<?I>,<?J>,<?K>,<?L>
	ENDIF
	ENDM
;
;	TEST-AND-JUMP MACROS
;
JCLR	MACRO	?SRC,?TRG
	IFIDNI	<?SRC>,<CX>
	JCXZ	?TRG
	ELSE
	ISREG	<?SRC>
	IF	REGTYPE
	OR	?SRC,?SRC
	ELSE
	CMP	?SRC,0
	ENDIF
	JE	?TRG
	ENDIF
	ENDM
;
JNCLR	MACRO	?SRC,?TRG
	ISREG	<?SRC>
	IF	REGTYPE
	OR	?SRC,?SRC
	ELSE
	CMP	?SRC,0
	ENDIF
	JNE	?TRG
	ENDM
;
CLR	MACRO	?DST
	ISREG	<?DST>
	IF	REGTYPE
	XOR	?DST,?DST
	ELSE
	MOV	?DST,0
	ENDIF
	ENDM
;
JSET	MACRO	?DST,?SRC,?TRG
	TEST	?DST,?SRC
	JNE	?TRG
	ENDM
;
JRES	MACRO	?DST,?SRC,?TRG
	TEST	?DST,?SRC
	JE	?TRG
	ENDM
;
;	80286 I/O DELAY MACRO
;
IODELAY	MACRO
	JMP	SHORT $+2
	ENDM
;
;	MULTIPLE SHIFT/ROTATE
;
MSH	MACRO	?INS,?REG,?CNT
	IF	M186 AND (?CNT GT 2)
	?INS	?REG,?CNT
	ELSE
	REPT	?CNT
	?INS	?REG,1
	ENDM
	ENDIF
	ENDM

;
;	PUSHA	push all MACRO or instruction
;	POPA	pop all MACRO or instruction
;
IF M186
; 80186/80286 INSTRUCTIONS MAY BE USED
ELSE
; 80186/80286 INSTRUCTIONS MUST BE SIMULATED

PUSHA	MACRO
	PUSH	AX
	PUSH	CX
	PUSH	DX
	PUSH	BX
;; PUSH original SP:
	PUSH	BP
	MOV	BP,SP
	ADD	BP,10
	XCHG	BP,SS:[BP-10]
;; end PUSH SP
	PUSH	BP
	PUSH	SI
	PUSH	DI
	ENDM

POPA	MACRO
	POP	DI
	POP	SI
	POP	BP
	POP	BX	;REALLY SP
	POP	BX
	POP	DX
	POP	CX
	POP	AX
	ENDM

LEAVE	MACRO
	MOV	SP,BP
	POP	BP
	ENDM

ENTER	MACRO	?NBYTES,?LEVEL
	LOCAL	?I
	PUSH	BP
IF ?LEVEL LE 1
	MOV	BP,SP
ELSE
?I = 0
REPT	?LEVEL - 1
?I = ?I + 2
	PUSH	SS:[BP-?I]
ENDM
	MOV	BP,?I
	ADD	BP,SP
ENDIF
IF ?LEVEL GE 1
	PUSH	BP
ENDIF
IF ?NBYTES NE 0
	SUB	SP,?NBYTES
ENDIF
	ENDM

ENDIF


FPOP	MACRO
	FSTP	ST(0)
	ENDM

