/* This defines a char * to the text of The Warper
 * project description. It's a long text.
 */

/************************************************************************************/

char *Command_summary_string[] =
{
	"\n\n*** SUMMARY OF OPTIONS ***\n",
	"\nExecute this program with any of the following arguments from the command line:\n",
	"\nd<n> = Set delay after each picture, where <n> is a number of seconds to pause.\n",
	"p<n> = Set a specific palette, where <n> is the palette number 0 - 8\n",
	
	/* Undocumented feature
		"f<n> = Set a specific function to be the first picture.\n",
	*/
	
	"   w = Print info on building \"The Warper\". You may wish to redirect to\n",
	"       a file or pipe through DOS's MORE command.\n",
	"   ? = Print Help and Explaination info.\n",
	"\n*** CTRL-BREAK will exit the program at any time. ***\n",
	"\nThis program is free and public domain. It may not be\n",
	"used for profit. I am not responsible for physical, personal,\n",
	"property, or brain damage. Enjoy!\n",
	"   -- Noah Spurrier\n",
	""
};

/************************************************************************************/

char *Help_string[] =
{
	"\n",
	"                           WHAT IS ACID WARP ?\n",
	"\n",
	"Acid Warp falls into the genre of programs known as kaleidoscopes or pretty\n",
	"picture programs. Acid Warp generates pictures by evaluating a simple\n",
	"mathematical formula over a two dimensional range and plotting the value at\n",
	"some point as a color. Acid Warp selects from over thirty formulae to use\n",
	"for a picture. A color palette pattern is also selected for each picture.\n",
	"While the picture is displayed, the color palette is rotated in a variety\n",
	"of ways. A crude timer-interrupt multitasking system is used to rotate the\n",
	"color palette while Acid Warp works on the next picture. Picture generation\n",
	"is extremely fast due to the elimination of any floating point variables.\n",
	"Look-up-tables or approximations are used when Square Roots, Sines,\n",
	"Arctangents, or other functions are necessary.\n",
	"\n",
	"Acid Warp has only a few options described in detail below. Enter them as\n",
	"arguments when executing Acid Warp from the command line.\n",
	"\n",
	"'d' - Option for Delay\n",
	"      On fast machines the pictures may be generated so quickly that you\n",
	"      will not have time to appreciate each picture. If this is the case\n",
	"      then a delay may be added after each picture. Use the 'd' option\n",
	"      followed by a number of seconds to delay. Do not add a space between\n",
	"      the 'd' and the number of seconds. The default delay is 20 seconds.\n",
	"\n",
	"'p' - Option to select Palette\n",
	"      By default, Acid Warp will randomly select one of 9 palettes types.\n",
	"      You may force the palette to stay one type. Use the 'p' option\n",
	"      followed by a palette number. Do not add a space between the 'p' and\n",
	"      the palette number. The following palettes are available:\n",
	"\n",
	"      0: Sharp palette with four bands of Red, Green, Blue, and White.\n",
	"      1: Smooth White palette\n",
	"      2: Smooth White palette, but bolder than #1\n",
	"      3: A Pastel palette\n",
	"      4: Palette #0 with sparkles\n",
	"      5: Palette #1 with sparkles\n",
	"      6: Palette #2 with sparkles\n",
	"      7: Palette #3 with sparkles\n",
	"      8: A special dynamic \"morph\" palette. Constantly morphs from one\n",
	"         palette number to another. Very Weird effects.\n",
	"\n",
	"'w' - Option to print \"The Warper\" text file\n",
	"      It is possible to take the pictures from Acid Warp and project them\n",
	"      onto a wall or movie screen using a very simple and inexpensive setup\n",
	"      that I have called \"The Warper\". The Warper allows you to view your\n",
	"      Acid Warp picture on a wall or screen just as you would view a slide\n",
	"      show or movie. You can get instructions for building The Warper by\n",
	"      selecting the 'w' option. These instructions fill quite a few\n",
	"      screens, so you may wish to redirect to a file or printer or you may\n",
	"      wish to pipe it through DOS's MORE command. I highly recommend\n",
	"      building The Warper. All you need are two cardboard boxes and a\n",
	"      Fresnel lens (sources for this are listed.) The Warper is lots of\n",
	"      fun; it is cheap; and anyone can build it in half an hour.\n",
	""
};

/************************************************************************************/

char *The_warper_string[] =
{
	"\n",
	"                          #######   #        #\n",
	"                             ##   ##       ##\n",
	"                            ##   ##       ##\n",
	"                           ##   ##   #   ##\n",
	"                          ###  ###  #   ######\n",
	"                         ###  #######  ###\n",
	"                         ###  ###   #  ###\n",
	"                         ###  ###   #  #######\n",
	"\n",
	"              #       #    #        #        #        #        #\n",
	"            ##      ##   ###      ###      ###      ##       ###\n",
	"           ##      ##   ## #     ## #     ## #     ##       ## #\n",
	"          ##      ##   ##  #    ##  #    ##  #    ##       ##  #\n",
	"         ###  #  ##   ######   ######   ######   ######   ######\n",
	"        ###  ## ###  ###   #  ####     ###      ###      ####\n",
	"        ### ### ###  ###   #  ### ##   ###      ###      ### ##\n",
	"        #####  ####  ###   #  ###   #  ###      #######  ###   #\n",
	"\n",
	"\n",
	"\n",
	"\n",
	"\n",
	"                  (c)Copyright 1992 by Noah Spurrier\n",
	"\n",
	"---------------------------\n",
	" Description of The Warper\n",
	"---------------------------\n",
	"The Warper is a simple device for enhancing the pleasure that you get from\n",
	"running your Acid Warp program. The Warper is a single lens projector that\n",
	"attaches to your computer monitor and allows you to enlarge and project the\n",
	"Acid Warp images onto a wall, movie screen, white bed-sheet, etc. The\n",
	"device should cost you less than $20.00.\n",
	"\n",
	"I will give only a general schematic for building The Warper. The design is\n",
	"quite simple and it will be easy for you to fit the design to your supplies\n",
	"and equipment size. The only special item that you will need is one large\n",
	"Fresnel lens. A Fresnel lens is usually encountered as a thin, floppy sheet\n",
	"of plastic that has the same optical properties as a glass lens many inches\n",
	"thicker. You may use a true glass lens. For our purposes we need a lens about\n",
	"6 inches or more in diameter. A glass lens this size would be very heavy and\n",
	"expensive, but if you have one on hand then try to use it because it should\n",
	"give a better image. The following instructions assume that you will be using\n",
	"a Fresnel lens.\n",
	"\n",
	"You will need a lens about 6\" x 6\". You can make The Warper with a smaller\n",
	"lens, but it will be less effective. You can certainly use a larger lens.\n",
	"I will give sources of cheap Fresnel lenses at the end of this text. Don't\n",
	"worry about focal length. For surplus and hobby grade equipment, you must\n",
	"take what you can get. A focal length of about 5 inches is fine. Often you\n",
	"won't even be told what the focal length is. Only the focus will have to be\n",
	"adjusted to compensate for the focal length of your lens.\n",
	"\n",
	"When you get your Fresnel lens, take it and your computer into a dark room.\n",
	"Activate the computer and execute the Acid Warp program. Now Aim the\n",
	"computer monitor at a white wall, movie screen, white sheet, etc. The\n",
	"plane of the monitor screen should be roughly parallel to the plane of the\n",
	"projection surface. Now hold your lens in front of the computer monitor.\n",
	"The lens should also be roughly parallel to the projection surface and the\n",
	"computer monitor. As you vary the distance between the lens and the monitor\n",
	"you will be able to focus an upside-down image from the monitor onto the\n",
	"projection surface. The exact distance between the screen and the lens will\n",
	"vary on how far your monitor is from the projection surface and the focal\n",
	"length of your lens. For my setup, a wall is about 12 feet away and the\n",
	"lens is held about a foot from the screen. The image covers most of the\n",
	"wall. You may never be able to get the focus good enough to read 80 column\n",
	"text, but you should be able to easily read the Acid Warp title screen.\n",
	"\n",
	"Besides the wobbly image and arm strain this method is flawed for one\n",
	"technical reason. A very large amount of light leaks off to the sides of\n",
	"the lens and fills the room with stray light. This badly washes out the\n",
	"image. All that is necessary to fix this is to enclose the monitor is a\n",
	"black box with the lens as the only opening for light to escape.\n",
	"\n",
	"-------------------------\n",
	" How to Build The Warper\n",
	"-------------------------\n",
	"Here is the simple method that you can scale to your supplies and skill. You\n",
	"only need two cardboard boxes to make the black, light-tight box. Use wood,\n",
	"metal, or plastic if you want a fancy box. You will have to work out the\n",
	"details for those materials by yourself. For my first prototype I used wine\n",
	"boxes that I got from a bar where I work. Wine boxes are very sturdy. For your\n",
	"boxes one should fit inside the other. You may need to rip the side panel\n",
	"seam on one box and reglue it so that it is slightly smaller or larger. Fit\n",
	"is not critical, as long as the boxes are snug, yet slide easily. This\n",
	"telescope action will allow you to focus.\n",
	"\n",
	"Spray paint the insides with FLAT BLACK paint. If you don't paint the inside\n",
	"then the results will not be as good.\n",
	"\n",
	"Cut a hole for the lens in one end of the larger box and attach the lens\n",
	"over this opening. Remove the flaps from the other end of the box or fold.\n",
	"them in. If you fold them in then the bigger box will fit more snuggly around.\n",
	"the smaller box.\n",
	"\n",
	"One end of the smaller box should have its flaps pulled open, but not cut\n",
	"off. These flaps fit over and around the monitor. Remove the flaps from the\n",
	"other end of the box.\n",
	"\n",
	"When complete, the flaps of the smaller box should be taped to the sides and\n",
	"top of the monitor. It does not matter if the fit is rough. The important\n",
	"thing is to make sure that very litle light escapes and that The Warper is\n",
	"held straight and steady on the front of the monitor.\n",
	"\n",
	"The larger box will fit over the smaller box and slide toward or away from\n",
	"the monitor screen. This will allow you to adjust the focus. You may need\n",
	"to put some blocks under the front (lens end) of The Warper to prevent it\n",
	"from sagging. I had no trouble with wine boxes.\n",
	"\n",
	"If you cannot move the lens close enough to the screen to get proper focus\n",
	"then simply trim a few inches off the edges of the open ends of the boxes\n",
	"where the smaller box meets to slide into the larger box.\n",
	"\n",
	"                                          /  FLAP\n",
	"                                        /'\n",
	"          |--------------------       /'.-----------        BACK OF\n",
	"          |       -------------------|  \\   TOP    |`\\      MONITOR\n",
	"         :|                          |   #         |  `\\--, <------\n",
	"         : HOLE                      |   #         |   |  |\n",
	"         :                           |   #         |   |  |\n",
	"         :                           |   #  SIDE   |   |  | CABLE\n",
	"         :                           |   #         |   |  |-------()\n",
	"    LENS :|                          |   #         |   /--'\n",
	"          |       -------------------|  /   BOTTOM | /\\     AC PLUG\n",
	"          |--------------------      `\\ `-----------'  \\_________,--\n",
	"               < ------- >             `\\                        `--\n",
	"                  MOVE                   `\\  FLAP\n",
	"                  FOR\n",
	"                  FOCUS\n",
	"                                                 CROSS-SECTION DIAGRAM\n",
	"\n",
	"Your Warper is now ready for use!\n",
	"\n",
	"For best results: use a white projection surface; make the room very dark;\n",
	"turn up the brightness of your monitor. You may also need to adjust color.\n",
	"\n",
	"-------------------------------\n",
	" Sources for Your Fresnel Lens\n",
	"-------------------------------\n",
	"American Science and Surplus Co.\n",
	"(Formerly Jerry Co.)\n",
	"601 Linden Place\n",
	"Evanston, IL 60202\n",
	"Orders 708-475-8440\n",
	"\n",
	"AS&S sells a hodge podge of surplus items. Some of it is good,\n",
	"some of it is junk. When you get their catalog, look for the \"Optics\"\n",
	"section. They should still have a large supply of 11\" x 11\" fresnel lenses\n",
	"for $1.95. They also sell an 11\" x 11\" Twin Layer lens for $3.25. These\n",
	"lenses have minor scratches. A friend informed me that for our purposes\n",
	"they work well. If they are sold out of these particular lenses then they\n",
	"will probably have others that will work. Minimum Order is $10.00.\n",
	"\n",
	"\n",
	"\n",
	"Edmund Scientific Co.\n",
	"101 East Gloucester Pike\n",
	"Barrington, NJ 08007-1380\n",
	"Orders 609-573-6250\n",
	"       609-547-3488\n",
	"FAX    609-573-6295\n",
	"\n",
	"Edmund Scientific Co. sells quality optics as well as hobby materials. When\n",
	"you get their catalog, do not want to start looking in the Optics section\n",
	"(unless you want to pay $30.00 for a 6\" x 7\" lens.) Look in the index under\n",
	"\"Fresnel\" or \"Lenses\". There should be some lenses referenced in the hobby\n",
	"section of their catalog. There, find a listing for an 8.5\" x 11\" lens for\n",
	"about $7.95. They also sell a 7\" x 10\" lens for about $5.95. This is the\n",
	"size I originally used.\n",
	"\n",
	"\n",
	"\n",
	"Herbach and Rademan Co.\n",
	"18 Canal Street\n",
	"P.O. 122\n",
	"Bristol PA, 19007-0122\n",
	"Orders 800-848-8001\n",
	"FAX    215-788-9577\n",
	"Office 215-788-5583\n",
	"\n",
	"H&R Co. sells new and surplus equipment for science and industry. They have\n",
	"a small selection of inexpensive multilens units and rear projection screens\n",
	"for TV projection systems. Most of the projection lenses are designed for a\n",
	"specific size of TV tube and may not necessarily be ideal for a different\n",
	"sized monitor, but the prices are low and these lenses are worthy of\n",
	"experimentation. H&R also sells single multipurpose glass and fresnel lenses\n",
	"in large sizes.\n",
	"\n",
	"\n",
	"\n",
	"Macrocoma Co.\n",
	"Dept. m\n",
	"15 North Main St.\n",
	"Washington Crossing, PA 18977\n",
	"Orders 215-736-2880\n",
	"\n",
	"Macrocoma is a weird company. They sell TV-Projector conversion kits. They\n",
	"also sell a booklet on how to make Fresnel lenses. I don't recommend it.\n",
	"They sell a Fresnel lens for about $15.00. I think the quality is supposed\n",
	"to be quite good. Ask for \"The Master Lens\" (Special made, Triple\n",
	"inspected, the best of the best.)\n",
	"\n",
	"The Warper (c)Copyright 1992 by Noah Spurrier\n",
	""
};

/************************************************************************************/
