/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.optifine.Config;
import net.optifine.Log;
import net.optifine.entity.model.CustomEntityModelParser;
import net.optifine.entity.model.CustomEntityRenderer;
import net.optifine.entity.model.CustomModelRegistry;
import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.anim.IModelResolver;
import net.optifine.entity.model.anim.ModelResolver;
import net.optifine.entity.model.anim.ModelUpdater;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorField;
import net.optifine.util.Either;
import net.optifine.util.StrUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomEntityModels {
    private static boolean active = false;
    private static Map<bbr, fek> originalEntityRenderMap = null;
    private static Map<ctk, fbp> originalTileEntityRenderMap = null;
    private static Map<cqm.a, ete> originalSkullModelMap = null;
    private static List<ctk> customTileEntityTypes = new ArrayList();
    private static eqw customBookModel;
    private static boolean debugModels;

    public static void update() {
        Map entityRenderMap = CustomEntityModels.getEntityRenderMap();
        Map tileEntityRenderMap = CustomEntityModels.getTileEntityRenderMap();
        Map skullModelMap = CustomEntityModels.getSkullModelMap();
        if (entityRenderMap == null) {
            Config.warn((String)"Entity render map not found, custom entity models are DISABLED.");
            return;
        }
        if (tileEntityRenderMap == null) {
            Config.warn((String)"Tile entity render map not found, custom entity models are DISABLED.");
            return;
        }
        active = false;
        entityRenderMap.clear();
        tileEntityRenderMap.clear();
        skullModelMap.clear();
        customTileEntityTypes.clear();
        entityRenderMap.putAll(originalEntityRenderMap);
        tileEntityRenderMap.putAll(originalTileEntityRenderMap);
        skullModelMap.putAll(originalSkullModelMap);
        eze blockEntityRenderer = efu.I().ai().getBlockEntityRenderer();
        blockEntityRenderer.j = new etl(ModelAdapter.bakeModelLayer((euc)eud.bx));
        fip.customParrotModel = null;
        customBookModel = null;
        fbp.CACHED_TYPES.clear();
        if (efu.I().s != null) {
            Iterable entities = efu.I().s.e();
            for (bbn entity : entities) {
                Map modelVariables = entity.ai().modelVariables;
                if (modelVariables == null) continue;
                modelVariables.clear();
            }
        }
        if (!Config.isCustomEntityModels()) {
            return;
        }
        abb[] locs = CustomEntityModels.getModelLocations();
        for (int i2 = 0; i2 < locs.length; ++i2) {
            abb loc = locs[i2];
            Config.dbg((String)("CustomEntityModel: " + loc.a()));
            IEntityRenderer rc = CustomEntityModels.parseEntityRender((abb)loc);
            if (rc == null) continue;
            Either type = rc.getType();
            if (rc instanceof fek) {
                ffx pr2;
                esj pm2;
                fgw tr;
                etl tm;
                entityRenderMap.put((bbr)type.getLeft().get(), (fek)rc);
                if (rc instanceof fgw && (tm = (etl)Reflector.getFieldValue((Object)(tr = (fgw)rc), (ReflectorField)Reflector.RenderTrident_modelTrident)) != null) {
                    blockEntityRenderer.j = tm;
                }
                if (rc instanceof ffx && (pm2 = (esj)(pr2 = (ffx)rc).a()) != null) {
                    fip.customParrotModel = pm2;
                }
            } else if (rc instanceof fbp) {
                tileEntityRenderMap.put((ctk)type.getRight().get(), (fbp)rc);
                if (rc instanceof fbw) {
                    fbw etr = (fbw)rc;
                    eqw bm = (eqw)Reflector.getFieldValue((Object)etr, (ReflectorField)Reflector.TileEntityEnchantmentTableRenderer_modelBook);
                    CustomEntityModels.setEnchantmentScreenBookModel((eqw)bm);
                }
                customTileEntityTypes.add((ctk)type.getRight().get());
            } else {
                Config.warn((String)("Unknown renderer type: " + rc.getClass().getName()));
            }
            active = true;
        }
    }

    private static void setEnchantmentScreenBookModel(eqw bookModel) {
        customBookModel = bookModel;
    }

    private static Map<bbr, fek> getEntityRenderMap() {
        fej rm = efu.I().ag();
        Map entityRenderMap = rm.getEntityRenderMap();
        if (entityRenderMap == null) {
            return null;
        }
        if (originalEntityRenderMap == null) {
            originalEntityRenderMap = new HashMap(entityRenderMap);
        }
        return entityRenderMap;
    }

    private static Map<ctk, fbp> getTileEntityRenderMap() {
        fbo blockEntityRenderDispatcher = efu.I().ah();
        Map tileEntityRenderMap = blockEntityRenderDispatcher.getBlockEntityRenderMap();
        if (originalTileEntityRenderMap == null) {
            originalTileEntityRenderMap = new HashMap(tileEntityRenderMap);
        }
        return tileEntityRenderMap;
    }

    private static Map<cqm.a, ete> getSkullModelMap() {
        HashMap skullModelMap = fcb.models;
        if (skullModelMap == null) {
            Config.warn((String)"Field not found: SkullBlockRenderer.MODELS");
            skullModelMap = new HashMap();
        }
        if (originalSkullModelMap == null) {
            originalSkullModelMap = new HashMap(skullModelMap);
        }
        return skullModelMap;
    }

    private static abb[] getModelLocations() {
        String prefix = "optifine/cem/";
        String suffix = ".jem";
        ArrayList<abb> resourceLocations = new ArrayList<abb>();
        String[] names = CustomModelRegistry.getModelNames();
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            String path = prefix + name + suffix;
            abb loc = new abb(path);
            if (!Config.hasResource((abb)loc) && !debugModels) continue;
            resourceLocations.add(loc);
        }
        abb[] locs = resourceLocations.toArray(new abb[resourceLocations.size()]);
        return locs;
    }

    private static IEntityRenderer parseEntityRender(abb location) {
        try {
            if (debugModels) {
                return CustomEntityModels.makeDebugEntityRenderer((abb)location);
            }
            JsonObject jo = CustomEntityModelParser.loadJson((abb)location);
            IEntityRenderer render = CustomEntityModels.parseEntityRender((JsonObject)jo, (String)location.a());
            return render;
        }
        catch (IOException e2) {
            Config.error((String)(e2.getClass().getName() + ": " + e2.getMessage()));
            return null;
        }
        catch (JsonParseException e3) {
            Config.error((String)(((Object)((Object)e3)).getClass().getName() + ": " + e3.getMessage()));
            return null;
        }
        catch (Exception e4) {
            Log.warn((String)("Error loading CEM: " + location), (Throwable)e4);
            return null;
        }
    }

    private static IEntityRenderer makeDebugEntityRenderer(abb loc) {
        String path = loc.a();
        String nameJem = StrUtils.removePrefix((String)path, (String)"optifine/cem/");
        String name = StrUtils.removeSuffix((String)nameJem, (String)".jem");
        ModelAdapter ma = CustomModelRegistry.getModelAdapter((String)name);
        esf model = ma.makeModel();
        bzq[] colors = bzq.values();
        int offset = Math.abs(loc.hashCode()) % 256;
        String[] partNames = ma.getModelRendererNames();
        for (int i2 = 0; i2 < partNames.length; ++i2) {
            String partName = partNames[i2];
            eue part = ma.getModelRenderer(model, partName);
            if (part == null) continue;
            bzq col = colors[(i2 + offset) % colors.length];
            abb locTexture = new abb("textures/block/" + col.c() + "_stained_glass.png");
            part.setTextureLocation(locTexture);
            Config.dbg((String)("  " + partName + ": " + col.c()));
        }
        IEntityRenderer er = ma.makeEntityRender(model, ma.getShadowSize());
        if (er == null) {
            return null;
        }
        er.setType(ma.getType());
        return er;
    }

    private static IEntityRenderer parseEntityRender(JsonObject obj, String path) {
        CustomEntityRenderer cer2 = CustomEntityModelParser.parseEntityRender((JsonObject)obj, (String)path);
        String name = cer2.getName();
        ModelAdapter modelAdapter = CustomModelRegistry.getModelAdapter((String)name);
        CustomEntityModels.checkNull((Object)modelAdapter, (String)("Entity not found: " + name));
        Either type = modelAdapter.getType();
        CustomEntityModels.checkNull((Object)type, (String)("Entity type not found: " + name));
        IEntityRenderer render = CustomEntityModels.makeEntityRender((ModelAdapter)modelAdapter, (CustomEntityRenderer)cer2);
        if (render == null) {
            return null;
        }
        render.setType(type);
        return render;
    }

    private static IEntityRenderer makeEntityRender(ModelAdapter modelAdapter, CustomEntityRenderer cer2) {
        esf model;
        abb textureLocation = cer2.getTextureLocation();
        CustomModelRenderer[] modelRenderers = cer2.getCustomModelRenderers();
        float shadowSize = cer2.getShadowSize();
        if (shadowSize < 0.0f) {
            shadowSize = modelAdapter.getShadowSize();
        }
        if ((model = modelAdapter.makeModel()) == null) {
            return null;
        }
        ModelResolver mr = new ModelResolver(modelAdapter, model, modelRenderers);
        if (!CustomEntityModels.modifyModel((ModelAdapter)modelAdapter, (esf)model, (CustomModelRenderer[])modelRenderers, (ModelResolver)mr)) {
            return null;
        }
        IEntityRenderer r = modelAdapter.makeEntityRender(model, shadowSize);
        if (r == null) {
            throw new JsonParseException("Entity renderer is null, model: " + modelAdapter.getName() + ", adapter: " + modelAdapter.getClass().getName());
        }
        if (textureLocation != null) {
            CustomEntityModels.setTextureLocation((ModelAdapter)modelAdapter, (esf)model, (IEntityRenderer)r, (abb)textureLocation);
        }
        return r;
    }

    private static void setTextureLocation(ModelAdapter modelAdapter, esf model, IEntityRenderer er, abb textureLocation) {
        if (modelAdapter.setTextureLocation(er, textureLocation)) {
            return;
        }
        if (er instanceof ffm) {
            er.setLocationTextureCustom(textureLocation);
            return;
        }
        CustomEntityModels.setTextureTopModelRenderers((ModelAdapter)modelAdapter, (esf)model, (abb)textureLocation);
    }

    public static void setTextureTopModelRenderers(ModelAdapter modelAdapter, esf model, abb textureLocation) {
        String[] parts = modelAdapter.getModelRendererNames();
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2];
            eue modelRenderer = modelAdapter.getModelRenderer(model, part);
            if (modelRenderer == null || modelRenderer.getTextureLocation() != null) continue;
            modelRenderer.setTextureLocation(textureLocation);
        }
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, esf model, CustomModelRenderer[] modelRenderers, ModelResolver mr) {
        for (int i2 = 0; i2 < modelRenderers.length; ++i2) {
            CustomModelRenderer cmr2 = modelRenderers[i2];
            if (CustomEntityModels.modifyModel((ModelAdapter)modelAdapter, (esf)model, (CustomModelRenderer)cmr2, (ModelResolver)mr)) continue;
            return false;
        }
        return true;
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, esf model, CustomModelRenderer customModelRenderer, ModelResolver modelResolver) {
        String modelPart = customModelRenderer.getModelPart();
        eue parent = modelAdapter.getModelRenderer(model, modelPart);
        if (parent == null) {
            Config.warn((String)("Model part not found: " + modelPart + ", model: " + model));
            return false;
        }
        if (!customModelRenderer.isAttach()) {
            if (parent.m != null) {
                parent.m.clear();
            }
            if (parent.spriteList != null) {
                parent.spriteList.clear();
            }
            if (parent.n != null) {
                eue[] mrs = modelAdapter.getModelRenderers(model);
                Set setMrs = Collections.newSetFromMap(new IdentityHashMap());
                setMrs.addAll(Arrays.asList(mrs));
                HashSet childModelKeys = new HashSet(parent.n.keySet());
                for (String key : childModelKeys) {
                    eue mr = (eue)parent.n.get(key);
                    if (setMrs.contains(mr)) continue;
                    parent.n.remove(key);
                }
            }
        }
        String childName = parent.getUniqueChildModelName("CEM-" + modelPart);
        parent.addChildModel(childName, customModelRenderer.getModelRenderer());
        ModelUpdater mu = customModelRenderer.getModelUpdater();
        if (mu != null) {
            modelResolver.setThisModelRenderer(customModelRenderer.getModelRenderer());
            modelResolver.setPartModelRenderer(parent);
            if (!mu.initialize((IModelResolver)modelResolver)) {
                return false;
            }
            customModelRenderer.getModelRenderer().setModelUpdater(mu);
        }
        return true;
    }

    private static void checkNull(Object obj, String msg) {
        if (obj == null) {
            throw new JsonParseException(msg);
        }
    }

    public static boolean isActive() {
        return active;
    }

    public static boolean isCustomModel(cvo blockStateIn) {
        for (int i2 = 0; i2 < customTileEntityTypes.size(); ++i2) {
            ctk type = (ctk)customTileEntityTypes.get(i2);
            if (!type.a(blockStateIn)) continue;
            return true;
        }
        return false;
    }

    public static void onRenderScreen(elm screen) {
        if (customBookModel != null && screen instanceof enb) {
            enb es = (enb)screen;
            Reflector.GuiEnchantment_bookModel.setValue((Object)es, (Object)customBookModel);
        }
    }

    static {
        debugModels = Boolean.getBoolean("cem.debug.models");
    }
}

