/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.Properties;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntities;
import net.optifine.RandomEntity;
import net.optifine.config.BiomeId;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchProfession;
import net.optifine.config.Matches;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeInt;
import net.optifine.config.RangeListInt;
import net.optifine.config.Weather;
import net.optifine.util.ArrayUtils;
import net.optifine.util.MathUtils;

public class RandomEntityRule {
    private String pathProps = null;
    private abb baseResLoc = null;
    private int index;
    private int[] textures = null;
    private abb[] resourceLocations = null;
    private int[] weights = null;
    private BiomeId[] biomes = null;
    private RangeListInt heights = null;
    private RangeListInt healthRange = null;
    private boolean healthPercent = false;
    private NbtTagValue nbtName = null;
    public int[] sumWeights = null;
    public int sumAllWeights = 1;
    private MatchProfession[] professions = null;
    private bzq[] colors = null;
    private Boolean baby = null;
    private RangeListInt moonPhases = null;
    private RangeListInt dayTimes = null;
    private Weather[] weatherList = null;
    private RangeListInt sizes = null;

    public RandomEntityRule(Properties props, String pathProps, abb baseResLoc, int index, String valTextures, ConnectedParser cp) {
        String healthStr;
        this.pathProps = pathProps;
        this.baseResLoc = baseResLoc;
        this.index = index;
        this.textures = cp.parseIntList(valTextures);
        this.weights = cp.parseIntList(props.getProperty("weights." + index));
        this.biomes = cp.parseBiomes(props.getProperty("biomes." + index));
        this.heights = cp.parseRangeListIntNeg(props.getProperty("heights." + index));
        if (this.heights == null) {
            this.heights = this.parseMinMaxHeight(props, index);
        }
        if ((healthStr = props.getProperty("health." + index)) != null) {
            this.healthPercent = healthStr.contains("%");
            healthStr = healthStr.replace("%", "");
            this.healthRange = cp.parseRangeListInt(healthStr);
        }
        this.nbtName = cp.parseNbtTagValue("name", props.getProperty("name." + index));
        this.professions = cp.parseProfessions(props.getProperty("professions." + index));
        this.colors = cp.parseDyeColors(props.getProperty("colors." + index), "color", ConnectedParser.DYE_COLORS_INVALID);
        if (this.colors == null) {
            this.colors = cp.parseDyeColors(props.getProperty("collarColors." + index), "collar color", ConnectedParser.DYE_COLORS_INVALID);
        }
        this.baby = cp.parseBooleanObject(props.getProperty("baby." + index));
        this.moonPhases = cp.parseRangeListInt(props.getProperty("moonPhase." + index));
        this.dayTimes = cp.parseRangeListInt(props.getProperty("dayTime." + index));
        this.weatherList = cp.parseWeather(props.getProperty("weather." + index), "weather." + index, null);
        this.sizes = cp.parseRangeListInt(props.getProperty("sizes." + index));
    }

    private RangeListInt parseMinMaxHeight(Properties props, int index) {
        String minHeightStr = props.getProperty("minHeight." + index);
        String maxHeightStr = props.getProperty("maxHeight." + index);
        if (minHeightStr == null && maxHeightStr == null) {
            return null;
        }
        int minHeight = 0;
        if (minHeightStr != null && (minHeight = Config.parseInt((String)minHeightStr, (int)-1)) < 0) {
            Config.warn((String)("Invalid minHeight: " + minHeightStr));
            return null;
        }
        int maxHeight = 256;
        if (maxHeightStr != null && (maxHeight = Config.parseInt((String)maxHeightStr, (int)-1)) < 0) {
            Config.warn((String)("Invalid maxHeight: " + maxHeightStr));
            return null;
        }
        if (maxHeight < 0) {
            Config.warn((String)("Invalid minHeight, maxHeight: " + minHeightStr + ", " + maxHeightStr));
            return null;
        }
        RangeListInt list = new RangeListInt();
        list.addRange(new RangeInt(minHeight, maxHeight));
        return list;
    }

    public boolean isValid(String path) {
        if (this.textures == null || this.textures.length == 0) {
            Config.warn((String)("Invalid skins for rule: " + this.index));
            return false;
        }
        if (this.resourceLocations != null) {
            return true;
        }
        this.resourceLocations = new abb[this.textures.length];
        boolean optifine = this.pathProps.startsWith("optifine/mob/");
        abb locOf = RandomEntities.getLocationRandom((abb)this.baseResLoc, (boolean)optifine);
        if (locOf == null) {
            Config.warn((String)("Invalid path: " + this.baseResLoc.a()));
            return false;
        }
        for (int i2 = 0; i2 < this.resourceLocations.length; ++i2) {
            int index = this.textures[i2];
            if (index <= 1) {
                this.resourceLocations[i2] = this.baseResLoc;
                continue;
            }
            abb locNew = RandomEntities.getLocationIndexed((abb)locOf, (int)index);
            if (locNew == null) {
                Config.warn((String)("Invalid path: " + this.baseResLoc.a()));
                return false;
            }
            if (!Config.hasResource((abb)locNew)) {
                Config.warn((String)("Texture not found: " + locNew.a()));
                return false;
            }
            this.resourceLocations[i2] = locNew;
        }
        if (this.weights != null) {
            if (this.weights.length > this.resourceLocations.length) {
                Config.warn((String)("More weights defined than skins, trimming weights: " + path));
                int[] weights2 = new int[this.resourceLocations.length];
                System.arraycopy(this.weights, 0, weights2, 0, weights2.length);
                this.weights = weights2;
            }
            if (this.weights.length < this.resourceLocations.length) {
                Config.warn((String)("Less weights defined than skins, expanding weights: " + path));
                int[] weights2 = new int[this.resourceLocations.length];
                System.arraycopy(this.weights, 0, weights2, 0, this.weights.length);
                int avgWeight = MathUtils.getAverage((int[])this.weights);
                for (int i3 = this.weights.length; i3 < weights2.length; ++i3) {
                    weights2[i3] = avgWeight;
                }
                this.weights = weights2;
            }
            this.sumWeights = new int[this.weights.length];
            int sum = 0;
            for (int i4 = 0; i4 < this.weights.length; ++i4) {
                if (this.weights[i4] < 0) {
                    Config.warn((String)("Invalid weight: " + this.weights[i4]));
                    return false;
                }
                this.sumWeights[i4] = sum += this.weights[i4];
            }
            this.sumAllWeights = sum;
            if (this.sumAllWeights <= 0) {
                Config.warn((String)("Invalid sum of all weights: " + sum));
                this.sumAllWeights = 1;
            }
        }
        if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
            Config.warn((String)("Invalid professions or careers: " + path));
            return false;
        }
        if (this.colors == ConnectedParser.DYE_COLORS_INVALID) {
            Config.warn((String)("Invalid colors: " + path));
            return false;
        }
        return true;
    }

    public boolean matches(IRandomEntity randomEntity) {
        bbn entity;
        int size;
        Weather weather;
        int dayTime;
        int moonPhase;
        euv world;
        bcc livingEntity;
        bbn entity2;
        bbn entity3;
        bzq col;
        int level;
        btp entityVillager;
        btq vd;
        bts vp;
        RandomEntity rme;
        bbn entity4;
        String name;
        gt pos;
        if (this.biomes != null && !Matches.biome((cht)randomEntity.getSpawnBiome(), (BiomeId[])this.biomes)) {
            return false;
        }
        if (this.heights != null && (pos = randomEntity.getSpawnPosition()) != null && !this.heights.isInRange(pos.v())) {
            return false;
        }
        if (this.healthRange != null) {
            int healthMax;
            int health = randomEntity.getHealth();
            if (this.healthPercent && (healthMax = randomEntity.getMaxHealth()) > 0) {
                health = (int)((double)(health * 100) / (double)healthMax);
            }
            if (!this.healthRange.isInRange(health)) {
                return false;
            }
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(name = randomEntity.getName())) {
            return false;
        }
        if (this.professions != null && randomEntity instanceof RandomEntity && (entity4 = (rme = (RandomEntity)randomEntity).getEntity()) instanceof btp && !MatchProfession.matchesOne((bts)(vp = (vd = (entityVillager = (btp)entity4).fU()).b()), (int)(level = vd.c()), (MatchProfession[])this.professions)) {
            return false;
        }
        if (this.colors != null && randomEntity instanceof RandomEntity && (col = this.getEntityColor(entity3 = (rme = (RandomEntity)randomEntity).getEntity())) != null && !Config.equalsOne((Object)col, (Object[])this.colors)) {
            return false;
        }
        if (this.baby != null && randomEntity instanceof RandomEntity && (entity2 = (rme = (RandomEntity)randomEntity).getEntity()) instanceof bcc && (livingEntity = (bcc)entity2).y_() != this.baby.booleanValue()) {
            return false;
        }
        if (this.moonPhases != null && (world = Config.getMinecraft().s) != null && !this.moonPhases.isInRange(moonPhase = world.am())) {
            return false;
        }
        if (this.dayTimes != null && (world = Config.getMinecraft().s) != null && !this.dayTimes.isInRange(dayTime = (int)world.V())) {
            return false;
        }
        if (this.weatherList != null && (world = Config.getMinecraft().s) != null && !ArrayUtils.contains((Object[])this.weatherList, (Object)(weather = Weather.getWeather((cgx)world, (float)0.0f)))) {
            return false;
        }
        return this.sizes == null || !(randomEntity instanceof RandomEntity) || (size = this.getEntitySize(entity = (rme = (RandomEntity)randomEntity).getEntity())) < 0 || this.sizes.isInRange(size);
    }

    private bzq getEntityColor(bbn entity) {
        if (entity instanceof boh) {
            boh entityWolf = (boh)entity;
            if (!entityWolf.q()) {
                return null;
            }
            return entityWolf.fU();
        }
        if (entity instanceof bnh) {
            bnh entityCat = (bnh)entity;
            if (!entityCat.q()) {
                return null;
            }
            return entityCat.fV();
        }
        if (entity instanceof boa) {
            boa entitySheep = (boa)entity;
            return entitySheep.t();
        }
        if (entity instanceof bpd) {
            bpd entityLlama = (bpd)entity;
            return entityLlama.gs();
        }
        return null;
    }

    private int getEntitySize(bbn entity) {
        if (entity instanceof brz) {
            brz entitySlime = (brz)entity;
            return entitySlime.fL() - 1;
        }
        if (entity instanceof brs) {
            brs entityPhantom = (brs)entity;
            return entityPhantom.n();
        }
        return -1;
    }

    public abb getTextureLocation(abb loc, int randomId) {
        if (this.resourceLocations == null || this.resourceLocations.length == 0) {
            return loc;
        }
        int index = 0;
        if (this.weights == null) {
            index = randomId % this.resourceLocations.length;
        } else {
            int randWeight = randomId % this.sumAllWeights;
            for (int i2 = 0; i2 < this.sumWeights.length; ++i2) {
                if (this.sumWeights[i2] <= randWeight) continue;
                index = i2;
                break;
            }
        }
        return this.resourceLocations[index];
    }
}

