//
//	rol2jm.c
//	.ROL to .JMA converter
//	v1.0d1
//

#pragma	warn	-pia

#include <alloc.h>
#include <ctype.h>
#include <fcntl.h>
#include <stdio.h>
#include <io.h>

#include "..\jm.h"
#include "..\jm_al.h"

#pragma	hdrstop

#define	MaxIns	256

#define	DEBUG	0

typedef	struct
		{
			unsigned	doffset;
			byte		unused;
			char		name[9];
		} instn;
	byte		*ini,*banki;
	FILE		*outf;

	instn		*inames;
	unsigned	numins,
				numused,usedins[MaxIns];

void
UpStr(char *s)
{
	char	c;

	while (c = *s)
	{
		if (islower(c))
			*s = toupper(c);
		s++;
	}
}

void
SetupBank(void)
{
	int	i;

	numins = *((word *)(banki + 8));
	inames = (instn *)(banki + *((long *)(banki + 12)));
	printf("%d instruments in bank\n",numins);
	for (i = 0;i < numins;i++)
	{
		inames[i].unused = true;
		UpStr(inames[i].name);
#if DEBUG
		if (i)
			printf(",");
		printf("%s",inames[i].name);
		fflush(stdout);
#endif
	}
}

void
MarkInstrument(char *name)
{
	char	buf[10];
	int		i;
	instn	*n;

	strcpy(buf,name);
	UpStr(buf);
	for (i = 0,n = inames;i < numins;i++,n++)
	{
		if (!strcmp(buf,n->name))
		{
			n->unused = false;
			return;
		}
	}
	fprintf(stderr,"Couldn't find instrument %s\n",buf);
	exit(1);
}

void
ScanForInsts()
{
	byte	*image;
	int		i,j,
			numevts,
			curtick,lasttick;
	instn	*n;

	printf("scanning for instruments in .ROL file\n");

	i = *((word *)(ini + 201));
	image = ini + 203 + (i * 6);	// skip tempo evts

#if	DEBUG == 0
	printf("Voice #");
#endif
	for (i = 0;i < 11;i++)
	{
#if DEBUG
		printf("Voice #%d",i + 1);
#else
		printf("%d",i + 1);
		if (i < 10)
			printf(",");
#endif
		fflush(stdout);

		image += 15;						// Skip filler
		lasttick = *((word *)image);		// Get last tick for this track
		image += 2;

		for (curtick = 0,j = 0;curtick < lasttick;image += 4,j++)	// Skip notes
			curtick += *((word *)(image + 2));
		image += 15;						// Skip filler
#if DEBUG
		printf(" (last = %d,%d notes) ",lasttick,j);
		fflush(stdout);
#endif

		numevts = *((word *)image);
		image += 2;
#if DEBUG
		printf(" (%d inst changes) ",numevts);
		fflush(stdout);
#endif
		for (j = 0;j < numevts;image += 14,j++)
		{
#if DEBUG
			if (j)
				printf(",");
			printf("%s",image + 2);
			fflush(stdout);
#endif
			MarkInstrument(image + 2);
		}
		image += 15;						// Skip filler
#if DEBUG
		printf("\n");
#endif

		numevts = *((word *)image);
		image += 2 + (numevts * 6) + 15;	// Skip volume evts

		numevts = *((word *)image);
		image += 2 + (numevts * 6);			// Skip pitch evts
	}
	printf("\n");

	for (i = 0,j = 0,n = inames;i < numins;i++,n++)
	{
		if (!n->unused)
		{
			usedins[j++] = i;
			if (j >= MaxIns)
			{
				fprintf(stderr,"More than %d instruments!\n",MaxIns);
				exit(1);
			}
		}
	}
	numused = j;
	printf("%d instruments used\n",numused);
}

void
LoadIn(char *name,char **buf)
{
	int	file;
	long	length;

	file = open(name,O_BINARY);
	if (file != -1)
	{
		length = filelength(file);
		*buf = malloc(length);
		if (!(*buf))
		{
			fprintf(stderr,"Couldn't allocate %ld bytes for %s\n",
						filelength(file),name);
			exit(1);
		}
		read(file,*buf,length);
		close(file);
	}
	else
	{
		fprintf(stderr,"Couldn't open %s for input\n",name);
		exit(1);
	}
}

void
DoIt(char *in,char *bank,char *out)
{
	LoadIn(bank,&banki);
	SetupBank();

	LoadIn(in,&ini);
	ScanForInsts();

	outf = fopen(out,"wb");
	if (outf)
	{
		fclose(outf);
	}
	else
	{
		fprintf(stderr,"couldn't open %s for output\n",out);
		exit(1);
	}
}

void
main(int argc,char *argv[])
{
	if (argc != 4)
		fprintf(stderr,"Usage: %s in.rol use.bnk out.jma\n",argv[0]);
	else
		DoIt(argv[1],argv[2],argv[3]);
}
