;====================================================
;
; Library ASM code
;
;====================================================
	IDEAL
;	P286N
	MODEL	medium,C

extrn	TEDCHAR:BYTE,xormask:WORD,yshift:WORD,CGAfont:WORD,VGAfont:WORD
extrn	XMSdriver:DWORD,videomode:WORD

	DATASEG

SCindex	=	3c4h
SCmapmask =	2
GCindex =      	3CEh
GCreadmap =	4
GCmode 	=	5
GCbitmask = 	8

plotpixels	db	128,64,32,16,8,4,2,1

a	=	0
LABEL	CGAlookup WORD
	REPT	100
	dw	a,a XOR 2000h
a	=	a+80
	ENDM

a	=	0
LABEL	EGA1lookup WORD
	REPT	200
	dw	a
a	=	a+40
	ENDM

a	=	0
LABEL	EGA2lookup WORD
	REPT	480
	dw	a
a	=	a+80
	ENDM

a	=	0
LABEL	VGAlookup WORD
	REPT	200
	dw	a
a	=	a+320
	ENDM

egacolors dw	0,0ffffh

oldh	db	0
oldy	dw	0
horzadd dw	0
wsize	dw	1,2,4
hsize	dw	8,16,32
twidth	dw	0
theight	dw	0
bmlen	dw	0
masklen	dw	0

	CODESEG

;====================================================
;
; Draw CGA chars
;
;====================================================
PROC CGAcharout
PUBLIC CGAcharout
ARG	x:WORD,y:WORD,chr:BYTE
USES si,di,ds
	mov	bx,[y]
	shl	bx,1
	shl	bx,1
	shl	bx,1
	shl	bx,1
	mov	di,[CGAlookup+bx]
	mov	ax,[x]
	shl	ax,1
	add	di,ax

	mov	al,[chr]
	xor	ah,ah
	shl	ax,1
	shl	ax,1
	shl	ax,1
	shl	ax,1
	mov	si,ax

	mov	ax,0b800h
	mov	es,ax
	mov	ds,[CGAfont]
	cld
	cmp	[ss:xormask],0
	ja	@@1

	REPT	4
	movsw
	add	di,2000h-2
	movsw
	sub	di,2000h-78
	ENDM
	jmp	@@exit
@@1:
	REPT	4
	lodsw
	xor	ax,0ffffh
	stosw
	add	di,2000h-2
	lodsw
	xor	ax,0ffffh
	stosw
	sub	di,2000h-78
	ENDM
@@exit:
	ret
ENDP

;====================================================
;
; Draw EGA chars
;
;====================================================
PROC EGAcharout
PUBLIC EGAcharout
ARG	x:WORD,y:WORD,chr:BYTE,video:WORD
USES si,di,ds,bp

	mov	dx,GCindex
	mov	ax,GCmode
	out	dx,ax

	mov	bx,[y]
	shl	bx,1
	shl	bx,1
	shl	bx,1
	add	bx,[yshift]
	shl	bx,1

	cmp	[video],1
	jne	@@0
	mov	cx,39
	mov	di,[EGA1lookup+bx]
	jmp	@@1
@@0:
	mov	cx,79
	mov	di,[EGA2lookup+bx]
@@1:
	add	di,[x]

	mov	ax,0a000h
	mov	es,ax
	mov	ds,ax

	mov	si,0f000h
	mov	al,[chr]
	xor	ah,ah
	shl	ax,1
	shl	ax,1
	shl	ax,1
	add	si,ax

	cld
	cmp	[ss:xormask],0
	ja	@@2

	mov	dx,GCindex
	mov	ax,GCmode OR 100h
	out	dx,ax
	mov	dx,SCindex
	mov	ax,SCmapmask OR 0f00h
	out	dx,ax

	REPT	8
	movsb
	add	di,cx
	ENDM
	jmp	@@exit

@@2:
ga	=	100h
gb	=	0
	mov	bp,si
	mov	bx,di
	REPT	4
	mov	dx,SCindex
	mov	ax,SCmapmask OR ga
	out	dx,ax
	mov	dx,GCindex
	mov	ax,GCreadmap OR gb
	out	dx,ax
	REPT	8
	lodsb
	xor	al,0ffh
	stosb
	add	di,cx
	ENDM
	mov	di,bx
	mov	si,bp
ga	=	ga*2
gb	=	gb+100h
	ENDM
@@exit:
	mov	dx,GCindex
	mov	ax,GCmode
	out	dx,ax
	ret
ENDP

;====================================================
;
; Draw VGA chars
;
;====================================================
PROC VGAcharout
PUBLIC VGAcharout
ARG	x:WORD,y:WORD,chr:BYTE
USES si,di,ds

	mov	bx,[y]
	shl	bx,1
	shl	bx,1
	shl	bx,1
	add	bx,[yshift]
	shl	bx,1
	mov	di,[VGAlookup+bx]

	mov	ax,[x]
	shl	ax,1
	shl	ax,1
	shl	ax,1
	add	di,ax

	mov     ah,[chr]
	xor	al,al
	shr	ax,1
	shr	ax,1	;[chr]*64!
	mov	si,ax

	mov	ax,0a000h
	mov	es,ax
	mov	ds,[VGAfont]

	cmp	[ss:xormask],0
	ja	@@1

	REPT	8
	REPT	4
	movsw
	ENDM
	add	di,320-8
	ENDM
	jmp	@@exit
@@1:
	REPT	8
	REPT	4
	lodsw
	xor	ax,0ffffh
	stosw
	ENDM
	add	di,320-8
	ENDM
@@exit:
	ret
ENDP

;====================================================
;
; Call the XMS driver because Turbo C won't let me!
;
;====================================================
PUBLIC	CallXMS
PROC	CallXMS
	ARG	func:BYTE

	mov	ah,[func]
	call	[DWORD XMSdriver]
	ret
ENDP

;============================================================================
;
; VW_Vlin (int yl,yh,x,color)
;
;============================================================================

PROC	VW_Vlin yl:WORD, yh:WORD, x:WORD, color:WORD
PUBLIC	VW_Vlin
USES	SI,DI

	mov	ax,0a000h
	mov	es,ax

	mov	dx,SCindex
	mov	ax,SCmapmask+15*256
	out	dx,ax

	mov	dx,GCindex
	mov	ax,GCmode+2*256			;write mode 2
	out	dx,ax

	mov	bx,[yl]
	shl	bx,1
	mov	di,[EGA1lookup+bx]
	mov	bx,[x]
	mov	ax,bx
	shr	ax,1
	shr	ax,1
	shr	ax,1
	add	di,ax				; di = byte on screen

	and	bx,7
	mov	ah,[plotpixels+bx]
	mov	al,GCbitmask			;mask off other pixels
	out	dx,ax

	mov	cx,[yh]
	sub	cx,[yl]
	inc	cx					;number of pixels to plot

	mov	bh,[BYTE color]
	mov	dx,40

@@plot:
	mov	bl,bh
	xchg	bl,[es:di]		; load latches and write pixel
	add	di,dx

	loop	@@plot

	mov	dx,GCindex
	mov	ah,0ffh				;no bit mask
	out	dx,ax
	mov	ax,GCmode+0*256	;write mode 0
	out	dx,ax

	ret

ENDP

END
