#include <sys\stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <alloc.h>
#include <mem.h>
#include <fcntl.h>
#include <dir.h>
#include <string.h>
#include <io.h>
#include <bios.h>
#include <conio.h>
#include <time.h>

#include "id_types.h"
//#include "memmgr.h"
#include "lib.h"
#include "xms.h"
#include "menu.h"
#include "jhuff.h"
#include "id_mm.h"
#include "id_sd.h"

//
// DEFINES
//
#define	WINDOW_LEFT	7
#define WINDOW_RIGHT	(320-7)
#define WINDOW_TOP	(8*2-1)
#define WINDOW_BOTTOM	(8*20)

#define MAXSOUNDS	100
#define MAXMUSIC	100
#define DATAPOINTS	(WINDOW_RIGHT-WINDOW_LEFT)
#define SCREENPOINTS	(WINDOW_BOTTOM-WINDOW_TOP+1)

#define EDCOLOR		1+8
#define EDBKGND		1
#define EDHIGHC		10
#define EDHIGHB		2
#define ENDCOLOR 	12

#define NUMMAINCTRLS	6
#define MAXPROJS	10
#define ALBUFSIZE	(sizeof(AdLibSound)+DATAPOINTS)
#define PCBUFSIZE	(sizeof(PCSound)+DATAPOINTS)

//
// TYPEDEFS
//
typedef enum {DATA,CODE,FARDATA} segtype;
typedef unsigned word;

typedef struct {
		// INDEX INTO MUSEINFO
		int num_sounds,num_music;
		// INDEX INTO AUDIO.EXT
		long soundnamesoff,digiinfooff,
		    musicinfooff, // THIS IS USELESS, BUT COMPATIBLE
		    pcdataoff[MAXSOUNDS],pcdatalen[MAXSOUNDS],
		    adlibdataoff[MAXSOUNDS],adlibdatalen[MAXSOUNDS],
		    digidataoff[MAXSOUNDS],digidatalen[MAXSOUNDS],
		    musicdataoff[MAXMUSIC],musicdatalen[MAXMUSIC];

		char digipath[64],musicpath[64];

	       } MUSEInfoStr;

typedef enum {PC,ADLIB} datatype;

//
// Instrument Bank format
//
typedef	struct {
		unsigned doffset;
		byte unused;
		char name[9];
		} instn;

typedef struct {
		int active;
		char name[16],filename[64];
		unsigned time,date,size;
		} MInfoStr;

typedef struct {
		PCSound _seg *data;
		} PCStr;

typedef struct {
		AdLibSound _seg *data;
		char instname[9];
		} AdLibStr;

typedef struct {
		SampledSound _seg *data;
		int type;	// -1:use digitized snd/0-??:use PC/Adlib
		char filename[13];	// filename on disk
		unsigned time,date;	// need this for Update function
		} DigiStr;

//
// VARIABLE PROTOTYPES
//
extern video videomode;
extern MBarDef MUSE_MBar[];
extern char far TEDCHAR,far VGAPAL;

extern MUSEInfoStr MUSEinfo;
extern PCStr PCsound[MAXSOUNDS];
extern AdLibStr AdLibsnd[MAXSOUNDS];
extern DigiStr Digisound[MAXSOUNDS];
extern datatype whichtype;
extern Instrument definst;
extern MInfoStr musicinfo[MAXMUSIC];

extern char MUSEversion[];
extern char soundnames[MAXSOUNDS][16],projname[14],infoname[14],
	ext[4],digifnames[MAXSOUNDS][16],bankname[64];
extern char _seg *InstBank,UNDObuf[DATAPOINTS];
extern byte adtranstable[256],adtrans2table[256];
extern int pixelx,pixely,lastx,lasty,DirtyFlag,writeH;
extern word selectx1,selectx2,selectstate,whichsound;
extern byte b0,b1,deltamode;

extern char tmpadlib[];

//
// FUNCTION PROTOTYPES
//

//
// MUSE.C
//
void InitMUSE(void);
void HandleEvent(void);
void Continuous(void);
void InitProject(void);
void InitBNKfile(void);
void errout(char *string);
void InitNewProject(void);
void LoadNewProject(void);
void ClearMemory(void);
void CheckForParms(void);
//
// MUSE-1.C
//
void DrawMUSEscreen(int drawdialog);
void DrawInfoLine(void);
void CheckMUSEbuttons(void);
void SaveAudio(void);
void LoadAudio(void);
void SaveHeaders(void);
char huge *GetDataAddr(void);
word GetDataLen(void);
void SetDataLen(word len);
void TransAdLibData(AdLibSound huge *loc);
void RevTransAdLibData(AdLibSound huge *loc);
void DrawEndLine(void);
void FindDataLength(void);
int  MakeOBJ(char *filename,char *destfilename,char *public,segtype whichseg,char *farname);
void SaveUNDO(void);
void CheckToSave(void);
int  FindInstrument(char *name);
int  SearchInstrument(char *name);
void CompileInstrument(int instnum,char huge *dest);
void VW_Bar (unsigned x, unsigned y, unsigned width, unsigned height,
	unsigned color);

//
// MUSE-2.C
//
void Item_About(void);
void Item_Quit(void);
void Item_DeltaTog(void);
void Item_PC_Mode(void);
void Item_AdLibMode(void);
void Item_PlayCurrentSound(void);
void Item_UpdateImports(void);
void Item_SaveAudio(void);
void Item_EditSndName(void);
void Item_DelArea(void);
void Item_CreateNewSound(void);
void Item_MemStats(void);
void Item_RaiseBlock(void);
void Item_LowerBlock(void);
void Item_ClearArea(void);
void Item_ChangeInst(void);
void Item_PCtoAdLib(void);
void Item_AdLibtoPC(void);
void Item_ChangeBNK(void);
void Item_HuffAudio(void);
void Item_Priorities(void);
void Item_Last(void);
void Item_Next(void);
void Item_INSERT(void);
void Item_RestoreUNDO(void);
void Item_GOTO(void);

//
// MUSE-3.C
//
void Item_MUSIC(void);
long ConvertROL(char _seg *ROL,char _seg *ID);
void Item_DigiImport(void);
void Item_NewProject(void);
void Item_CreateProject(void);
void Item_WriteH(void);

//
// DIALOG BUTTON PROTOTYPES
//
void ProjOn(int x,int y,int which);
void ProjOff(int x,int y,int which);

void InsOn(int x,int y,int w);
void InsOff(int x,int y,int w);
void ExitOn(int x,int y);
void ExitOff(int x,int y);
void PrintOn(int x,int y);
void PrintOff(int x,int y);
void CancelOn(int x,int y);
void CancelOff(int x,int y);
void ArUpOn(int x,int y);
void ArUpOff(int x,int y);
void ArDnOn(int x,int y);
void ArDnOff(int x,int y);
void AcceptOn(int x,int y);
void AcceptOff(int x,int y);
void PlayOn(int x,int y);
void PlayOff(int x,int y);
void BankOn(int x,int y,int w);
void BankOff(int x,int y,int w);
void MNon(int x,int y,int w);
void MNoff(int x,int y,int w);
void SPon(int x,int y,int w);
void SPoff(int x,int y,int w);
void SGon(int x,int y,int w);
void SGoff(int x,int y,int w);
void MFbon(int x,int y);
void MFboff(int x,int y);
void DIbon(int x,int y);
void DIboff(int x,int y);
void DIlon(int x,int y,int w);
void DIloff(int x,int y,int w);
