// ID_GLOB.H

#include "id_sd.h"
#include <ALLOC.H>
#include <CTYPE.H>
#include <DOS.H>
#include <ERRNO.H>
#include <FCNTL.H>
#include <IO.H>
#include <MEM.H>
#include <PROCESS.H>
#include <STDIO.H>
#include <STDLIB.H>
#include <STRING.H>
#include <SYS\STAT.H>
#include <VALUES.H>
#define __ID_GLOB__

//--------------------------------------------------------------------------

#define WOLF

#define	TEXTGR	0
#define	CGAGR	1
#define	EGAGR	2
#define	VGAGR	3


#ifdef WOLF1

#define	EXTENSION	"WL1"

#if GRMODE == EGAGR
#include "GFXE_WL1.H"
extern	char		far signone1;
#define	introscn	signone1
#endif

#if GRMODE == VGAGR
#include "GFXV_WL1.H"
extern	char		far signonv1;
#define	introscn	signonv1
#endif

#include "AUDIOWL1.H"
#include "MAPSWL1.H"

#endif

//-----------------

#ifdef WOLF2

#define	EXTENSION	"WL2"

#if GRMODE == EGAGR
#include "GFXE_WL2.H"
extern	char		far signone2;
#define	introscn	signone2
#endif

#if GRMODE == VGAGR
#include "GFXV_WL2.H"
extern	char		far signonv2;
#define	introscn	signonv2
#endif

#include "AUDIOWL2.H"
#include "MAPSWL2.H"

#endif

//-----------------

#ifdef WOLF3

#define	EXTENSION	"WL3"

#if GRMODE == EGAGR
#include "GFXE_WL3.H"
extern	char		far signone3;
#define	introscn	signone3
#endif

#if GRMODE == VGAGR
#include "GFXV_WL3.H"
extern	char		far signonv3;
#define	introscn	signonv3
#endif

#include "AUDIOWL3.H"
#include "MAPSWL3.H"

#endif

//-----------------


#if GRMODE == EGAGR
#define GREXT	"EGA"
#endif
#if GRMODE == VGAGR
#define GREXT	"VGA"
#endif

//#define PROFILE

//
//	ID Engine
//	Types.h - Generic types, #defines, etc.
//	v1.0d1
//

#ifndef	__TYPES__
#define	__TYPES__

typedef	enum	{false,true}	boolean;
typedef	unsigned	char		byte;
typedef	unsigned	int			word;
typedef	unsigned	long		longword;
typedef	byte *					Ptr;

typedef	struct
		{
			int	x,y;
		} Point;
typedef	struct
		{
			Point	ul,lr;
		} Rect;

#define	nil	((void *)0)

#endif

#include "ID_MM.H"

void	Quit (char *error);		// defined in user program

//
// replacing refresh manager with custom routines
//

#define	PORTTILESWIDE		21      // all drawing takes place inside a
#define	PORTTILESHIGH		14		// non displayed port of this size

#define UPDATEWIDE			(PORTTILESWIDE+1)
#define UPDATEHIGH			PORTTILESHIGH

#define	MAXTICS				10
#define DEMOTICS			4

#define	UPDATETERMINATE	0x0301

extern	unsigned	mapwidth,mapheight,tics;
extern	boolean		compatability;

extern	byte		*updateptr;
extern	unsigned	uwidthtable[UPDATEHIGH];
extern	unsigned	blockstarts[UPDATEWIDE*UPDATEHIGH];

extern	byte		fontcolor,backcolor;
#if GRMODE == EGAGR
#define SETFONTCOLOR(f,b) fontcolor=(b)^(f);
#else
#define SETFONTCOLOR(f,b) fontcolor=f;backcolor=b;
#endif

