/////////////////////////////////////////////////
/////////////////////////////////////////////////
//
// MUSE-3	More Menu Items
//
/////////////////////////////////////////////////
/////////////////////////////////////////////////
#include "muse.h"
#pragma hdrstop

/////////////////////////////////////////////////
//
// Item - MUSIC functions
//
/////////////////////////////////////////////////
#define NUMMUSBTNS	6

btype MFb[NUMMUSBTNS]={
	     {" Import ",24,5,1},
	     {"  Play  ",24,8,2},
	     {" Delete ",24,11,1},
	     {"  Exit  ",24,14,1},
	     {"New Path",24,17,1},
	     {"  Info  ",24,20,1}
	    },
      MUSIb[]={
	       {"#define",7,8,1},
	       {" Exit ",24,8,2}
	      };

word mbase,whichb;
#define MFx	1
#define MFxo	5
#define MUSICNAMES	16

btype NPb={"                                    ",1,3,1};
DialogDef NPd={"Current Path:",38,5,1,&NPb,NULL},
	MUSId={"Music Info\n\n"
	       "Pathname:\n"
	       "#define:\n"
	       "Size:",38,10,2,&MUSIb[0],0
	      },
	INPDEF={"Input #define:",18,2,0,0};


void Item_MUSIC(void)
{
 int temp,whichon=-1,i;
 word redraw,dx,dy,max,tx,ty;
 char _seg *ROLfile,rolpath[64],tempstr[40];


 MouseHide();
 drawwindow(MFxo,0,35,22);
 for (i=0;i<NUMMUSBTNS;i++)
   {
    dx=sx=MFb[i].xoff;
    dy=sy=MFb[i].yoff;
    print(MFb[i].text);
    sx=dx;
    sy=dy;
    DrawBorder(sx-1,sy-1,strlen(MFb[i].text)+1,2,MFb[i].border);
   }
 DrawBorder(MFxo+MFx,3,16,MUSICNAMES+1,1);
 dx=MFxo+MFx;
 dy=4;
 sx=13;
 sy=1;
 print("MUSIC Utilities");
 MouseShow();

 strcpy(rolpath,MUSEinfo.musicpath);
 strcat(rolpath,"*.IMF");

 while(1)
 {
  //
  // DRAW IMPORTED MUSIC NAMES
  //
  max=(MUSEinfo.num_music<MUSICNAMES)?MUSEinfo.num_music:MUSICNAMES;

  for (i=0;i<max;i++)
  {
   if (whichon==i+mbase)
     MNon(dx+MFx,dy+i,i);
   else
     MNoff(dx+MFx,dy+i,i);
  }

  MouseHide();
  for (i=max;i<MUSICNAMES;i++)
    bar(dx+MFx,dy+i,dx+MFx+14,dy+i,' ');
  MouseShow();

  redraw=0;
  do
  {
   //
   // BUTTON CHECKS
   //
   MouseCoords(&pixelx,&pixely);
   pixelx/=8;
   pixely/=8;
   for (i=0;i<NUMMUSBTNS;i++)
     {
      whichb=i;
      tx=MFb[i].xoff;
      ty=MFb[i].yoff;
      temp=CheckList(tx,ty,strlen(MFb[i].text),1,MFbon,MFboff,0);

      //
      // ENTER will PLAY
      //
      if (keydown[0x1c] && i==1)
	temp=1;
      else
      if (keydown[0x53] && i==2)
	temp=1;

      if (temp>=0)
	{
	 MFboff(tx,ty);
	 switch(i)
	 {
	  //
	  // IMPORT
	  //
	  case 0:
	    {
	     int select;
	     char path[64]="";

	     select=GetPath("Select MUSIC file\nto import.",rolpath,path);
	     if (select==-1)
	       {
		ErrDialog("There are no .IMF files\nin your directory!","Get some!");
		break;
	       }
	     if (!select)
	       {
		char _seg *tblk;
		int idx=MUSEinfo.num_music;
		long size;


		//
		// SEE IF THIS FILE ALREADY EXISTS...
		//
		for (i=0;i<idx;i++)
		  if (!strcmp(f.ff_name,musicinfo[i].filename))
		  {
		   ErrDialog("You already have this song\n"
			     "in your Import list!"," OK ");
		   break;
		  }
		if (i!=idx)
		  break;


		//
		// GET .ROL INFO & LOAD IT IN...
		//
		strcpy(musicinfo[idx].filename,MUSEinfo.musicpath);
		strcat(musicinfo[idx].filename,f.ff_name);
		strcpy(musicinfo[idx].name,f.ff_name);
		for (i=strlen(f.ff_name);i>=0;i--)
		  if (f.ff_name[i]=='.')
		    {
		     musicinfo[idx].name[i]=0;
		     break;
		    }
		musicinfo[idx].date=f.ff_fdate;
		musicinfo[idx].time=f.ff_ftime;

		LoadIn(path,(memptr *)&ROLfile);
		//MMAllocate((memptr *)&tblk,2L*f.ff_fsize);

		//
		// NOT CONVERTING .ROL FILES ANYMORE...
		//
		#if 0
		//
		// CONVERT .ROL TO .ID FORMAT
		// FROM "ROLFILE" TO "TBLK"
		//
		size=ConvertROL(ROLfile,tblk);
		#endif

		size=f.ff_fsize;

		//
		// MOVE CONVERTED DATA FROM TEMP BUFFER (TBLK) TO
		// FINISHED MEMORY
		//
		MMAllocate((memptr *)&musicinfo[idx].data,size+2);
		*(unsigned huge *)musicinfo[idx].data=size;
		movedata((unsigned)ROLfile,0,(unsigned)musicinfo[idx].data,2,size);
		musicinfo[idx].size=size+2;

		MMFreePtr((memptr *)&ROLfile);
		//MMFreePtr((memptr *)&tblk);
		MUSEinfo.num_music++;
		whichon=idx;
		writeH=DirtyFlag=redraw=1;
	       }
	    }
	    break;

	  //
	  // PLAY
	  //
	  case 1:
	    if (whichon>=0)
	    {
	     SD_SetMusicMode(smm_AdLib);
	     SD_StartMusic((MusicGroup far *)musicinfo[whichon].data);
	    }
	    else
	      ErrDialog("You need to highlight\n"
			"a song name before you\n"
			"can play it."," Oh, yeah ");

	    while(keydown[0x1c]);
	    break;

	  //
	  // DELETE
	  //
	  case 2:
	    if (whichon>=0)
	    {
	     int last=MUSEinfo.num_music-1;


	     SD_MusicOff();
	     MMFreePtr((memptr *)&musicinfo[whichon].data);
	     if (whichon!=last)
	     {
	      MMAllocate((memptr *)&musicinfo[whichon].data,musicinfo[last].size);
	      movedata((unsigned)musicinfo[last].data,0,
		       (unsigned)musicinfo[whichon].data,0,
		       musicinfo[last].size);

	      // COPY STRUCTURE INFO
	      musicinfo[whichon].time=musicinfo[last].time;
	      musicinfo[whichon].date=musicinfo[last].date;
	      musicinfo[whichon].size=musicinfo[last].size;
	      strcpy(musicinfo[whichon].name,musicinfo[last].name);
	      strcpy(musicinfo[whichon].filename,musicinfo[last].filename);

	      MMFreePtr((memptr *)&musicinfo[last].data);
	     }

	     MUSEinfo.num_music--;
	     writeH=DirtyFlag=redraw=1;
	     whichon=-1;
	     while(keydown[0x53]);
	     continue;
	    }
	    else
	      ErrDialog("You need to highlight\n"
			"a song name before you\n"
			"can delete it."," Oops! ");

	    break;

	  //
	  // EXIT
	  //
	  case 3:
	    RedrawDesktop();
	    DrawMUSEscreen(1);
	    clearkeys();
	    SD_MusicOff();
	    return;

	  //
	  // NEW PATH
	  //
	  case 4:
	    MouseHide();
	    DrawDialog(&NPd,1);
	    GetDialogXY(&NPd,&sx,&sy);
	    sy++;
	    sx++;
	    if (!MUSEinfo.musicpath[0])
	      print("- current dir -");
	    else
	      print(MUSEinfo.musicpath);
	    GetButtonXY(&NPd,0,&sx,&sy);
	    if (input(tempstr,36))
	      {
	       strcpy(rolpath,tempstr);
	       if (rolpath[strlen(rolpath)-1]!='\\')
		 strcat(rolpath,"\\");
	       strcpy(MUSEinfo.musicpath,rolpath);
	       strcat(rolpath,"*.IMF");
	       DirtyFlag=1;
	      }
	    MouseShow();
	    RestoreBackground();
	    break;

	 //
	 // INFO
	 //
	 case 5:
	   if (whichon>=0)
	   {
	    char tempstr[18];
	    unsigned dx,dy;
	    int butn,exit,redraw;


	    exit=redraw=0;
	    do
	    {
	     MouseHide();
	     if (redraw)
	       RestoreBackground();
	     DrawDialog(&MUSId,1);
	     GetDialogXY(&MUSId,&dx,&dy);
	     sy=dy+2;
	     sx=dx+9;
	     print(musicinfo[whichon].filename);
	     sy=dy+3;
	     sx=dx+8;
	     print(musicinfo[whichon].name);
	     sy=dy+4;
	     sx=dx+5;
	     printint(musicinfo[whichon].size);
	     MouseShow();
	     redraw=0;

	     do
	     {
	      butn=CheckButtons(&MUSId);
	      switch(butn)
	      {
	       case -1:
	       case 0:
	       case 2:
		 exit=1;
		 break;

	       case 1:
		 MouseHide();
		 DrawDialog(&INPDEF,1);
		 GetDialogXY(&INPDEF,&sx,&sy);
		 sy++;
		 if (input(tempstr,16))
		 {
		  _fstrcpy(musicinfo[whichon].name,strupr(tempstr));
		  writeH=DirtyFlag=1;
		 }

		 RestoreBackground();
		 MouseShow();
		 redraw=1;
		 break;
	      }
	     } while(!redraw && !exit);
	    } while(!exit);

	    RestoreBackground();
	   }
	   else
	     ErrDialog("You need to select a\n"
		       "song before getting\n"
		       "INFO about it!"," OK ");
	 }
	 if (DirtyFlag)
	   redraw=1;
	 break;
	}
     }

   //
   // CHECK LIST OF MUSIC NAMES
   //
   temp=CheckList(dx+MFx,dy,15,max,MNon,MNoff,0);
   if (temp>=0)
     {
      if (whichon>=0)
      {
       SD_MusicOff();
       if (whichon>=mbase && whichon<mbase+MUSICNAMES)
	 MNoff(dx+MFx,dy+whichon-mbase,whichon-mbase);
      }

      if (whichon==temp+mbase)
	whichon=-1;
      else
	whichon=temp+mbase;
     }


   //
   // ESC or Exit
   //
   if (keydown[1])
     {
      SD_MusicOff();
      RedrawDesktop();
      DrawMUSEscreen(1);
      clearkeys();
      return;
     }

   //
   // Up/Dn arrows - SCROLL THRU
   //
   if (keydown[0x48])
     if (mbase)
     {
      mbase--;
      redraw=1;
      while(keydown[0x48]);
      continue;
     }

   if (keydown[0x50])
     if (mbase+MUSICNAMES<MUSEinfo.num_music)
     {
      mbase++;
      redraw=1;
      while(keydown[0x50]);
      continue;
     }

  } while(!redraw);
 }
}


void MNon(int x,int y,int w)
{
 xormask=1;
 MNoff(x,y,w);
 xormask=0;
}
void MNoff(int x,int y,int w)
{
 MouseHide();
 bar(x,y,x+14,y,' ');
 sx=x;
 sy=y;
 print(musicinfo[mbase+w].name);
 sx=x+9;
 printint(musicinfo[mbase+w].size);
 MouseShow();
}
void MFbon(int x,int y)
{
 xormask=1;
 MFboff(x,y);
 xormask=0;
}
void MFboff(int x,int y)
{
 MouseHide();
 sx=x;
 sy=y;
 print(MFb[whichb].text);
 MouseShow();
}


#if 0
/////////////////////////////////////////////////
//
// Convert .ROL to .ID format
//
/////////////////////////////////////////////////
long ConvertROL(char _seg *ROL,char _seg *ID)
{
 struct ROLhead
	{
	 long fileversion;
	 char unused1[40];
	 int ticksperbeat;
	 int beatspermeas;
	 long unused2;
	 char unused2a;
	 char whichmode;
	 char unused3[90];
	 char filler[38+15];
	 float basictempo;
	};
 struct tmfield
	{
	 int tempevents;
	 int timeofevent;
	 float tempomult;
	};
 struct trackhead
	{
	 char filler[15];
	 int lastnote;
	};
 struct nfield
	{
	 int notenum;
	 int noteduration;
	};
 struct ifield
	{
	 int timeofevent;
	 char instname[9];
	 char filler;
	 int unused;
	};
 struct vfield
	{
	 int timeofevent;
	 float volumemult;
	};
 struct pfield
	{
	 int timeofevent;
	 float pitchvar;
	};

 int freqtable[12]={172,182,193,205,217,230,243,258,273,290,307,325};

 unsigned IDoff,maxlastnote,percmode,percvoice;
 int curtick,track,sum,numinst[11],i,numvol[11],numpitch[11],numtrks,trknum,
     lastnote,ntick,itick,vtick,ptick,ninc,iinc,vinc,pinc;
 struct tmfield huge *tempo;
 struct trackhead huge *thead[12];
 struct nfield huge *notef[11],huge *tempn;
 struct ifield huge *instf[11],huge *tempi;
 struct vfield huge *volume[11],huge *tempv;
 struct pfield huge *pitch[11],huge *tempp;

 float TheTempo;
 int TempEqu;
 int TheTicks;

 #define ADLIBTICKBASE	18.2
 #define IDTICKBASE	140
 #define CONVERT_TICK(oldtick) (TempEqu*(oldtick))



 ErrDialog("Converting .ROL to .ID ...","");
 #pragma warn -sus


 percmode=sf_Melodic;
 if (!((struct ROLhead _seg *)ROL)->whichmode)
   percmode=sf_Percussive;

 TheTempo=((struct ROLhead _seg *)ROL)->basictempo;
 TheTicks=((struct ROLhead _seg *)ROL)->ticksperbeat;
 TempEqu=(float)IDTICKBASE/((float)(TheTempo/60)*TheTicks);

 tempo=MK_FP(ROL,sizeof(struct ROLhead));
 thead[0]=(char huge *)tempo+2+(6*tempo->tempevents);

 maxlastnote=numtrks=0;
 for (track=0;track<11;track++)
 {
  //
  // NOTE EVENTS
  //
  numtrks+=(thead[track]->lastnote)>0;

  if (thead[track]->lastnote>maxlastnote)
    maxlastnote=thead[track]->lastnote;

  notef[track]=tempn=thead[track]+1;

  sum=0;
  while(sum<thead[track]->lastnote)
  {
   sum+=tempn->noteduration;
   tempn+=1;
  }

  //
  // INSTRUMENT EVENTS
  //
  tempi=(char huge *)tempn+15;	// ADD FILLER AT END OF NOTES
  numinst[track]=*(int huge *)tempi;
  instf[track]=(char huge *)tempi+=2;
  tempi+=numinst[track];

  //
  // VOLUME EVENTS
  //
  tempv=(char huge *)tempi+=15;	// ADD FILLER AT END OF INSTRUMENTS
  numvol[track]=*(int huge *)tempv;
  volume[track]=(char huge *)tempv+=2;
  tempv+=numvol[track];

  //
  // PITCH EVENTS
  //
  tempp=(char huge *)tempv+15;	// ADD FILLER AT END OF VOLUMES
  numpitch[track]=*(int huge *)tempp;
  pitch[track]=(char huge *)tempp+=2;
  tempp+=numpitch[track];

  thead[track+1]=tempp;
 }

 //
 // TIME TO CONVERT!
 //
 ((MusicGroup _seg *)ID)->flags=percmode;
 ((MusicGroup _seg *)ID)->count=numtrks;
 IDoff=sizeof(MusicGroup)+2*numtrks;

 trknum=0;
 for (track=0;track<11;track++)
 {
  if (thead[track]->lastnote)
  {
   ((MusicGroup _seg *)ID)->offsets[trknum]=IDoff;
   lastnote=thead[track]->lastnote;
   ntick=itick=vtick=ptick=curtick=0;
   ninc=iinc=vinc=pinc=0;
   percvoice=percmode=0;	// KEEP TRACK OF PERCUSSIVE INSTRUMENTS

   while(curtick<lastnote)
   {
    //
    // INSTRUMENTS
    //
    if (itick==curtick)
    {
     Instrument TheInst;
     int temp,inst;
     char iname[9];


     _fstrcpy((char far *)iname,(instf[track]+iinc)->instname);
     inst=FindInstrument(iname);
     if (inst<0)
     {
      int j;
      char err[200]="Couldn't find instrument\n"
		    "named '",old[9];


      strcpy(old,iname);
      for (j=strlen(old);j>=0;j--)
      {
       iname[strlen(iname)-1]=0;
       inst=SearchInstrument(iname);
       if (inst>=0)
	 break;
      }

      strcat(err,old);
      strcat(err,"'. Replacing\nwith '");
      strcat(err,iname);
      strcat(err,"'.");

      ErrDialog(err," OK ");
     }

     if (!iname[0])
       inst=SearchInstrument("piano1");

     CompileInstrument(inst,&TheInst);
     percvoice=TheInst.voice;
     percmode=TheInst.mode;

     *(int huge *)(ID+IDoff)=percmode? sev_NewPerc : sev_NewInst;
     IDoff+=2;
     temp=*(int huge *)(ID+IDoff)=CONVERT_TICK((instf[track]+iinc)->timeofevent);
     IDoff+=2;
     if (percmode)
     {
      *(int huge *)(ID+IDoff)=10-percvoice;
      IDoff+=2;
     }
     movedata(FP_SEG(&TheInst),FP_OFF(&TheInst),(unsigned)ID,IDoff,sizeof(Instrument));
     IDoff+=sizeof(Instrument);

     iinc++;
     itick+=temp;
    }
    //
    // VOLUMES
    //
    if (vtick==curtick)
    {
     int temp;


     #if 0
     *(int huge *)(ID+IDoff)=sev_NewInst;
     IDoff+=2;
     temp=*(int huge *)(ID+IDoff)=CONVERT_TICK((volume[track]+vinc)->timeofevent);
     IDoff+=2;
     #endif

     vinc++;
     vtick+=temp;
    }
    //
    // PITCHES
    //
    if (ptick==curtick)
    {
     int temp;


     #if 0
     *(int huge *)(ID+IDoff)=sev_NotePitch;
     IDoff+=2;
     temp=*(int huge *)(ID+IDoff)=CONVERT_TICK((pitch[track]+pinc)->timeofevent);
     IDoff+=2;
     #endif

     pinc++;
     ptick+=temp;
    }
    //
    // NOTES
    //
    if (ntick==curtick)
    {
     int temp,temp1;


     temp=(notef[track]+ninc)->noteduration;
     temp1=(notef[track]+ninc)->notenum;

     if (!temp1)
     {
      if (!percmode)
      {
       *(int huge *)(ID+IDoff)=sev_NoteOff;
       IDoff+=2;
       *(int huge *)(ID+IDoff)=CONVERT_TICK(temp);
      }
      else
      {
       *(int huge *)(ID+IDoff)=sev_PercOff;
       IDoff+=2;
       *(int huge *)(ID+IDoff)=CONVERT_TICK(temp);
       IDoff+=2;
       *(int huge *)(ID+IDoff)=10-percvoice;
      }
     }
     else
     {
      if (!percmode)
      {
       *(int huge *)(ID+IDoff)=sev_NoteOn;
       IDoff+=2;
       *(int huge *)(ID+IDoff)=CONVERT_TICK(temp);
       IDoff+=2;
       *(int huge *)(ID+IDoff)=freqtable[temp1%12] | ((temp1/12)<<10);
      }
      else
      {
       *(int huge *)(ID+IDoff)=sev_PercOn;
       IDoff+=2;
       *(int huge *)(ID+IDoff)=CONVERT_TICK(temp);
       IDoff+=2;
       *(int huge *)(ID+IDoff)=10-percvoice;
      }

     }

     IDoff+=2;

     ninc++;
     ntick+=temp;
    }

    curtick++;
   }

   //
   // END OF TRACK!
   //

   //
   // "PAD" THE END OF EACH TRACK SO THEY ALL
   // CATCH UP AT THE END!
   //
   if (curtick<maxlastnote)
   {
    *(int huge *)(ID+IDoff)=sev_Null;
    IDoff+=2;
    *(int huge *)(ID+IDoff)=CONVERT_TICK(maxlastnote-curtick);
    IDoff+=2;
   }

   *(int huge *)(ID+IDoff)=sev_SeqEnd;
   IDoff+=2;


   trknum++;
  }
 }
 #pragma warn +sus

 RestoreBackground();
 return IDoff;
}
#endif


/////////////////////////////////////////////////
//
// Item - Digitized Importing
//
/////////////////////////////////////////////////
#define NUMDIBTNS	5
btype DIb[]={{" Play "	  ,19,4,2},
	     {" Delete "  ,19,7,1},
	     {" Import "  ,19,10,1},
	     {" New Path ",19,15,1},
	     {" Exit "    ,19,18,1}};
DialogDef DId={"  Import DIGITIZED sounds",30,23,NUMDIBTNS,&DIb[0],0};
int DIbase=0,DIhigh;
word DIdx,DIdy;

void Item_DigiImport(void)
{
 int which,i,max;
 word exit,redraw;


 MouseHide();
 DrawDialog(&DId,1);
 GetDialogXY(&DId,&DIdx,&DIdy);
 DrawBorder(DIdx+1,DIdy+1,16,19,1);
 MouseShow();

 DIhigh=-1;

 exit=0;
 do
 {
  //
  // DRAW THE NAMES IN THE WINDOW
  //
  max=(MUSEinfo.num_sounds<19)?MUSEinfo.num_sounds:19;
  for (i=0;i<max;i++)
    {
     sx=DIdx+2;
     sy=DIdy+2+i;
     if (Digisound[i+DIbase].type<0)
       print(Digisound[i+DIbase].filename);
     else
       print(soundnames[i+DIbase]);
    }

  redraw=0;
  do
  {
   //
   // CHECK BUTTONS
   //
   for (i=0;i<NUMDIBTNS;i++)
     {
      whichb=i;
      if (!CheckList(DIdx+DIb[i].xoff,DIdy+DIb[i].yoff,strlen(DIb[i].text),1,DIbon,DIboff,0))
	{
	 DIboff(DIdx+DIb[i].xoff,DIdy+DIb[i].yoff);
	 switch(i)
	 {
	  case 0: // Play
	    break;
	  case 1: // Delete
	    if (DIhigh<0)
	      ErrDialog("You haven't selected an\n"
			"existing digitized sound!"," OK ");
	    else
	      {
	       if (Digisound[DIhigh].type<0)
		 ErrDialog("You can't DELETE a PC/Adlib\n"
			   "sound from this dialog!"," OK ");
	       else
		 {

		 }
	      }
	    break;
	  case 2: // Import
	  case 3: // New Path
	  case 4: // Exit
	    exit=1;
	 }
	}
     }

   //
   // CHECK LIST
   //
   which=CheckList(DIdx+2,DIdy+2,16,max,DIlon,DIloff,0);
   if (which>=0)
     {
      if (DIhigh>=0)
	DIloff(DIdx+2,DIdy+2+DIhigh-DIbase,DIhigh-DIbase);
      if (DIhigh!=which+DIbase)
	{
	 DIhigh=which+DIbase;
	 DIlon(DIdx+2,DIdy+2+DIhigh-DIbase,DIhigh-DIbase);
	}
      else
	DIhigh=-1;
     }

   //
   // CHECK KEYS
   //

  } while(!redraw && !exit);
 } while(!exit);

 RestoreBackground();
}

void DIbon(int x,int y)
{
 xormask=1;
 DIboff(x,y);
 xormask=0;
}
void DIboff(int x,int y)
{
 MouseHide();
 sx=x;
 sy=y;
 print(DIb[whichb].text);
 MouseShow();
}
void DIlon(int x,int y,int w)
{
 xormask=1;
 DIloff(x,y,w);
 //
 // PRINT HIGHLIGHTED NAME
 //
 if (DIhigh>=0)
   DIloff(DIdx+2,DIdy+2+DIhigh-DIbase,DIhigh-DIbase);

 xormask=0;
}
void DIloff(int x,int y,int w)
{
 MouseHide();
 bar(x,y,16,1,' ');
 sx=x;
 sy=y;
 if (Digisound[w+DIbase].type<0)
   print(Digisound[w+DIbase].filename);
 else
   print(soundnames[w+DIbase]);

 MouseShow();
}


/////////////////////////////////////////////////
//
// Item - Change to another project
//
/////////////////////////////////////////////////
void Item_NewProject(void)
{
 if (Message("Are you sure you want\n"
	     "to do this? You are going\n"
	     "to change projects!")<2)
   return;

 CheckToSave();
 ClearMemory();
 LoadNewProject();
 RedrawDesktop();
 DrawMUSEscreen(1);
 SaveUNDO();
}


/////////////////////////////////////////////////
//
// Item - Create a new project
//
/////////////////////////////////////////////////
void Item_CreateProject(void)
{
 if (Message("Are you sure you want\n"
	     "to do this? You are going\n"
	     "to create a NEW project!")<2)
   return;

 CheckToSave();
 ClearMemory();
 InitNewProject();
 RedrawDesktop();
 DrawMUSEscreen(1);
 SaveUNDO();
 DirtyFlag=1;
}
