/////////////////////////////////////////////////
/////////////////////////////////////////////////
//
// MUSE-2	Menu Items
//
/////////////////////////////////////////////////
/////////////////////////////////////////////////
#include "muse.h"
#pragma hdrstop


char tmpadlib[ALBUFSIZE],tmppc[PCBUFSIZE];

/////////////////////////////////////////////////
//
// Item - About
//
/////////////////////////////////////////////////
void Item_About(void)
{
 char str[200];

 strcpy(str,MUSEversion);
 strcat(str,"\n   IdWare by John Romero\n");
 strcat(str,"        ");
 strcat(str,__DATE__);
 strcat(str,"\n   (C) 1991 Id Software\n\n"
	    "The Complete Sound Utility!");

 ErrDialog(str," OK ");
}


/////////////////////////////////////////////////
//
// Item - Quit
//
/////////////////////////////////////////////////
void Item_Quit(void)
{
 if (Message("Are you sure you\nwant to Quit?")<2)
   return;

 CheckToSave();

 setvideo(TEXT);
 Quit("");
}


/////////////////////////////////////////////////
//
// Item - Toggle DELTA-DRAW mode
//
/////////////////////////////////////////////////
void Item_DeltaTog(void)
{
 deltamode^=1;
 DrawInfoLine();
}


/////////////////////////////////////////////////
//
// Item - Select PC mode
//
/////////////////////////////////////////////////
void Item_PC_Mode(void)
{
 whichtype=PC;
 while(keydown[0x19]);
 SaveUNDO();
 selectstate=0;
 DrawMUSEscreen(0);
}


/////////////////////////////////////////////////
//
// Item - Select AdLib mode
//
/////////////////////////////////////////////////
void Item_AdLibMode(void)
{
 if (!AdLibPresent)
   {
    ErrDialog("Sorry, but I cannot find\n"
	      "an AdLib card on this system.\n"
	      "Therefore, tough luck!"," Wah! ");
    return;
   }

 whichtype=ADLIB;
 while(keydown[0x1e]);
 SaveUNDO();
 selectstate=0;
 DrawMUSEscreen(0);
}


/////////////////////////////////////////////////
//
// Item - Play the current sound
//
/////////////////////////////////////////////////
void Item_PlayCurrentSound(void)
{
 char huge *Data;
 AdLibSound huge *loc;
 word i;

 switch(whichtype)
 {
  case PC:
    if (!PCsound[whichsound].data->common.length)
      break;

    SD_SetSoundMode(sdm_PC);
    if (selectstate)
      {
       PCSound *temp=(PCSound *)&tmppc;

       Data=GetDataAddr();
       movedata((unsigned)PCsound[whichsound].data,0,FP_SEG(&tmppc),FP_OFF(&tmppc),sizeof(PCSound));
       movedata(FP_SEG(Data),
		FP_OFF(Data)+selectx1-WINDOW_LEFT,
		FP_SEG(&temp->data),
		FP_OFF(&temp->data),selectx2-selectx1);
       temp->common.length=selectx2-selectx1;
       SDL_PCPlaySound((PCSound far *)&tmppc);
      }
    else
      SDL_PCPlaySound(PCsound[whichsound].data);
    break;
  case ADLIB:
    if (!AdLibsnd[whichsound].data->common.length)
      break;
    //
    // Copy data into temporary buffer & transpose
    //
    loc=AdLibsnd[whichsound].data;

    if (selectstate)
      {
       AdLibSound *temp=(AdLibSound *)&tmpadlib;

       Data=GetDataAddr();
       movedata((unsigned)AdLibsnd[whichsound].data,0,FP_SEG(&tmpadlib),FP_OFF(&tmpadlib),sizeof(AdLibSound));
       movedata(FP_SEG(Data),
		FP_OFF(Data)+selectx1-WINDOW_LEFT,
		FP_SEG(&temp->data),
		FP_OFF(&temp->data),selectx2-selectx1);
       temp->common.length=selectx2-selectx1;
      }
    else
      movedata(FP_SEG(loc),FP_OFF(loc),FP_SEG(tmpadlib),FP_OFF(tmpadlib),ALBUFSIZE);

    TransAdLibData((AdLibSound huge *)&tmpadlib);
    SD_SetSoundMode(sdm_AdLib);
    SDL_ALPlaySound((AdLibSound far *)&tmpadlib);
 }
}


/////////////////////////////////////////////////
//
// Item - Update all IMPORTed files (MUSIC & DIGITIZED)
//
/////////////////////////////////////////////////
void Item_UpdateImports(void)
{
 struct ffblk ff;
 int i;


 for (i=0;i<MUSEinfo.num_music;i++)
 {
  //
  // MAKE SURE EVERYTHING'S COOL WITH CHECKING THE FILE...
  //
  if (!strncmp(strupr(musicinfo[i].filename),"A:",2) ||
      !strncmp(strupr(musicinfo[i].filename),"B:",2))
  {
   char drive=musicinfo[i].filename[0];

   if (drive>='a')
     drive-='a'-'A';

   retry:
   if (access(musicinfo[i].filename,0))
   {
    char errst[100]="Having trouble with drive ",dr[3]="";
    strncpy(dr,musicinfo[i].filename,2);
    strcat(errst,dr);
    strcat(errst,"\nRetry ");
    strcat(errst,musicinfo[i].name);
    strcat(errst,"?");
    if (Message(errst)<2)
      continue;
    else
      goto retry;
   }
  }

  //
  // SEE IF FILE NEEDS UPDATING...
  //
  if (findfirst(musicinfo[i].filename,&ff,FA_ARCH)<0)
  {
   char errst[100]="Having trouble checking\n";
   strcat(errst,musicinfo[i].filename);
   strcat(errst," file.");
   ErrDialog(errst," OK ");
   continue;
  }

  if (ff.ff_ftime!=musicinfo[i].time || ff.ff_fdate!=musicinfo[i].date)
  {
   long srcsize=ff.ff_fsize,destsize;
   memptr source,dest;
   char errst[80]="Updating ";
   //
   // YES! UPDATE THE FILE!
   //
   strcat(errst,musicinfo[i].name);
   strcat(errst,"...");
   ErrDialog(errst,"");

   MMFreePtr((memptr *)&musicinfo[i].data);
   //MMAllocate(&source,srcsize);
   MMAllocate(&dest,srcsize+2);
   LoadFile(musicinfo[i].filename,(char huge *)dest+2,0,0);
   //destsize=ConvertROL(source,dest);
   destsize=srcsize+2;
   *(unsigned huge *)dest=srcsize;
   //movedata((unsigned)source,0,(unsigned)dest,2,srcsize);
   //MMFreePtr(&source);
   MMAllocate((memptr *)&musicinfo[i].data,destsize);
   movedata((unsigned)dest,0,(unsigned)musicinfo[i].data,0,destsize);
   MMFreePtr(&dest);

   musicinfo[i].size=destsize;
   musicinfo[i].time=ff.ff_ftime;
   musicinfo[i].date=ff.ff_fdate;
   DirtyFlag=1;

   RestoreBackground();
  }
 }

 if (i)
   ErrDialog("Import Update finished."," OK ");
}


/////////////////////////////////////////////////
//
// Item - Save the AUDIO file out
//
/////////////////////////////////////////////////
void Item_SaveAudio(void)
{
 SaveAudio();
 DirtyFlag=0;
}


/////////////////////////////////////////////////
//
// Item - Edit the current sound's name
//
/////////////////////////////////////////////////
btype ESNb={"               ",1,6,1};
DialogDef ESNd={"Change sound name\nFrom:\n\n\nTo:",18,8,1,&ESNb,NULL};

void Item_EditSndName(void)
{
 char temp[16];


 SaveUNDO();
 clearkeys();
 MouseHide();
 DrawDialog(&ESNd,1);
 GetDialogXY(&ESNd,&sx,&sy);
 sx+=1;
 sy+=2;
 print(soundnames[whichsound]);

 GetButtonXY(&ESNd,0,&sx,&sy);
 memset(temp,0,16);
 if (input(temp,14))
   {
    strcpy(soundnames[whichsound],temp);
    writeH=DirtyFlag=1;
    DrawInfoLine();
   }

 MouseShow();
 RestoreBackground();
}


/////////////////////////////////////////////////
//
// Item - DELETE the selected area/Sound
//
/////////////////////////////////////////////////
void Item_DelArea(void)
{
 char huge *Data;
 word dellen,sndlen;


 SaveUNDO();
 Data=GetDataAddr();

 if (!selectstate)
   {
    if (MUSEinfo.num_sounds<2)
      {
       ErrDialog("You must have AT LEAST one\n"
		 "sound available. You might\n"
		 "want to CLEAR this instead."," As you wish... ");
       return;
      }

    if (Message("About to DELETE this\nentire sound! Proceed?")<2)
      return;


    if (whichsound==MUSEinfo.num_sounds-1)
      {
       MMFreePtr((memptr *)&PCsound[whichsound]);
       MMFreePtr((memptr *)&AdLibsnd[whichsound]);
       whichsound--;
      }
    else
      {
       movedata((unsigned)PCsound[MUSEinfo.num_sounds-1].data,0,(unsigned)PCsound[whichsound].data,0,PCBUFSIZE);
       MMFreePtr((memptr *)&PCsound[MUSEinfo.num_sounds-1]);

       movedata((unsigned)AdLibsnd[MUSEinfo.num_sounds-1].data,0,(unsigned)AdLibsnd[whichsound].data,0,ALBUFSIZE);
       MMFreePtr((memptr *)&AdLibsnd[MUSEinfo.num_sounds-1]);

       strcpy(soundnames[whichsound],soundnames[MUSEinfo.num_sounds-1]);
      }

    MUSEinfo.num_sounds--;
    SaveUNDO();
   }
 else
   {
    sndlen=GetDataLen();
    dellen=selectx2-selectx1+1;

    movedata(FP_SEG(Data),FP_OFF(Data)+selectx2-WINDOW_LEFT+1,
	     FP_SEG(Data),FP_OFF(Data)+selectx1-WINDOW_LEFT,
	     sndlen);

    SetDataLen(sndlen-dellen);
    selectx1=selectx2=selectstate=0;
    for (dellen=1+GetDataLen();dellen<DATAPOINTS;dellen++)
      Data[dellen]=0;
    FindDataLength();
   }

 writeH=DirtyFlag=1;

 DrawMUSEscreen(0);
}


/////////////////////////////////////////////////
//
// Item - Clear selected area/Sound
//
/////////////////////////////////////////////////
void Item_ClearArea(void)
{
 char huge *Data;
 word i;


 SaveUNDO();
 Data=GetDataAddr();

 if (!selectstate)
   {
    if (Message("About to CLEAR this\nentire sound. Proceed?")<2)
      return;

    _fmemset((void far *)Data,0,DATAPOINTS);
    SetDataLen(0);
   }
 else
   {
    for (i=selectx1;i<=selectx2;i++)
      Data[i-WINDOW_LEFT]=0;

    //
    // Get endline redrawn
    //
    MouseHide();
    VW_Vlin(WINDOW_TOP,WINDOW_BOTTOM,GetDataLen()+WINDOW_LEFT,EDBKGND);
    MouseShow();
    FindDataLength();
    selectx1=selectx2=selectstate=0;
   }

 DirtyFlag=1;
 DrawMUSEscreen(0);
}


/////////////////////////////////////////////////
//
// Item - Create a new sound spot
//
/////////////////////////////////////////////////
void Item_CreateNewSound(void)
{
 char temp[4];
 word i;


 if (whichsound==MAXSOUNDS-1)
   {
    ErrDialog("You can't have ANY MORE\n"
	      "sounds -- no more room!"," Aw, gosh ");
    return;
   }

 //
 // SET UP NEW SOUND
 //
 i=MUSEinfo.num_sounds;

 MMAllocate((memptr *)&PCsound[i].data,PCBUFSIZE);
 MMAllocate((memptr *)&AdLibsnd[i].data,ALBUFSIZE);
 _fmemset(PCsound[i].data,0,PCBUFSIZE);
 _fmemset(AdLibsnd[i].data,0,ALBUFSIZE);

 AdLibsnd[i].data->inst = definst;
 strcpy(AdLibsnd[i].instname,"Default");
 AdLibsnd[i].data->block=4;

 Digisound[i].type=-1;

 itoa(i,temp,10);
 strcpy(soundnames[i],"Untitled");
 strcat(soundnames[i],temp);

 whichsound=i;
 MUSEinfo.num_sounds++;
 writeH=DirtyFlag=1;
 selectstate=0;
 DrawMUSEscreen(0);
}


/////////////////////////////////////////////////
//
// Item - Raise block value
//
/////////////////////////////////////////////////
void Item_RaiseBlock(void)
{
 if (whichtype!=ADLIB)
   return;

 SaveUNDO();
 AdLibsnd[whichsound].data->block++;
 if (AdLibsnd[whichsound].data->block>7)
   AdLibsnd[whichsound].data->block=7;

 DirtyFlag=1;
 DrawInfoLine();
}


/////////////////////////////////////////////////
//
// Item - Lower block value
//
/////////////////////////////////////////////////
void Item_LowerBlock(void)
{
 if (whichtype!=ADLIB)
   return;

 SaveUNDO();
 if (AdLibsnd[whichsound].data->block>0)
   AdLibsnd[whichsound].data->block--;

 DirtyFlag=1;
 DrawInfoLine();
}


/////////////////////////////////////////////////
//
// Item - Memory Available
//
/////////////////////////////////////////////////
void Item_MemStats(void)
{
 char tstr[200]="Memory Available\n\nMain memory:",temp[4];

 itoa((1023L+16L*MMTotalFree())/1024L,temp,10);
 strcat(tstr,temp);
 strcat(tstr,"K ");
 ErrDialog(tstr," OK ");
}


/////////////////////////////////////////////////
//
// Item - Change AdLib instrument
//
/////////////////////////////////////////////////
#define NUMCAIB 5
btype CAIb[]={{" Cancel ",29,11,1},
	      {" Accept ",29,14,1},
	      {"\xb",31,6,1},
	      {"\xc",34,6,1},
	      {"  Play  ",29,17,2}};
DialogDef CAId={"Change instrument...\n\n"
		"                             Current"
		,38,22,NUMCAIB,&CAIb[0],NULL};

int insbase,coladd;
instn huge *inames;
#define INSOFF	0
#define CURX	11
#define CURY	3


void Item_ChangeInst(void)
{
 Instrument oldinst;
 char oldname[9];

 long instdata,lastoff;
 word numins,maxd,i,dx,dy,dx1,dy1,oldoct,l_dirty;
 unsigned char insbuf[30];
 int select,whichins,exit,redraw;
 char key;


 if (whichtype!=ADLIB)
   return;

 numins = *((word huge *)(InstBank + 8));
 instdata= *((long huge *)(InstBank+16));
 inames = (instn huge *)(InstBank + *((long huge *)(InstBank + 12)));

 //
 // THIS LITTLE BLIB O' CODE MAKES SURE
 // THAT WE AREN'T OUT IN THE MIDDLE OF
 // TIMBUKFUCK IF THE INSTRUMENT BANK
 // FILE WAS CHANGED!
 //
 if (insbase+3*18>numins)
   insbase=numins-3*18;
 if (insbase<0)
   insbase=0;


 MouseHide();
 DrawDialog(&CAId,1);
 GetDialogXY(&CAId,&dx,&dy);
 DrawBorder(dx+INSOFF,dy+1,27,19,1);

 sx=dx+CURX+18;
 sy=dy+CURY+1;
 printint(numins);
 print(" inst.");
 sx=dx+CURX+18;
 sy=dy+CURY+5;
 print("Octave:");

 MouseShow();

 whichins=-1;

 oldinst=AdLibsnd[whichsound].data->inst;
 oldoct=AdLibsnd[whichsound].data->block;
 _fstrcpy(oldname,AdLibsnd[whichsound].instname);

 l_dirty=exit=0;
 do
 {
  MouseHide();
  coladd=0;
  maxd=18*3;
  dx1=dx+1+INSOFF;
  dy1=dy+2;
  if (numins<maxd)
    maxd=numins;
  for (i=0;i<maxd;i++)
    {
     InsOff(dx1,dy1,i);
     dy1++;
     if (dy1>20)
       {
	dy1=dy+2;
	dx1+=9;
       }
    }

  sx=dx+CURX+18;
  sy=dy+CURY;
  print(AdLibsnd[whichsound].instname);
  sx=dx+CURX+25;
  sy=dy+CURY+5;
  printint(AdLibsnd[whichsound].data->block);
  MouseShow();

  clearkeys();
  redraw=0;
  do
  {
   //
   // 'A'-'Z' goto inst
   //
   key=bioskey(1)&0xff;
   if (key>='a')
     key-=0x20;
   if (key>='A' && key<='Z')
     {
      int i;

      for (i=0;i<numins;i++)
	if (inames[i].name[0]==key)
	  {
	   insbase=whichins=i;
	   if (insbase+3*18>numins && numins>3*18)
	     insbase=numins-3*18;
	   redraw=1;
	   break;
	  }

      if (redraw)
	continue;
     }

   //
   // Cancel or ESC
   //
   GetButtonXY(&CAId,0,&sx,&sy);
   select=CheckList(sx,sy,6,1,CancelOn,CancelOff,0);
   if (!select || keydown[1])
     {
      AdLibsnd[whichsound].data->inst=oldinst;
      AdLibsnd[whichsound].data->block=oldoct;
      _fstrcpy(AdLibsnd[whichsound].instname,oldname);

      exit=1;
      l_dirty=0;
      continue;
     }

   //
   // Accept
   //
   GetButtonXY(&CAId,1,&sx,&sy);
   select=CheckList(sx,sy,8,1,AcceptOn,AcceptOff,0);
   if (!select)
     {
      exit=1;
      continue;
     }

   //
   // Play
   //
   GetButtonXY(&CAId,4,&sx,&sy);
   select=CheckList(sx,sy,8,1,PlayOn,PlayOff,0);
   if (!select || keydown[0x1c])
     {
      GetButtonXY(&CAId,4,&sx,&sy);
      PlayOff(sx,sy);
      Item_PlayCurrentSound();
      while(keydown[0x1c]);
     }

   //
   // Up Arrow
   //
   GetButtonXY(&CAId,2,&sx,&sy);
   select=CheckList(sx,sy,1,1,ArUpOn,ArUpOff,0);
   if (!select)
     {
      ArUpOff(sx-1,sy);
      if (AdLibsnd[whichsound].data->block<7)
	{
	 AdLibsnd[whichsound].data->block++;
	 DrawInfoLine();
	 Item_PlayCurrentSound();
	 l_dirty=redraw=1;
	 continue;
	}
     }

   //
   // Down Arrow
   //
   GetButtonXY(&CAId,3,&sx,&sy);
   select=CheckList(sx,sy,1,1,ArDnOn,ArDnOff,0);
   if (!select)
     {
      ArDnOff(sx-1,sy);
      if (AdLibsnd[whichsound].data->block)
	{
	 AdLibsnd[whichsound].data->block--;
	 DrawInfoLine();
	 Item_PlayCurrentSound();
	 l_dirty=redraw=1;
	 continue;
	}
     }

   //
   // SELECT FROM LIST
   //
   dx1=dx+1+INSOFF;
   coladd=0;
   select=CheckList(dx+1+INSOFF,dy+2,8,maxd/3,InsOn,InsOff,0);
   dy1=select+dy+2;
   if (select<0)
     {
      dx1=dx+10+INSOFF;
      coladd=18;
      select=CheckList(dx+10+INSOFF,dy+2,8,maxd/3,InsOn,InsOff,0);
      dy1=select+dy+2;

      if (select<0)
	{
	 dx1=dx+19+INSOFF;
	 coladd=36;
	 select=CheckList(dx+19+INSOFF,dy+2,8,maxd/3,InsOn,InsOff,0);
	 dy1=select+dy+2;
	 if (select>=0)
	   select+=36;
	}
      else
	select+=18;
     }

   if (select>=0)
     {
      coladd=0;
      InsOff(dx1,dy1,select);
      whichins=select+insbase;

      bar(dx+CURX+18,dy+CURY,dx+CURX+18+8,dy+CURY,' ');
      sx=dx+CURX+18;
      sy=dy+CURY;
      fprint(inames[whichins].name);

      lastoff=instdata+30L*inames[whichins].doffset;
      movedata((unsigned)InstBank,lastoff,
	       FP_SEG(&insbuf),FP_OFF(&insbuf),sizeof(insbuf));

      if (insbuf[0])
      {
       sound(1800);
       WaitVBL(10);
       nosound();
       continue;
      }

      _fstrcpy(AdLibsnd[whichsound].instname,inames[whichins].name);

#if 1
      CompileInstrument2(insbuf,
			(char huge *)(&AdLibsnd[whichsound].data->inst));
#else
      //
      // THIS CHUNK OF BULLSHIT CODE TAKES THE 30 BYTES OF
      // INSTRUMENT BANK DATA AND MUNGES IT INTO THE BYTES
      // THAT GET STORED DIRECTLY INTO THE ADLIB'S REGISTERS!
      //
      {
       char mchar,cchar,mscale,cscale,mattack,cattack,
	     msus,csus,mwave,cwave,nconn;

       mchar=((insbuf[11]&1)<<7)|	// AM
	     ((insbuf[12]&1)<<6)|	// VIB
	     ((insbuf[7]&1)<<5) |	// KSR
	     ((insbuf[13]&1)<<4)|	// EG
	     (insbuf[3]&15);		// MULTI
       cchar=((insbuf[24]&1)<<7)|	// AM
	     ((insbuf[25]&1)<<6)|	// VIB
	     ((insbuf[20]&1)<<5)|	// KSR
	     ((insbuf[26]&1)<<4)|	// EG
	     (insbuf[16]&15);		// MULTI

       mscale=((insbuf[2]&3)<<6)|	// KSL
	      (insbuf[10]&63);		// TL
       cscale=((insbuf[15]&3)<<6)|	// KSL
	      (insbuf[23]&63);		// TL

       mattack=((insbuf[5]&15)<<4)|	// AR
	       (insbuf[8]&15);		// DR
       cattack=((insbuf[18]&15)<<4)|	// AR
	       (insbuf[21]&15);		// DR

       msus=((insbuf[6]&15)<<4)|	// SL
	     (insbuf[9]&15);		// RR
       csus=((insbuf[19]&15)<<4)|	// SL
	     (insbuf[22]&15);		// RR

       mwave=(insbuf[28]&3);		// WS
       cwave=(insbuf[29]&3);		// WS

       nconn=((insbuf[4]&7)<<1)|	// FB
	      (insbuf[14]&1);		// C

       if (insbuf[0]==1 && insbuf[1]!=6)
	 {
	  cchar=mchar;
	  cscale=mscale;
	  cattack=mattack;
	  csus=msus;
	  cwave=mwave;
	  mchar=mscale=mattack=msus=mwave=0;
	 }

       AdLibsnd[whichsound].data->inst.mChar=mchar;
       AdLibsnd[whichsound].data->inst.cChar=cchar;
       AdLibsnd[whichsound].data->inst.mScale=mscale;
       AdLibsnd[whichsound].data->inst.cScale=cscale;
       AdLibsnd[whichsound].data->inst.mAttack=mattack;
       AdLibsnd[whichsound].data->inst.cAttack=cattack;
       AdLibsnd[whichsound].data->inst.mSus=msus;
       AdLibsnd[whichsound].data->inst.cSus=csus;
       AdLibsnd[whichsound].data->inst.mWave=mwave;
       AdLibsnd[whichsound].data->inst.cWave=cwave;
       AdLibsnd[whichsound].data->inst.nConn=nconn;
      }
#endif

      Item_PlayCurrentSound();
      while(keydown[0x1c]);
      l_dirty=1;
      continue;
     }

   //
   // SCROLL UP
   //
   if (keydown[0x48])
     {
      if (insbase>0)
	{
	 insbase--;
	 redraw=1;
	 continue;
	}
      if (!keydown[0x1d])
	while(keydown[0x48]);
     }
   else
   //
   // SCROLL DOWN
   //
   if (keydown[0x50])
     {
      if (insbase+18*3<numins)
	{
	 insbase++;
	 redraw=1;
	 continue;
	}
      if (!keydown[0x1d])
	while(keydown[0x50]);
     }
   //
   // PAGE UP
   //
   else
   if (keydown[0x49])
     {
      if (insbase>0)
	{
	 insbase-=18;
	 if (insbase<0)
	   insbase=0;
	 redraw=1;
	 continue;
	}
      if (!keydown[0x1d])
	while(keydown[0x49]);
     }
   else
   //
   // PAGE DOWN
   //
   if (keydown[0x51])
     {
      if (insbase+18*3<numins)
	{
	 insbase+=18;
	 if (insbase+18*3>numins)
	   insbase=numins-18*3;
	 redraw=1;
	 continue;
	}
      if (!keydown[0x1d])
	while(keydown[0x51]);
     }

  } while(!redraw && !exit);
 } while(!exit);

 if (l_dirty)
   writeH=DirtyFlag=1;
 DrawInfoLine();
 RestoreBackground();
 clearkeys();
}


void InsOn(int x,int y,int w)
{
 xormask=1;
 InsOff(x,y,w);
 xormask=0;
}

void InsOff(int x,int y,int w)
{
 MouseHide();
 bar(x,y,x+7,y,' ');
 sx=x;
 sy=y;
 fprint(inames[w+insbase+coladd].name);
 MouseShow();
}

void ExitOn(int x,int y)
{
 xormask=1;
 ExitOff(x,y);
 xormask=0;
}

void ExitOff(int x,int y)
{
 MouseHide();
 sx=x;
 sy=y;
 print(" Exit ");
 MouseShow();
}
void PrintOn(int x,int y)
{
 xormask=1;
 PrintOff(x,y);
 xormask=0;
}

void PrintOff(int x,int y)
{
 MouseHide();
 sx=x;
 sy=y;
 print("Print");
 MouseShow();
}
void CancelOn(int x,int y)
{
 xormask=1;
 CancelOff(x,y);
 xormask=0;
}

void CancelOff(int x,int y)
{
 MouseHide();
 sx=x;
 sy=y;
 print(" Cancel ");
 MouseShow();
}
void AcceptOn(int x,int y)
{
 xormask=1;
 AcceptOff(x,y);
 xormask=0;
}

void AcceptOff(int x,int y)
{
 MouseHide();
 sx=x;
 sy=y;
 print(" Accept ");
 MouseShow();
}

void PlayOn(int x,int y)
{
 xormask=1;
 PlayOff(x,y);
 xormask=0;
}

void PlayOff(int x,int y)
{
 MouseHide();
 sx=x;
 sy=y;
 print("  Play  ");
 MouseShow();
}

void ArUpOn(int x,int y)
{
 xormask=1;
 ArUpOff(x,y);
 xormask=0;
}

void ArUpOff(int x,int y)
{
 MouseHide();
 sx=x;
 sy=y;
 print("\xb");
 MouseShow();
}

void ArDnOn(int x,int y)
{
 xormask=1;
 ArDnOff(x,y);
 xormask=0;
}

void ArDnOff(int x,int y)
{
 MouseHide();
 sx=x;
 sy=y;
 print("\xc");
 MouseShow();
}


/////////////////////////////////////////////////
//
// Item - Copy PC to AdLib
//
/////////////////////////////////////////////////
void Item_PCtoAdLib(void)
{
 void far *src,far *dest;


 if (!AdLibPresent)
   {
    ErrDialog("No AdLib/SoundBlaster is\n"
	      "present. No can do."," OK ");
    return;
   }

 SaveUNDO();
 _fmemset(AdLibsnd[whichsound].data->data,0,DATAPOINTS);
 src=&PCsound[whichsound].data->data;
 dest=&AdLibsnd[whichsound].data->data;
 movedata(FP_SEG(src),FP_OFF(src),FP_SEG(dest),FP_OFF(dest),DATAPOINTS);
 AdLibsnd[whichsound].data->common.length=PCsound[whichsound].data->common.length;
 AdLibsnd[whichsound].data->common.priority=PCsound[whichsound].data->common.priority;

 selectstate=0;
 if (whichtype==ADLIB)
   DrawMUSEscreen(0);
 DirtyFlag=1;
}


/////////////////////////////////////////////////
//
// Item - Copy AdLib to PC
//
/////////////////////////////////////////////////
void Item_AdLibtoPC(void)
{
 void far *src,far *dest;


 if (!AdLibPresent)
   {
    ErrDialog("No AdLib/SoundBlaster is\n"
	      "present. No can do."," OK ");
    return;
   }

 SaveUNDO();
 _fmemset(PCsound[whichsound].data->data,0,DATAPOINTS);
 dest=&PCsound[whichsound].data->data;
 src=&AdLibsnd[whichsound].data->data;
 movedata(FP_SEG(src),FP_OFF(src),FP_SEG(dest),FP_OFF(dest),DATAPOINTS);
 PCsound[whichsound].data->common.length=AdLibsnd[whichsound].data->common.length;
 PCsound[whichsound].data->common.priority=AdLibsnd[whichsound].data->common.priority;

 selectstate=0;
 if (whichtype==PC)
   DrawMUSEscreen(0);
 DirtyFlag=1;
}


/////////////////////////////////////////////////
//
// Item - Change the instrument bank file
//
/////////////////////////////////////////////////
void Item_ChangeBNK(void)
{
 char temp[64],path[64];
 int select,i;


 strcpy(path,_argv[0]);
 for (i=strlen(path);i>=0;i--)
   if (path[i]=='\\')
     {
      path[i+1]=0;
      break;
     }

 strcpy(temp,path);
 strcat(temp,"*.BNK");

 select=GetPath("   Select Bank file",temp,temp);
 if (select==-1)
   {
    ErrDialog("There are no Instrument Bank\n"
	      "files to choose from!"," OK ");
    return;
   }
 if (select==-2)
   return;

 strcpy(bankname,temp);
 MMFreePtr((memptr *)&InstBank);
 LoadIn(bankname,(memptr *)&InstBank);
}


/////////////////////////////////////////////////
//
// Huffmanize and save the AUDIO.ext file out
// with the .OBJs as well!
//
/////////////////////////////////////////////////
void Item_HuffAudio(void)
{
 MUSEInfoStr TempMI=MUSEinfo;
 word i;
 long size,fsize=0,temp,_seg *fileoffs,newlen,lastlen,
	orgsize,newsize;
 char tstr[100]="Huffmanizing audio data...",cname[13]="AUDIO.",hname[13]="AUDIOHHD.",
      dname[13]="AUDIODCT.",_seg *CompBuff,tempstr[13];



 ErrDialog(tstr,"");

 strcat(cname,ext);
 strcat(hname,ext);
 strcat(dname,ext);

 ////////////////////////////////////////////////
 //
 // AUDIO.EXT (Huffman compressed)
 // ------------------
 // COUNT BYTES
 //
 memset(counts,0,sizeof(counts));
 orgsize=newsize=0;

 for (i=0;i<MUSEinfo.num_sounds;i++)
 {
  AdLibSound huge *loc;


  temp=sizeof(PCSound)+PCsound[i].data->common.length;
  orgsize+=temp;
  CountBytes((char huge *)PCsound[i].data,temp);

  temp=AdLibsnd[i].data->common.length;
  loc=AdLibsnd[i].data;
  orgsize+=temp;
  movedata(FP_SEG(loc),FP_OFF(loc),FP_SEG(&tmpadlib),FP_OFF(&tmpadlib),temp);
  TransAdLibData((AdLibSound huge *)&tmpadlib);
  CountBytes((char huge *)AdLibsnd[i].data,sizeof(AdLibSound));
  CountBytes((char huge *)&tmpadlib,temp);
 }

 for (i=0;i<MUSEinfo.num_music;i++)
 {
  orgsize+=musicinfo[i].size;
  CountBytes((char huge *)musicinfo[i].data,musicinfo[i].size);
 }

 Huffmanize();

 //
 // SAVE PC DATA
 //
 for (i=0;i<MUSEinfo.num_sounds;i++)
 {
  temp=sizeof(PCSound)+PCsound[i].data->common.length;

  MMAllocate((memptr *)&CompBuff,temp);
  *(long _seg *)CompBuff=temp;
  newlen=HuffCompress((unsigned char huge *)PCsound[i].data,temp,
	 (unsigned char huge *)CompBuff+4)+4;

  newsize+=newlen;
  TempMI.pcdataoff[i]=fsize;
//  TempMI.pcdatalen[i]=newlen;

  SaveFile(cname,(char huge *)CompBuff,fsize,newlen);
  fsize+=newlen;
  lastlen=fsize;
  MMFreePtr((memptr *)&CompBuff);
 }

 SaveFile(cname,"!ID!",fsize,4);
 fsize+=4;

 //
 // SAVE ADLIB DATA
 //
 for (i=0;i<MUSEinfo.num_sounds;i++)
 {
  AdLibSound huge *loc;
  temp=sizeof(AdLibSound)+AdLibsnd[i].data->common.length;

  loc=AdLibsnd[i].data;
  movedata(FP_SEG(loc),FP_OFF(loc),FP_SEG(tmpadlib),FP_OFF(tmpadlib),ALBUFSIZE);
  TransAdLibData((AdLibSound huge *)&tmpadlib);

  MMAllocate((memptr *)&CompBuff,temp);
  *(long _seg *)CompBuff=temp;
  newlen=HuffCompress((unsigned char huge *)&tmpadlib,temp,
	 (unsigned char huge *)CompBuff+4)+4;

  newsize+=newlen;
  TempMI.adlibdataoff[i]=fsize;
//  TempMI.adlibdatalen[i]=newlen;

  SaveFile(cname,(char huge *)CompBuff,fsize,newlen);
  fsize+=newlen;
  lastlen=fsize;
  MMFreePtr((memptr *)&CompBuff);
 }

 SaveFile(cname,"!ID!",fsize,4);
 fsize+=4;

 //
 // SAVE MUSIC DATA
 //
 for (i=0;i<MUSEinfo.num_music;i++)
 {
  temp=musicinfo[i].size;

  MMAllocate((memptr *)&CompBuff,temp);
  *(long _seg *)CompBuff=temp;
  newlen=HuffCompress((unsigned char huge *)musicinfo[i].data,temp,
	 (unsigned char huge *)CompBuff+4)+4;

  newsize+=newlen;
  TempMI.musicdataoff[i]=fsize;

  SaveFile(cname,(char huge *)CompBuff,fsize,newlen);
  fsize+=newlen;
  lastlen=fsize;

  MMFreePtr((memptr *)&CompBuff);
 }

 RestoreBackground();
 ////////////////////////////////////////////////
 //
 // AUDIODCT.EXT
 // ------------
 // CREATE DICTIONARY .OBJ FILE
 //
 {
  int DorFD=0;

  do
  {
   switch(Message("Should I make the Huffman\n"
		  "dictionary FARDATA? 'No' will\n"
		  "make it DATA."))
   {
    case 1: DorFD=1; break;
    case 2: DorFD=2;
   }
  } while(!DorFD);
  ErrDialog("Generating OBJ files...","");

  SaveFile(dname,(char huge *)&nodearray,0,sizeof(nodearray));
  strcpy(tempstr,ext);
  strcat(tempstr,"ADICT.OBJ");
  switch(DorFD)
  {
   case 1: MakeOBJ(dname,tempstr,"_audiodict",DATA,""); break;
   case 2: MakeOBJ(dname,tempstr,"_audiodict",FARDATA,"_AudioDict");
  }
  unlink(dname);
 }

 ////////////////////////////////////////////////
 //
 // AUDIOHED.EXT
 // ------------
 // ALLOCATE MEMORY FOR THE "FILEOFFS" ARRAY:
 // "3L*" IS FOR PC/ADLIB/DIGI AND "4L*" IS FOR LONGTYPE
 //
 // CREATE HEADER .OBJ FILE
 //
 size=4L*(3L*MUSEinfo.num_sounds+MUSEinfo.num_music+1);
 MMAllocate((memptr *)&fileoffs,size);

 for (i=0;i<TempMI.num_sounds;i++)
 {
  fileoffs[i]=TempMI.pcdataoff[i];
  fileoffs[i+TempMI.num_sounds]=TempMI.adlibdataoff[i];
  fileoffs[i+2*TempMI.num_sounds]=TempMI.digidataoff[i];
 }

 for (i=0;i<TempMI.num_music;i++)
   fileoffs[i+3*TempMI.num_sounds]=TempMI.musicdataoff[i];

 fileoffs[TempMI.num_sounds*3+TempMI.num_music]=lastlen;

 SaveFile(hname,(char huge *)fileoffs,0,size);
 MMFreePtr((memptr *)&fileoffs);

 strcpy(tempstr,ext);
 strcat(tempstr,"AHEAD.OBJ");
 MakeOBJ(hname,tempstr,"_audiohead",FARDATA,"_AudioHeader");
 unlink(hname);

 RestoreBackground();

 //
 // REPORT SPACE SAVINGS(?)
 //
 {
  char tstr[100]="Done compressing.\n\nOriginal size:",temps[8];
  strcat(tstr,ltoa(orgsize,temps,10));
  strcat(tstr,"\nCompressed:");
  strcat(tstr,ltoa(newsize,temps,10));
  ErrDialog(tstr," OK ");
 }
}


/////////////////////////////////////////////////
//
// Item - Sound Priorities
//
/////////////////////////////////////////////////
btype SPb[]={{" Exit ",16,20,2},
	     {"Print",3,20,1}}	;
DialogDef SPd={"      SOUND PRIORITIES",27,22,2,&SPb[0],0};
word spbase;


void Item_Priorities(void)
{
 word redraw,exit=0,dx,dy,i,max,bx,by,cx,cy;
 int select;


 MouseHide();
 DrawDialog(&SPd,1);
 GetDialogXY(&SPd,&dx,&dy);
 GetButtonXY(&SPd,0,&bx,&by);
 GetButtonXY(&SPd,1,&cx,&cy);
 DrawBorder(dx+1,dy+2,24,16,1);
 sx=dx+2;
 sy=dy+1;
 print("#   Name            Pr");
 MouseShow();
 SaveUNDO();

 do
 {
  max=15;
  if (max>MUSEinfo.num_sounds)
    max=MUSEinfo.num_sounds;
  if (spbase+max>MUSEinfo.num_sounds)
    spbase=MUSEinfo.num_sounds-max;

  for (i=0;i<max;i++)
    SPoff(dx+2,dy+3+i,i);
  redraw=0;

  do
  {
   select=CheckList(dx+2,dy+3,24,max,SPon,SPoff,0);
   if (select>=0)
     {
      word temp;

      MouseHide();
      SPoff(dx+2,dy+3+select,select);
      sy=dy+3+select;
      sx=dx+22;
      clearkeys();
      print("  ");
      sx-=2;
      if ((temp=inputint(2))!=ESCOUT)
	{
	 PCsound[select+spbase].data->common.priority=
	   AdLibsnd[select+spbase].data->common.priority=temp;
	 DirtyFlag=1;
	}
      SPoff(dx+2,dy+3+select,select);
      MouseShow();
     }

   //
   // EXIT
   //
   select=CheckList(bx,by,strlen(SPb[0].text),1,ExitOn,ExitOff,0);
   if (select>=0 || keydown[1] || keydown[0x1c])
     {
      exit=1;
      continue;
     }

   //
   // PRINT
   //
   select=CheckList(cx,cy,strlen(SPb[1].text),1,PrintOn,PrintOff,0);
   if (select>=0)
     {
      int i;


      PrintOff(cx,cy);
      ErrDialog("Printing Priorities...","");

      fprintf(stdprn,"MUSE Priority Information for .%s\n\n",ext);
      fprintf(stdprn,"#       Pr.     Name\n");
      fprintf(stdprn,"---------------------------------------\n");
      for (i=0;i<MUSEinfo.num_sounds;i++)
	fprintf(stdprn,"%d\t%d\t%s\n",i,PCsound[i].data->common.priority,soundnames[i]);

      fprintf(stdprn,"\xc");

      RestoreBackground();
      continue;
     }


   //
   // KEYCHECKS
   //
   if (keydown[0x49])
     {
      if (spbase<max)
	spbase=0;
      else
	spbase-=max;
      while(keydown[0x49]);
      redraw=1;
      continue;
     }

   if (keydown[0x51])
     {
      if (spbase+max>MUSEinfo.num_sounds)
	spbase=MUSEinfo.num_sounds-max;
      else
	spbase+=max;
      while(keydown[0x51]);
      redraw=1;
      continue;
     }

   if (keydown[0x48])
     if (spbase)
       {
	spbase--;
	redraw=1;
	continue;
       }

   if (keydown[0x50])
     if (spbase+max<MUSEinfo.num_sounds)
       {
	spbase++;
	redraw=1;
	continue;
       }

  } while(!redraw && !exit);
 } while(!exit);

 RestoreBackground();
}



void SPon(int x,int y,int w)
{
 xormask=1;
 SPoff(x,y,w);
 xormask=0;
}
void SPoff(int x,int y,int w)
{
 MouseHide();
 bar(x,y,x+22,y,' ');
 sx=x;
 sy=y;
 printint(w+spbase);
 sx=x+4;
 print(soundnames[w+spbase]);
 sx=x+20;
 printint(PCsound[w+spbase].data->common.priority);
 MouseShow();
}


/////////////////////////////////////////////////
//
// Item - Last Sound
//
/////////////////////////////////////////////////
void Item_Last(void)
{
 if (whichsound)
   {
    whichsound--;
    SaveUNDO();
    selectstate=0;
    DrawMUSEscreen(0);
   }
}


/////////////////////////////////////////////////
//
// Item - Next Sound
//
/////////////////////////////////////////////////
void Item_Next(void)
{
 if (PCsound[whichsound+1].data)
   {
    whichsound++;
    SaveUNDO();
    selectstate=0;
    DrawMUSEscreen(0);
   }
}


/////////////////////////////////////////////////
//
// Item - INSERT a spot
//
/////////////////////////////////////////////////
void Item_INSERT(void)
{
 char buffer[DATAPOINTS],huge *Data;
 word len,off;


 SaveUNDO();
 Data=GetDataAddr();
 len=GetDataLen();

 if (pixelx>=WINDOW_LEFT && pixelx<=WINDOW_LEFT+GetDataLen()-1 &&
     pixely>=WINDOW_TOP && pixely<=WINDOW_BOTTOM && len+2<DATAPOINTS)
   {
    memset(&buffer,0,DATAPOINTS);
    off=pixelx-WINDOW_LEFT;
    _fmemcpy((char far *)buffer,(char far *)Data,off);
    _fmemcpy((char far *)buffer+off+2,(char far *)Data+off,len-off);
    off+=len-off+2;

    _fmemcpy((char far *)Data,(char far *)buffer,off);
    SetDataLen(off);
    DrawMUSEscreen(0);
    DirtyFlag=1;
   }
}


/////////////////////////////////////////////////
//
// Restore current sound from the UNDO buffer
//
/////////////////////////////////////////////////
void Item_RestoreUNDO(void)
{
 char huge *Data;


 Data=GetDataAddr();
 _fmemset((char far *)Data,0,DATAPOINTS);
 _fmemcpy((char far *)Data,(char far *)UNDObuf,DATAPOINTS);
 FindDataLength();
 DrawMUSEscreen(0);
}


/////////////////////////////////////////////////
//
// Item - Sound GOTO
//
/////////////////////////////////////////////////
DialogDef SGd={"        SOUND GOTO",27,22,1,&SPb[0],0};
word sgbase;


void Item_GOTO(void)
{
 word redraw,exit=0,dx,dy,i,max,bx,by;
 int select;


 MouseHide();
 DrawDialog(&SGd,1);
 GetDialogXY(&SGd,&dx,&dy);
 GetButtonXY(&SGd,0,&bx,&by);
 DrawBorder(dx+1,dy+2,22,16,1);
 sx=dx+2;
 sy=dy+1;
 print("#   Name");
 MouseShow();

 do
 {
  max=15;
  if (max>MUSEinfo.num_sounds)
    max=MUSEinfo.num_sounds;
  if (sgbase+max>MUSEinfo.num_sounds)
    sgbase=MUSEinfo.num_sounds-max;

  for (i=0;i<max;i++)
    SGoff(dx+2,dy+3+i,i);
  redraw=0;

  do
  {
   select=CheckList(dx+2,dy+3,20,max,SGon,SGoff,0);
   if (select>=0)
     {
      whichsound=select+sgbase;
      redraw=exit=1;
      continue;
     }

   select=CheckList(bx,by,strlen(SPb[0].text),1,ExitOn,ExitOff,0);
   if (select>=0 || keydown[1] || keydown[0x1c])
     {
      exit=1;
      continue;
     }

   //
   // KEYCHECKS
   //
   if (keydown[0x49])
     {
      if (sgbase<max)
	sgbase=0;
      else
	sgbase-=max;
      while(keydown[0x49]);
      redraw=1;
      continue;
     }

   if (keydown[0x51])
     {
      if (sgbase+max>MUSEinfo.num_sounds)
	sgbase=MUSEinfo.num_sounds-max;
      else
	sgbase+=max;
      while(keydown[0x51]);
      redraw=1;
      continue;
     }

   if (keydown[0x48])
     if (sgbase)
       {
	sgbase--;
	redraw=1;
	continue;
       }

   if (keydown[0x50])
     if (sgbase+max<MUSEinfo.num_sounds)
       {
	sgbase++;
	redraw=1;
	continue;
       }

  } while(!redraw && !exit);
 } while(!exit);

 SaveUNDO();
 RestoreBackground();
 if (redraw)
   DrawMUSEscreen(0);
}



void SGon(int x,int y,int w)
{
 xormask=1;
 SGoff(x,y,w);
 xormask=0;
}
void SGoff(int x,int y,int w)
{
 MouseHide();
 bar(x,y,x+20,y,' ');
 sx=x;
 sy=y;
 printint(w+sgbase);
 sx=x+4;
 print(soundnames[w+sgbase]);
 MouseShow();
}
