// Victoria Crenshaw
// CSC 475
// Assignment 3
// 11-14-2022

#include "Othello.h"

#include "field.h"



#ifndef MOVES_H
#define MOVES_H




struct move        // used for internal representation
{
  char     x;              //  vaild:  A..H
  short    y;              //  valid:  0..7
  Place    player;   // who made this move?
};

typedef struct move Move;


// store a list of moves
// intended for a list of possible moves from one board status
struct movelist
{
  struct movelist *next;         // pointer to a possible next movelist
  Move             m;            // the move itself
  int              value;        // evaluation of this board status
  Field           *field;        /* storage for a board with
				   this move, can be NULL  */
};


//  store a tree of possible moves
struct movetree
{
  short             num_children;     // number of children
  struct movetree  *children;         // pointer to an array of the children
  Move              m;                // the move itself
  int               value;            // evaluation of this board status
  Field            *field;            /* storage for a board with
					this move, can be NULL  */
};






// search for possible disc placement
// possible moves will be marked in the given board
// pre-existing marks will be removed
// return the count of possible moves
struct movelist *possible_moves(Field *field, Place color);

// create a moves structure from coordinates
Move *create_move(short x, short y, Place player, Move *m);

// execute a move on a board
int    execute_move(Field *field, Move m);

/*  return the x part of the move */
int get_move_x(Move *m);

/*  return the y part of the move */
int get_move_y(Move *m);



#endif
