// Victoria Crenshaw
// CSC 475
// Assignment 3
// 11-14-2022

#include "moves.h"


// a structure to store possible moves
// including needed sub-structures and functions to work on it



/* remove possible markings on the board  */
void remove_markers(Field *field)
{
    int i;

    // cycle through all places, 'correct' x/y is here not needed
    for (i=0;i<64;i++)
    {
	/* is it a marking ?  */
	if ((PLACE_MASK_POSSIBLE_PLACE & (field->place[i]))>0)
	{
	    /*  clear that place  */
	    field->place[i] = PLACE_EMPTY;
	}
    }
}


// search for possible disc placement
// possible moves will be marked in the given board
// pre-existing marks will be removed
// return the count of possible moves
struct movelist *possible_moves(Field *field, Place color)
{
    // variables for different uses
    int a,b,i,j,cx,cy,other_color,marker_color;
    /* int possible_moves_count = 0; */
    struct movelist *possible_moves_list = NULL;
    struct movelist *temp_list = NULL;

	// init possible move count to 0
    field->possible_moves_count = 0;

    // check the given color
    if ((color != PLACE_DISC_BLACK) && (color != PLACE_DISC_WHITE))
    {
	// not black or white?  then no action
	return 0;
    }

    /*  remove markers from the board */
    remove_markers(field);

    /*  determine the other color  */
    other_color = next_player(color);

    /* marker for the own color
       simple calculation  2,3  -->  4,5  */
    marker_color = color + 2;

    /* loop through all places to find the given disc color  */
    for (i=0;i<8;i++)
    {
	for (j=0;j<8;j++)
	{
	    // is the place the own color?
	    if (get_place(field,i,j) == color)
	    {
		// check for possible placements combined with this place

		// check for discs of the other color around the current place
		for (a=-1;a<2;a++)
		{
		    for (b=-1;b<2;b++)
		    {
			// skip the position itself
			if ((a==0) && (b==0)) continue;

			// position to [c]heck
			cx = i+a;
			cy = j+b;

			// check the position if it's on the board
			if ((cx != limit_position(cx)) || (cy != limit_position(cy)))
			{
			    // is the position legal? no
			    continue;
			}

			// is the position in the other color?
			if (get_place(field,cx,cy) != other_color)
			{
			    // no
			    continue;
			}

			// next place on the same direction from the own disc
			cx = cx + a;
			cy = cy + b;

			// continue as long as the to-check place is legal
			while  ((cx == limit_position(cx)) && (cy == limit_position(cy)))
			{
			    // is there already an own disc?
			    if (get_place(field,cx,cy) == color)
			    {
				// then no placement possible
				// end the search in this direction
				break;
			    }

			    if (get_place(field,cx,cy) == PLACE_EMPTY)
			    {
			        // possible placement, mark this place
				// set_place(field,cx,cy,marker_color);
				field->possible_moves_count++;
				temp_list = possible_moves_list;


				possible_moves_list = calloc(sizeof(struct movelist),1);
				if (possible_moves_list == NULL)
				{
				    /*  this should not happen, there should be
					enough RAM available
					"crash and burn"
				    */
				    exit(20);
				}
				/*  add the new move in front */
				possible_moves_list->next = temp_list;
				create_move(cx,cy,color,&possible_moves_list->m);


				// end the search in this direction
				break;
			    }

			    // calculate the next position to check
			    cx = cx + a;
			    cy = cy + b;
			}

		    }
		}
	    }
	}
    }
    return possible_moves_list;
}


struct move *create_move(short x, short y, Place player,
			 struct move *m)
{
    // if a struct move is not given then allocate memory
    if (NULL == m)
    {
	m = calloc(sizeof(struct move),1);
	if (NULL == m)
	{
	    /*  this should not happen, there should be
		enough RAM available
	    */
	    exit(20);
	}
    }
    // set the values in teh struct
    m->x = 'A'+x;
    m->y = y+1;
    m->player = player;

    // return the pointer
    return m;
}


// return the numeric value of the x part of the move
int get_move_x(Move *m)
{
    if (NULL == m) return 0;

    return (m->x-'A');
}

// return the numeric value of the y part of the move
int get_move_y(Move *m)
{
    if (NULL == m) return 0;

    return (m->y-1);
}




/*
   execute a move on a board
   the 'field' contains the current game and
   the 'm(ove)' the move/placement and the color
   of the player who makes that move
*/
int execute_move(Field *field, Move m)
{
    Place color = m.player;
    Place other = next_player(color);
    int a,b,i,j,cx,cy,mx,my;

    /*  prevent NULL pointer dereference  */
    if (field == NULL)  return -1;

    /*  remove markers from the board */
    remove_markers(field);

    // get the move as nbumeric values
    mx = get_move_x(&m);
    my = get_move_y(&m);

    // place the disc
    set_place(field,mx,my,color);




    /* check for discs of the other color around the current place   */
    for (a=-1;a<2;a++)
    {
	for (b=-1;b<2;b++)
	{
	    /*   skip the position itself  */
	    if ((a==0) && (b==0)) continue;

	    // position to [c]heck
	    cx = mx+a;
	    cy = my+b;

	    // check the position if it's on the board
	    if ((cx != limit_position(cx)) || (cy != limit_position(cy)))
	    {
		// is the position legal? no
		continue;
	    }

	    // is the position in the other color?
	    if (get_place(field,cx,cy) != other)
	    {
		// no
		continue;
	    }

	    // next place on the same direction from the own disc
	    cx = cx + a;
	    cy = cy + b;

	    // continue as long as the to-check place is legal
	    while  ((cx == limit_position(cx)) && (cy == limit_position(cy)))
	    {
		// is there already an own disc?
		if (get_place(field,cx,cy) == color)
		{
		    // then we can flip all disc in between

		    i = cx-a;
		    j = cy-b;
		    while ((i != mx) || (j != my))
		    {
			set_place(field,i,j,color);
			i = i-a;
			j = j-b;
		    }

		    break;
		}

		if (get_place(field,cx,cy) == PLACE_EMPTY)
		{
		    /*  empty place  */
		    break;
		}
		if (get_place(field,cx,cy) != other)
		{
		    /* any other color? don't continue */
		    break;
		}

		// next place on the same direction
		cx = cx + a;
		cy = cy + b;

	    }

	}
    }
    return 0;
}
