// Victoria Crenshaw
// CSC 475
// Assignment 3
// 11-14-2022




// field.h
// definitions for the playing field

#ifndef FIELD_H
#define FIELD_H

#include "Othello.h"

/* #include "moves.h"  */


// values for a place (which disc is on it)

#define PLACE_EMPTY                  0
#define PLACE_UNUSED1                1
#define PLACE_DISC_BLACK             2
#define PLACE_DISC_WHITE             3
#define PLACE_POSSIBLE_BLACK         4
#define PLACE_POSSIBLE_WHITE         5

#define PLACE_INTERNAL_MAX           6


#define PLACE_MASK_USED_PLACE        2

#define PLACE_MASK_POSSIBLE_PLACE    4


typedef unsigned char Place;


// stores the data of a board and a few other data
struct field
{
  Place place[64];
  Place next_move;
  int   possible_moves_count;
};

typedef struct field Field;


// return struct for disc counting
struct disc_count
{
  int  count_black;
  int  count_white;
  int  evaluation;
};


typedef struct disc_count Disc_Count;



// allocate the memory
Field* create_field(void);


// initialize the field with the starting position
void   init_field(Field *field);


// print the field
void print_field(Field *field);


// enforces the range 0..7 for a coordinate of the field
int limit_position(int i);


// set a disc in a place on the board
void set_place(Field *field, int x, int y, Place color);


// get the disc color on one field
Place get_place(Field *field,int x,int y);


// get a copy of the given field
Field* copy_field(Field *field);


// get the other player color (for game and calculations)
Place  next_player(Place current_player);


// counts the discs on the field
Disc_Count  *count_discs(Field *board, Disc_Count *dc);


#endif
