// Victoria Crenshaw
// CSC 475
// Assignment 3
// 11-14-2022



#include "Othello.h"

#include "field.h"
#include "moves.h"
#include "display.h"
#include "computer.h"
#include "eval.h"
#include "debug.h"


#define INPUT_BUFFER_SIZE 10

// quit the game
void Quit(Field *field, Disc_Count *dc)
{
    // write the quitting message
    puts("No possible move     END");
    puts("");
    term_clear();
    // write the evaluation
    printf("result: %d\n", evalfield(field, dc));
    free(field);
    exit(1);
}

/*   let two humans play using this game only as board  */
void human_game(void)
{
  /* names of the players */
  char  *name[] = { "Player 1 *", "Player 2 O"};

  /* buffer for the player name title */
  char   titlebuffer[50];

  /* buffer for different sprintf uses */
  char   strbuffer[81];

  /* active player = who has the current move */
  Place  active_player = PLACE_DISC_BLACK;

  /* the board itself */
  Field *board ;
  int    psbl_moves = 0;

  /* buffer and return pointer for the player move input */
  char   input_buffer[INPUT_BUFFER_SIZE+1] = "";
  char  *user_input;

  /* variable for the while loop */
  char   continue_game = 1;

  /* store if the other player before was able to move */
  char   last_move_possible = 1;

  /* variables to store and loop through the list of possible moves */
  struct movelist *ml,*ml2,*ml_temp;

  /*  for the disc count */
  Disc_Count dc;


  /* create an empty board */
  board = create_field();

  /*  initialize the board (place the 4 discs in the middle) */
  init_field(board);

  /*  create the string with the player names */
  sprintf((char *)&titlebuffer,"%s vs %s",name[0],name[1]);

  /* display the board with the player name string */
  display_field(board,0,titlebuffer,0);

  /*  loop until the game is finished  */
  do
  {
      /* print the disc counts */
      count_discs(board,&dc);

      // write the text in a string buffer
      sprintf((char *)strbuffer,"Black Discs: %-3d",dc.count_black);
      // then write it to the screen
      term_write_at(50, 8,(char *)&strbuffer);
      sprintf((char *)strbuffer,"White Discs: %-3d",dc.count_white);
      term_write_at(50,10,(char *)&strbuffer);

      // place the cursor again behind the prompt
      term_goto(26,22);


      // end the game is one player has no discs anymore on teh board
      if ((dc.count_black == 0) || (dc.count_white == 0))
      {
	  sprintf((char *)strbuffer,"No more %s discs on the board!  GAME LOST",
		  dc.count_black == 0?"black":"white");

      }

      /* get the list of possible moves */
      ml = possible_moves(board,active_player);

      /* no possible move */
      if (NULL == ml)
      {
	  /* was the other player also not able to move?
	     if yes, then the game ends */
	  if (last_move_possible == 0)
	  {
		Quit(board,&dc);
	  }
	  /* save that this player can't move */
	  last_move_possible = 0;

	  // place the cursor again behind the prompt
	  term_goto(26,22);
	  puts("No possible move");
	  sleep(2);
	  // switch the player
	  active_player = next_player(active_player);
      }
      else
      {
	// clear the marker
	  last_move_possible = 1;
      }

      /* print the prompt */
      term_write_at(3,22,name[active_player == PLACE_DISC_BLACK ? 0 : 1]);
      term_write_at(15,22,"Your Move: ");
      /* move the cursor behind the : of the prompt */
      term_goto(26,22);
      /* clear possible remaining text in the line after the prompt */
      term_clear_eol();
      /* read the player input  */
      user_input = fgets(input_buffer,INPUT_BUFFER_SIZE,stdin);


      /*  if the player pressed ^D then stdin is closed
	  and NULL is returned in user_input
	  --> abort the game, it's not easy to recover
      */
      if (NULL == user_input)
      {
	  puts("");
	  free(board);
	  exit(25);
      }

      /*  check for a move as input   */
      if (strlen(user_input) == 3)
      {
	  /* is the first character a letter 'A'..'H'/'a'..'h' ?  */
	  if (((user_input[0]>='A') && (user_input[0]<='H')) ||
	      ((user_input[0]>='a') && (user_input[0]<='h')))
	  {
	      /* is the second character a digit '1'..'8' ?  */
	      if ((user_input[1]>='1') && (user_input[1]<='8'))
	      {
		  /* make a lowercase to an uppercase letter */
		  if (user_input[0] > 96) user_input[0] -= 32;

		  /* check if that is a valid move */

		  /* used here for the move to do, if allowed  */
		  ml2 = NULL;

		  /* used here to loop through the list of
		     possible moves */
		  ml_temp = ml;

		  /* loop through the list  */
		  while (ml_temp != NULL)
		  {
		      if ((ml_temp->m.x == user_input[0]) &&
			  (ml_temp->m.y == user_input[1]-'0'))
		      {
			  /* found the move in the list */
			  ml2 = ml_temp;
			  break;
		      }
		      ml_temp = ml_temp->next;
		  }

		  if (ml_temp == NULL)
		  {
		      /* ml_temp is NULL, then the move is invalid */

		      term_goto(26,22);
		      printf("invalid move %s!",user_input);
		      sleep(2);

		  }
		  else
		  {
		      /* ml_temp is not NULL, then the move is valid */

		      /* execute the move  */
		      execute_move(board,ml_temp->m);
		      display_field(board,0,titlebuffer,0);
		      active_player = next_player(active_player);
		  }

	      }
	  }


	  /* cleanup the list of possible moves */
	  while (ml)
	  {
	      ml2 = ml;
	      ml = ml->next;
	      free(ml2);
	  }
	  continue;

      }

  } while (continue_game);

  /*  free the memory of the board */
  free(board);

}


/*  computer vs human  */
void computer_game(Place color_computer)
{
  /* names of the players */
    char  *name[] = { "Human", "Computer" } ;

  /* buffer for the player name title */
  char   titlebuffer[50];

  /* buffer for different sprintf uses */
  char   strbuffer[81];

  /* active player = who has the current move */
  Place  active_player = PLACE_DISC_BLACK;

  /* the board itself */
  Field *board ;
  int    psbl_moves = 0;

  /* buffer and return pointer for the player move input */
  char   input_buffer[INPUT_BUFFER_SIZE+1] = "";
  char  *user_input;

  /* variable for the while loop */
  char   continue_game = 1;

  /* store if the other player before was able to move */
  char   last_move_possible = 1;

  /* variables to store and loop through the list of possible moves */
  struct movelist *ml,*ml2,*ml_temp;

  /*  for the disc count */
  Disc_Count dc;


  /* create an empty board */
  board = create_field();

  /*  initialize the board (place the 4 discs in the middle) */
  init_field(board);



  /*  create the string with the player names */
  sprintf((char *)&titlebuffer,"%s (*) vs %s (O)",
	  name[color_computer == PLACE_DISC_WHITE ? 0 : 1],
	  name[color_computer == PLACE_DISC_BLACK ? 0 : 1]);

  /* display the board with the player name string */
  display_field(board,0,titlebuffer,0);

  /*  loop until the game is finished  */
  do
  {
      /* print the disc counts */
      count_discs(board,&dc);

      // write the text in a string buffer
      sprintf((char *)strbuffer,"Black Discs: %-3d",dc.count_black);
      // then write it
      term_write_at(50, 8,(char *)&strbuffer);
      sprintf((char *)strbuffer,"White Discs: %-3d",dc.count_white);
      term_write_at(50,10,(char *)&strbuffer);

      // go back to the prompt
      term_goto(26,22);

      // no discs = lost
      if ((dc.count_black == 0) || (dc.count_white == 0))
      {
	  sprintf((char *)strbuffer,"No more %s discs on the board!  GAME LOST",
		  dc.count_black == 0?"black":"white");

      }

      /* get the list of possible moves */
      ml = possible_moves(board,active_player);

      // print the possible moves on teh right side
      // mostly for debugging
      show_possible_moves(ml);

      /* no possible move */
      if (NULL == ml)
      {
	  /* was the other player also not able to move?
	     if yes, then the game ends */
	  if (last_move_possible == 0)
	  {
		Quit(board,&dc);
	  }
	  /* save that this player can't move */
	  last_move_possible = 0;
	  term_goto(26,22);
	  puts("No possible move");
	  sleep(2);
	  active_player = next_player(active_player);
      }
      else
      {
	  last_move_possible = 1;
      }

      /* print the prompt */
      term_write_at(3,22,name[active_player == PLACE_DISC_BLACK ? 0 : 1]);
      term_write_at(15,22,"Your Move: ");
      /* move the cursor behind the : of the prompt */
      term_goto(26,22);
      /* clear possible remaining text in the line after the prompt */
      term_clear_eol();
      /* read the player input  */
      if (color_computer != active_player)
      {
	  user_input = fgets(input_buffer,INPUT_BUFFER_SIZE,stdin);


	  /*  if the player pressed ^D then stdin is closed
	      and NULL is returned in user_input
	      --> abort the game, it's not easy to recover
	  */
	  if (NULL == user_input)
	  {
	      puts("");
	      free(board);
	      exit(25);
	  }

	  /*  check for a move as input   */
	  if (strlen(user_input) == 3)
	  {
	      /* is the first character a letter 'A'..'H'/'a'..'h' ?  */
	      if (((user_input[0]>='A') && (user_input[0]<='H')) ||
		  ((user_input[0]>='a') && (user_input[0]<='h')))
	      {
		  /* is the second character a digit '1'..'8' ?  */
		  if ((user_input[1]>='1') && (user_input[1]<='8'))
		  {
		      /* make a lowercase to an uppercase letter */
		      if (user_input[0] > 96) user_input[0] -= 32;

		      /* check if that is a valid move */

		      /* used here for the move to do, if allowed  */
		      ml2 = NULL;

		      /* used here to loop through the list of
			 possible moves */
		      ml_temp = ml;

		      /* loop through the list  */
		      while (ml_temp != NULL)
		      {
			  if ((ml_temp->m.x == user_input[0]) &&
			      (ml_temp->m.y == user_input[1]-'0'))
			  {
			      /* found the move in the list */
			      ml2 = ml_temp;
			      break;
			  }
			  ml_temp = ml_temp->next;
		      }

		      if (ml_temp == NULL)
		      {
			  /* ml_temp is NULL, then the move is invalid */

			  term_goto(26,22);
			  printf("invalid move %s!",user_input);
			  sleep(2);

			  /* cleanup the list of possible moves */
			  while (ml)
			  {
			      ml2 = ml;
			      ml = ml->next;
			      free(ml2);
			  }
		      }
		      else
		      {
			  /* ml_temp is not NULL, then the move is valid */

			  /* execute the move  */
			  execute_move(board,ml_temp->m);
			  display_field(board,0,titlebuffer,0);
			  active_player = next_player(active_player);
		      }

		  }
	      }

	  }
      }
      else
      {
	  /* computer moves */

	  getchar();


	  /* calculate the computer move */

	  /*  simple  strategy - take the first possible move  */
	  ml_temp = computer_move_simple(board,active_player,ml,3,0);

	  /* breath-first, select the best move in each depth
	     depth is limited  */
	  // ml_temp = computer_move_breadth(board,active_player,ml,3,0);



	  execute_move(board,ml_temp->m);
	  // delay the change on the screen so that it's easier to follow
	  sleep(2);
	  display_field(board,0,titlebuffer,0);
	  sleep(2);
	  active_player = next_player(active_player);


      }
      /* cleanup the list of possible moves */
      while (ml)
      {
	  ml2 = ml;
	  ml = ml->next;
	  free(ml2);
      }
      continue;



  } while (continue_game);

  /*  free the memory of the board */
  free(board);

}


/*  computer vs computer  */
void automatic_game(Place color_computer)
{
  /* names of the players */
    char  *name[] = { "Simple", "Breath" } ;

  /* buffer for the player name title */
  char   titlebuffer[50];

  /* buffer for different sprintf uses */
  char   strbuffer[81];

  /* active player = who has the current move */
  Place  active_player = PLACE_DISC_BLACK;

  /* the board itself */
  Field *board ;
  int    psbl_moves = 0;

  /* buffer and return pointer for the player move input */
  char   input_buffer[INPUT_BUFFER_SIZE+1] = "";
  char  *user_input;

  /* variable for the while loop */
  char   continue_game = 1;

  /* store if the other player before was able to move */
  char   last_move_possible = 1;

  /* variables to store and loop through the list of possible moves */
  struct movelist *ml,*ml2,*ml_temp;

  /*  for the disc count */
  Disc_Count dc;


  /* create an empty board */
  board = create_field();

  /*  initialize the board (place the 4 discs in the middle) */
  init_field(board);



  /*  create the string with the player names */
  sprintf((char *)&titlebuffer,"%s (*) vs %s (O)",
	  name[color_computer == PLACE_DISC_WHITE ? 0 : 1],
	  name[color_computer == PLACE_DISC_BLACK ? 0 : 1]);

  /* display the board with the player name string */
  display_field(board,0,titlebuffer,0);

  /*  loop until the game is finished  */
  do
  {
      /* print the disc counts */
      count_discs(board,&dc);

      sprintf((char *)strbuffer,"Black Discs: %-3d",dc.count_black);
      term_write_at(50, 8,(char *)&strbuffer);
      sprintf((char *)strbuffer,"White Discs: %-3d",dc.count_white);
      term_write_at(50,10,(char *)&strbuffer);

      term_goto(26,22);


      if ((dc.count_black == 0) || (dc.count_white == 0))
      {
	  sprintf((char *)strbuffer,"No more %s discs on the board!  GAME LOST",
		  dc.count_black == 0?"black":"white");

      }

      /* get the list of possible moves */
      ml = possible_moves(board,active_player);

      show_possible_moves(ml);

      /* no possible move */
      if (NULL == ml)
      {
	  /* was the other player also not able to move?
	     if yes, then the game ends */
	  if (last_move_possible == 0)
	  {
		Quit(board,&dc);
	  }
	  /* save that this player can't move */
	  last_move_possible = 0;
	  term_goto(26,22);
	  puts("No possible move");
	  sleep(2);
	  active_player = next_player(active_player);
      }
      else
      {
	  last_move_possible = 1;
      }

      /* print the prompt */
      term_write_at(3,22,name[active_player == PLACE_DISC_BLACK ? 0 : 1]);
      term_write_at(15,22,"Your Move: ");
      /* move the cursor behind the : of the prompt */
      term_goto(26,22);
      /* clear possible remaining text in the line after the prompt */
      term_clear_eol();


      /* computer moves */


      // user_input = fgets(input_buffer,INPUT_BUFFER_SIZE,stdin);


      /* calculate the computer move */

      if (active_player == PLACE_DISC_BLACK)
      {
	  /*  simple  strategy - take the first possible move  */
	  ml_temp = computer_move_simple(board,active_player,ml,3,0);
      }
      else
      {
	  /* breath-first, select the best move in each depth
	     depth is limited  */

	  ml_temp = computer_move_breadth(board,active_player,ml,3,0);
      }


      execute_move(board,ml_temp->m);
      sleep(2);
      display_field(board,0,titlebuffer,0);
      sleep(2);
      active_player = next_player(active_player);



      /* cleanup the list of possible moves */
      while (ml)
      {
	  ml2 = ml;
	  ml = ml->next;
	  free(ml2);
      }
      continue;



  } while (continue_game);

  /*  free the memory of the board */
  free(board);

}



void main(int argc, char* argv[])
{
  struct movelist *ml,*ml2;
  Field *f;
  /* buffer and return pointer for the player move input */
  char   input_buffer[INPUT_BUFFER_SIZE+1] = "";
  char  *user_input;

  // display a menu for the game mode

  display_field(NULL,0,"Choose Game Mode",0);

  term_write_at(50,10,"Human (*) [v]s Human (O)");

  term_write_at(50,12,"[H]uman (*) vs Computer (O)");

  term_write_at(50,14,"[C]omputer (*) vs Human (O)");

  term_write_at(50,16,"[A]utomatic Computer (*/O) ");

  term_write_at(50,18,"[E]xit");

  do
  {

    term_goto(50,21);

    printf("Enter v,h,c,a or e: ");

    term_clear_eol();

    user_input = fgets(input_buffer,INPUT_BUFFER_SIZE,stdin);

    if (user_input == NULL)
    {
      term_clear();
      exit(5);
    }

  } while ((*user_input != 'v') &&
	   (*user_input != 'h') &&
	   (*user_input != 'c') &&
	   (*user_input != 'a') &&
	   (*user_input != 'e'));

  if (*user_input == 'e')
  {
      term_clear();
      exit(5);
  }

  if (*user_input == 'v')
  {
      human_game();
      exit(5);
  }

  if (*user_input == 'h')
  {
      computer_game(PLACE_DISC_WHITE);
      exit(5);
  }

  if (*user_input == 'c')
  {
      computer_game(PLACE_DISC_BLACK);
      exit(5);
  }

  if (*user_input == 'a')
  {
      computer_game(PLACE_DISC_BLACK);
      exit(5);
  }



}
