// Victoria Crenshaw
// CSC 475
// Assignment 3
// 11-14-2022



#include "Othello.h"

#include "field.h"





// allocate the memory
Field* create_field(void)
{
    Field *field;

    // calloc because it clears teh allocaed memory
    field = calloc(sizeof(Field),1);
    if (!field)
      {
	puts("Can't allocate memory for a board!");
	exit(10);
      }
  return field;
}

// initialize the field with the starting position
void   init_field(Field *field)
{
  int i,j;

  if (!field) return;

  /*  clear the board  */
  /* this is needed even with calloc() in case a board is reused  */

  for (i=0;i<8;i++)
    {
      for (j=0;j<8;j++)
	{
	    set_place(field,i,j,PLACE_EMPTY  );
	}
    }

  /*  place the discs for the starting state */
  set_place(field,3,3,PLACE_DISC_WHITE);
  set_place(field,4,4,PLACE_DISC_WHITE);
  set_place(field,3,4,PLACE_DISC_BLACK);
  set_place(field,4,3,PLACE_DISC_BLACK);
}


char print_disc(Place p)
{
  // Place pl = 0;
    //---- redundant if (p<0) p=0;
    // if (p<PLACE_INTERNAL_MAX) pl=p;

    return "  XO+o      "[p];
}


// print the field - intented for debugging
void print_field(Field *field)
{
    int i,j;

    if (!field) return;

    // temp - will be beautified later



    puts("     A   B   C   D   E   F   G   H");
    puts("   +---+---+---+---+---+---+---+---+");
    // puts("  |   |   |   |   |   |   |   |   |");

    for (j=0;j<8;j++)
    {
      printf(" %d |", j+1);
	for (i=0;i<8;i++)
	{
	    putchar(' ');
	    putchar(print_disc(get_place(field,i,j)));
	    putchar(' ');
	    putchar('|');
	}
	puts("");
	puts("   +---+---+---+---+---+---+---+---+");
    }
}



// set a disc in a place on the board
void set_place(Field *field, int x, int y, Place color)
{
    // prevent null pointer access
    if (!field) return;

    // check the x coordinate and return if invalid
    if (x != limit_position(x)) return;

    // check the x coordinate and return if invalid
    if (y != limit_position(y)) return;

    //  no validity check for 'color' because it can be also be used for markers etc.

    // set the color into the board
    field->place[y*8+x] = color;
}



// get the disc color on one field
Place get_place(Field *field,int x,int y)
{
    // prevent null pointer access and return an invalid color
    if (!field) return PLACE_UNUSED1;

    // on invalid x coordinate return invalid color
    if (x != limit_position(x)) return PLACE_UNUSED1;

    // on invalid y coordinate return invalid color
    if (y != limit_position(y)) return PLACE_UNUSED1;

    // return the color of the place
    return field->place[y*8+x];
}


// get a copy of the given field
// a new field is created
Field* copy_field(Field *field)
{
    Field *f;
    int i;

    f = create_field();
    for (i=0;i<64;i++)
    {
	f->place[i] = field->place[i];
    }
    return f;
}




// get the oher player while playing
Place  next_player(Place current_player)
{
    /* if black is the current color then white is the other/next */
    if (current_player == PLACE_DISC_BLACK)
      return PLACE_DISC_WHITE;

    /* to ensure a valid disc color return 'black' in any case
       beside 'black' as current player color   */
    return PLACE_DISC_BLACK;
}


// enforces the range 0..7 for a coordinate of the field
int limit_position(int i)
{
    // less than 0? then limit to 0
    if (i<0) return 0;

    // greater than 7? then limit to 7
    if (i>7) return 7;

    // coordinate is ok, return it
    return i;
}


// counts the discs on the field
Disc_Count  *count_discs(Field *board, Disc_Count *dc)
{
    int i;

    if (NULL == dc)
    {
	dc = calloc(sizeof(Disc_Count),1);
    }

    dc->count_black = 0;
    dc->count_white = 0;
    dc->evaluation = 0;

    for (i=0;i<64;i++)
    {
	switch (board->place[i])
	{
	  case PLACE_DISC_BLACK:
	    dc->count_black++;
	    break;

	  case PLACE_DISC_WHITE:
	    dc->count_white++;
	    break;
	}
    }
    return dc;
}
