// Victoria Crenshaw
// CSC 475
// Assignment 3
// 11-14-2022



// display.c

// display the board in a 'beautiful' way


#include "Othello.h"
#include "display.h"


// this code expects a xterm or similar terminal on Unix/Linux
//  with 80x24 characters


// place the curcor at x,y
void term_goto(int x, int y)
{
    printf("%c[%d;%dH",27,y,x);
}


// write text at x,y
void term_write_at(int x, int y, char *string)
{
    term_goto(x,y);
    puts(string);
}


// clear the screen
void term_clear()
{
    printf("%c[0m",27);
    term_goto(1,1);
    printf("%c[2J",27);
}


// clear to teh end of the line
void term_clear_eol()
{
#ifndef __WATCOMC__
    printf("%c[J",27);
#endif
}


// display the board as ASCII
void display_field(Field *field, Place next_player,
		   char *text_right, char print_markers)
{
    int i,j,a,b,x,y;
    Place p;
    char buffer[3] = "  ";
    char *disc_str;

    term_clear();

    term_write_at(20,2,AAYELLOW"Othello");
    if (text_right) term_write_at(55,2,text_right);

    /*  print board  */
    term_write_at(5,4,AAGREEN"     A   B   C   D   E   F   G   H");

    for (y=0;y<9;y++)
    {
	term_write_at(8,5+y*2,"+---+---+---+---+---+---+---+---+");
	if (y<8)
	{
	    term_write_at(8,6+y*2,"|   |   |   |   |   |   |   |   |");
	    buffer[0]=y+49;
	    term_write_at(5,6+y*2,buffer);
	}
    }

    /* print pieces */

    for (y=0;y<8;y++)
    {
	for (x=0;x<8;x++)
	{
	    p = get_place(field,x,y);

	    disc_str = "";

	    switch (p)
	    {
	      case PLACE_DISC_BLACK:
		disc_str = AAGREY" *"AAGREEN;
		break;

	      case PLACE_DISC_WHITE:
		disc_str = AAWHITE" O"AAGREEN;
		break;

	      case PLACE_POSSIBLE_BLACK:
		if (print_markers) disc_str = " +";
		break;

	      case PLACE_POSSIBLE_WHITE:
		if (print_markers) disc_str = " .";
		break;

	      default:
		break;

	    }

	    term_write_at(9+4*x,6+y*2,disc_str);
	}
    }


}


void show_possible_moves(struct movelist *ml)
{
    struct movelist *m;
    int c,l;

    term_write_at(45,12,"Possible Moves");

    if (ml == NULL)
    {
	term_write_at(45,14,"No Moves Possible!");
	return;
    }

    c = 0;
    l = 0;
    m = ml;

    term_goto(45,14);

    while (m)
    {
	printf("%c%d  ",m->m.x,m->m.y);
	m = m-> next;

	c++;
	if (c>4)
	{
	    c=0;
	    l++;
	    term_goto(45,14+l);
	}

    }

}


