// Victoria Crenshaw
// CSC 475
// Assignment 3
// 11-14-2022

/* calculate the computer move */

#include "Othello.h"
#include "computer.h"



// determine the value of a disc depending on the color
int place_value(Place p)
{
    if (p == PLACE_DISC_BLACK) return 1;
    if (p == PLACE_DISC_WHITE) return -1;
    return 0;
}


// calculate which player has the discs in better positions
// heuristic evaluation of the board
int score_board(Field *board)
{
    // the complete score
    int score = 0;

    // temp. variable
    Disc_Count  *dc;

    // loop variables
    int i,j;

    // temp. variable
    Place p;


    dc = count_discs(board, NULL);

    /* simple difference in discs  */
    score = dc->count_black - dc->count_white;


    /* discs on the corners are impossible to flip
       give them value 25
    */

    // get teh value for 0,0
    p = get_place(board,0,0);
    // because an empty place has value 0 it can easily
    // multiplied and added
    score += 25 * place_value(p);
    p = get_place(board,7,0);
    score += 25 * place_value(p);
    p = get_place(board,0,7);
    score += 25 * place_value(p);
    p = get_place(board,7,7);
    score += 25 * place_value(p);

    /* discs on the outer row/column can't be easily flipped
       give them value 5
    */

    // loop on all 4 sides from 1 to 6, exclude the corners
    for (i=1;i<7;i++)
    {
	p = get_place(board,0,i);
	score += 5 * place_value(p);
	p = get_place(board,i,0);
	score += 5 * place_value(p);
	p = get_place(board,7,i);
	score += 5 * place_value(p);
	p = get_place(board,i,7);
	score += 5 * place_value(p);
    }

    return score;
}



// very simple move selection, take the first possible move
struct movelist *computer_move_simple(Field *board,Place active_player,
			       struct movelist *pos_moves,
			       int depth, int strategy)
{
    return pos_moves;
}



// take the best move and then continue into the depth this way
struct movelist *computer_move_breadth(Field *board,Place active_player,
				       struct movelist *pos_moves,
				       int depth, int strategy)
{
    // temp. variables
    struct movelist *ml_temp,*ml_selected,*ml_local,*ml_depth;;
    Field *calc_board;


    /* if there are no possible moves ...  */
    if (possible_moves == NULL) return NULL;

    // use ml_temp to loop through the list
    ml_temp = pos_moves;

    /* evaluate all possible moves */
    while (ml_temp)
    {
	/* copy the board (allocates memory) */
	calc_board = copy_field(board);

	/* execute the player move in that copy  */
	execute_move(calc_board, ml_temp->m);

	/* score the new board */
	ml_temp->value = score_board(calc_board);

	free(calc_board);

	ml_temp = ml_temp->next;
    }


    ml_temp = pos_moves;

    // set the selected (best)move as start value

    ml_selected = ml_temp;

    // move one entry forward
    ml_temp = ml_temp -> next;

    // and move though the list
    while (ml_temp)
    {
	// if a board has a better score, take as selected on
	// if black has the current move the comparison is  ">"
	if (active_player == PLACE_DISC_BLACK)
	{
	    if (ml_temp->value > ml_selected->value)
	    {
		ml_selected = ml_temp;
	    }
	}
	// if white has the current move the comparison is  "<"
	if (active_player == PLACE_DISC_WHITE)
	{
	    if (ml_temp->value < ml_selected->value)
	    {
		ml_selected = ml_temp;
	    }
	}
    }

    // allocate space for a new struct movelist which can be returned
    ml_temp = calloc(sizeof(struct movelist),1);
    // set the move
    ml_temp->m = ml_selected->m;
    // set the value
    ml_temp->value = ml_selected->value;

    // if the depth is >1 then repeat this in teh next level(s)
    if (depth >1)
    {
	calc_board = copy_field(board);

	/* execute the player move in that copy  */
	execute_move(calc_board, ml_selected->m);

	/* get the possible moves */
	ml_local = possible_moves(calc_board, next_player(active_player));

	ml_depth = computer_move_breadth(calc_board,next_player(active_player),
					 ml_local, depth-1, strategy);

	ml_temp->next = ml_depth;
    }

    // return the list of moves
    return ml_temp;

}


